% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{plane_2d_hole}
\alias{plane_2d_hole}
\title{Generate 2D Plane with Hole and Noise}
\usage{
plane_2d_hole(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A list containing the 2D plane data with a hole and the sample size.
}
\description{
This function generates a dataset representing a 2D plane with a hole in the
middle, with added noise.
}
\examples{
set.seed(20240412)
plane_data <- plane_2d_hole(
  n = 100, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
