% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear.R
\name{swiss_roll}
\alias{swiss_roll}
\title{Generate Swiss Roll Data}
\usage{
swiss_roll(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated Swiss roll data points.
}
\description{
This function generates data points in the shape of a Swiss roll.
}
\examples{

# Generate Swiss roll data with noise with custom parameters
set.seed(20240412)
data <- swiss_roll(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
}
