# conic_spiral_3d() works

    Code
      conic_spiral_3d(n = 100, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                         x            y           z                           
        [1,]  0.1652705399  0.197655432  0.56196756  0.046811273 -0.0397026339
        [2,] -0.0503955365 -0.214441320  0.37706739 -0.012496258  0.0290763175
        [3,] -0.1261257283 -0.113418205  0.81181242 -0.039036306  0.0422360181
        [4,]  0.2665173598 -0.123134358  0.45560915  0.012114244 -0.0214310022
        [5,]  0.0996705791  0.091156521  0.54774636 -0.007777032 -0.0499433291
        [6,]  0.0437924361 -0.099445170  0.41508432 -0.043311664 -0.0356851794
        [7,] -0.2340716670  0.346800356  0.18236676  0.009618158  0.0015637302
        [8,]  0.0439289356  0.126512734  0.58797019  0.040446538 -0.0123396746
        [9,]  0.1480882404 -0.061412971  0.48396567 -0.049745073 -0.0284339315
       [10,]  0.0769614733 -0.104517663  0.92548686 -0.015265306 -0.0350829806
       [11,]  0.0321642128 -0.102515589  0.89670361  0.036571148 -0.0353439124
       [12,]  0.0928606406  0.037877951  0.03250360  0.015919120  0.0423142502
       [13,]  0.0460846298 -0.092542179  0.91011412 -0.031443569 -0.0051962465
       [14,]  0.0694460398  0.076145771  0.07151625  0.044940477 -0.0389469245
       [15,] -0.0574431914  0.133410012  0.66761320 -0.028938895 -0.0086575911
       [16,] -0.0531663776  0.159754791  0.12888588  0.013595432  0.0232040592
       [17,]  0.0523673056  0.141408954  0.11676387  0.002368991 -0.0245691278
       [18,]  0.1633681435  0.026015119 -0.01080325 -0.030572272 -0.0315889175
       [19,] -0.1508265735  0.082564605  0.18905609 -0.018436977  0.0227344875
       [20,] -0.1212481578  0.335913044  0.12947682  0.045953311 -0.0366494890
       [21,] -0.3775116267  0.031377390  0.23042905  0.034806118  0.0157848667
       [22,]  0.2407401225  0.059480024  0.53216298  0.004200594  0.0070135517
       [23,]  0.0859179028 -0.065061982  0.45489713 -0.030929957  0.0208199039
       [24,]  0.1189491519  0.222318807  0.59311723 -0.023326323 -0.0189224581
       [25,]  0.0662781347  0.110313469  0.57191298  0.038856192  0.0338216087
       [26,]  0.0633287178 -0.084667759  0.92424468  0.036005257 -0.0460992394
       [27,] -0.0736354460  0.076480478  0.17892801 -0.005547783  0.0447378346
       [28,]  0.0521597046 -0.086409012  0.91735178  0.010797826  0.0272497393
       [29,]  0.0144862076 -0.131029745  0.88720095  0.029635492 -0.0160971409
       [30,]  0.1030225527 -0.014904482  0.98834397  0.009967849  0.0464448324
       [31,] -0.0317932811  0.115590059  0.15908594 -0.006457079  0.0179349351
       [32,] -0.1179802964  0.314892306  0.17827294 -0.030954550 -0.0207382537
       [33,] -0.0119618902  0.126641643  0.62340828 -0.025088984  0.0037443788
       [34,]  0.0836894919 -0.073383346  0.94089059  0.031934072 -0.0118583800
       [35,]  0.1007341092  0.098191771  0.04291249 -0.035403466  0.0063740385
       [36,] -0.1157049076  0.054273855  0.72288678 -0.042859625 -0.0297865495
       [37,] -0.1069723154 -0.003305185  0.75650346 -0.034428535 -0.0433482581
       [38,]  0.0456057180 -0.121483918  0.90100170  0.034162961 -0.0163532625
       [39,]  0.0819433093  0.218396768  0.06868350 -0.045406635  0.0359919606
       [40,] -0.2740627274  0.157893565  0.23185376  0.012260502 -0.0370901504
       [41,]  0.0442711388  0.258241515  0.13966080  0.002252682 -0.0496382012
       [42,] -0.1898921012  0.003656120  0.75340162  0.004865140  0.0114451926
       [43,] -0.0364220198 -0.152715791  0.85556012  0.037104514 -0.0157686300
       [44,] -0.2401621261  0.315221993  0.16107495  0.019189041 -0.0482725061
       [45,] -0.0475882714  0.223957195  0.64851466  0.016947191  0.0417446218
       [46,]  0.2071281625  0.069749153  0.51123541  0.023474528  0.0490760001
       [47,]  0.0971114179 -0.052560033  0.46788593 -0.046460505 -0.0143416769
       [48,] -0.2548529530  0.268059306  0.16593710 -0.014047195 -0.0389693632
       [49,] -0.0532109435 -0.130509646  0.32904039 -0.002774406 -0.0050521928
       [50,]  0.0421894330  0.285217974  0.08514373  0.021978159 -0.0338490285
       [51,]  0.0950771463  0.243899817  0.59494467  0.001459893  0.0007207744
       [52,]  0.0874246501  0.075427410  0.54868476 -0.032680244  0.0358561296
       [53,] -0.0354734229  0.216252480  0.62913467 -0.006952650 -0.0343432767
       [54,]  0.2656597028  0.046356794  0.04483268  0.049056897  0.0380912595
       [55,]  0.1819985251  0.171537011  0.55023318 -0.037429136 -0.0017651984
       [56,] -0.0388461917  0.113135287  0.65903762  0.040186682  0.0271230818
       [57,]  0.0072851823 -0.111475590  0.37182156  0.037823953 -0.0153674109
       [58,] -0.1712406520  0.128214836  0.70319892 -0.013801423 -0.0435791666
       [59,] -0.0521091851 -0.292724400  0.37804870  0.014180800 -0.0007038843
       [60,] -0.0156651304 -0.099808397  0.86379751  0.016110678 -0.0042624283
       [61,]  0.0001969794  0.128084093  0.10974355  0.045699345  0.0307058573
       [62,]  0.0648762577 -0.174703181  0.38504121 -0.017281139 -0.0172181919
       [63,]  0.0257079332 -0.098954199  0.89372679 -0.022220930  0.0344564827
       [64,]  0.1364136357 -0.002313632  0.51095689  0.048801365 -0.0145525717
       [65,]  0.0710564382 -0.106525297  0.92332611  0.007458667  0.0024064121
       [66,] -0.1109366693  0.174632821  0.14534892 -0.033425671  0.0470545179
       [67,] -0.0849568255  0.423912518  0.13095956 -0.035560294 -0.0429631366
       [68,] -0.1382339309  0.033387622  0.72278301  0.046699327  0.0314480813
       [69,] -0.1089722775  0.292256888  0.12731943  0.021227714 -0.0469257004
       [70,]  0.2013966349  0.197723048  0.03191514  0.028738201  0.0067218661
       [71,] -0.0566907701  0.131776282  0.66748087 -0.048813058 -0.0365070718
       [72,] -0.1063010396  0.055317306  0.71874140 -0.025414831  0.0148092618
       [73,]  0.0176651913 -0.128185950  0.88241999 -0.044960774 -0.0288158743
       [74,]  0.0353068477  0.139845606  0.08657420 -0.032921567 -0.0393909458
       [75,]  0.1402746081 -0.267844813  0.40052641  0.004026652 -0.0436995254
       [76,]  0.0256392128 -0.137361909  0.89178698  0.014284641 -0.0465217978
       [77,] -0.1280522272 -0.033046939  0.25553312 -0.032963758 -0.0291392233
       [78,] -0.0728610624  0.070311875  0.68693820  0.049464466  0.0114881480
       [79,] -0.3345972845 -0.140922125  0.26900981 -0.036069776 -0.0194828836
       [80,]  0.1072902918  0.173998034  0.05464647  0.020289299 -0.0485348954
       [81,] -0.1780656377 -0.202959143  0.29663925  0.036633093 -0.0097199444
       [82,] -0.1876751116  0.087116421  0.71974687 -0.029914531 -0.0044783109
       [83,] -0.0143729079 -0.101694819  0.35967328  0.035608689  0.0366461525
       [84,]  0.0608352925  0.143715936  0.07226579  0.030768446 -0.0395055116
       [85,] -0.0931896338 -0.056221115  0.28536875  0.022653194 -0.0053874930
       [86,]  0.0795980598 -0.239474206  0.41890499  0.014886355  0.0058034629
       [87,] -0.0043018994 -0.199315030  0.39279846 -0.003475857  0.0060975001
       [88,] -0.0993007126  0.069212199  0.70880013  0.021506445 -0.0234173421
       [89,]  0.2835643239 -0.131126037  0.46281453  0.031937469  0.0187736356
       [90,]  0.3793856712  0.279113500  0.04137405 -0.037160310 -0.0442129100
       [91,]  0.2312444607 -0.045258701  0.50018499  0.049801787 -0.0419374371
       [92,] -0.0618468942 -0.271872287  0.37603289  0.012772074 -0.0498900986
       [93,]  0.0845594947 -0.084146447  0.93603629  0.005877741  0.0109741065
       [94,] -0.1536838003 -0.070743683  0.30383456  0.025761254 -0.0074751925
       [95,]  0.1281951569  0.326210654  0.12179217  0.027342288 -0.0305212979
       [96,]  0.0798742454  0.134807525  0.59502223 -0.035392174 -0.0172342707
       [97,]  0.0589677022 -0.112630134  0.42532349  0.018060863 -0.0040695532
       [98,] -0.3552016390  0.080158976  0.24928544 -0.004448415  0.0392953042
       [99,] -0.0715559521 -0.102026048  0.83161640 -0.047147391  0.0337261188
      [100,]  0.4071285057  0.187344014  0.01598701 -0.017987990  0.0190098491

---

    Code
      conic_spiral_3d(n = 100, num_noise = 0)
    Output
                        x            y            z
        [1,] -0.143014732 -0.051377487  0.295109620
        [2,] -0.108405013 -0.095204393  0.813411705
        [3,]  0.094623220  0.263560413  0.126295811
        [4,]  0.102670088  0.440466244  0.100086436
        [5,]  0.281565484  0.044124775 -0.019003822
        [6,] -0.003909021 -0.101477767  0.873333988
        [7,]  0.027959618 -0.139188703  0.889422698
        [8,] -0.220636002  0.076040018  0.199122207
        [9,]  0.282062625  0.058781250  0.511306473
       [10,] -0.103806168  0.121491794  0.691392196
       [11,] -0.231719023  0.364324099  0.171368457
       [12,]  0.056774227 -0.083855400  0.921383188
       [13,] -0.123560101 -0.102916815  0.810396561
       [14,] -0.170132890 -0.143336586  0.283768703
       [15,] -0.042031372 -0.090739936  0.840535531
       [16,]  0.190879679  0.010426788  0.520068824
       [17,] -0.295517747 -0.235282257  0.305961305
       [18,] -0.078046938 -0.169999661  0.321013529
       [19,]  0.280160910  0.076534904 -0.009922608
       [20,]  0.050211538 -0.086662416  0.916424619
       [21,] -0.232082801  0.036163445  0.261802054
       [22,] -0.053545799 -0.142066035  0.842757582
       [23,] -0.170567856 -0.300772913  0.345286044
       [24,] -0.168002906  0.009138829  0.738067706
       [25,]  0.255098652  0.011254671  0.490463022
       [26,]  0.101092961  0.015182457  0.508562952
       [27,] -0.117792185 -0.060590145  0.273399465
       [28,] -0.110910151  0.099760930  0.682097469
       [29,] -0.193431571  0.077968492  0.722673779
       [30,]  0.048289337 -0.342091557  0.385583806
       [31,]  0.034907845 -0.102919225  0.903628665
       [32,]  0.063445879 -0.086413877  0.927430312
       [33,] -0.314464052  0.281539466  0.194971444
       [34,]  0.054098805  0.105224500  0.074524978
       [35,] -0.119397024  0.102947401  0.683634048
       [36,] -0.149843176  0.159658172  0.689585896
       [37,]  0.015436539  0.151691183  0.605357309
       [38,] -0.116248377  0.101963240  0.702423086
       [39,]  0.112905173  0.187965254  0.569919763
       [40,] -0.305928967 -0.022047273  0.233897431
       [41,] -0.032870971 -0.107613180  0.847551477
       [42,]  0.171882447 -0.061357053  0.489096828
       [43,] -0.342314560 -0.097875921  0.287250089
       [44,]  0.096839521 -0.045669428  0.966048805
       [45,] -0.133058517 -0.010917640  0.763878452
       [46,]  0.274604340 -0.103692009  0.461884407
       [47,]  0.102802899 -0.011530631  0.991208590
       [48,] -0.064071191 -0.145475231  0.839467978
       [49,]  0.025259319 -0.114690585  0.382266502
       [50,] -0.098858160  0.136012277  0.196274913
       [51,] -0.138677758  0.147424421  0.677248396
       [52,] -0.249382131 -0.086019555  0.299262463
       [53,]  0.051226817  0.222905559  0.616659347
       [54,] -0.176550821  0.073955104  0.241065485
       [55,]  0.042144958 -0.091260102  0.908740927
       [56,] -0.157215770  0.098872104  0.713680563
       [57,]  0.414643108  0.064037082 -0.012538067
       [58,]  0.089741826 -0.084794159  0.940368490
       [59,] -0.173762952  0.086779681  0.720139105
       [60,] -0.044177832  0.094557046  0.165839435
       [61,]  0.101188980  0.185190726  0.597629379
       [62,] -0.349883685  0.063182339  0.253799178
       [63,]  0.083703219  0.077610321  0.567116296
       [64,]  0.210543931  0.046422505  0.532333136
       [65,]  0.307821181  0.012749577  0.034989716
       [66,] -0.103278520  0.031528932  0.218613751
       [67,] -0.110227482 -0.019686276  0.769062824
       [68,]  0.168474405 -0.005164401  0.482397360
       [69,] -0.017498346  0.108100896  0.146757899
       [70,]  0.059528938  0.141207404  0.605401405
       [71,]  0.099363577 -0.034995421  0.973910450
       [72,] -0.238203881  0.044748895  0.210937579
       [73,] -0.064404290  0.196151978  0.175335613
       [74,]  0.053674434  0.248222414  0.604737591
       [75,] -0.086033437  0.214219031  0.660205194
       [76,] -0.130097571  0.007183787  0.260043560
       [77,]  0.041144017 -0.163105595  0.411998913
       [78,] -0.022534273 -0.262159667  0.387418289
       [79,] -0.164732738 -0.136432332  0.326801545
       [80,] -0.091789911  0.353640074  0.122524326
       [81,]  0.093426433 -0.078016417  0.945119630
       [82,]  0.073939776 -0.229579982  0.418600591
       [83,] -0.110733208  0.093924061  0.684620233
       [84,] -0.054530292  0.227303996  0.649181912
       [85,]  0.291099350  0.040891820  0.508301976
       [86,] -0.023050569  0.204709894  0.623504134
       [87,]  0.018005470  0.249759353  0.616594464
       [88,] -0.069801744  0.134211613  0.652752852
       [89,]  0.143672437 -0.012564496  0.479731664
       [90,] -0.117750605 -0.216297687  0.314278091
       [91,] -0.337322526 -0.160839454  0.276234809
       [92,] -0.057586933  0.095591658  0.158434036
       [93,]  0.085538274  0.091781438  0.575084433
       [94,] -0.376424902 -0.010196501  0.264730716
       [95,]  0.406957140  0.230952175  0.029001821
       [96,]  0.081797902 -0.058237112  0.950316329
       [97,]  0.055701011 -0.092541882  0.411362761
       [98,]  0.231057414 -0.061900126  0.494782800
       [99,]  0.071379941 -0.096283803  0.927990137
      [100,] -0.133327788 -0.027627103  0.281612007

# dini_surface_3d() works

    Code
      dini_surface_3d(n = 100, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                        x            y           z                           
        [1,]  0.347151898 -0.839324583 11.36041584  0.046811273 -0.0397026339
        [2,] -0.648741637 -0.085146601  3.04097530 -0.012496258  0.0290763175
        [3,]  0.330471890  0.942706226  1.23365770 -0.039036306  0.0422360181
        [4,]  0.253389045 -0.761222512 11.22547072  0.012114244 -0.0214310022
        [5,] -0.246514057  0.864733938  8.10003919 -0.007777032 -0.0499433291
        [6,]  0.523088728 -0.506932653  5.35988562 -0.043311664 -0.0356851794
        [7,]  0.238064969  0.239539384 -0.01913971  0.009618158  0.0015637302
        [8,] -0.309640512  0.877870834  8.17538241  0.040446538 -0.0123396746
        [9,] -0.504711391 -0.628465947  3.94710645 -0.049745073 -0.0284339315
       [10,]  0.960836104 -0.017447131 12.55560826 -0.015265306 -0.0350829806
       [11,] -0.198839966  0.953705115  8.06347944  0.036571148 -0.0353439124
       [12,]  0.061234707 -0.006712548  3.69283627  0.015919120  0.0423142502
       [13,]  0.297093445  0.921524373  7.54752564 -0.031443569 -0.0051962465
       [14,]  0.123363267 -0.046773958  4.19780591  0.044940477 -0.0389469245
       [15,] -0.744154289 -0.618122361  3.82910207 -0.028938895 -0.0086575911
       [16,] -0.084782350  0.284225698  7.21311486  0.013595432  0.0232040592
       [17,]  0.006424263 -0.192239598  3.39490002  0.002368991 -0.0245691278
       [18,] -0.002655535  0.024989829  4.58287196 -0.030572272 -0.0315889175
       [19,] -0.166027330  0.372715415  7.64092767 -0.018436977  0.0227344875
       [20,] -0.139770029 -0.265923474  9.59310212  0.045953311 -0.0366494890
       [21,]  0.196364538 -0.424593269 10.91956933  0.034806118  0.0157848667
       [22,] -0.360768984  0.782508943  1.95094799  0.004200594  0.0070135517
       [23,]  0.568905980 -0.535606381  5.42034856 -0.030929957  0.0208199039
       [24,]  0.369682516  0.844046466  1.13644660 -0.023326323 -0.0189224581
       [25,] -0.125956866  0.909672364  7.96871815  0.038856192  0.0338216087
       [26,] -0.240603232  0.930045959  8.11462122  0.036005257 -0.0460992394
       [27,]  0.309434329  0.190674646  6.09661582 -0.005547783  0.0447378346
       [28,]  0.751391236  0.605385261  6.96767707  0.010797826  0.0272497393
       [29,] -0.713505955  0.672832819  2.38807249  0.029635492 -0.0160971409
       [30,]  0.230500085 -0.889184617 11.27197392  0.009967849  0.0464448324
       [31,]  0.161964438 -0.238815265  4.35128491 -0.006457079  0.0179349351
       [32,] -0.207644560  0.219635589  1.41538757 -0.030954550 -0.0207382537
       [33,] -0.196956443  0.933042780  8.05239280 -0.025088984  0.0037443788
       [34,] -0.950579597  0.025083500  9.40888525  0.031934072 -0.0118583800
       [35,]  0.027861544  0.119450107  5.82954655 -0.035403466  0.0063740385
       [36,] -0.470847067 -0.871013280  4.21588312 -0.042859625 -0.0297865495
       [37,]  0.471775798 -0.879257440  5.20476096 -0.034428535 -0.0433482581
       [38,] -0.398186880 -0.886912406 10.57801342  0.034162961 -0.0163532625
       [39,] -0.165248625  0.097125167  7.53909915 -0.045406635  0.0359919606
       [40,] -0.296276634  0.275903293  1.75253207  0.012260502 -0.0370901504
       [41,] -0.217685789 -0.038905499  2.10401887  0.002252682 -0.0496382012
       [42,]  0.239945560  0.967977635  1.32767639  0.004865140  0.0114451926
       [43,]  0.927942486 -0.344833511 12.21152974  0.037104514 -0.0157686300
       [44,]  0.096544105 -0.332565945 10.49405157  0.019189041 -0.0482725061
       [45,]  0.266604143  0.921158428  1.28108500  0.016947191  0.0417446218
       [46,] -0.759561413 -0.420656930  9.88252661  0.023474528  0.0490760001
       [47,]  0.503428273 -0.616886581  5.30086775 -0.046460505 -0.0143416769
       [48,] -0.049884198 -0.359081746 10.11631943 -0.014047195 -0.0389693632
       [49,] -0.034107378  0.634374263  7.65403261 -0.002774406 -0.0050521928
       [50,] -0.222968284 -0.027781133  8.34986287  0.021978159 -0.0338490285
       [51,]  0.926140266 -0.068656559 12.47381130  0.001459893  0.0007207744
       [52,]  0.325817713  0.835905532  7.44967562 -0.032680244  0.0358561296
       [53,] -0.159867243 -0.943375641 10.81907884 -0.006952650 -0.0343432767
       [54,] -0.026417070 -0.007611457  0.13491526  0.049056897  0.0380912595
       [55,] -0.002278861 -0.900224652 10.96189757 -0.037429136 -0.0017651984
       [56,]  0.031801939 -0.963736493  4.73890062  0.040186682  0.0271230818
       [57,]  0.441012136  0.529629049  6.96699885  0.037823953 -0.0153674109
       [58,]  0.580660577  0.795721731  0.93866224 -0.013801423 -0.0435791666
       [59,] -0.269745990  0.603299931  1.76763793  0.014180800 -0.0007038843
       [60,]  0.842686227 -0.515966531  5.73501010  0.016110678 -0.0042624283
       [61,]  0.101253939  0.225475200  6.32567115  0.045699345  0.0307058573
       [62,] -0.611659325  0.383482421  8.70502431 -0.017281139 -0.0172181919
       [63,]  0.581112679  0.784110818  7.21974431 -0.022220930  0.0344564827
       [64,] -0.159062719 -0.824812214  4.45665921  0.048801365 -0.0145525717
       [65,]  0.250373296  0.929896049  1.31460602  0.007458667  0.0024064121
       [66,] -0.248982250  0.221961583  7.87738183 -0.033425671  0.0470545179
       [67,]  0.206743070 -0.185519380 10.84146120 -0.035560294 -0.0429631366
       [68,] -0.902179248  0.417544404  8.99088978  0.046699327  0.0314480813
       [69,] -0.263790988 -0.147055282  9.01982902  0.021227714 -0.0469257004
       [70,] -0.123016001  0.007107815  7.57633787  0.028738201  0.0067218661
       [71,] -0.708259840 -0.658926702  3.88528377 -0.048813058 -0.0365070718
       [72,] -0.138086697 -0.979505605  4.57127135 -0.025414831  0.0148092618
       [73,] -0.817085427 -0.540843602 10.01220380 -0.044960774 -0.0288158743
       [74,]  0.027892732  0.207217578  6.45103515 -0.032921567 -0.0393909458
       [75,]  0.037231031 -0.734813680 10.89943494  0.004026652 -0.0436995254
       [76,]  0.276868295  0.938332860  1.28691191  0.014284641 -0.0465217978
       [77,]  0.110050058  0.502392545  7.21171450 -0.032963758 -0.0291392233
       [78,]  0.903075425  0.384291500  6.68310622  0.049464466  0.0114881480
       [79,]  0.203913794 -0.493641331 10.99284738 -0.036069776 -0.0194828836
       [80,] -0.101160946  0.125700043  7.00777845  0.020289299 -0.0485348954
       [81,] -0.521790590 -0.282772514  9.61403054  0.036633093 -0.0097199444
       [82,]  0.537640400  0.831553151  0.99593473 -0.029914531 -0.0044783109
       [83,]  0.609149362  0.267060310  6.47756273  0.035608689  0.0366461525
       [84,] -0.008389469  0.185003897  6.51118830  0.030768446 -0.0395055116
       [85,]  0.419341104  0.361058381  6.62931578  0.022653194 -0.0053874930
       [86,] -0.612803648  0.374357486  2.42976126  0.014886355  0.0058034629
       [87,] -0.620761115 -0.275430442  3.35581853 -0.003475857  0.0060975001
       [88,] -0.159272977 -0.973026049  4.54856371  0.021506445 -0.0234173421
       [89,]  0.761310900 -0.253022040 12.15404297  0.031937469  0.0187736356
       [90,]  0.082504020 -0.057873506  9.96414135 -0.037160310 -0.0442129100
       [91,] -0.659966481  0.494136703  2.42332166  0.049801787 -0.0419374371
       [92,] -0.454909604  0.471484770  2.10817581  0.012772074 -0.0498900986
       [93,] -0.380370892 -0.874857030 10.59495885  0.005877741  0.0109741065
       [94,] -0.251025791 -0.476415627  3.83992116  0.025761254 -0.0074751925
       [95,] -0.133365763  0.134282790  0.98597769  0.027342288 -0.0305212979
       [96,] -0.729239088 -0.558827049  3.77276735 -0.035392174 -0.0172342707
       [97,]  0.133839219 -0.723466594  4.74854179  0.018060863 -0.0040695532
       [98,]  0.016980852  0.447810417  0.98552143 -0.004448415  0.0392953042
       [99,] -0.827555443 -0.555397120  3.73286173 -0.047147391  0.0337261188
      [100,]  0.019795064 -0.065666173  8.91435430 -0.017987990  0.0190098491

---

    Code
      dini_surface_3d(n = 100, num_noise = 0)
    Output
                         x             y          z
        [1,] -9.468889e-02 -0.5182714575  4.1256371
        [2,] -9.546090e-01  0.2946110644  2.8422750
        [3,] -1.939028e-01 -0.0009762715  1.8036500
        [4,]  1.884666e-01 -0.0969331103 10.8354047
        [5,] -2.453890e-02  0.0031306562  5.9051608
        [6,]  7.533870e-01 -0.6346263799  5.5848743
        [7,]  6.818923e-01 -0.7008989757 11.7703626
        [8,] -4.152038e-01  0.1208101047  8.5622158
        [9,]  6.743838e-01 -0.5315520174 11.8452484
       [10,] -9.708896e-01 -0.1209250115  3.2624809
       [11,]  3.320491e-01  0.0325150643 -0.7214676
       [12,]  6.612818e-01  0.6996636006  7.1036825
       [13,] -3.696059e-01  0.9283390035  1.9497164
       [14,] -5.580373e-01  0.1345852391  8.8536965
       [15,]  9.937061e-01 -0.0214676030  6.2620313
       [16,] -8.352008e-01 -0.1355678557  3.2411911
       [17,]  5.564488e-01  0.1254697515 -0.1178361
       [18,] -4.845618e-01  0.4025519964  8.4713738
       [19,] -4.236705e-02  0.0023092290  6.5168280
       [20,]  9.292335e-01  0.2627668586  6.5648598
       [21,] -4.455259e-01 -0.1048288460  2.8441283
       [22,] -5.836887e-02 -0.9908693166 10.9373393
       [23,]  2.650751e-01  0.5597422866  0.8550472
       [24,] -7.639080e-01 -0.6404266474 10.1223057
       [25,] -3.066548e-01 -0.7876523791 10.5624244
       [26,]  7.770237e-01  0.3544550512  6.6547490
       [27,]  1.046639e-01  0.5341917847  7.2820514
       [28,] -9.019542e-01  0.3895842949  9.0148483
       [29,]  7.422421e-01  0.6571236409  0.7238824
       [30,]  6.965871e-01 -0.0410910602 12.3237511
       [31,] -3.593472e-01 -0.9046218176  4.3384132
       [32,] -4.469794e-01 -0.8507862583  4.2360266
       [33,]  3.636955e-01  0.0890181738 -0.4711483
       [34,]  1.073838e-01  0.1363218950  5.7347005
       [35,] -9.760555e-01  0.1175777632  9.3028084
       [36,]  5.659263e-01  0.7999559158  0.9523784
       [37,] -7.563866e-01  0.5644328086  8.7707973
       [38,] -9.585848e-01 -0.2171103648  3.3621940
       [39,] -5.842541e-01 -0.7085396574 10.2831690
       [40,] -3.415068e-01 -0.3506091116  9.7538471
       [41,] -3.274364e-01  0.9356584573  8.1913829
       [42,] -7.339445e-01 -0.3444405208  3.4951446
       [43,]  7.856613e-02  0.5118448855  0.9977348
       [44,] -9.361106e-01  0.0145965599  3.1416416
       [45,] -8.040228e-01 -0.5917889091  3.7760318
       [46,]  3.060084e-01 -0.7489481575 11.2969938
       [47,]  7.008673e-01  0.5906361254  0.7238866
       [48,]  4.954993e-01 -0.8612353256 11.5181445
       [49,]  3.301170e-01  0.6246006224  7.1928736
       [50,] -1.066021e-01 -0.3259361513  3.6030543
       [51,] -2.125556e-01 -0.9566049504 10.7742244
       [52,] -5.068557e-01  0.1373132839  2.4681998
       [53,] -1.748988e-01  0.9205702423  1.7432118
       [54,] -2.772353e-01 -0.3196182002  3.3987724
       [55,]  8.593328e-01  0.4486262279  6.7694475
       [56,] -5.793268e-01  0.7993450166  2.1965693
       [57,] -5.787547e-03 -0.0236878739  7.3488462
       [58,]  7.578492e-01  0.5773643556  0.6609436
       [59,] -1.728209e-01  0.9743683924  1.7453297
       [60,]  2.819110e-01 -0.1386253832  4.9501552
       [61,] -7.099889e-01  0.5865082392  2.4293903
       [62,] -4.408064e-02  0.4521382799  1.1327730
       [63,]  3.681878e-01 -0.8208695972  5.1026031
       [64,] -7.926562e-01  0.3326480499  2.6911969
       [65,] -6.562838e-03  0.0005774142 -1.6617985
       [66,]  3.495426e-01  0.2631486588  6.3596464
       [67,]  1.138083e-01 -0.9925866135  4.8265229
       [68,] -6.693970e-01  0.5055061040  8.7119908
       [69,]  2.137189e-01 -0.1683596980  4.6024180
       [70,] -7.057203e-01 -0.6011703813  3.8279489
       [71,] -9.302739e-01 -0.0149701706  3.1755668
       [72,] -4.489422e-01  0.0625853823  8.7490938
       [73,] -2.133565e-01 -0.2051561571  2.9746726
       [74,]  8.052716e-01 -0.4805423906 12.0132774
       [75,]  5.940137e-01  0.7622661386  0.9029217
       [76,]  1.308751e-01 -0.4531831858  4.4916752
       [77,] -4.393032e-01 -0.5576213084  3.8736164
       [78,] -5.579131e-01  0.3738537783  2.3396223
       [79,] -5.355790e-01 -0.2035065133  3.1687249
       [80,] -1.117318e-01 -0.2636548459  9.6303433
       [81,]  8.052485e-01  0.5035217059  0.5696951
       [82,] -6.725420e-01  0.2487487878  2.6228889
       [83,] -8.490076e-01  0.4961425232  8.8938819
       [84,]  5.173718e-01  0.8088136054  0.9940754
       [85,]  7.978636e-01 -0.3024437173 12.1471488
       [86,] -5.716209e-01 -0.7643586986 10.3440984
       [87,]  8.529488e-01 -0.4075424872 12.1082704
       [88,] -8.595815e-01  0.4500405555  8.9375623
       [89,] -3.036627e-01  0.7766336743  8.1574807
       [90,] -6.089879e-01 -0.1240846843  9.3550482
       [91,]  3.646379e-01 -0.3987231678 11.3516511
       [92,]  2.411843e-01  0.2252203178  6.2049237
       [93,]  7.171279e-05 -0.9046685716  4.6834429
       [94,]  2.134924e-01  0.4334820057  0.6324732
       [95,]  5.637645e-02 -0.0596301726  9.5578116
       [96,]  7.910315e-01  0.5184741807  6.8755721
       [97,]  5.447900e-01  0.5039353731  6.8886889
       [98,] -6.330690e-01  0.5183998897  2.3755516
       [99,] -7.420272e-01  0.6104361047  2.4606215
      [100,]  6.894595e-02 -0.5030016064  4.4108858

# roman_surface_3d() works

    Code
      roman_surface_3d(n = 100, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                         x            y            z                           
        [1,] -1.306904e-02 -0.061479760  0.202577449  0.046811273 -0.0397026339
        [2,]  9.455417e-02  0.286017746  0.267938117 -0.012496258  0.0290763175
        [3,]  1.963898e-01 -0.141707179 -0.444820895 -0.039036306  0.0422360181
        [4,] -3.410296e-03  0.032991970 -0.102162045  0.012114244 -0.0214310022
        [5,] -1.353286e-02 -0.162011383  0.080697823 -0.007777032 -0.0499433291
        [6,]  1.524588e-02  0.268129074  0.052242111 -0.043311664 -0.0356851794
        [7,]  1.410966e-01  0.086468327  0.432959032  0.009618158  0.0015637302
        [8,] -3.778011e-02 -0.257409606  0.133184389  0.040446538 -0.0123396746
        [9,]  4.340756e-03  0.082636506  0.052022578 -0.049745073 -0.0284339315
       [10,] -4.294929e-03 -0.001023880  0.225568717 -0.015265306 -0.0350829806
       [11,] -3.503332e-01 -0.267234015  0.127145062  0.036571148 -0.0353439124
       [12,]  2.702748e-02  0.096184884  0.002626116  0.015919120  0.0423142502
       [13,] -2.723116e-01 -0.250279655  0.081479001 -0.031443569 -0.0051962465
       [14,]  8.627048e-02  0.201083149  0.018268628  0.044940477 -0.0389469245
       [15,]  1.058617e-01 -0.341822671 -0.239982428 -0.028938895 -0.0086575911
       [16,] -3.177041e-01  0.362458950 -0.181920406  0.013595432  0.0232040592
       [17,]  3.164463e-01  0.264800864  0.107102099  0.002368991 -0.0245691278
       [18,] -3.711852e-01  0.036023883 -0.016051251 -0.030572272 -0.0315889175
       [19,] -2.616431e-01  0.425691020 -0.231157200 -0.018436977  0.0227344875
       [20,] -3.369538e-01  0.201071157 -0.356383637  0.045953311 -0.0366494890
       [21,] -1.402386e-01  0.140172058 -0.479502083  0.034806118  0.0157848667
       [22,]  1.542301e-03 -0.028997783 -0.052992069  0.004200594  0.0070135517
       [23,]  4.798042e-03  0.156381651  0.029883114 -0.030929957  0.0208199039
       [24,]  1.944749e-02 -0.073354659 -0.246270760 -0.023326323 -0.0189224581
       [25,] -2.444079e-02 -0.224101599  0.101991176  0.038856192  0.0338216087
       [26,] -3.744296e-01 -0.201021601  0.098593090  0.036005257 -0.0460992394
       [27,] -9.483536e-02  0.455727976 -0.063321673 -0.005547783  0.0447378346
       [28,] -1.555794e-01 -0.242244181  0.041470547  0.010797826  0.0272497393
       [29,]  4.054346e-01 -0.187346194 -0.275981004  0.029635492 -0.0160971409
       [30,] -3.056012e-01 -0.011605060  0.033959753  0.009967849  0.0464448324
       [31,]  1.880595e-01  0.385929272  0.095963473 -0.006457079  0.0179349351
       [32,]  3.604144e-01  0.225893639  0.343261555 -0.030954550 -0.0207382537
       [33,] -6.348793e-02 -0.333834879  0.159087348 -0.025088984  0.0037443788
       [34,] -4.839375e-01 -0.125346203  0.123703604  0.031934072 -0.0118583800
       [35,] -2.993626e-01  0.177888309 -0.062008709 -0.035403466  0.0063740385
       [36,]  1.680193e-01 -0.424341037 -0.241045789 -0.042859625 -0.0297865495
       [37,]  1.303370e-01 -0.481883646 -0.133148518 -0.034428535 -0.0433482581
       [38,] -3.824052e-01 -0.136053148  0.250115015  0.034162961 -0.0163532625
       [39,] -4.395125e-01  0.226251984 -0.172912388 -0.045406635  0.0359919606
       [40,]  2.927428e-01  0.271915803  0.399214894  0.012260502 -0.0370901504
       [41,]  4.394053e-01  0.237752837  0.217606460  0.002252682 -0.0496382012
       [42,]  1.525665e-01 -0.162937322 -0.472681993  0.004865140  0.0114451926
       [43,] -7.165520e-02 -0.034859947  0.390875169  0.037104514 -0.0157686300
       [44,] -2.167561e-01  0.141821509 -0.425018425  0.019189041 -0.0482725061
       [45,]  5.567480e-02 -0.123064995 -0.368559325  0.016947191  0.0417446218
       [46,] -3.185190e-03 -0.049502410  0.063920783  0.023474528  0.0490760001
       [47,]  3.280915e-03  0.119753034  0.026978086 -0.046460505 -0.0143416769
       [48,] -2.628943e-01  0.190380255 -0.418191297 -0.014047195 -0.0389693632
       [49,] -8.022732e-02  0.381207244 -0.163932413 -0.002774406 -0.0050521928
       [50,] -4.384255e-01  0.223718063 -0.238032048  0.021978159 -0.0338490285
       [51,] -1.612843e-03 -0.005218952  0.282086423  0.001459893  0.0007207744
       [52,] -8.841976e-03 -0.166460821  0.051452828 -0.032680244  0.0358561296
       [53,] -6.734700e-02 -0.160482446  0.345658202 -0.006952650 -0.0343432767
       [54,]  4.941666e-01  0.032563935  0.028289169  0.049056897  0.0380912595
       [55,] -1.248938e-02 -0.070708496  0.170400315 -0.037429136 -0.0017651984
       [56,]  7.282822e-02 -0.377227722 -0.152620557  0.040186682  0.0271230818
       [57,] -2.866358e-02  0.333658094 -0.074300955  0.037823953 -0.0153674109
       [58,]  7.749127e-02 -0.110507627 -0.461355088 -0.013801423 -0.0435791666
       [59,]  7.506567e-02  0.183020443  0.336765382  0.014180800 -0.0007038843
       [60,]  1.118937e-01 -0.376397391 -0.052026298  0.016110678 -0.0042624283
       [61,] -2.319400e-01  0.338813374 -0.100066286  0.045699345  0.0307058573
       [62,] -4.300422e-02  0.228038935 -0.171705803 -0.017281139 -0.0172181919
       [63,] -2.013863e-01 -0.297606701  0.070704360 -0.022220930  0.0344564827
       [64,]  6.930720e-06  0.003835237  0.001807084  0.048801365 -0.0145525717
       [65,]  2.861557e-01 -0.075750977 -0.223377533  0.007458667  0.0024064121
       [66,] -3.461152e-01  0.360831116 -0.248650743 -0.033425671  0.0470545179
       [67,] -1.460557e-01  0.070315649 -0.380287636 -0.035560294 -0.0429631366
       [68,] -2.152882e-01 -0.386984698  0.311044926  0.046699327  0.0314480813
       [69,] -3.799672e-01  0.251239088 -0.324884617  0.021227714 -0.0469257004
       [70,] -4.812073e-01  0.135710909 -0.131850042  0.028738201  0.0067218661
       [71,]  1.047156e-01 -0.345124072 -0.235133315 -0.048813058 -0.0365070718
       [72,]  1.438713e-01 -0.441928157 -0.201455190 -0.025414831  0.0148092618
       [73,] -4.198529e-01 -0.195994221  0.263669125 -0.044960774 -0.0288158743
       [74,] -2.943910e-01  0.287633709 -0.108019482 -0.032921567 -0.0393909458
       [75,] -2.488041e-02  0.096025936 -0.240387757  0.004026652 -0.0436995254
       [76,]  2.648335e-01 -0.100789831 -0.303159563  0.014284641 -0.0465217978
       [77,] -1.369873e-01  0.467823993 -0.164848723 -0.032963758 -0.0291392233
       [78,] -3.124783e-02 -0.461281505  0.046553355  0.049464466  0.0114881480
       [79,] -1.114733e-01  0.142382394 -0.468963608 -0.036069776 -0.0194828836
       [80,] -4.223685e-01  0.206207479 -0.129888998  0.020289299 -0.0485348954
       [81,] -1.423431e-01  0.279692940 -0.359457614  0.036633093 -0.0097199444
       [82,]  9.374558e-02 -0.120420518 -0.473158829 -0.029914531 -0.0044783109
       [83,] -1.765258e-02  0.375470240 -0.038922570  0.035608689  0.0366461525
       [84,] -3.314004e-01  0.253939337 -0.108571663  0.030768446 -0.0395055116
       [85,] -6.367353e-02  0.474109057 -0.085153841  0.022653194 -0.0053874930
       [86,]  4.548659e-02  0.176637905  0.233177284  0.014886355  0.0058034629
       [87,]  7.350894e-02  0.277639358  0.224974856 -0.003475857  0.0060975001
       [88,]  1.334260e-01 -0.432944387 -0.200268978  0.021506445 -0.0234173421
       [89,] -9.328826e-04  0.008609155 -0.107093783  0.031937469  0.0187736356
       [90,] -1.467996e-01  0.023752496 -0.154106722 -0.037160310 -0.0442129100
       [91,]  1.106733e-03  0.028216455  0.039131464  0.049801787 -0.0419374371
       [92,]  8.657199e-02  0.215663220  0.325908924  0.012772074 -0.0498900986
       [93,] -4.023227e-01 -0.090663372  0.167856091  0.005877741  0.0109741065
       [94,]  1.682362e-01  0.425318734  0.240107256  0.025761254 -0.0074751925
       [95,]  4.215350e-01  0.156230462  0.234249521  0.027342288 -0.0305212979
       [96,]  3.105447e-02 -0.201198219 -0.144225112 -0.035392174 -0.0172342707
       [97,]  2.310118e-02  0.243457796  0.088033115  0.018060863 -0.0040695532
       [98,]  1.925985e-01  0.185806049  0.460879339 -0.004448415  0.0392953042
       [99,]  3.495120e-01 -0.356432450 -0.264067007 -0.047147391  0.0337261188
      [100,] -2.947455e-01  0.033603044 -0.101569692 -0.017987990  0.0190098491

---

    Code
      roman_surface_3d(n = 100, num_noise = 0)
    Output
                         x            y            z
        [1,]  1.590599e-01  0.446110949  0.208864035
        [2,]  3.343648e-01 -0.305186183 -0.354659052
        [3,]  4.544721e-01  0.203679392  0.203167293
        [4,] -1.048978e-01  0.036829248 -0.308654375
        [5,] -4.982407e-01  0.028308835 -0.026567388
        [6,]  1.451715e-01 -0.354790073 -0.062734008
        [7,] -1.724938e-01 -0.062878166  0.310529622
        [8,] -2.883820e-01  0.372485781 -0.323160628
        [9,] -4.317613e-04 -0.008516780  0.050561735
       [10,]  1.450791e-01 -0.330883211 -0.310992717
       [11,]  1.806695e-02  0.010694054  0.438143362
       [12,] -1.862966e-01 -0.229519744  0.047338533
       [13,]  2.773163e-01 -0.220198223 -0.415402805
       [14,] -1.631125e-01  0.351167501 -0.311892280
       [15,]  4.153571e-03 -0.421346722 -0.002275317
       [16,]  9.275446e-05 -0.010025751 -0.009249901
       [17,]  1.853824e-02  0.026156358  0.471282186
       [18,] -1.082079e-01  0.344481187 -0.241839959
       [19,] -4.975965e-01  0.047637858 -0.046358224
       [20,] -6.409051e-02 -0.249076327  0.017187500
       [21,]  2.675074e-01  0.372263105  0.331556556
       [22,] -2.853845e-01 -0.162930674  0.377544176
       [23,]  6.640215e-02  0.120281807  0.414963123
       [24,] -2.285588e-01 -0.286727054  0.409393536
       [25,] -5.014410e-05 -0.005143443  0.009747948
       [26,] -1.473978e-04 -0.037019854  0.003976060
       [27,] -1.214897e-01  0.457434660 -0.164043187
       [28,] -1.571449e-01 -0.361979484  0.294799711
       [29,]  7.173933e-02 -0.088438006 -0.482819579
       [30,] -1.804864e-03  0.004830084 -0.327879541
       [31,]  3.749714e-01 -0.257393030 -0.136375635
       [32,]  4.048652e-01 -0.196734268 -0.110985503
       [33,]  4.062072e-02  0.028010549  0.466202248
       [34,] -2.023101e-01  0.253853892 -0.058340495
       [35,] -1.626282e-01 -0.341195239  0.321332585
       [36,]  6.925267e-02 -0.108522416 -0.445830947
       [37,] -6.120577e-02 -0.271792666  0.196147235
       [38,]  1.609252e-01 -0.348790342 -0.311959615
       [39,] -2.932318e-02 -0.131860255  0.207961743
       [40,] -2.220522e-01  0.276238010 -0.416376297
       [41,] -3.251933e-01 -0.357056680  0.184463644
       [42,]  3.576942e-03  0.066555835  0.053349564
       [43,]  1.402169e-01  0.171937604  0.464350402
       [44,]  4.939411e-01 -0.076969594 -0.077571981
       [45,]  2.472442e-01 -0.404623210 -0.293021149
       [46,] -2.265223e-03  0.026163308 -0.085876636
       [47,]  1.713747e-01 -0.004860996 -0.027482825
       [48,] -1.935433e-01 -0.108543201  0.404476950
       [49,] -2.845665e-02  0.301788096 -0.083895264
       [50,]  2.942656e-01  0.396867441  0.202456387
       [51,] -1.176378e-01 -0.198541144  0.413796514
       [52,]  2.068486e-01  0.324880862  0.370972091
       [53,]  4.192296e-02 -0.132557902 -0.281835879
       [54,]  2.722488e-01  0.412346596  0.265073101
       [55,] -1.097411e-01 -0.267482596  0.032330363
       [56,]  1.609955e-01 -0.250904499 -0.409708560
       [57,] -3.927017e-01  0.016735749 -0.034416285
       [58,]  1.542409e-01 -0.029941684 -0.182335003
       [59,]  1.476170e-01 -0.205778972 -0.441004089
       [60,]  8.704090e-02  0.419044998  0.048086725
       [61,]  3.291490e-02 -0.146706338 -0.208663535
       [62,]  2.016723e-01  0.201700310  0.455332209
       [63,]  9.383489e-03 -0.175105072 -0.051737325
       [64,]  1.441386e-03 -0.034302300 -0.041896525
       [65,]  4.994653e-01  0.007154889  0.007475928
       [66,] -9.097294e-02  0.488101621 -0.079435101
       [67,]  1.810893e-01 -0.465388823 -0.177387007
       [68,] -2.782426e-05  0.006218441 -0.004474212
       [69,]  1.349274e-01  0.375469294  0.063218953
       [70,]  3.913060e-02 -0.226775082 -0.158162044
       [71,]  4.964091e-01 -0.059815378 -0.059336064
       [72,] -2.725237e-01  0.364007326 -0.339631682
       [73,]  3.679110e-01  0.335607616  0.226631297
       [74,] -1.473401e-02 -0.042104423  0.311140479
       [75,]  4.827685e-02 -0.093307333 -0.403582655
       [76,]  1.544091e-01  0.474056322  0.158368151
       [77,]  4.749011e-02  0.260430432  0.163101190
       [78,]  7.746056e-02  0.219346872  0.295959477
       [79,]  1.625342e-01  0.361402854  0.301094740
       [80,] -3.359632e-01  0.187136994 -0.348401806
       [81,]  1.337631e-01 -0.023735333 -0.168790899
       [82,]  4.718574e-02  0.188953280  0.225780508
       [83,] -1.581749e-01 -0.372767258  0.285256976
       [84,]  4.571788e-02 -0.097302283 -0.380384574
       [85,] -1.096218e-04 -0.003153568  0.034718906
       [86,] -7.457548e-02 -0.195887900  0.317198178
       [87,] -1.480393e-02 -0.037876314  0.338492690
       [88,] -1.167861e-01 -0.336381377  0.263674562
       [89,] -1.963513e-04  0.019277583 -0.010180631
       [90,] -1.216787e-01  0.288295311 -0.318829667
       [91,] -7.856007e-02  0.100471082 -0.477216814
       [92,] -1.368180e-01  0.427665563 -0.081271509
       [93,]  1.467140e-02 -0.184260436 -0.076318893
       [94,]  1.302833e-01  0.137343571  0.480719159
       [95,] -1.945235e-01  0.025774009 -0.124989065
       [96,] -1.396271e-01 -0.150623688  0.022002121
       [97,] -1.180077e-02  0.241773696 -0.045649842
       [98,]  2.013435e-03  0.037586828  0.053338513
       [99,]  4.455339e-01 -0.129415563 -0.183871445
      [100,]  1.475765e-01  0.465745778  0.174587396

# spiral_3d() works

    Code
      spiral_3d(n = 100, num_dims = 6, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                     [,1]          [,2]          [,3]          [,4]          [,5]
        [1,] -0.439112258  0.0427584121 -4.163586e-03  4.054279e-04 -3.947840e-05
        [2,] -1.162891415  1.0326564554 -9.170068e-01  8.143091e-01 -7.231127e-01
        [3,]  0.616623480 -0.3594179731  2.094978e-01 -1.221123e-01  7.117689e-02
        [4,] -0.872298453 -0.6776035480 -5.263641e-01 -4.088809e-01 -3.176197e-01
        [5,]  0.014110930  0.0004058330  1.167184e-05  3.356842e-07  9.654342e-09
        [6,]  0.519877205  0.5154836421  5.111272e-01  5.068076e-01  5.025245e-01
        [7,] -0.040384530  0.0003622093 -3.248659e-06  2.913726e-08 -2.613324e-10
        [8,]  1.027601537  0.5292064218  2.725370e-01  1.403543e-01  7.228134e-02
        [9,]  1.611036044 -1.1898789351  8.788207e-01 -6.490794e-01  4.793970e-01
       [10,] -1.342482766  1.0729532471 -8.575370e-01  6.853698e-01 -5.477685e-01
       [11,]  1.029051287  0.8442528612  6.926408e-01  5.682554e-01  4.662073e-01
       [12,]  0.253977652  0.2519700010  2.499782e-01  2.480022e-01  2.460418e-01
       [13,]  0.144455983  0.0797913559  4.407336e-02  2.434425e-02  1.344673e-02
       [14,] -0.329662221  0.2988278239 -2.708775e-01  2.455414e-01 -2.225751e-01
       [15,]  1.626794727 -1.1139113892  7.627260e-01 -5.222596e-01  3.576056e-01
       [16,] -0.074938088  0.0749145653 -7.489105e-02  7.486754e-02 -7.484404e-02
       [17,] -0.495208057 -0.1615567939 -5.270633e-02 -1.719492e-02 -5.609676e-03
       [18,]  0.974991432  0.4600587254  2.170830e-01  1.024326e-01  4.833377e-02
       [19,] -0.113273921  0.1132447495 -1.132156e-01  1.131864e-01 -1.131573e-01
       [20,] -1.662003733  0.6482627786 -2.528542e-01  9.862551e-02 -3.846878e-02
       [21,]  1.544647046 -1.2300110147  9.794646e-01 -7.799531e-01  6.210810e-01
       [22,]  0.056960525  0.0007217050  9.144195e-06  1.158594e-07  1.467969e-09
       [23,]  0.331123158  0.0450515394  6.129566e-03  8.339688e-04  1.134671e-04
       [24,]  0.063481581  0.0561864761  4.972970e-02  4.401492e-02  3.895686e-02
       [25,]  0.008577614 -0.0085775785  8.577543e-03 -8.577508e-03  8.577473e-03
       [26,] -0.823609694  0.1513738103 -2.782147e-02  5.113395e-03 -9.398069e-04
       [27,]  0.927075359  0.4057583052  1.775905e-01  7.772705e-02  3.401924e-02
       [28,]  0.144538991  0.0732646885  3.713679e-02  1.882409e-02  9.541656e-03
       [29,] -0.123099435 -0.0099642300 -8.065502e-04 -6.528586e-05 -5.284535e-06
       [30,]  1.599712026 -0.9932317507  6.166793e-01 -3.828848e-01  2.377261e-01
       [31,]  1.617190318 -1.1776862653  8.576263e-01 -6.245491e-01  4.548153e-01
       [32,] -0.376355231  0.2684783340 -1.915228e-01  1.366255e-01 -9.746375e-02
       [33,] -0.609595011 -0.5724397350 -5.375491e-01 -5.047851e-01 -4.740180e-01
       [34,]  0.024458773  0.0012379013  6.265235e-05  3.170945e-06  1.604871e-07
       [35,]  1.373670507 -1.1886470967  1.028545e+00 -8.900075e-01  7.701300e-01
       [36,]  0.012083252  0.0118486040  1.161851e-02  1.139289e-02  1.117165e-02
       [37,]  1.589589117 -0.9673849752  5.887268e-01 -3.582847e-01  2.180433e-01
       [38,]  0.164590099 -0.1625054095  1.604471e-01 -1.584149e-01  1.564084e-01
       [39,]  1.905706346  1.6011187672  1.345213e+00  1.130209e+00  9.495684e-01
       [40,] -0.380175467  0.2794364310 -2.053913e-01  1.509666e-01 -1.109634e-01
       [41,] -0.666604002  0.0988100402 -1.464651e-02  2.171038e-03 -3.218108e-04
       [42,]  0.595472727 -0.4623707716  3.590202e-01 -2.787709e-01  2.164591e-01
       [43,] -0.381278059  0.3062536134 -2.459918e-01  1.975878e-01 -1.587082e-01
       [44,] -0.738948832  0.2203329382 -6.569684e-02  1.958888e-02 -5.840830e-03
       [45,]  1.044830945  0.8462647441  6.854353e-01  5.551709e-01  4.496628e-01
       [46,]  1.119683956  0.8110979708  5.875586e-01  4.256269e-01  3.083237e-01
       [47,]  0.056247432  0.0069192137  8.511592e-04  1.047044e-04  1.288009e-05
       [48,] -0.627624059  0.6123035419 -5.973570e-01  5.827753e-01 -5.685496e-01
       [49,]  1.437473116 -1.2143153932  1.025801e+00 -8.665528e-01  7.320265e-01
       [50,] -0.781599976  0.7503838378 -7.204144e-01  6.916420e-01 -6.640186e-01
       [51,]  1.594138938 -1.2098305007  9.181696e-01 -6.968210e-01  5.288343e-01
       [52,] -1.692950346  0.6749027786 -2.690532e-01  1.072594e-01 -4.275946e-02
       [53,] -1.335349968  0.8503204461 -5.414647e-01  3.447924e-01 -2.195559e-01
       [54,] -0.198084471  0.1933085305 -1.886477e-01  1.840993e-01 -1.796606e-01
       [55,] -1.374169470  1.0303414629 -7.725419e-01  5.792459e-01 -4.343140e-01
       [56,] -1.243241382  0.3509339703 -9.905932e-02  2.796181e-02 -7.892876e-03
       [57,] -0.149006457  0.1471106652 -1.452390e-01  1.433911e-01 -1.415668e-01
       [58,]  1.078821558  0.2721927598  6.867577e-02  1.732728e-02  4.371771e-03
       [59,]  0.337290965  0.0254900507  1.926357e-03  1.455803e-04  1.100192e-05
       [60,] -0.868737950  0.8547654287 -8.410176e-01  8.274910e-01 -8.141818e-01
       [61,]  0.683930400  0.6419406005  6.025288e-01  5.655366e-01  5.308156e-01
       [62,] -0.363509267  0.2419300181 -1.610141e-01  1.071614e-01 -7.132020e-02
       [63,] -0.206800450  0.2012875048 -1.959215e-01  1.906986e-01 -1.856149e-01
       [64,] -0.381463686  0.2842577383 -2.118222e-01  1.578449e-01 -1.176223e-01
       [65,]  1.547770696 -1.2295797387  9.768025e-01 -7.759913e-01  6.164629e-01
       [66,]  1.348075084 -1.1762498578  1.026325e+00 -8.955103e-01  7.813688e-01
       [67,] -1.865686447 -1.2750258336 -8.713634e-01 -5.954971e-01 -4.069677e-01
       [68,] -2.295312095  1.4270624209 -8.872463e-01  5.516269e-01 -3.429625e-01
       [69,]  0.319952550 -0.3181479313  3.163535e-01 -3.145692e-01  3.127949e-01
       [70,]  0.143813778  0.0817985629  4.652548e-02  2.646281e-02  1.505155e-02
       [71,] -0.754093743 -0.3996855389 -2.118417e-01 -1.122806e-01 -5.951107e-02
       [72,] -0.816484943 -0.1918181154 -4.506414e-02 -1.058699e-02 -2.487218e-03
       [73,]  0.446447308  0.4354038889  4.246336e-01  4.141298e-01  4.038858e-01
       [74,] -1.875539234 -1.3764098350 -1.010112e+00 -7.412949e-01 -5.440172e-01
       [75,]  2.027579349  1.6133707238  1.283780e+00  1.021520e+00  8.128363e-01
       [76,] -0.253409218  0.0142362438 -7.997761e-04  4.493052e-05 -2.524146e-06
       [77,] -0.424661174 -0.0513397443 -6.206758e-03 -7.503709e-04 -9.071668e-05
       [78,]  0.026939663  0.0015075004  8.435731e-05  4.720500e-06  2.641516e-07
       [79,] -0.142307802  0.1406700366 -1.390511e-01  1.374508e-01 -1.358690e-01
       [80,]  0.136008325 -0.1348242125  1.336504e-01 -1.324868e-01  1.313334e-01
       [81,]  0.596699825 -0.3191439156  1.706936e-01 -9.129519e-02  4.882908e-02
       [82,] -0.098432424  0.0176679025 -3.171260e-03  5.692180e-04 -1.021705e-04
       [83,] -0.046755410  0.0041542099 -3.691008e-04  3.279454e-05 -2.913789e-06
       [84,] -1.869003374 -1.2894026193 -8.895431e-01 -6.136850e-01 -4.233738e-01
       [85,] -1.886895845  1.7033393069 -1.537639e+00  1.388058e+00 -1.253028e+00
       [86,]  2.098207247  1.3280500500  8.405828e-01  5.320428e-01  3.367539e-01
       [87,]  0.177205955  0.0070032498  2.767712e-04  1.093811e-05  4.322784e-07
       [88,] -0.294290997  0.2749809356 -2.569379e-01  2.400788e-01 -2.243259e-01
       [89,] -0.020771975  0.0008419290 -3.412504e-05  1.383155e-06 -5.606198e-08
       [90,]  1.549425586 -1.2293190269  9.753455e-01 -7.738421e-01  6.139687e-01
       [91,] -0.595858498 -0.5888807578 -5.819847e-01 -5.751695e-01 -5.684340e-01
       [92,] -0.954011894  0.3767938037 -1.488174e-01  5.877649e-02 -2.321420e-02
       [93,]  0.857955325  0.7676702712  6.868862e-01  6.146032e-01  5.499268e-01
       [94,]  1.088969761  0.6328276871  3.677521e-01  2.137100e-01  1.241922e-01
       [95,]  1.954019321  1.0466199259  5.605949e-01  3.002682e-01  1.608309e-01
       [96,] -0.204133617  0.1988547775 -1.937124e-01  1.887031e-01 -1.838233e-01
       [97,]  1.251326512 -1.1213424657  1.004861e+00 -9.004788e-01  8.069398e-01
       [98,] -0.846198010 -0.5413540454 -3.463305e-01 -2.215645e-01 -1.417456e-01
       [99,] -1.809171494 -1.4613798006 -1.180447e+00 -9.535200e-01 -7.702172e-01
      [100,] -0.115061938  0.0238879142 -4.959350e-03  1.029607e-03 -2.137558e-04
                    [,6]          [,7]         [,8]
        [1,] -0.44120897 -0.0494111540 -0.046811273
        [2,] -2.52896654 -0.0095421034  0.012496258
        [3,] -0.75886732 -0.0095423958  0.039036306
        [4,]  1.38516271 -0.0056648134 -0.012114244
        [5,]  0.01411677 -0.0361641475  0.007777032
        [6,]  4.00725771 -0.0137938427  0.043311664
        [7,] -0.04038615  0.0227676261 -0.009618158
        [8,]  1.19879543  0.0486252397 -0.040446538
        [9,] -2.38967304 -0.0374798555  0.049745073
       [10,] -2.23365709 -0.0060145900  0.015265306
       [11,]  1.79978554  0.0122375009 -0.036571148
       [12,]  2.02392333 -0.0151320067 -0.015919120
       [13,]  0.17329021 -0.0069745122  0.031443569
       [14,] -0.78067708  0.0119806817 -0.044940477
       [15,] -2.23215826  0.0425165671  0.028938895
       [16,] -2.99108510 -0.0198855986 -0.013595432
       [17,]  0.52387065  0.0341541310 -0.002368991
       [18,]  1.10584134  0.0139019090  0.030572272
       [19,] -4.99149006  0.0043720318  0.018436977
       [20,] -1.80496777 -0.0362611223 -0.045953311
       [21,] -2.55358050 -0.0091411981 -0.034806118
       [22,]  0.05696510  0.0375122381 -0.004200594
       [23,]  0.33423116 -0.0205436346  0.030929957
       [24,]  0.13639253  0.0096704798  0.023326323
       [25,] -3.00089758 -0.0074246488 -0.038856192
       [26,] -0.83788308 -0.0395226781 -0.036005257
       [27,]  1.03107708  0.0140160184  0.005547783
       [28,]  0.16767601  0.0001349537 -0.010797826
       [29,]  0.12350470  0.0395929786 -0.029635492
       [30,] -2.04069795 -0.0421812224 -0.009967849
       [31,] -2.35971474 -0.0192060802  0.006457079
       [32,] -0.53704153  0.0329963851  0.030954550
       [33,]  1.77319885 -0.0441801412  0.025088984
       [34,]  0.02449016  0.0359260298 -0.031934072
       [35,] -2.74053484 -0.0215506210  0.035403466
       [36,]  0.06161276 -0.0231140854  0.042859625
       [37,] -2.00327305 -0.0290469873  0.034428535
       [38,] -1.03740751  0.0346599014 -0.034162961
       [39,]  3.51397617 -0.0245407152  0.045406635
       [40,] -0.56069288  0.0438232428 -0.012260502
       [41,] -0.67405019  0.0190370204 -0.002252682
       [42,] -0.94497609 -0.0157330000 -0.004865140
       [43,] -0.64008239  0.0136145061 -0.037104514
       [44,] -0.77416356 -0.0211817049 -0.019189041
       [45,]  1.78148692 -0.0296529576 -0.016947191
       [46,]  1.62418763 -0.0385897858 -0.023474528
       [47,]  0.05667790 -0.0114352393  0.046460505
       [48,] -2.85801360  0.0394679684  0.014047195
       [49,] -2.68611165 -0.0379028531  0.002774406
       [50,] -2.79352394  0.0086608654 -0.021978159
       [51,] -2.44808077  0.0397832549 -0.001459893
       [52,] -1.84598015 -0.0389684510  0.032680244
       [53,] -1.73186397 -0.0107839450  0.006952650
       [54,] -0.90753813  0.0229901668 -0.049056897
       [55,] -2.07680915 -0.0032016000  0.037429136
       [56,] -1.29594216 -0.0188916723 -0.040186682
       [57,] -0.93709390 -0.0406173033 -0.037823953
       [58,]  1.11489096  0.0218278701  0.013801423
       [59,]  0.33825829 -0.0178925602 -0.014180800
       [60,] -4.86333440  0.0418970450 -0.016110678
       [61,]  1.98244560 -0.0289520095 -0.045699345
       [62,] -0.48704148  0.0182308341  0.017281139
       [63,] -0.90164222  0.0420673159  0.022220930
       [64,] -0.57202330 -0.0215416480 -0.048801365
       [65,] -2.54832012 -0.0032879685 -0.007458667
       [66,] -2.75938356  0.0136172979  0.033425671
       [67,]  2.55560795 -0.0128606171  0.035560294
       [68,] -2.93056354  0.0406865353 -0.046699327
       [69,] -3.01671198 -0.0056567913 -0.021227714
       [70,]  0.17485193  0.0206802091 -0.028738201
       [71,]  0.88927774  0.0293639539  0.048813058
       [72,]  0.83999480  0.0099463716  0.025414831
       [73,]  2.01971913  0.0216768384  0.044960774
       [74,]  2.76104741  0.0126717287  0.032921567
       [75,]  3.34764030  0.0137911398 -0.004026652
       [76,] -0.25381006 -0.0201560635 -0.014284641
       [77,]  0.42779899 -0.0474466317  0.032963758
       [78,]  0.02698194  0.0034467781 -0.049464466
       [79,] -0.94070910 -0.0451321898  0.036069776
       [80,] -1.03296127  0.0449525188 -0.020289299
       [81,] -0.70619704  0.0301143471 -0.036633093
       [82,] -0.10005743  0.0015380326  0.029914531
       [83,] -0.04694106  0.0313923658 -0.035608689
       [84,]  2.58179480  0.0142799772 -0.030768446
       [85,] -4.38580663 -0.0342363236 -0.022653194
       [86,]  2.71017347 -0.0437694831 -0.014886355
       [87,]  0.17734450  0.0163590239  0.003475857
       [88,] -0.82604221  0.0215670073 -0.021506445
       [89,] -0.02078906  0.0312772650 -0.031937469
       [90,] -2.54548090  0.0404797181  0.037160310
       [91,]  3.90496808  0.0197967365 -0.049801787
       [92,] -1.03843732 -0.0082434738 -0.012772074
       [93,]  1.92137065  0.0110442976 -0.005877741
       [94,]  1.33810608  0.0086618911 -0.025761254
       [95,]  2.31393722  0.0378016111 -0.027342288
       [96,] -0.90346965  0.0267662517  0.035392174
       [97,] -2.81953630  0.0202962862 -0.018060863
       [98,]  1.10098286 -0.0326327926  0.004448415
       [99,]  3.06894699 -0.0398299208  0.047147391
      [100,] -0.11762476  0.0465680600  0.017987990

---

    Code
      spiral_3d(n = 100, num_dims = 6, num_noise = 0)
    Output
                      [,1]          [,2]          [,3]          [,4]          [,5]
        [1,]  6.387390e-02  6.384161e-02  6.380934e-02  6.377709e-02  6.374485e-02
        [2,] -1.801128e+00 -1.109818e+00 -6.838475e-01 -4.213729e-01 -2.596414e-01
        [3,] -3.294340e-01  2.986943e-01 -2.708229e-01  2.455522e-01 -2.226396e-01
        [4,] -1.363439e-03  1.363439e-03 -1.363439e-03  1.363438e-03 -1.363438e-03
        [5,]  4.358612e-01  4.332799e-01  4.307138e-01  4.281629e-01  4.256271e-01
        [6,] -8.784703e-01 -6.435661e-01 -4.714757e-01 -3.454025e-01 -2.530414e-01
        [7,]  8.270871e-01 -2.065908e-01  5.160250e-02 -1.288933e-02  3.219513e-03
        [8,]  5.278603e-01 -4.482545e-01  3.806540e-01 -3.232482e-01  2.744996e-01
        [9,] -7.135510e-01 -6.464988e-01 -5.857476e-01 -5.307051e-01 -4.808349e-01
       [10,] -1.512975e+00  5.296506e-01 -1.854161e-01  6.490904e-02 -2.272286e-02
       [11,] -1.839297e-01  1.835778e-01 -1.832265e-01  1.828759e-01 -1.825260e-01
       [12,] -9.949899e-01 -9.598412e-01 -9.259341e-01 -8.932249e-01 -8.616711e-01
       [13,] -1.237436e+00  3.475498e-01 -9.761383e-02  2.741610e-02 -7.700162e-03
       [14,] -7.645906e-01 -6.750800e-01 -5.960483e-01 -5.262690e-01 -4.646586e-01
       [15,] -2.848681e-01 -5.295825e-02 -9.845177e-03 -1.830263e-03 -3.402540e-04
       [16,] -6.458010e-01 -2.820210e-01 -1.231584e-01 -5.378324e-02 -2.348712e-02
       [17,]  6.492954e-01  6.137834e-01  5.802137e-01  5.484801e-01  5.184820e-01
       [18,]  1.177838e-01  3.650783e-02  1.131583e-02  3.507412e-03  1.087144e-03
       [19,]  1.999539e-01 -1.962360e-01  1.925872e-01 -1.890063e-01  1.854920e-01
       [20,] -2.913338e-01  2.727640e-01 -2.553778e-01  2.390998e-01 -2.238594e-01
       [21,]  3.411907e-01 -3.225026e-01  3.048382e-01 -2.881413e-01  2.723589e-01
       [22,]  1.221461e+00 -4.816063e-01  1.898911e-01 -7.487161e-02  2.952090e-02
       [23,]  1.118613e+00  8.132813e-01  5.912915e-01  4.298951e-01  3.125528e-01
       [24,] -1.582139e-01 -1.580891e-01 -1.579644e-01 -1.578398e-01 -1.577153e-01
       [25,]  6.445287e-02 -2.797842e-03  1.214519e-04 -5.272118e-06  2.288580e-07
       [26,]  8.815861e-01  7.820182e-01  6.936956e-01  6.153484e-01  5.458498e-01
       [27,] -1.033437e+00  4.485506e-01 -1.946879e-01  8.450186e-02 -3.667699e-02
       [28,]  2.556392e-02  2.448446e-02  2.345059e-02  2.246037e-02  2.151196e-02
       [29,]  1.504874e+00 -8.092296e-01  4.351543e-01 -2.339995e-01  1.258307e-01
       [30,] -1.579596e+00  5.807669e-01 -2.135294e-01  7.850791e-02 -2.886485e-02
       [31,]  7.598567e-02 -3.896710e-03  1.998317e-04 -1.024781e-05  5.255297e-07
       [32,]  1.124214e+00  7.333450e-01  4.783742e-01  3.120521e-01  2.035572e-01
       [33,] -6.446808e-01 -2.809633e-01 -1.224488e-01 -5.336535e-02 -2.325756e-02
       [34,]  2.111351e-06  8.915629e-12  3.764814e-17  1.589773e-22  6.713155e-28
       [35,]  8.039987e-01  7.874312e-01  7.712052e-01  7.553135e-01  7.397493e-01
       [36,]  1.365013e+00 -6.262993e-01  2.873605e-01 -1.318476e-01  6.049471e-02
       [37,] -1.808567e+00 -1.461530e+00 -1.181084e+00 -9.544512e-01 -7.713061e-01
       [38,]  4.826744e-01 -4.250961e-01  3.743863e-01 -3.297257e-01  2.903926e-01
       [39,] -2.394001e-01  2.303170e-01 -2.215786e-01  2.131716e-01 -2.050837e-01
       [40,] -9.669097e-02 -2.665516e-03 -7.348126e-05 -2.025685e-06 -5.584281e-08
       [41,] -8.712109e-01 -6.794384e-01 -5.298791e-01 -4.132412e-01 -3.222777e-01
       [42,] -2.203814e+00  1.262153e+00 -7.228516e-01  4.139866e-01 -2.370956e-01
       [43,]  5.908812e-02  5.284332e-02  4.725852e-02  4.226395e-02  3.779724e-02
       [44,] -1.339280e+00  8.590057e-01 -5.509609e-01  3.533829e-01 -2.266576e-01
       [45,]  1.891725e+00  9.584055e-01  4.855574e-01  2.459981e-01  1.246301e-01
       [46,]  4.623242e-01  4.500330e-01  4.380687e-01  4.264224e-01  4.150857e-01
       [47,] -9.086402e-01  8.566986e-01 -8.077262e-01  7.615532e-01 -7.180197e-01
       [48,]  1.941761e+00  1.028382e+00  5.446448e-01  2.884510e-01  1.527675e-01
       [49,] -3.621358e-01  3.127638e-01 -2.701229e-01  2.332956e-01 -2.014891e-01
       [50,]  4.923577e-01 -7.092413e-02  1.021662e-02 -1.471704e-03  2.119990e-04
       [51,] -5.737765e-01  1.314173e-01 -3.009970e-02  6.894009e-03 -1.578998e-03
       [52,]  1.396492e+00 -1.198765e+00  1.029034e+00 -8.833345e-01  7.582646e-01
       [53,] -3.692492e-01  2.527414e-01 -1.729949e-01  1.184105e-01 -8.104887e-02
       [54,] -1.718407e+00 -9.686998e-01 -5.460751e-01 -3.078333e-01 -1.735317e-01
       [55,] -1.673084e+00 -1.442591e+00 -1.243851e+00 -1.072491e+00 -9.247390e-01
       [56,] -3.555333e-01  2.284439e-01 -1.467841e-01  9.431446e-02 -6.060070e-02
       [57,] -3.355828e-01  1.992719e-01 -1.183293e-01  7.026495e-02 -4.172392e-02
       [58,]  1.448214e+00 -1.217742e+00  1.023947e+00 -8.609938e-01  7.239732e-01
       [59,]  1.188708e-02  1.166008e-02  1.143741e-02  1.121899e-02  1.100475e-02
       [60,]  6.264160e-01 -4.386585e-01  3.071781e-01 -2.151067e-01  1.506321e-01
       [61,] -1.371704e+00  9.541097e-01 -6.636459e-01  4.616092e-01 -3.210795e-01
       [62,]  2.106417e-01  9.903849e-03  4.656544e-04  2.189391e-05  1.029398e-06
       [63,]  4.023667e-01  3.943236e-01  3.864413e-01  3.787166e-01  3.711462e-01
       [64,] -8.113874e-01 -4.798460e-01 -2.837759e-01 -1.678221e-01 -9.924821e-02
       [65,] -1.089034e-01 -3.380643e-03 -1.049439e-04 -3.257732e-06 -1.011284e-07
       [66,]  2.729411e-01  2.704490e-01  2.679796e-01  2.655327e-01  2.631082e-01
       [67,] -4.386968e-02  4.382613e-02 -4.378263e-02  4.373917e-02 -4.369575e-02
       [68,] -4.949005e-01 -1.613508e-01 -5.260469e-02 -1.715054e-02 -5.591534e-03
       [69,] -1.835457e+00  8.076677e-01 -3.554032e-01  1.563903e-01 -6.881743e-02
       [70,] -1.069573e+00 -3.344346e-01 -1.045712e-01 -3.269739e-02 -1.022384e-02
       [71,]  9.383103e-01  8.125559e-01  7.036554e-01  6.093500e-01  5.276836e-01
       [72,]  1.428298e-01  8.360867e-02  4.894223e-02  2.864945e-02  1.677060e-02
       [73,]  2.483480e-02 -2.482725e-02  2.481971e-02 -2.481217e-02  2.480463e-02
       [74,]  1.127142e+00  7.543928e-01  5.049127e-01  3.379365e-01  2.261798e-01
       [75,]  6.886225e-01 -6.701281e-01  6.521303e-01 -6.346159e-01  6.175719e-01
       [76,] -4.258070e-01 -4.233160e-01 -4.208396e-01 -4.183777e-01 -4.159302e-01
       [77,]  2.123884e+00  1.510852e+00  1.074764e+00  7.645473e-01  5.438705e-01
       [78,]  1.972944e-01  1.578098e-02  1.262272e-03  1.009652e-04  8.075900e-06
       [79,]  5.062067e-01 -4.989983e-01  4.918925e-01 -4.848880e-01  4.779832e-01
       [80,] -3.829954e-01  2.935617e-01 -2.250118e-01  1.724690e-01 -1.321956e-01
       [81,]  6.212494e-01  1.659093e-01  4.430734e-02  1.183261e-02  3.159988e-03
       [82,]  1.121725e+00  8.062845e-01  5.795491e-01  4.165739e-01  2.994291e-01
       [83,] -2.458133e-01  2.449661e-01 -2.441218e-01  2.432805e-01 -2.424420e-01
       [84,]  5.292416e-01 -2.287814e-01  9.889795e-02 -4.275176e-02  1.848079e-02
       [85,]  1.715466e+00  7.516212e-01  3.293183e-01  1.442888e-01  6.321929e-02
       [86,]  1.388348e-01  8.707411e-02  5.461097e-02  3.425080e-02  2.148134e-02
       [87,] -8.445603e-01 -6.955935e-01 -5.729020e-01 -4.718513e-01 -3.886243e-01
       [88,]  6.896471e-02  1.058191e-03  1.623683e-05  2.491372e-07  3.822748e-09
       [89,] -8.513531e-01 -6.941390e-01 -5.659567e-01 -4.614450e-01 -3.762328e-01
       [90,] -1.359339e+00  9.099366e-01 -6.091084e-01  4.077351e-01 -2.729365e-01
       [91,] -7.982968e-01 -6.890283e-01 -5.947162e-01 -5.133132e-01 -4.430525e-01
       [92,]  5.080665e-01  5.039677e-01  4.999019e-01  4.958689e-01  4.918685e-01
       [93,] -5.364104e-01 -5.125882e-01 -4.898240e-01 -4.680708e-01 -4.472836e-01
       [94,]  3.711862e-01 -1.014479e-01  2.772646e-02 -7.577846e-03  2.071081e-03
       [95,]  1.074841e+00  6.053570e-01  3.409406e-01  1.920198e-01  1.081467e-01
       [96,] -1.241844e-01 -4.394831e-03 -1.555312e-04 -5.504180e-06 -1.947905e-07
       [97,] -1.221023e+00  6.611889e-01 -3.580363e-01  1.938781e-01 -1.049857e-01
       [98,]  1.093745e+00  8.384844e-01  6.427972e-01  4.927799e-01  3.777740e-01
       [99,]  5.817927e-01 -4.629092e-01  3.683183e-01 -2.930561e-01  2.331730e-01
      [100,]  1.592669e+00 -9.749320e-01  5.967921e-01 -3.653186e-01  2.236250e-01
                      [,6]
        [1,]  2.009105e+00
        [2,]  2.286840e+00
        [3,] -7.810211e-01
        [4,] -2.999855e+00
        [5,]  4.010765e+00
        [6,]  1.290614e+00
        [7,] -8.541621e-01
        [8,] -9.995747e-01
        [9,]  1.686034e+00
       [10,] -1.615179e+00
       [11,] -2.974602e+00
       [12,]  3.776836e+00
       [13,] -1.289335e+00
       [14,]  1.628505e+00
       [15,]  2.899220e-01
       [16,]  7.178698e-01
       [17,]  1.990592e+00
       [18,]  1.238850e-01
       [19,] -1.041742e+00
       [20,] -8.292790e-01
       [21,] -1.045270e+00
       [22,] -1.329138e+00
       [23,]  1.629229e+00
       [24,]  3.984211e+00
       [25,] -6.451368e-02
       [26,]  1.909610e+00
       [27,] -1.147123e+00
       [28,]  8.891137e-02
       [29,] -1.784906e+00
       [30,] -1.698569e+00
       [31,] -7.608578e-02
       [32,]  1.483239e+00
       [33,]  7.162842e-01
       [34,]  2.111351e-06
       [35,]  3.980972e+00
       [36,] -1.536264e+00
       [37,]  3.070442e+00
       [38,] -1.019039e+00
       [39,] -8.774330e-01
       [40,]  9.672773e-02
       [41,]  1.391863e+00
       [42,] -2.688378e+00
       [43,]  1.320582e-01
       [44,] -1.745645e+00
       [45,]  2.194161e+00
       [46,]  2.018435e+00
       [47,] -2.726542e+00
       [48,]  2.289167e+00
       [49,] -7.184275e-01
       [50,] -4.975469e-01
       [51,] -5.894456e-01
       [52,] -2.722411e+00
       [53,] -5.064887e-01
       [54,]  2.080481e+00
       [55,]  3.303165e+00
       [56,] -4.639893e-01
       [57,] -4.170769e-01
       [58,] -2.675652e+00
       [59,]  6.111732e-02
       [60,] -8.774796e-01
       [61,] -1.909220e+00
       [62,]  2.108749e-01
       [63,]  2.022498e+00
       [64,]  1.006202e+00
       [65,]  1.089559e-01
       [66,]  2.024393e+00
       [67,] -9.848376e-01
       [68,]  5.235045e-01
       [69,] -2.043984e+00
       [70,]  1.126034e+00
       [71,]  1.876312e+00
       [72,]  1.761669e-01
       [73,] -1.007541e+00
       [74,]  1.517025e+00
       [75,] -2.991381e+00
       [76,]  3.942354e+00
       [77,]  3.021925e+00
       [78,]  1.979286e-01
       [79,] -3.010296e+00
       [80,] -5.963267e-01
       [81,]  6.446632e-01
       [82,]  1.613465e+00
       [83,] -2.963317e+00
       [84,] -5.869124e-01
       [85,]  1.908396e+00
       [86,]  1.782502e-01
       [87,]  1.489137e+00
       [88,]  6.897283e-02
       [89,]  1.470416e+00
       [90,] -1.829760e+00
       [91,]  1.580805e+00
       [92,]  4.007864e+00
       [93,]  1.820188e+00
       [94,] -3.858778e-01
       [95,]  1.300762e+00
       [96,]  1.242622e-01
       [97,] -1.452392e+00
       [98,]  1.703378e+00
       [99,] -9.604604e-01
      [100,] -2.014121e+00

# torus_3d() works

    Code
      torus_3d(n = 100, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                 [,1]        [,2]         [,3]         [,4]          [,5]
      out  0.90951920 -0.60806107 -0.423402332  0.046811273 -0.0397026339
      elt -0.08991944  1.37608857  0.783829026 -0.012496258  0.0290763175
      elt  1.92353899  1.36399767 -0.933694924 -0.039036306  0.0422360181
      elt  0.83003839 -0.59852019  0.214714262  0.012114244 -0.0214310022
      elt -0.64328797 -0.85230208 -0.361993519 -0.007777032 -0.0499433291
      elt -1.07740800  0.43641026  0.546342158 -0.043311664 -0.0356851794
      elt  2.27991016  0.94849529  0.883018221  0.009618158  0.0015637302
      elt -0.68459612 -0.96740243 -0.579647433  0.040446538 -0.0123396746
      elt -0.44066721  0.91907265  0.195296091 -0.049745073 -0.0284339315
      elt  2.89233295 -0.02625773 -0.451142082 -0.015265306 -0.0350829806
      elt -1.77013063 -2.17725247 -0.591877980  0.036571148 -0.0353439124
      elt -2.97686698  0.16267482  0.192441454  0.015919120  0.0423142502
      elt -2.30396469 -1.67795640 -0.526417071 -0.031443569 -0.0051962465
      elt -2.86711352  0.52529668  0.403822613  0.044940477 -0.0389469245
      elt -0.49260368  1.36398943 -0.835306661 -0.028938895 -0.0086575911
      elt -1.54463353 -2.07264114  0.811101781  0.013595432  0.0232040592
      elt -2.02761009  1.96098328  0.571280516  0.002368991 -0.0245691278
      elt -2.00402888 -2.22826939  0.078876177 -0.030572272 -0.0315889175
      elt -1.22407299 -1.88529399  0.968806473 -0.018436977  0.0227344875
      elt  1.33131560 -2.20375109  0.818385989  0.045953311 -0.0366494890
      elt  1.72001191 -1.09958228  0.999140538  0.034806118  0.0157848667
      elt  0.54307519  0.84839423 -0.120814417  0.004200594  0.0070135517
      elt -0.97792502  0.38791002  0.318422494 -0.030929957  0.0208199039
      elt  0.95601211  0.62496716 -0.513926816 -0.023326323 -0.0189224581
      elt -0.74198663 -0.85180408 -0.492437719  0.038856192  0.0338216087
      elt -1.77175118 -2.28843176 -0.447795853  0.036005257 -0.0460992394
      elt -2.30083104 -0.65197046  0.920212197 -0.005547783  0.0447378346
      elt -2.70737514 -0.95495518 -0.491536569  0.010797826  0.0272497393
      elt  1.01314292  2.55113040 -0.667125509  0.029635492 -0.0160971409
      elt  2.37055274 -1.83439665 -0.071775824  0.009967849  0.0464448324
      elt -2.30262724  1.22059095  0.795362536 -0.006457079  0.0179349351
      elt  1.01659347  2.36007814  0.821842883 -0.030954550 -0.0207382537
      elt -0.83580668 -1.03065600 -0.739606682 -0.025088984  0.0037443788
      elt -0.03872579 -2.93566285 -0.352217275  0.031934072 -0.0118583800
      elt -2.29220660 -1.81908089  0.376772240 -0.035403466  0.0063740385
      elt -0.91276612  1.53101233 -0.976049974 -0.042859625 -0.0297865495
      elt -1.72952833  1.03476726 -0.999880746 -0.034428535 -0.0433482581
      elt  1.53330562 -2.36913681 -0.569448787  0.034162961 -0.0163532625
      elt -0.74096005 -2.72296339  0.569521392 -0.045406635  0.0359919606
      elt  0.82697717  2.10151405  0.966045000  0.012260502 -0.0370901504
      elt -0.24414201  2.75371405  0.644605254  0.002252682 -0.0496382012
      elt  1.56760255  1.22646358 -0.999953674  0.004865140  0.0114451926
      elt  2.57833755 -0.46358197 -0.784853142  0.037104514 -0.0157686300
      elt  1.95413931 -1.46752808  0.896111606  0.019189041 -0.0482725061
      elt  1.09567189  0.82352660 -0.777125394  0.016947191  0.0417446218
      elt  0.25348964 -0.98093565 -0.161695456  0.023474528  0.0490760001
      elt -0.93104859  0.44192346  0.245508504 -0.046460505 -0.0143416769
      elt  1.57224754 -1.80576569  0.918974650 -0.014047195 -0.0389693632
      elt -0.99198238 -1.04674944  0.829922404 -0.002774406 -0.0050521928
      elt  0.17077138 -2.75178207  0.653326955  0.021978159 -0.0338490285
      elt  1.17360555 -0.04344122 -0.564269394  0.001459893  0.0007207744
      elt -0.87732561 -0.59965247 -0.348462901 -0.032680244  0.0358561296
      elt  0.87291423 -1.03328620 -0.762192123 -0.006952650 -0.0343432767
      elt -0.41889290  2.96684558  0.086271361  0.049056897  0.0380912595
      elt  0.75604245 -0.75795875 -0.368976740 -0.037429136 -0.0017651984
      elt -1.01975695  0.98666147 -0.813864335  0.040186682  0.0271230818
      elt -1.15017686 -0.53898403  0.683661775  0.037823953 -0.0153674109
      elt  1.50138800  0.76302784 -0.948810736 -0.013801423 -0.0435791666
      elt  0.73863510  1.13936198  0.766570036  0.014180800 -0.0007038843
      elt -2.55062055  0.71883590 -0.759951924  0.016110678 -0.0042624283
      elt -2.27318356 -1.47105629  0.706562846  0.045699345  0.0307058573
      elt -0.32582179 -1.13307184  0.570910285 -0.017281139 -0.0172181919
      elt -2.49279489 -1.25531207 -0.611780532 -0.022220930  0.0344564827
      elt -0.63667106  0.77118212  0.008479292  0.048801365 -0.0145525717
      elt  2.28729702  1.75290343 -0.471744562  0.007458667  0.0024064121
      elt -0.88356971 -2.31892603  0.876416079 -0.033425671  0.0470545179
      elt  2.45969599 -0.94180030  0.773467457 -0.035560294 -0.0429631366
      elt -0.40465479 -1.83775855 -0.992987618  0.046699327  0.0314480813
      elt  0.64657094 -2.48771371  0.821391731  0.021227714 -0.0469257004
      elt -0.08441530 -2.92441274  0.378427718  0.028738201  0.0067218661
      elt -0.53067423  1.34949272 -0.835220452 -0.048813058 -0.0365070718
      elt -1.15594435  1.33033489 -0.971359232 -0.025414831  0.0148092618
      elt  0.79367328 -2.63697962 -0.657069683 -0.044960774 -0.0288158743
      elt -2.09948703 -1.83581814  0.614496082 -0.032921567 -0.0393909458
      elt  0.82946845 -0.78850553  0.517715189  0.004026652 -0.0436995254
      elt  2.21799463  1.65808181 -0.638950109  0.014284641 -0.0465217978
      elt -1.46006615 -1.17485514  0.992037077 -0.032963758 -0.0291392233
      elt -1.59277619 -0.32479980 -0.927249355  0.049464466  0.0114881480
      elt  1.49782906 -1.00186546  0.980203269 -0.036069776 -0.0194828836
      elt -1.24085892 -2.59140625  0.487412253  0.020289299 -0.0485348954
      elt  0.39012953 -1.53870104  0.910907058  0.036633093 -0.0097199444
      elt  1.56731349  0.85302527 -0.976484262 -0.029914531 -0.0044783109
      elt -1.31565093 -0.27573310  0.754964550  0.035608689  0.0366461525
      elt -1.95775589 -2.04854721  0.552351312  0.030768446 -0.0395055116
      elt -1.62365279 -0.60268453  0.963391041  0.022653194 -0.0053874930
      elt  0.32195027  1.14458975  0.585055878  0.014886355  0.0058034629
      elt -0.26958936  1.27231605  0.714695177 -0.003475857  0.0060975001
      elt -1.10092603  1.29578627 -0.954040891  0.021506445 -0.0234173421
      elt  1.01021747 -0.16347705  0.214878532  0.031937469  0.0187736356
      elt  2.81321570 -0.88830553  0.311852932 -0.037160310 -0.0442129100
      elt  0.31731560  0.95323875  0.096487094  0.049801787 -0.0419374371
      elt  0.53801202  1.26670743  0.781606682  0.012772074 -0.0498900986
      elt  1.60343247 -2.44556976 -0.381552169  0.005877741  0.0109741065
      elt -0.92271228  1.52914417  0.976826535  0.025761254 -0.0074751925
      elt  1.08607425  2.60936276  0.563136912  0.027342288 -0.0305212979
      elt -0.36325997  1.07125036 -0.495102439 -0.035392174 -0.0172342707
      elt -0.87980337  0.73197081  0.517770327  0.018060863 -0.0040695532
      elt  1.52053991  1.46397425  0.993848385 -0.004448415  0.0392953042
      elt -0.71690846  2.35469226 -0.887187637 -0.047147391  0.0337261188
      elt  2.38947912 -1.77537884  0.213967914 -0.017987990  0.0190098491

---

    Code
      torus_3d(n = 100, num_noise = 0)
    Output
                  [,1]        [,2]        [,3]
      out -1.170948578  1.40426503  0.98516834
      elt  0.350804429  2.32627898 -0.93578128
      elt -0.007093771  2.81788533  0.57536856
      elt  2.705122972 -0.65488528  0.62168776
      elt -0.190021668 -2.99095084  0.07764577
      elt -2.530052228  0.92360488 -0.72058740
      elt  2.555125861 -1.07899874 -0.63366335
      elt -0.305511091 -2.14352295  0.98626254
      elt  0.949800459 -0.32931865 -0.10254803
      elt -0.097917003  1.57839756 -0.90818538
      elt  2.478360350  0.12105407  0.87654770
      elt -2.648054761 -1.14085567 -0.46870140
      elt  1.313603912  1.93688156 -0.94031218
      elt -0.195618114 -1.64545755  0.93935171
      elt -2.538226414  0.02741418 -0.84270573
      elt -0.080400272  0.99713609 -0.02728196
      elt  1.659840114  0.18481292  0.94401494
      elt -0.496042611 -1.37336240  0.84179298
      elt -0.081425415 -2.99001520  0.13294285
      elt -2.839239210 -0.39371789 -0.49933727
      elt -0.239476792  2.06336166  0.99701468
      elt  1.762273681 -1.86913836 -0.82240139
      elt  1.264654901  0.80039858  0.86408821
      elt  0.674343381 -1.85400267 -0.99963087
      elt  0.564583195 -0.82567054 -0.02204337
      elt -0.979905188 -0.21294683 -0.07446553
      elt -1.362511010 -1.12146091  0.97191900
      elt -0.332405427 -1.60787097 -0.93367235
      elt  1.692104124  0.64140494 -0.98170469
      elt  1.244551311 -0.03667562  0.65583023
      elt -1.579700013  2.32728320 -0.58257870
      elt -1.495696893  2.47534984 -0.45176168
      elt  2.340092122  0.28221546  0.93408592
      elt -2.567278141 -1.24581984  0.52094304
      elt -0.098946327 -1.64871660 -0.93737681
      elt  1.423418073  0.73661087 -0.91769788
      elt -0.396357129 -1.19388862 -0.67035809
      elt -0.183120719  1.63750591 -0.93589210
      elt  0.481808737 -1.02177998 -0.49248437
      elt  0.763519089 -1.80955200  0.99935311
      elt -1.501572546 -2.11634386 -0.80378183
      elt -0.220828483  0.99033731  0.17059725
      elt  1.412381373  1.21212822  0.99032083
      elt  0.023198560  2.97573388 -0.21855645
      elt -0.636679297  1.93907309 -0.99916232
      elt  0.843619989 -0.56663105  0.17954738
      elt  2.816523264  1.02851574 -0.05581881
      elt  2.204215635 -1.27482789 -0.83757562
      elt -1.045433468 -0.62992972  0.62646459
      elt -1.440444817  1.98664868  0.89104961
      elt  1.003208125 -1.25058559 -0.91792405
      elt  0.241986674  1.81865809  0.98624108
      elt  0.776542268  0.93796802 -0.62290629
      elt -0.912176988  1.99873292  0.98039475
      elt -2.760541004 -0.67722161 -0.53885876
      elt  0.783114121  1.53472221 -0.96086247
      elt  1.850741533 -2.35736373  0.07653930
      elt  2.775380728  0.93676489 -0.36955410
      elt  1.137355446  1.35683641 -0.97330281
      elt -2.471040612  0.57468692  0.84359005
      elt  0.385752796  1.07266014 -0.51014986
      elt  1.403791744  1.54730839  0.99601292
      elt -0.897391914  0.58101719 -0.36517687
      elt  0.198526924  0.98609538 -0.10829528
      elt  0.131583001  2.99689854  0.02069608
      elt -2.036781236 -0.68097952  0.98904626
      elt -1.558451529  1.38997275 -0.99609820
      elt -0.317829152 -0.94827180  0.01532156
      elt -2.502146258  0.86717250  0.76150857
      elt -0.403141799  1.09493663 -0.55296354
      elt -0.024020939  2.98560384 -0.16850695
      elt -0.144818903 -2.08769748  0.99569275
      elt -0.966368661  2.39922783  0.80992399
      elt  1.177807239 -0.32471478 -0.62795280
      elt  1.293820957  0.63204058 -0.82845692
      elt -1.620447251  1.21869690  0.99961966
      elt -0.528728642  1.08963869  0.61457630
      elt  0.385130781  1.26659042  0.73676336
      elt -0.299921434  1.63369958  0.94078704
      elt  1.442227903 -2.17757629  0.79095910
      elt  2.826078558  0.81083832 -0.34090312
      elt  0.209991286  1.17309641  0.58882996
      elt -0.432671186 -1.59794207 -0.93878000
      elt  1.211231450  0.66305120 -0.78526469
      elt  0.986028156 -0.18061481 -0.06972367
      elt  0.597239874 -1.19242001 -0.74561854
      elt  1.236554079 -0.28024226 -0.68121044
      elt -0.353718609 -1.43820642 -0.85481391
      elt -0.564383515 -0.82666447  0.04360140
      elt  0.149414123 -1.48166864  0.85968958
      elt  1.628321038 -0.71743942  0.97535701
      elt -2.318212944 -0.91409517  0.87063860
      elt -0.765825039  0.76576434 -0.39888084
      elt  1.686636072  1.04941961  0.99990833
      elt  2.724851151 -1.17369218  0.25523766
      elt -2.829163523 -0.84455190 -0.30444434
      elt -1.051698010 -0.41182871  0.49209116
      elt  0.339256704  0.94978010  0.13050313
      elt  0.976293957  2.72348016 -0.44969810
      elt -1.430329173  1.24764924  0.99478619

# cube_3d() works

    Code
      cube_3d(num_dims = 3, num_noise = 2, min_n = -0.01, max_n = 0.01)
    Output
      $df
                    Var1       Var2       Var3                            
         [1,] 0.00000000 0.00000000 0.00000000 -8.124178e-03 -2.697369e-03
         [2,] 0.09090909 0.00000000 0.00000000 -1.391643e-03 -2.970038e-03
         [3,] 0.18181818 0.00000000 0.00000000  4.792298e-03  9.002440e-03
         [4,] 0.27272727 0.00000000 0.00000000  2.867361e-03 -2.866219e-03
         [5,] 0.36363636 0.00000000 0.00000000  8.036624e-03 -2.911962e-03
         [6,] 0.45454545 0.00000000 0.00000000 -6.165649e-03  7.459886e-03
         [7,] 0.54545455 0.00000000 0.00000000 -8.011420e-03  7.328162e-03
         [8,] 0.63636364 0.00000000 0.00000000  6.888202e-04  8.131205e-03
         [9,] 0.72727273 0.00000000 0.00000000 -2.941987e-03  1.259575e-03
        [10,] 0.81818182 0.00000000 0.00000000 -1.179038e-03  9.251623e-03
        [11,] 0.90909091 0.00000000 0.00000000  1.225038e-03  7.426411e-03
        [12,] 1.00000000 0.00000000 0.00000000  1.839802e-03 -2.785255e-03
        [13,] 0.00000000 0.09090909 0.00000000  8.745087e-03  5.421727e-03
        [14,] 0.09090909 0.09090909 0.00000000  6.555077e-03  3.819043e-03
        [15,] 0.18181818 0.09090909 0.00000000 -3.039685e-03  6.666528e-03
        [16,] 0.27272727 0.09090909 0.00000000 -1.968097e-03  4.701778e-03
        [17,] 0.36363636 0.09090909 0.00000000  3.576873e-03 -6.310753e-03
        [18,] 0.45454545 0.09090909 0.00000000  6.256678e-04 -4.448198e-03
        [19,] 0.54545455 0.09090909 0.00000000 -9.971103e-03 -9.307321e-03
        [20,] 0.63636364 0.09090909 0.00000000 -8.510168e-03 -6.461049e-03
        [21,] 0.72727273 0.09090909 0.00000000 -2.827139e-03 -3.320958e-03
        [22,] 0.81818182 0.09090909 0.00000000 -7.983867e-03 -5.806853e-04
        [23,] 0.90909091 0.09090909 0.00000000  1.737718e-04 -6.768188e-03
        [24,] 1.00000000 0.09090909 0.00000000  9.383594e-03 -7.933360e-03
        [25,] 0.00000000 0.18181818 0.00000000 -2.003639e-03 -4.628290e-03
        [26,] 0.09090909 0.18181818 0.00000000 -8.235351e-03  1.723719e-05
        [27,] 0.18181818 0.18181818 0.00000000  5.767927e-04  8.059760e-03
        [28,] 0.27272727 0.18181818 0.00000000  8.676813e-03 -9.961998e-03
        [29,] 0.36363636 0.18181818 0.00000000  3.896825e-03 -3.544780e-03
        [30,] 0.45454545 0.18181818 0.00000000 -3.147099e-03  8.440027e-05
        [31,] 0.54545455 0.18181818 0.00000000 -2.961373e-03 -8.380443e-04
        [32,] 0.63636364 0.18181818 0.00000000  6.988682e-03 -6.405191e-03
        [33,] 0.72727273 0.18181818 0.00000000  2.446833e-03  6.516927e-03
        [34,] 0.81818182 0.18181818 0.00000000  8.064468e-03  5.004854e-03
        [35,] 0.90909091 0.18181818 0.00000000 -2.668493e-03 -4.456271e-03
        [36,] 1.00000000 0.18181818 0.00000000  9.748668e-03 -4.938625e-03
        [37,] 0.00000000 0.27272727 0.00000000 -3.166965e-03  4.893097e-03
        [38,] 0.09090909 0.27272727 0.00000000  5.797137e-03 -8.180000e-03
        [39,] 0.18181818 0.27272727 0.00000000 -6.729819e-03  5.007976e-03
        [40,] 0.27272727 0.27272727 0.00000000  6.948692e-03 -7.134562e-04
        [41,] 0.36363636 0.27272727 0.00000000 -8.189429e-03  9.989207e-03
        [42,] 0.45454545 0.27272727 0.00000000  5.131980e-03 -6.902568e-04
        [43,] 0.54545455 0.27272727 0.00000000  6.812454e-03  5.137314e-03
        [44,] 0.63636364 0.27272727 0.00000000 -3.855060e-04 -3.331670e-03
        [45,] 0.72727273 0.27272727 0.00000000  1.202031e-03  1.556938e-04
        [46,] 0.81818182 0.27272727 0.00000000  1.031531e-03 -9.600339e-04
        [47,] 0.90909091 0.27272727 0.00000000  8.157024e-03  2.535382e-03
        [48,] 1.00000000 0.27272727 0.00000000 -1.718097e-03 -4.326004e-03
        [49,] 0.00000000 0.36363636 0.00000000 -2.718980e-03  8.443764e-03
        [50,] 0.09090909 0.36363636 0.00000000 -1.638941e-03 -1.277512e-03
        [51,] 0.18181818 0.36363636 0.00000000 -2.902901e-03  5.511081e-03
        [52,] 0.27272727 0.36363636 0.00000000 -8.522091e-03  3.674864e-03
        [53,] 0.36363636 0.36363636 0.00000000 -8.789316e-04 -4.785298e-03
        [54,] 0.45454545 0.36363636 0.00000000  6.280160e-03 -7.029393e-04
        [55,] 0.54545455 0.36363636 0.00000000 -1.079386e-03 -6.238216e-03
        [56,] 0.63636364 0.36363636 0.00000000 -8.364354e-03  1.108086e-03
        [57,] 0.72727273 0.36363636 0.00000000  6.203320e-03 -3.236950e-03
        [58,] 0.81818182 0.36363636 0.00000000 -7.675245e-03 -1.891267e-03
        [59,] 0.90909091 0.36363636 0.00000000 -7.903686e-03 -9.915529e-03
        [60,] 1.00000000 0.36363636 0.00000000 -9.771334e-03 -1.269518e-03
        [61,] 0.00000000 0.45454545 0.00000000  1.551525e-03  1.362679e-03
        [62,] 0.09090909 0.45454545 0.00000000  7.072805e-03  4.340921e-03
        [63,] 0.18181818 0.45454545 0.00000000  6.294653e-03  2.027933e-03
        [64,] 0.27272727 0.45454545 0.00000000  6.929461e-03  1.230003e-03
        [65,] 0.36363636 0.45454545 0.00000000 -2.831100e-03 -3.161999e-03
        [66,] 0.45454545 0.45454545 0.00000000 -2.649885e-03  7.039033e-04
        [67,] 0.54545455 0.45454545 0.00000000 -4.958013e-03  2.844952e-03
        [68,] 0.63636364 0.45454545 0.00000000 -8.854278e-03  8.967116e-04
        [69,] 0.72727273 0.45454545 0.00000000 -2.135294e-03  6.446204e-03
        [70,] 0.81818182 0.45454545 0.00000000  8.770339e-03 -8.459764e-03
        [71,] 0.90909091 0.45454545 0.00000000  3.288736e-03 -4.875961e-03
        [72,] 1.00000000 0.45454545 0.00000000 -4.301946e-03  7.542220e-03
        [73,] 0.00000000 0.54545455 0.00000000  1.716214e-03  4.929327e-03
        [74,] 0.09090909 0.54545455 0.00000000 -5.049159e-03 -5.734380e-03
        [75,] 0.18181818 0.54545455 0.00000000 -6.828386e-03 -1.807518e-03
        [76,] 0.27272727 0.54545455 0.00000000 -8.071567e-03  6.202702e-03
        [77,] 0.36363636 0.54545455 0.00000000 -4.154307e-03 -2.778889e-03
        [78,] 0.45454545 0.54545455 0.00000000  8.071286e-03  9.874226e-03
        [79,] 0.54545455 0.54545455 0.00000000  6.193354e-03  5.233020e-03
        [80,] 0.63636364 0.54545455 0.00000000  5.831866e-03 -3.171882e-03
        [81,] 0.72727273 0.54545455 0.00000000  4.718525e-03 -7.069478e-03
        [82,] 0.81818182 0.54545455 0.00000000  7.770217e-03  9.788304e-03
        [83,] 0.90909091 0.54545455 0.00000000  7.886724e-03 -3.823116e-03
        [84,] 1.00000000 0.54545455 0.00000000 -4.969361e-03  8.060303e-03
        [85,] 0.00000000 0.63636364 0.00000000 -9.433733e-03 -9.193862e-03
        [86,] 0.09090909 0.63636364 0.00000000 -7.127383e-03  8.764185e-03
        [87,] 0.18181818 0.63636364 0.00000000 -7.949668e-03 -5.112082e-03
        [88,] 0.27272727 0.63636364 0.00000000  6.463802e-03  3.641166e-03
        [89,] 0.36363636 0.63636364 0.00000000  7.948379e-03 -6.627908e-03
        [90,] 0.45454545 0.63636364 0.00000000 -2.833229e-03 -5.032779e-03
        [91,] 0.54545455 0.63636364 0.00000000 -5.804955e-03 -2.422864e-03
        [92,] 0.63636364 0.63636364 0.00000000 -5.169622e-04  2.716772e-03
        [93,] 0.72727273 0.63636364 0.00000000  1.410634e-03  1.289683e-03
        [94,] 0.81818182 0.63636364 0.00000000  7.895493e-04 -5.980759e-03
        [95,] 0.90909091 0.63636364 0.00000000 -7.280306e-03  4.260543e-03
        [96,] 1.00000000 0.63636364 0.00000000  6.290187e-03 -8.953455e-03
        [97,] 0.00000000 0.72727273 0.00000000 -2.585488e-03  8.084754e-03
        [98,] 0.09090909 0.72727273 0.00000000  3.116154e-03 -6.553089e-04
        [99,] 0.18181818 0.72727273 0.00000000 -5.197285e-03 -3.019085e-03
       [100,] 0.27272727 0.72727273 0.00000000  7.733727e-03  6.295110e-03
       [101,] 0.36363636 0.72727273 0.00000000 -9.882231e-03  4.538513e-03
       [102,] 0.45454545 0.72727273 0.00000000 -1.908421e-03 -2.830505e-03
       [103,] 0.54545455 0.72727273 0.00000000 -1.908479e-03  2.238200e-05
       [104,] 0.63636364 0.72727273 0.00000000 -1.132963e-03 -4.086983e-03
       [105,] 0.72727273 0.72727273 0.00000000 -7.232830e-03 -9.776966e-03
       [106,] 0.81818182 0.72727273 0.00000000 -2.758769e-03 -4.291739e-03
       [107,] 0.90909091 0.72727273 0.00000000  4.553525e-03 -3.065229e-03
       [108,] 1.00000000 0.72727273 0.00000000  9.725048e-03 -3.912031e-03
       [109,] 0.00000000 0.81818182 0.00000000 -7.495971e-03  4.154205e-03
       [110,] 0.09090909 0.81818182 0.00000000 -1.202918e-03  5.797433e-03
       [111,] 0.18181818 0.81818182 0.00000000  2.447500e-03  8.597864e-03
       [112,] 0.27272727 0.81818182 0.00000000 -3.026401e-03 -8.573975e-03
       [113,] 0.36363636 0.81818182 0.00000000 -1.394902e-03  1.954309e-04
       [114,] 0.45454545 0.81818182 0.00000000  2.396136e-03 -3.901417e-03
       [115,] 0.54545455 0.81818182 0.00000000  8.503313e-03  1.870572e-03
       [116,] 0.63636364 0.81818182 0.00000000 -3.977120e-03  8.616173e-03
       [117,] 0.72727273 0.81818182 0.00000000  6.830826e-03  9.354180e-03
       [118,] 0.81818182 0.81818182 0.00000000  2.780382e-03  6.952329e-03
       [119,] 0.90909091 0.81818182 0.00000000  8.744064e-04 -1.746174e-03
       [120,] 1.00000000 0.81818182 0.00000000 -7.252224e-03  9.008143e-03
       [121,] 0.00000000 0.90909091 0.00000000 -1.828240e-03 -1.356061e-03
       [122,] 0.09090909 0.90909091 0.00000000  7.502448e-03 -5.765045e-03
       [123,] 0.18181818 0.90909091 0.00000000 -4.108727e-03  7.633204e-04
       [124,] 0.27272727 0.90909091 0.00000000  1.934096e-03 -9.722112e-03
       [125,] 0.36363636 0.90909091 0.00000000 -1.484930e-03 -4.320201e-04
       [126,] 0.45454545 0.90909091 0.00000000 -7.904536e-03  1.387228e-03
       [127,] 0.54545455 0.90909091 0.00000000  2.803204e-03  4.546905e-03
       [128,] 0.63636364 0.90909091 0.00000000  2.699075e-05 -4.086098e-03
       [129,] 0.72727273 0.90909091 0.00000000  7.918596e-03  1.736256e-03
       [130,] 0.81818182 0.90909091 0.00000000 -8.436244e-03  3.525322e-03
       [131,] 0.90909091 0.90909091 0.00000000 -3.841216e-03  8.931835e-03
       [132,] 1.00000000 0.90909091 0.00000000  6.599277e-03 -2.330168e-03
       [133,] 0.00000000 1.00000000 0.00000000 -8.836028e-03 -7.303112e-03
       [134,] 0.09090909 1.00000000 0.00000000  7.185206e-03  8.214986e-03
       [135,] 0.18181818 1.00000000 0.00000000 -4.310124e-03 -6.978052e-05
       [136,] 0.27272727 1.00000000 0.00000000 -4.622817e-03  1.669922e-03
       [137,] 0.36363636 1.00000000 0.00000000 -5.809397e-03 -1.855650e-03
       [138,] 0.45454545 1.00000000 0.00000000  6.931980e-03 -8.520004e-03
       [139,] 0.54545455 1.00000000 0.00000000 -4.908143e-03 -5.100815e-03
       [140,] 0.63636364 1.00000000 0.00000000  8.764649e-03 -3.456176e-05
       [141,] 0.72727273 1.00000000 0.00000000  3.807404e-03 -5.793903e-04
       [142,] 0.81818182 1.00000000 0.00000000 -3.146600e-03 -9.868424e-03
       [143,] 0.90909091 1.00000000 0.00000000  2.722901e-03 -1.758524e-03
       [144,] 1.00000000 1.00000000 0.00000000 -4.236341e-03 -6.469695e-03
       [145,] 0.00000000 0.00000000 0.09090909 -5.930592e-03 -7.778733e-03
       [146,] 0.09090909 0.00000000 0.09090909 -7.717957e-03 -3.228411e-03
       [147,] 0.18181818 0.00000000 0.09090909 -2.287048e-03 -8.102733e-03
       [148,] 0.27272727 0.00000000 0.09090909  7.893594e-03 -6.802622e-03
       [149,] 0.36363636 0.00000000 0.09090909 -7.580571e-03 -3.298732e-03
       [150,] 0.45454545 0.00000000 0.09090909  1.732173e-03  8.849527e-03
       [151,] 0.54545455 0.00000000 0.09090909  7.956651e-03  5.548212e-03
       [152,] 0.63636364 0.00000000 0.09090909 -7.793690e-03  7.458924e-03
       [153,] 0.72727273 0.00000000 0.09090909 -2.156789e-03 -5.852982e-03
       [154,] 0.81818182 0.00000000 0.09090909  4.598033e-03 -8.378869e-03
       [155,] 0.90909091 0.00000000 0.09090909 -6.403200e-04 -3.535548e-03
       [156,] 1.00000000 0.00000000 0.09090909 -3.778334e-03  3.581210e-03
       [157,] 0.00000000 0.09090909 0.09090909 -8.123461e-03  2.127145e-04
       [158,] 0.09090909 0.09090909 0.09090909  4.365574e-03  3.907957e-03
       [159,] 0.18181818 0.09090909 0.09090909 -3.578512e-03  1.210487e-03
       [160,] 0.27272727 0.09090909 0.09090909  8.379409e-03  4.016883e-03
       [161,] 0.36363636 0.09090909 0.09090909 -5.790402e-03  1.277035e-03
       [162,] 0.45454545 0.09090909 0.09090909  3.646167e-03  9.579999e-03
       [163,] 0.54545455 0.09090909 0.09090909  8.413463e-03 -2.227314e-03
       [164,] 0.63636364 0.09090909 0.09090909 -4.308330e-03 -7.271333e-03
       [165,] 0.72727273 0.09090909 0.09090909 -6.575937e-04 -5.084751e-03
       [166,] 0.81818182 0.09090909 0.09090909  2.723460e-03 -4.429561e-03
       [167,] 0.90909091 0.09090909 0.09090909 -2.572123e-03 -1.661987e-03
       [168,] 1.00000000 0.09090909 0.09090909  8.137307e-03 -5.396547e-03
       [169,] 0.00000000 0.18181818 0.09090909 -1.131358e-03  3.782149e-03
       [170,] 0.09090909 0.18181818 0.09090909  4.136042e-03  7.301706e-03
       [171,] 0.18181818 0.18181818 0.09090909  5.872791e-03  7.878061e-03
       [172,] 0.27272727 0.18181818 0.09090909  1.989274e-03 -7.002534e-03
       [173,] 0.36363636 0.18181818 0.09090909  4.335368e-03  8.007125e-03
       [174,] 0.45454545 0.18181818 0.09090909  2.534346e-03 -4.678686e-03
       [175,] 0.54545455 0.18181818 0.09090909  2.758228e-03 -6.263430e-03
       [176,] 0.63636364 0.18181818 0.09090909 -4.031213e-03  7.686993e-03
       [177,] 0.72727273 0.18181818 0.09090909 -9.489326e-03  7.701355e-04
       [178,] 0.81818182 0.18181818 0.09090909  6.893556e-04 -6.015660e-03
       [179,] 0.90909091 0.18181818 0.09090909 -9.026438e-03 -1.601373e-03
       [180,] 1.00000000 0.18181818 0.09090909  8.990504e-03  7.762220e-03
       [181,] 0.00000000 0.27272727 0.09090909  6.022869e-03 -4.484656e-03
       [182,] 0.09090909 0.27272727 0.09090909  3.076065e-04 -5.817924e-04
       [183,] 0.18181818 0.27272727 0.09090909  6.278473e-03  4.203732e-03
       [184,] 0.27272727 0.27272727 0.09090909  2.855995e-03  9.744418e-03
       [185,] 0.36363636 0.27272727 0.09090909 -6.847265e-03 -1.267061e-03
       [186,] 0.45454545 0.27272727 0.09090909 -8.753897e-03 -4.833458e-03
       [187,] 0.54545455 0.27272727 0.09090909  3.271805e-03  8.207915e-04
       [188,] 0.63636364 0.27272727 0.09090909  4.313401e-03 -7.441632e-03
       [189,] 0.72727273 0.27272727 0.09090909  6.255453e-03  4.728414e-03
       [190,] 0.81818182 0.27272727 0.09090909  8.095944e-03  1.527558e-04
       [191,] 0.90909091 0.27272727 0.09090909  3.959347e-03 -3.265277e-03
       [192,] 1.00000000 0.27272727 0.09090909 -1.648695e-03  9.716016e-03
       [193,] 0.00000000 0.36363636 0.09090909  2.208860e-03 -6.924941e-03
       [194,] 0.09090909 0.36363636 0.09090909  1.732378e-03  6.489421e-03
       [195,] 0.18181818 0.36363636 0.09090909  7.560322e-03  5.612785e-04
       [196,] 0.27272727 0.36363636 0.09090909  5.353250e-03  7.316882e-03
       [197,] 0.36363636 0.36363636 0.09090909  4.059257e-03  1.908742e-03
       [198,] 0.45454545 0.36363636 0.09090909 -6.526559e-03 -6.406542e-03
       [199,] 0.54545455 0.36363636 0.09090909 -7.965984e-03 -1.888560e-03
       [200,] 0.63636364 0.36363636 0.09090909  9.313612e-03  3.354252e-03
       [201,] 0.72727273 0.36363636 0.09090909  9.362255e-03 -9.117263e-03
       [202,] 0.81818182 0.36363636 0.09090909 -2.499252e-03 -8.476181e-03
       [203,] 0.90909091 0.36363636 0.09090909 -7.807261e-03 -3.697073e-03
       [204,] 1.00000000 0.36363636 0.09090909  2.422849e-03  4.463077e-03
       [205,] 0.00000000 0.45454545 0.09090909 -1.555406e-03  9.514821e-03
       [206,] 0.09090909 0.45454545 0.09090909 -8.662333e-03 -2.135579e-03
       [207,] 0.18181818 0.45454545 0.09090909  1.923632e-03 -8.085401e-03
       [208,] 0.27272727 0.45454545 0.09090909  8.089308e-03 -8.069320e-04
       [209,] 0.36363636 0.45454545 0.09090909 -9.949015e-03 -7.741853e-03
       [210,] 0.45454545 0.45454545 0.09090909 -3.053061e-03  6.715547e-03
       [211,] 0.54545455 0.45454545 0.09090909  7.314230e-03  6.976160e-03
       [212,] 0.63636364 0.45454545 0.09090909  3.183824e-03  4.827511e-03
       [213,] 0.72727273 0.45454545 0.09090909 -6.288714e-03 -7.680407e-03
       [214,] 0.81818182 0.45454545 0.09090909  8.988095e-03 -2.969991e-03
       [215,] 0.90909091 0.45454545 0.09090909 -5.787779e-03 -8.180815e-03
       [216,] 1.00000000 0.45454545 0.09090909  2.719086e-03  6.478838e-03
       [217,] 0.00000000 0.54545455 0.09090909  4.737982e-04  9.925982e-03
       [218,] 0.09090909 0.54545455 0.09090909 -6.114454e-03  2.108393e-03
       [219,] 0.18181818 0.54545455 0.09090909 -3.687395e-03  6.418279e-03
       [220,] 0.27272727 0.54545455 0.09090909  9.190662e-03 -7.184891e-03
       [221,] 0.36363636 0.54545455 0.09090909  6.961224e-03 -7.453126e-03
       [222,] 0.45454545 0.54545455 0.09090909  8.401188e-04  5.322298e-03
       [223,] 0.54545455 0.54545455 0.09090909 -6.185991e-03 -9.887934e-04
       [224,] 0.63636364 0.54545455 0.09090909 -4.665265e-03  7.380376e-03
       [225,] 0.72727273 0.54545455 0.09090909  7.771238e-03 -5.117242e-03
       [226,] 0.81818182 0.54545455 0.09090909  7.201051e-03 -5.385996e-03
       [227,] 0.90909091 0.54545455 0.09090909 -1.109557e-03  5.523195e-03
       [228,] 1.00000000 0.54545455 0.09090909  2.159565e-03  2.997087e-03
       [229,] 0.00000000 0.63636364 0.09090909  5.927098e-03  6.890859e-03
       [230,] 0.09090909 0.63636364 0.09090909  1.993570e-03  5.406825e-03
       [231,] 0.18181818 0.63636364 0.09090909 -1.291416e-03 -5.624780e-03
       [232,] 0.27272727 0.63636364 0.09090909 -6.190910e-03  9.138922e-03
       [233,] 0.36363636 0.63636364 0.09090909 -5.017797e-03 -5.597052e-03
       [234,] 0.45454545 0.63636364 0.09090909  6.386814e-03  4.932953e-03
       [235,] 0.54545455 0.63636364 0.09090909 -7.080693e-03 -8.893492e-03
       [236,] 0.63636364 0.63636364 0.09090909 -8.571925e-03 -8.704432e-03
       [237,] 0.72727273 0.63636364 0.09090909 -6.885707e-03  1.767015e-03
       [238,] 0.81818182 0.63636364 0.09090909  6.832592e-03 -6.526650e-03
       [239,] 0.90909091 0.63636364 0.09090909 -9.081327e-03  1.567832e-03
       [240,] 1.00000000 0.63636364 0.09090909  2.452100e-03 -1.266342e-03
       [241,] 0.00000000 0.72727273 0.09090909  4.505364e-04 -4.452849e-03
       [242,] 0.09090909 0.72727273 0.09090909  9.730280e-04 -2.841891e-03
       [243,] 0.18181818 0.72727273 0.09090909  7.420903e-03 -9.387541e-03
       [244,] 0.27272727 0.72727273 0.09090909  3.837808e-03 -6.651406e-03
       [245,] 0.36363636 0.72727273 0.09090909  3.389438e-03  3.539096e-03
       [246,] 0.45454545 0.72727273 0.09090909  4.694906e-03 -3.143322e-03
       [247,] 0.54545455 0.72727273 0.09090909 -9.292101e-03 -6.937758e-03
       [248,] 0.63636364 0.72727273 0.09090909 -2.809439e-03 -8.927833e-03
       [249,] 0.72727273 0.72727273 0.09090909 -5.548812e-04  2.963614e-03
       [250,] 0.81818182 0.72727273 0.09090909  4.395632e-03  1.672481e-03
       [251,] 0.90909091 0.72727273 0.09090909  2.919785e-04  8.094120e-03
       [252,] 1.00000000 0.72727273 0.09090909 -6.536049e-03 -4.212314e-04
       [253,] 0.00000000 0.81818182 0.09090909 -1.390530e-03 -6.852107e-03
       [254,] 0.09090909 0.81818182 0.09090909  9.811379e-03  7.944183e-03
       [255,] 0.18181818 0.81818182 0.09090909 -7.485827e-03 -4.482163e-03
       [256,] 0.27272727 0.81818182 0.09090909  8.037336e-03  1.485074e-04
       [257,] 0.36363636 0.81818182 0.09090909  7.564791e-03 -3.954935e-03
       [258,] 0.45454545 0.81818182 0.09090909 -2.760285e-03  4.800100e-03
       [259,] 0.54545455 0.81818182 0.09090909  2.836160e-03 -1.697953e-03
       [260,] 0.63636364 0.81818182 0.09090909  3.222136e-03  3.723093e-03
       [261,] 0.72727273 0.81818182 0.09090909  9.139869e-03  3.932135e-03
       [262,] 0.81818182 0.81818182 0.09090909 -3.456228e-03  9.534661e-03
       [263,] 0.90909091 0.81818182 0.09090909 -4.444186e-03  1.595777e-03
       [264,] 1.00000000 0.81818182 0.09090909  9.760273e-03  1.927200e-03
       [265,] 0.00000000 0.90909091 0.09090909  1.491733e-03 -8.456987e-03
       [266,] 0.09090909 0.90909091 0.09090909 -6.685134e-03 -1.926907e-03
       [267,] 0.18181818 0.90909091 0.09090909 -7.112059e-03 -2.344593e-03
       [268,] 0.27272727 0.90909091 0.09090909  9.339865e-03  7.026226e-03
       [269,] 0.36363636 0.90909091 0.09090909  4.245543e-03 -1.048463e-03
       [270,] 0.45454545 0.90909091 0.09090909  5.747640e-03  7.073814e-03
       [271,] 0.54545455 0.90909091 0.09090909 -9.762612e-03  2.906735e-03
       [272,] 0.63636364 0.90909091 0.09090909 -5.082966e-03 -5.171525e-03
       [273,] 0.72727273 0.90909091 0.09090909 -8.992155e-03 -7.471631e-03
       [274,] 0.81818182 0.90909091 0.09090909 -6.584313e-03 -9.660182e-03
       [275,] 0.90909091 0.90909091 0.09090909  8.053304e-04  7.996044e-03
       [276,] 1.00000000 0.90909091 0.09090909  2.856928e-03  9.218790e-03
       [277,] 0.00000000 1.00000000 0.09090909 -6.592752e-03 -8.062854e-03
       [278,] 0.09090909 1.00000000 0.09090909  9.892893e-03  1.391963e-03
       [279,] 0.18181818 1.00000000 0.09090909 -7.213955e-03  1.694874e-03
       [280,] 0.27272727 1.00000000 0.09090909  4.057860e-03 -2.476641e-03
       [281,] 0.36363636 1.00000000 0.09090909  7.326619e-03  7.927006e-03
       [282,] 0.45454545 1.00000000 0.09090909 -5.982906e-03 -5.164104e-03
       [283,] 0.54545455 1.00000000 0.09090909  7.121738e-03 -7.332289e-03
       [284,] 0.63636364 1.00000000 0.09090909  6.153689e-03  3.464311e-03
       [285,] 0.72727273 1.00000000 0.09090909  4.530639e-03 -4.680090e-03
       [286,] 0.81818182 1.00000000 0.09090909  2.977271e-03 -4.539150e-03
       [287,] 0.90909091 1.00000000 0.09090909 -6.951713e-04 -7.595865e-04
       [288,] 1.00000000 1.00000000 0.09090909  4.301289e-03 -2.725547e-03
       [289,] 0.00000000 0.00000000 0.18181818  6.387494e-03 -8.071617e-03
       [290,] 0.09090909 0.00000000 0.18181818 -7.432062e-03  7.267679e-03
       [291,] 0.18181818 0.00000000 0.18181818  9.960357e-03  7.355439e-03
       [292,] 0.27272727 0.00000000 0.18181818  2.554415e-03 -3.101711e-03
       [293,] 0.36363636 0.00000000 0.18181818  1.175548e-03 -6.732661e-03
       [294,] 0.45454545 0.00000000 0.18181818  5.152251e-03  2.610557e-03
       [295,] 0.54545455 0.00000000 0.18181818  5.468458e-03  8.945560e-03
       [296,] 0.63636364 0.00000000 0.18181818 -7.078435e-03  8.315454e-03
       [297,] 0.72727273 0.00000000 0.18181818  3.612173e-03 -7.309495e-03
       [298,] 0.81818182 0.00000000 0.18181818 -8.896829e-04 -1.678332e-03
       [299,] 0.90909091 0.00000000 0.18181818 -9.429478e-03  6.151415e-03
       [300,] 1.00000000 0.00000000 0.18181818 -3.597598e-03 -9.165595e-03
       [301,] 0.00000000 0.09090909 0.18181818  7.940527e-03  4.257476e-03
       [302,] 0.09090909 0.09090909 0.18181818 -5.815264e-03  6.593700e-03
       [303,] 0.18181818 0.09090909 0.18181818 -8.447204e-03 -2.395240e-03
       [304,] 0.27272727 0.09090909 0.18181818  4.286200e-03 -5.922047e-03
       [305,] 0.36363636 0.09090909 0.18181818  9.988666e-03  4.415178e-03
       [306,] 0.45454545 0.09090909 0.18181818  7.137036e-03 -2.147733e-03
       [307,] 0.54545455 0.09090909 0.18181818 -3.127460e-04 -9.829086e-03
       [308,] 0.63636364 0.09090909 0.18181818  2.467935e-03  2.664128e-03
       [309,] 0.72727273 0.09090909 0.18181818  5.686786e-03  6.013614e-03
       [310,] 0.81818182 0.09090909 0.18181818  7.016596e-03 -7.202602e-03
       [311,] 0.90909091 0.09090909 0.18181818  7.068782e-03 -7.666323e-03
       [312,] 1.00000000 0.09090909 0.18181818 -8.462850e-03  2.053057e-03
       [313,] 0.00000000 0.18181818 0.18181818  1.039249e-03 -2.579672e-03
       [314,] 0.09090909 0.18181818 0.18181818  7.789385e-03 -8.814970e-03
       [315,] 0.18181818 0.18181818 0.18181818  1.731518e-03  9.765602e-03
       [316,] 0.27272727 0.18181818 0.18181818 -4.640812e-03 -7.524518e-03
       [317,] 0.36363636 0.18181818 0.18181818  4.913826e-03 -7.109186e-03
       [318,] 0.45454545 0.18181818 0.18181818  6.317783e-03  7.197041e-03
       [319,] 0.54545455 0.18181818 0.18181818 -4.546898e-03  8.251355e-03
       [320,] 0.63636364 0.18181818 0.18181818  7.329898e-03 -3.409663e-03
       [321,] 0.72727273 0.18181818 0.18181818 -3.156973e-03 -4.464283e-03
       [322,] 0.81818182 0.18181818 0.18181818 -1.402710e-03 -7.978688e-03
       [323,] 0.90909091 0.18181818 0.18181818 -4.163981e-03 -6.071947e-03
       [324,] 1.00000000 0.18181818 0.18181818  3.784492e-03  5.382973e-03
       [325,] 0.00000000 0.27272727 0.18181818 -6.764322e-03 -6.504694e-03
       [326,] 0.09090909 0.27272727 0.18181818  9.219848e-03  8.121052e-03
       [327,] 0.18181818 0.27272727 0.18181818 -8.947567e-03 -8.590341e-03
       [328,] 0.27272727 0.27272727 0.18181818 -5.449948e-03 -7.460789e-03
       [329,] 0.36363636 0.27272727 0.18181818  3.219428e-03 -4.712357e-03
       [330,] 0.45454545 0.27272727 0.18181818 -9.288966e-03 -9.314355e-03
       [331,] 0.54545455 0.27272727 0.18181818 -3.586987e-03 -7.179587e-03
       [332,] 0.63636364 0.27272727 0.18181818  4.147651e-03 -3.870578e-03
       [333,] 0.72727273 0.27272727 0.18181818 -7.488758e-04 -1.875406e-03
       [334,] 0.81818182 0.27272727 0.18181818  2.371676e-03  7.641839e-04
       [335,] 0.90909091 0.27272727 0.18181818 -1.274808e-03  7.530213e-03
       [336,] 1.00000000 0.27272727 0.18181818  5.957310e-03  9.413888e-03
       [337,] 0.00000000 0.36363636 0.18181818  8.669652e-03  4.508791e-03
       [338,] 0.09090909 0.36363636 0.18181818  3.270653e-03  6.189419e-04
       [339,] 0.18181818 0.36363636 0.18181818 -7.198392e-03 -4.174262e-03
       [340,] 0.27272727 0.36363636 0.18181818  7.418030e-03 -8.263734e-03
       [341,] 0.36363636 0.36363636 0.18181818  9.927640e-03  2.572353e-04
       [342,] 0.45454545 0.36363636 0.18181818 -2.289039e-03 -2.394142e-03
       [343,] 0.54545455 0.36363636 0.18181818  3.153726e-03 -1.905897e-03
       [344,] 0.63636364 0.36363636 0.18181818  9.654501e-03  9.124407e-03
       [345,] 0.72727273 0.36363636 0.18181818 -8.348924e-03  6.606785e-03
       [346,] 0.81818182 0.36363636 0.18181818 -9.815200e-03  5.049311e-03
       [347,] 0.90909091 0.36363636 0.18181818  2.868335e-03  3.152312e-03
       [348,] 1.00000000 0.36363636 0.18181818  7.793873e-03 -1.174184e-03
       [349,] 0.00000000 0.45454545 0.18181818  1.010439e-03  5.978106e-03
       [350,] 0.09090909 0.45454545 0.18181818  6.769806e-03  9.423439e-03
       [351,] 0.18181818 0.45454545 0.18181818 -1.441549e-04  2.796925e-03
       [352,] 0.27272727 0.45454545 0.18181818 -7.171226e-03 -4.386596e-03
       [353,] 0.36363636 0.45454545 0.18181818  6.868655e-03 -3.706117e-03
       [354,] 0.45454545 0.45454545 0.18181818 -7.618252e-03 -5.188722e-03
       [355,] 0.54545455 0.45454545 0.18181818  3.530397e-04  6.414325e-03
       [356,] 0.63636364 0.45454545 0.18181818 -5.424616e-03  2.457169e-03
       [357,] 0.72727273 0.45454545 0.18181818  3.073482e-03  1.512805e-03
       [358,] 0.81818182 0.45454545 0.18181818  8.715833e-03  7.220107e-03
       [359,] 0.90909091 0.45454545 0.18181818  1.407769e-04 -4.419188e-03
       [360,] 1.00000000 0.45454545 0.18181818  8.524857e-04 -2.960530e-03
       [361,] 0.00000000 0.54545455 0.18181818 -6.141171e-03  1.359418e-03
       [362,] 0.09090909 0.54545455 0.18181818  3.443638e-03 -2.452750e-03
       [363,] 0.18181818 0.54545455 0.18181818 -6.891297e-03 -4.286440e-05
       [364,] 0.27272727 0.54545455 0.18181818  2.910514e-03 -1.905229e-03
       [365,] 0.36363636 0.54545455 0.18181818 -4.812824e-04  7.670229e-03
       [366,] 0.45454545 0.54545455 0.18181818 -9.410904e-03 -5.707502e-03
       [367,] 0.54545455 0.54545455 0.18181818  8.592627e-03 -3.157665e-03
       [368,] 0.63636364 0.54545455 0.18181818 -6.289616e-03  1.017760e-03
       [369,] 0.72727273 0.54545455 0.18181818  9.385140e-03 -6.906663e-03
       [370,] 0.81818182 0.54545455 0.18181818 -1.344373e-03 -9.112396e-03
       [371,] 0.90909091 0.54545455 0.18181818  7.301414e-03  1.937749e-03
       [372,] 1.00000000 0.54545455 0.18181818 -2.961852e-03 -3.465658e-03
       [373,] 0.00000000 0.63636364 0.18181818  5.763175e-03  2.325506e-03
       [374,] 0.09090909 0.63636364 0.18181818  7.878189e-03 -2.241820e-03
       [375,] 0.18181818 0.63636364 0.18181818  8.739905e-03 -8.375677e-03
       [376,] 0.27272727 0.63636364 0.18181818  9.304360e-03  5.320735e-04
       [377,] 0.36363636 0.63636364 0.18181818  5.827845e-03  7.450842e-03
       [378,] 0.45454545 0.63636364 0.18181818 -2.297630e-03  8.669006e-03
       [379,] 0.54545455 0.63636364 0.18181818  3.896577e-03 -3.848070e-03
       [380,] 0.63636364 0.63636364 0.18181818  9.706979e-03  6.761805e-03
       [381,] 0.72727273 0.63636364 0.18181818  1.943989e-03  8.077509e-03
       [382,] 0.81818182 0.63636364 0.18181818  8.956622e-04 -5.612646e-04
       [383,] 0.90909091 0.63636364 0.18181818 -7.329231e-03 -5.965035e-03
       [384,] 1.00000000 0.63636364 0.18181818  7.901102e-03 -6.564719e-04
       [385,] 0.00000000 0.72727273 0.18181818  1.077499e-03  4.886949e-04
       [386,] 0.09090909 0.72727273 0.18181818 -1.160693e-03  7.501554e-03
       [387,] 0.18181818 0.72727273 0.18181818 -1.219500e-03 -9.327148e-03
       [388,] 0.27272727 0.72727273 0.18181818  4.683468e-03 -6.642379e-03
       [389,] 0.36363636 0.72727273 0.18181818 -3.754727e-03  8.894364e-03
       [390,] 0.45454545 0.72727273 0.18181818  8.842582e-03  3.240848e-03
       [391,] 0.54545455 0.72727273 0.18181818  8.387487e-03  5.948172e-03
       [392,] 0.63636364 0.72727273 0.18181818  9.978020e-03  9.988957e-03
       [393,] 0.72727273 0.72727273 0.18181818 -2.194821e-03  2.642254e-03
       [394,] 0.81818182 0.72727273 0.18181818  1.495039e-03 -2.059626e-03
       [395,] 0.90909091 0.72727273 0.18181818  6.104260e-03 -6.478144e-03
       [396,] 1.00000000 0.72727273 0.18181818  3.446854e-03  9.625548e-03
       [397,] 0.00000000 0.81818182 0.18181818  8.139106e-04 -7.063196e-03
       [398,] 0.09090909 0.81818182 0.18181818 -7.859061e-03  5.806222e-03
       [399,] 0.18181818 0.81818182 0.18181818 -6.745224e-03  7.407756e-03
       [400,] 0.27272727 0.81818182 0.18181818 -3.801970e-03  5.405599e-03
       [401,] 0.36363636 0.81818182 0.18181818 -2.917797e-03  8.301387e-03
       [402,] 0.45454545 0.81818182 0.18181818  5.731245e-03  5.028366e-03
       [403,] 0.54545455 0.81818182 0.18181818  5.219563e-03 -9.520854e-03
       [404,] 0.63636364 0.81818182 0.18181818  8.221478e-03  8.278235e-04
       [405,] 0.72727273 0.81818182 0.18181818  9.930245e-03  6.075980e-03
       [406,] 0.81818182 0.81818182 0.18181818  6.503715e-03 -1.210801e-03
       [407,] 0.90909091 0.81818182 0.18181818 -4.562084e-03 -4.218492e-03
       [408,] 1.00000000 0.81818182 0.18181818 -9.377155e-03  6.607533e-03
       [409,] 0.00000000 0.90909091 0.18181818  7.171829e-03  5.849615e-03
       [410,] 0.09090909 0.90909091 0.18181818 -8.093255e-03 -8.715622e-03
       [411,] 0.18181818 0.90909091 0.18181818  2.179648e-03 -2.876393e-03
       [412,] 0.27272727 0.90909091 0.18181818  6.827107e-03 -6.438400e-03
       [413,] 0.36363636 0.90909091 0.18181818  6.179010e-03 -4.853327e-03
       [414,] 0.45454545 0.90909091 0.18181818 -8.049303e-03  4.999530e-03
       [415,] 0.54545455 0.90909091 0.18181818  5.638084e-03 -3.544895e-03
       [416,] 0.63636364 0.90909091 0.18181818  7.542908e-03  8.804209e-04
       [417,] 0.72727273 0.90909091 0.18181818  9.260504e-04  7.387884e-03
       [418,] 0.81818182 0.90909091 0.18181818  8.984751e-03  2.897092e-03
       [419,] 0.90909091 0.90909091 0.18181818 -2.722302e-03 -1.755821e-03
       [420,] 1.00000000 0.90909091 0.18181818  5.522995e-03 -4.992563e-03
       [421,] 0.00000000 1.00000000 0.18181818 -1.403361e-03  3.199242e-04
       [422,] 0.09090909 1.00000000 0.18181818 -1.446101e-03  8.316670e-03
       [423,] 0.18181818 1.00000000 0.18181818 -2.704042e-03  7.607336e-03
       [424,] 0.27272727 1.00000000 0.18181818  8.914038e-03  9.316697e-03
       [425,] 0.36363636 1.00000000 0.18181818  2.620067e-04 -8.001769e-04
       [426,] 0.45454545 1.00000000 0.18181818  1.902759e-03  1.523003e-03
       [427,] 0.54545455 1.00000000 0.18181818 -6.007690e-03 -4.061142e-03
       [428,] 0.63636364 1.00000000 0.18181818 -1.276564e-03 -3.971636e-03
       [429,] 0.72727273 1.00000000 0.18181818  4.889959e-03  9.530039e-03
       [430,] 0.81818182 1.00000000 0.18181818  5.354200e-03 -2.518027e-03
       [431,] 0.90909091 1.00000000 0.18181818 -9.409730e-03  5.114750e-03
       [432,] 1.00000000 1.00000000 0.18181818  5.923561e-03 -3.427449e-03
       [433,] 0.00000000 0.00000000 0.27272727 -6.740342e-03  5.805901e-03
       [434,] 0.09090909 0.00000000 0.27272727 -3.309367e-03 -1.196826e-03
       [435,] 0.18181818 0.00000000 0.27272727 -3.666450e-03 -4.452097e-03
       [436,] 0.27272727 0.00000000 0.27272727  7.733417e-04 -2.195427e-03
       [437,] 0.36363636 0.00000000 0.27272727  8.126574e-03  9.380822e-03
       [438,] 0.45454545 0.00000000 0.27272727 -6.802457e-03 -5.115943e-03
       [439,] 0.54545455 0.00000000 0.27272727 -8.911312e-04  9.190995e-03
       [440,] 0.63636364 0.00000000 0.27272727 -4.675507e-03 -5.343477e-03
       [441,] 0.72727273 0.00000000 0.27272727 -1.320145e-03  5.690328e-03
       [442,] 0.81818182 0.00000000 0.27272727 -1.486074e-03 -7.514052e-03
       [443,] 0.90909091 0.00000000 0.27272727  8.726588e-03 -7.353009e-03
       [444,] 1.00000000 0.00000000 0.27272727 -8.381871e-03  6.192794e-03
       [445,] 0.00000000 0.09090909 0.27272727 -6.850851e-03  7.427314e-04
       [446,] 0.09090909 0.09090909 0.27272727  7.720366e-03 -6.357103e-03
       [447,] 0.18181818 0.09090909 0.27272727  1.487052e-03 -4.491429e-03
       [448,] 0.27272727 0.09090909 0.27272727 -8.080831e-03 -7.193189e-03
       [449,] 0.36363636 0.09090909 0.27272727  8.553476e-03 -8.972873e-03
       [450,] 0.45454545 0.09090909 0.27272727 -5.989384e-03 -7.941813e-04
       [451,] 0.54545455 0.09090909 0.27272727  8.913970e-03  7.420439e-03
       [452,] 0.63636364 0.09090909 0.27272727  2.164222e-03 -4.238212e-03
       [453,] 0.72727273 0.09090909 0.27272727  2.483721e-03 -4.386766e-03
       [454,] 0.81818182 0.09090909 0.27272727  3.263303e-03 -1.177024e-03
       [455,] 0.90909091 0.09090909 0.27272727 -6.081672e-04  6.376925e-03
       [456,] 1.00000000 0.09090909 0.27272727  8.055756e-03 -3.390505e-03
       [457,] 0.00000000 0.18181818 0.27272727  1.870207e-03  1.746986e-03
       [458,] 0.09090909 0.18181818 0.27272727  3.435507e-03  2.425236e-03
       [459,] 0.18181818 0.18181818 0.27272727  1.427123e-03 -2.541400e-04
       [460,] 0.27272727 0.18181818 0.27272727  6.670750e-03 -3.845441e-03
       [461,] 0.36363636 0.18181818 0.27272727 -6.862231e-04  9.329032e-03
       [462,] 0.45454545 0.18181818 0.27272727 -3.733012e-03 -5.125035e-03
       [463,] 0.54545455 0.18181818 0.27272727  4.277005e-03  9.610634e-03
       [464,] 0.63636364 0.18181818 0.27272727 -9.335539e-03 -3.577067e-03
       [465,] 0.72727273 0.18181818 0.27272727  6.507916e-03 -3.117407e-03
       [466,] 0.81818182 0.18181818 0.27272727 -5.609305e-03 -7.244707e-03
       [467,] 0.90909091 0.18181818 0.27272727 -1.801918e-03 -4.123632e-03
       [468,] 1.00000000 0.18181818 0.27272727  5.976260e-03  7.141431e-03
       [469,] 0.00000000 0.27272727 0.27272727  1.411748e-03 -8.012134e-03
       [470,] 0.09090909 0.27272727 0.27272727 -3.417429e-03 -4.399422e-03
       [471,] 0.18181818 0.27272727 0.27272727 -5.132195e-03 -3.267307e-03
       [472,] 0.27272727 0.27272727 0.27272727 -6.410127e-03  3.917452e-03
       [473,] 0.36363636 0.27272727 0.27272727 -5.188265e-03  4.226055e-03
       [474,] 0.45454545 0.27272727 0.27272727  7.606264e-03  7.928385e-03
       [475,] 0.54545455 0.27272727 0.27272727  8.758609e-03  2.218471e-03
       [476,] 0.63636364 0.27272727 0.27272727 -2.868308e-03  7.836259e-03
       [477,] 0.72727273 0.27272727 0.27272727 -8.898322e-04  5.548495e-03
       [478,] 0.81818182 0.27272727 0.27272727 -1.500765e-03  9.797015e-03
       [479,] 0.90909091 0.27272727 0.27272727 -9.313555e-03  6.030470e-03
       [480,] 1.00000000 0.27272727 0.27272727 -5.421682e-03 -5.894035e-03
       [481,] 0.00000000 0.36363636 0.27272727  5.201622e-03  8.945070e-03
       [482,] 0.09090909 0.36363636 0.27272727 -6.568626e-03 -5.640042e-03
       [483,] 0.18181818 0.36363636 0.27272727 -8.958034e-03 -7.315190e-03
       [484,] 0.27272727 0.36363636 0.27272727 -6.354810e-03  1.855481e-03
       [485,] 0.36363636 0.36363636 0.27272727  2.428218e-03 -6.391002e-03
       [486,] 0.45454545 0.36363636 0.27272727 -5.091455e-04 -6.681038e-03
       [487,] 0.54545455 0.36363636 0.27272727 -6.739245e-03 -1.937523e-03
       [488,] 0.63636364 0.36363636 0.27272727 -7.885662e-03  7.401387e-03
       [489,] 0.72727273 0.36363636 0.27272727  2.144002e-03  3.991790e-03
       [490,] 0.81818182 0.36363636 0.27272727 -8.369593e-03 -3.783426e-04
       [491,] 0.90909091 0.36363636 0.27272727 -9.251521e-03 -4.409638e-04
       [492,] 1.00000000 0.36363636 0.27272727 -4.769873e-03 -3.377403e-03
       [493,] 0.00000000 0.45454545 0.27272727 -4.059189e-03  9.490232e-03
       [494,] 0.09090909 0.45454545 0.27272727 -6.178087e-06 -5.004735e-03
       [495,] 0.18181818 0.45454545 0.27272727 -4.328919e-03  5.821920e-03
       [496,] 0.27272727 0.45454545 0.27272727  1.456172e-03  9.126393e-03
       [497,] 0.36363636 0.45454545 0.27272727 -1.031921e-03  9.509189e-03
       [498,] 0.45454545 0.45454545 0.27272727  9.143837e-03 -4.174940e-03
       [499,] 0.54545455 0.45454545 0.27272727  8.742367e-03 -2.251655e-03
       [500,] 0.63636364 0.45454545 0.27272727 -1.693190e-03 -6.821476e-03
       [501,] 0.72727273 0.45454545 0.27272727  1.959514e-03 -8.429108e-03
       [502,] 0.81818182 0.45454545 0.27272727 -4.845282e-03 -1.631404e-03
       [503,] 0.90909091 0.45454545 0.27272727  6.554405e-03 -3.951282e-03
       [504,] 1.00000000 0.45454545 0.27272727 -1.999421e-03  9.690119e-03
       [505,] 0.00000000 0.54545455 0.27272727 -6.138640e-03  6.406523e-03
       [506,] 0.09090909 0.54545455 0.27272727  2.953229e-03 -1.509353e-03
       [507,] 0.18181818 0.54545455 0.27272727 -3.678565e-03 -7.060404e-03
       [508,] 0.27272727 0.54545455 0.27272727  5.291641e-03 -3.048997e-03
       [509,] 0.36363636 0.54545455 0.27272727  2.556391e-03 -7.369011e-03
       [510,] 0.45454545 0.54545455 0.27272727 -8.455372e-03  9.695040e-03
       [511,] 0.54545455 0.54545455 0.27272727 -1.921221e-03  2.905413e-03
       [512,] 0.63636364 0.54545455 0.27272727 -5.660565e-03  2.474812e-03
       [513,] 0.72727273 0.54545455 0.27272727 -8.362482e-03 -8.143100e-03
       [514,] 0.81818182 0.54545455 0.27272727  2.622270e-03  1.653681e-03
       [515,] 0.90909091 0.54545455 0.27272727  3.761914e-03  1.007146e-04
       [516,] 1.00000000 0.54545455 0.27272727  3.424589e-03  5.460575e-03
       [517,] 0.00000000 0.63636364 0.27272727  1.576951e-03 -3.232727e-03
       [518,] 0.09090909 0.63636364 0.27272727  8.401258e-03  5.169471e-03
       [519,] 0.18181818 0.63636364 0.27272727  5.754086e-03  7.766765e-03
       [520,] 0.27272727 0.63636364 0.27272727  6.457054e-03 -4.591852e-03
       [521,] 0.36363636 0.63636364 0.27272727  5.576639e-03  2.482139e-03
       [522,] 0.45454545 0.63636364 0.27272727 -3.483966e-03 -2.723219e-03
       [523,] 0.54545455 0.63636364 0.27272727  1.036426e-03 -5.751931e-03
       [524,] 0.63636364 0.63636364 0.27272727 -5.949426e-03  2.960065e-03
       [525,] 0.72727273 0.63636364 0.27272727  4.055288e-03  5.411546e-03
       [526,] 0.81818182 0.63636364 0.27272727  1.389019e-03  6.915499e-03
       [527,] 0.90909091 0.63636364 0.27272727 -5.716461e-04 -5.871296e-03
       [528,] 1.00000000 0.63636364 0.27272727  9.628675e-03  6.679780e-03
       [529,] 0.00000000 0.72727273 0.27272727 -3.277114e-03 -9.230742e-04
       [530,] 0.09090909 0.72727273 0.27272727 -8.479375e-03  8.445169e-03
       [531,] 0.18181818 0.72727273 0.27272727  4.065323e-03 -9.264315e-03
       [532,] 0.27272727 0.72727273 0.27272727  9.048134e-04  4.569957e-03
       [533,] 0.36363636 0.72727273 0.27272727  3.425837e-03  3.131597e-03
       [534,] 0.45454545 0.72727273 0.27272727  8.000005e-03  6.788937e-03
       [535,] 0.54545455 0.72727273 0.27272727 -6.258925e-03  6.183433e-03
       [536,] 0.63636364 0.72727273 0.27272727 -3.393085e-03  3.254927e-03
       [537,] 0.72727273 0.72727273 0.27272727 -5.198048e-03 -4.141843e-03
       [538,] 0.81818182 0.72727273 0.27272727  5.371736e-03 -4.788431e-03
       [539,] 0.90909091 0.72727273 0.27272727  6.351854e-03  1.943379e-04
       [540,] 1.00000000 0.72727273 0.27272727 -4.035104e-03 -5.482139e-03
       [541,] 0.00000000 0.81818182 0.27272727  2.861124e-03  7.603964e-03
       [542,] 0.09090909 0.81818182 0.27272727 -8.776436e-03  9.704943e-03
       [543,] 0.18181818 0.81818182 0.27272727  9.409343e-03 -3.591678e-03
       [544,] 0.27272727 0.81818182 0.27272727 -8.865740e-04 -3.424983e-03
       [545,] 0.36363636 0.81818182 0.27272727 -7.323564e-03  4.096990e-03
       [546,] 0.45454545 0.81818182 0.27272727  1.705751e-03 -3.599601e-03
       [547,] 0.54545455 0.81818182 0.27272727 -1.567409e-03  7.002256e-03
       [548,] 0.63636364 0.81818182 0.27272727 -7.289348e-03  6.454469e-03
       [549,] 0.72727273 0.81818182 0.27272727  6.672655e-03  8.197517e-03
       [550,] 0.81818182 0.81818182 0.27272727 -3.815950e-03 -9.449264e-03
       [551,] 0.90909091 0.81818182 0.27272727 -2.942335e-04 -2.698419e-03
       [552,] 1.00000000 0.81818182 0.27272727 -2.685807e-03 -6.513581e-04
       [553,] 0.00000000 0.90909091 0.27272727  7.040128e-03 -5.706582e-03
       [554,] 0.09090909 0.90909091 0.27272727 -4.762521e-03 -6.702757e-03
       [555,] 0.18181818 0.90909091 0.27272727 -5.323742e-03 -8.473298e-03
       [556,] 0.27272727 0.90909091 0.27272727  7.111525e-03  2.682909e-03
       [557,] 0.36363636 0.90909091 0.27272727  7.190495e-03  9.167520e-03
       [558,] 0.45454545 0.90909091 0.27272727 -2.728205e-03  3.349230e-03
       [559,] 0.54545455 0.90909091 0.27272727  9.750771e-03  4.795629e-03
       [560,] 0.63636364 0.90909091 0.27272727  4.987743e-03 -8.053206e-03
       [561,] 0.72727273 0.90909091 0.27272727 -9.793845e-04  3.896635e-03
       [562,] 0.81818182 0.90909091 0.27272727 -7.940113e-03 -9.004833e-03
       [563,] 0.90909091 0.90909091 0.27272727  1.744993e-03  5.911563e-03
       [564,] 1.00000000 0.90909091 0.27272727  3.194318e-03 -6.945726e-03
       [565,] 0.00000000 1.00000000 0.27272727 -4.039531e-03  2.473874e-03
       [566,] 0.09090909 1.00000000 0.27272727  1.827810e-03  1.301887e-03
       [567,] 0.18181818 1.00000000 0.27272727  6.056735e-03  6.665140e-03
       [568,] 0.27272727 1.00000000 0.27272727  3.577160e-03 -8.376941e-03
       [569,] 0.36363636 1.00000000 0.27272727 -8.580138e-03 -9.599176e-04
       [570,] 0.45454545 1.00000000 0.27272727 -4.404908e-03 -1.963399e-03
       [571,] 0.54545455 1.00000000 0.27272727  1.333212e-03 -4.599319e-03
       [572,] 0.63636364 1.00000000 0.27272727  8.796207e-03  9.011438e-03
       [573,] 0.72727273 1.00000000 0.27272727  5.968613e-03 -8.113702e-03
       [574,] 0.81818182 1.00000000 0.27272727  9.336182e-04 -1.699813e-03
       [575,] 0.90909091 1.00000000 0.27272727 -2.295755e-03  9.834792e-03
       [576,] 1.00000000 1.00000000 0.27272727 -5.862211e-03  6.105563e-03
       [577,] 0.00000000 0.00000000 0.36363636 -6.992313e-03  2.893437e-03
       [578,] 0.09090909 0.00000000 0.36363636  1.019514e-04 -5.363563e-03
       [579,] 0.18181818 0.00000000 0.36363636 -2.215128e-03  6.430364e-03
       [580,] 0.27272727 0.00000000 0.36363636  6.888008e-03 -3.021318e-03
       [581,] 0.36363636 0.00000000 0.36363636  3.442055e-04 -3.666261e-03
       [582,] 0.45454545 0.00000000 0.36363636  1.021214e-03 -8.636904e-03
       [583,] 0.54545455 0.00000000 0.36363636 -1.894261e-03 -6.998016e-03
       [584,] 0.63636364 0.00000000 0.36363636  4.569165e-03 -8.282509e-03
       [585,] 0.72727273 0.00000000 0.36363636 -7.422544e-03  2.725592e-04
       [586,] 0.81818182 0.00000000 0.36363636  8.863161e-03  4.517337e-03
       [587,] 0.90909091 0.00000000 0.36363636  2.767813e-03 -8.498777e-03
       [588,] 1.00000000 0.00000000 0.36363636 -7.980463e-03  4.416709e-03
       [589,] 0.00000000 0.09090909 0.36363636  2.786208e-03 -2.276748e-04
       [590,] 0.09090909 0.09090909 0.36363636 -9.337891e-04  8.171538e-03
       [591,] 0.18181818 0.09090909 0.36363636  2.674021e-03  8.232641e-03
       [592,] 0.27272727 0.09090909 0.36363636 -6.161841e-03  5.101975e-03
       [593,] 0.36363636 0.09090909 0.36363636  2.380880e-03  9.865781e-03
       [594,] 0.45454545 0.09090909 0.36363636  4.352470e-03  3.854705e-03
       [595,] 0.54545455 0.09090909 0.36363636  7.617288e-04 -8.572742e-03
       [596,] 0.63636364 0.09090909 0.36363636 -4.045069e-03 -8.561763e-03
       [597,] 0.72727273 0.09090909 0.36363636 -7.285794e-04  7.761104e-03
       [598,] 0.81818182 0.09090909 0.36363636  1.112248e-03  2.411984e-03
       [599,] 0.90909091 0.09090909 0.36363636  5.171503e-03  2.147771e-03
       [600,] 1.00000000 0.09090909 0.36363636 -3.161240e-03  5.154888e-03
       [601,] 0.00000000 0.18181818 0.36363636  2.433089e-03 -5.743812e-03
       [602,] 0.09090909 0.18181818 0.36363636 -4.876077e-03 -9.629053e-03
       [603,] 0.18181818 0.18181818 0.36363636  7.385134e-03  8.784115e-03
       [604,] 0.27272727 0.18181818 0.36363636 -2.459800e-03 -9.125045e-03
       [605,] 0.36363636 0.18181818 0.36363636  9.085466e-03 -8.218734e-03
       [606,] 0.45454545 0.18181818 0.36363636  2.135503e-03 -3.791312e-03
       [607,] 0.54545455 0.18181818 0.36363636 -7.456168e-03  2.214638e-03
       [608,] 0.63636364 0.18181818 0.36363636 -9.269159e-03 -2.965693e-03
       [609,] 0.72727273 0.18181818 0.36363636 -7.010324e-03 -8.902550e-03
       [610,] 0.81818182 0.18181818 0.36363636  9.771664e-03 -4.207175e-03
       [611,] 0.90909091 0.18181818 0.36363636  9.475544e-03 -1.292191e-03
       [612,] 1.00000000 0.18181818 0.36363636 -2.088122e-03  8.547634e-03
       [613,] 0.00000000 0.27272727 0.36363636 -9.110802e-03 -1.093318e-03
       [614,] 0.09090909 0.27272727 0.36363636 -2.931319e-03  8.249364e-03
       [615,] 0.18181818 0.27272727 0.36363636  3.037637e-03  6.207990e-03
       [616,] 0.27272727 0.27272727 0.36363636  1.958815e-03  2.133471e-03
       [617,] 0.36363636 0.27272727 0.36363636  4.180963e-04 -4.300853e-03
       [618,] 0.45454545 0.27272727 0.36363636  3.345936e-03  1.773530e-03
       [619,] 0.54545455 0.27272727 0.36363636 -2.106166e-03  2.642938e-03
       [620,] 0.63636364 0.27272727 0.36363636  5.138136e-03 -5.043840e-03
       [621,] 0.72727273 0.27272727 0.36363636  3.903976e-03 -3.324300e-03
       [622,] 0.81818182 0.27272727 0.36363636  5.951670e-03 -9.474109e-03
       [623,] 0.90909091 0.27272727 0.36363636  2.219871e-03 -2.285536e-03
       [624,] 1.00000000 0.27272727 0.36363636 -2.983104e-03  5.169661e-03
       [625,] 0.00000000 0.36363636 0.36363636  3.237790e-03  9.747204e-03
       [626,] 0.09090909 0.36363636 0.36363636  9.473253e-03 -1.016168e-03
       [627,] 0.18181818 0.36363636 0.36363636 -5.490189e-03  7.113554e-03
       [628,] 0.27272727 0.36363636 0.36363636 -8.317638e-04 -5.626966e-03
       [629,] 0.36363636 0.36363636 0.36363636  6.732507e-03  6.038614e-03
       [630,] 0.45454545 0.36363636 0.36363636 -7.125508e-03 -5.295144e-03
       [631,] 0.54545455 0.36363636 0.36363636 -4.033672e-03 -9.953344e-03
       [632,] 0.63636364 0.36363636 0.36363636 -7.948379e-04  2.767666e-03
       [633,] 0.72727273 0.36363636 0.36363636 -3.780131e-03  3.405881e-03
       [634,] 0.81818182 0.36363636 0.36363636 -6.789074e-03 -2.106454e-03
       [635,] 0.90909091 0.36363636 0.36363636  7.909685e-03 -5.079899e-03
       [636,] 1.00000000 0.36363636 0.36363636 -7.031569e-03  7.912365e-04
       [637,] 0.00000000 0.45454545 0.36363636 -2.369103e-03  5.087603e-03
       [638,] 0.09090909 0.45454545 0.36363636  5.785696e-04 -5.512638e-05
       [639,] 0.18181818 0.45454545 0.36363636  8.320918e-03 -5.051931e-03
       [640,] 0.27272727 0.45454545 0.36363636 -2.671022e-03  2.657944e-03
       [641,] 0.36363636 0.45454545 0.36363636  7.259535e-03  4.106609e-03
       [642,] 0.45454545 0.45454545 0.36363636  6.283451e-03 -6.892240e-03
       [643,] 0.54545455 0.45454545 0.36363636  3.549791e-03  7.004363e-03
       [644,] 0.63636364 0.45454545 0.36363636 -1.624180e-03 -8.198796e-03
       [645,] 0.72727273 0.45454545 0.36363636  3.173237e-03 -3.522916e-03
       [646,] 0.81818182 0.45454545 0.36363636  1.837188e-03 -8.963471e-03
       [647,] 0.90909091 0.45454545 0.36363636 -5.819077e-03  9.603564e-03
       [648,] 1.00000000 0.45454545 0.36363636  4.107218e-03  9.582976e-03
       [649,] 0.00000000 0.54545455 0.36363636 -1.612727e-03  9.358113e-03
       [650,] 0.09090909 0.54545455 0.36363636  3.106765e-03  7.356859e-04
       [651,] 0.18181818 0.54545455 0.36363636  5.205726e-03 -5.690112e-03
       [652,] 0.27272727 0.54545455 0.36363636 -8.921946e-03  4.758808e-03
       [653,] 0.36363636 0.54545455 0.36363636  9.041786e-03 -6.848444e-03
       [654,] 0.45454545 0.54545455 0.36363636  4.654371e-04 -4.916246e-03
       [655,] 0.54545455 0.54545455 0.36363636 -7.707501e-03  7.712828e-03
       [656,] 0.63636364 0.54545455 0.36363636 -1.476067e-03 -4.633974e-03
       [657,] 0.72727273 0.54545455 0.36363636 -4.465915e-03  7.856619e-03
       [658,] 0.81818182 0.54545455 0.36363636 -1.213135e-03 -7.698211e-03
       [659,] 0.90909091 0.54545455 0.36363636 -2.518088e-03 -2.198856e-04
       [660,] 1.00000000 0.54545455 0.36363636  8.665436e-03 -9.679238e-03
       [661,] 0.00000000 0.63636364 0.36363636  4.726525e-03 -6.706158e-03
       [662,] 0.09090909 0.63636364 0.36363636 -4.317620e-03 -3.335654e-03
       [663,] 0.18181818 0.63636364 0.36363636 -2.468865e-04  1.788851e-04
       [664,] 0.27272727 0.63636364 0.36363636  7.573496e-03  7.811002e-03
       [665,] 0.36363636 0.63636364 0.36363636 -1.197882e-03  6.961539e-03
       [666,] 0.45454545 0.63636364 0.36363636  9.394548e-03 -6.618445e-03
       [667,] 0.54545455 0.63636364 0.36363636 -9.222476e-03 -1.823320e-03
       [668,] 0.63636364 0.63636364 0.36363636  1.127845e-04 -5.522174e-04
       [669,] 0.72727273 0.63636364 0.36363636 -7.690986e-03  8.685443e-03
       [670,] 0.81818182 0.63636364 0.36363636 -1.632591e-03 -3.452849e-03
       [671,] 0.90909091 0.63636364 0.36363636  8.785331e-03 -5.311637e-03
       [672,] 1.00000000 0.63636364 0.36363636  5.418908e-03  5.066191e-03
       [673,] 0.00000000 0.72727273 0.36363636 -3.673432e-03  3.273058e-03
       [674,] 0.09090909 0.72727273 0.36363636  1.276375e-03 -4.449074e-04
       [675,] 0.18181818 0.72727273 0.36363636 -3.980618e-03  2.682370e-03
       [676,] 0.27272727 0.72727273 0.36363636  5.461563e-03  3.715040e-03
       [677,] 0.36363636 0.72727273 0.36363636  8.452436e-03  9.138859e-03
       [678,] 0.45454545 0.72727273 0.36363636  9.329997e-03 -9.165492e-03
       [679,] 0.54545455 0.72727273 0.36363636  4.233597e-03  6.910507e-03
       [680,] 0.63636364 0.72727273 0.36363636 -8.618832e-03 -5.164860e-03
       [681,] 0.72727273 0.72727273 0.36363636 -3.841355e-03 -2.079314e-03
       [682,] 0.81818182 0.72727273 0.36363636 -4.485796e-03  2.753899e-03
       [683,] 0.90909091 0.72727273 0.36363636  8.383547e-03  8.146330e-03
       [684,] 1.00000000 0.72727273 0.36363636  7.348133e-04 -9.694142e-03
       [685,] 0.00000000 0.81818182 0.36363636 -8.886913e-03  5.940746e-03
       [686,] 0.09090909 0.81818182 0.36363636 -3.720362e-03 -1.398340e-05
       [687,] 0.18181818 0.81818182 0.36363636  4.350904e-03 -4.766129e-03
       [688,] 0.27272727 0.81818182 0.36363636 -4.360508e-03  8.447103e-03
       [689,] 0.36363636 0.81818182 0.36363636  8.184809e-03 -2.523237e-03
       [690,] 0.45454545 0.81818182 0.36363636 -2.312188e-03 -9.246065e-03
       [691,] 0.54545455 0.81818182 0.36363636  8.782262e-03  5.349324e-03
       [692,] 0.63636364 0.81818182 0.36363636  6.843370e-03 -9.534001e-03
       [693,] 0.72727273 0.81818182 0.36363636  8.441619e-03  4.278475e-03
       [694,] 0.81818182 0.81818182 0.36363636 -8.044291e-03 -1.355240e-03
       [695,] 0.90909091 0.81818182 0.36363636  8.593162e-03 -5.157447e-03
       [696,] 1.00000000 0.81818182 0.36363636 -9.048052e-03 -9.254783e-03
       [697,] 0.00000000 0.90909091 0.36363636 -5.022304e-03 -9.976556e-04
       [698,] 0.09090909 0.90909091 0.36363636 -5.813386e-03 -3.867720e-03
       [699,] 0.18181818 0.90909091 0.36363636  4.978115e-04  5.354925e-03
       [700,] 0.27272727 0.90909091 0.36363636  3.781265e-03  3.950382e-03
       [701,] 0.36363636 0.90909091 0.36363636  5.854440e-03 -9.596563e-03
       [702,] 0.45454545 0.90909091 0.36363636  8.185530e-03  1.422507e-03
       [703,] 0.54545455 0.90909091 0.36363636  6.097144e-03 -1.604391e-03
       [704,] 0.63636364 0.90909091 0.36363636  6.614133e-03 -8.479682e-04
       [705,] 0.72727273 0.90909091 0.36363636  7.498770e-03 -4.788067e-03
       [706,] 0.81818182 0.90909091 0.36363636 -6.822533e-03 -6.290837e-04
       [707,] 0.90909091 0.90909091 0.36363636 -6.410245e-03  4.326821e-03
       [708,] 1.00000000 0.90909091 0.36363636  7.715640e-03  4.253126e-04
       [709,] 0.00000000 1.00000000 0.36363636 -5.352304e-03 -4.391115e-03
       [710,] 0.09090909 1.00000000 0.36363636  4.011615e-03 -6.568977e-04
       [711,] 0.18181818 1.00000000 0.36363636 -7.927158e-03 -9.574728e-03
       [712,] 0.27272727 1.00000000 0.36363636 -8.928919e-03 -9.459107e-03
       [713,] 0.36363636 1.00000000 0.36363636  6.519079e-03  2.279405e-03
       [714,] 0.45454545 1.00000000 0.36363636  8.631516e-03  3.043408e-03
       [715,] 0.54545455 1.00000000 0.36363636 -8.646982e-03 -4.381596e-03
       [716,] 0.63636364 1.00000000 0.36363636 -2.897096e-03  2.940512e-03
       [717,] 0.72727273 1.00000000 0.36363636  4.434600e-03  4.210979e-03
       [718,] 0.81818182 1.00000000 0.36363636 -2.054127e-03 -9.897135e-03
       [719,] 0.90909091 1.00000000 0.36363636  8.993642e-03  9.286391e-03
       [720,] 1.00000000 1.00000000 0.36363636  5.311832e-03 -5.813343e-03
       [721,] 0.00000000 0.00000000 0.45454545 -1.610883e-03  8.436584e-03
       [722,] 0.09090909 0.00000000 0.45454545 -8.784747e-03 -9.983148e-03
       [723,] 0.18181818 0.00000000 0.45454545 -4.719050e-03  8.400379e-03
       [724,] 0.27272727 0.00000000 0.45454545 -2.184780e-03  2.667324e-03
       [725,] 0.36363636 0.00000000 0.45454545  9.260203e-03  5.309733e-03
       [726,] 0.45454545 0.00000000 0.45454545  5.324397e-03  5.567981e-03
       [727,] 0.54545455 0.00000000 0.45454545 -8.527036e-04  9.561259e-03
       [728,] 0.63636364 0.00000000 0.45454545 -5.223168e-03 -9.941654e-03
       [729,] 0.72727273 0.00000000 0.45454545  8.710902e-03 -6.012815e-04
       [730,] 0.81818182 0.00000000 0.45454545 -2.249607e-03 -1.635385e-03
       [731,] 0.90909091 0.00000000 0.45454545 -5.734180e-03 -9.912533e-03
       [732,] 1.00000000 0.00000000 0.45454545  2.970875e-03  3.254958e-03
       [733,] 0.00000000 0.09090909 0.45454545  8.248991e-03  3.391075e-04
       [734,] 0.09090909 0.09090909 0.45454545 -7.699294e-03  8.589699e-03
       [735,] 0.18181818 0.09090909 0.45454545 -8.070712e-03  2.687289e-03
       [736,] 0.27272727 0.09090909 0.45454545  8.876201e-03  5.669401e-03
       [737,] 0.36363636 0.09090909 0.45454545  3.828059e-03 -4.686959e-03
       [738,] 0.45454545 0.09090909 0.45454545 -1.765430e-03  6.335818e-03
       [739,] 0.54545455 0.09090909 0.45454545  1.381279e-03 -2.467212e-03
       [740,] 0.63636364 0.09090909 0.45454545 -5.000991e-03  3.191628e-03
       [741,] 0.72727273 0.09090909 0.45454545  6.972830e-03  5.916420e-04
       [742,] 0.81818182 0.09090909 0.45454545  6.414732e-03 -6.317422e-03
       [743,] 0.90909091 0.09090909 0.45454545  2.952841e-03 -3.450306e-03
       [744,] 1.00000000 0.09090909 0.45454545 -2.974263e-04 -7.192861e-04
       [745,] 0.00000000 0.18181818 0.45454545 -6.229766e-03 -8.546643e-03
       [746,] 0.09090909 0.18181818 0.45454545  7.861248e-03  8.916323e-03
       [747,] 0.18181818 0.18181818 0.45454545 -2.584182e-03  6.550485e-03
       [748,] 0.27272727 0.18181818 0.45454545 -6.876220e-03 -2.901575e-03
       [749,] 0.36363636 0.18181818 0.45454545  7.346659e-03  4.702235e-04
       [750,] 0.45454545 0.18181818 0.45454545 -1.557158e-03  3.955235e-03
       [751,] 0.54545455 0.18181818 0.45454545  7.551974e-03 -6.627742e-03
       [752,] 0.63636364 0.18181818 0.45454545 -5.635559e-03  4.695843e-03
       [753,] 0.72727273 0.18181818 0.45454545  2.129707e-03  1.719923e-03
       [754,] 0.81818182 0.18181818 0.45454545  8.844936e-03  8.722160e-03
       [755,] 0.90909091 0.18181818 0.45454545  8.818969e-04 -7.163470e-03
       [756,] 1.00000000 0.18181818 0.45454545  5.531683e-03  5.187264e-03
       [757,] 0.00000000 0.27272727 0.45454545  1.328320e-03 -3.839794e-03
       [758,] 0.09090909 0.27272727 0.45454545 -5.024899e-03  7.998059e-03
       [759,] 0.18181818 0.27272727 0.45454545 -9.911261e-03 -3.636320e-04
       [760,] 0.27272727 0.27272727 0.45454545 -6.293679e-04 -6.044487e-03
       [761,] 0.36363636 0.27272727 0.45454545  1.966258e-03 -7.030072e-03
       [762,] 0.45454545 0.27272727 0.45454545 -5.428778e-03 -9.487418e-03
       [763,] 0.54545455 0.27272727 0.45454545 -8.004948e-03  9.095470e-03
       [764,] 0.63636364 0.27272727 0.45454545  6.835594e-03  8.572302e-03
       [765,] 0.72727273 0.27272727 0.45454545  1.138257e-03  6.243892e-03
       [766,] 0.81818182 0.27272727 0.45454545  4.319614e-03  9.138350e-04
       [767,] 0.90909091 0.27272727 0.45454545 -1.614245e-03 -1.128375e-03
       [768,] 1.00000000 0.27272727 0.45454545  8.782634e-04 -8.500654e-03
       [769,] 0.00000000 0.36363636 0.45454545 -9.543025e-04 -6.714469e-04
       [770,] 0.09090909 0.36363636 0.45454545  3.174142e-03  1.109875e-04
       [771,] 0.18181818 0.36363636 0.45454545  7.271945e-03  5.111866e-03
       [772,] 0.27272727 0.36363636 0.45454545 -2.266740e-03 -4.331972e-03
       [773,] 0.36363636 0.36363636 0.45454545  4.577580e-03 -5.201604e-03
       [774,] 0.45454545 0.36363636 0.45454545 -1.332218e-03  8.533890e-03
       [775,] 0.54545455 0.36363636 0.45454545 -7.189330e-03 -2.624838e-03
       [776,] 0.63636364 0.36363636 0.45454545 -6.919522e-03  6.915948e-03
       [777,] 0.72727273 0.36363636 0.45454545 -1.159072e-03 -7.626150e-03
       [778,] 0.81818182 0.36363636 0.45454545  3.313073e-03 -9.166615e-03
       [779,] 0.90909091 0.36363636 0.45454545  2.030413e-03 -6.306987e-03
       [780,] 1.00000000 0.36363636 0.45454545 -9.740572e-03  3.312908e-03
       [781,] 0.00000000 0.45454545 0.45454545 -2.305015e-03 -8.148104e-03
       [782,] 0.09090909 0.45454545 0.45454545 -8.888612e-03  1.045918e-03
       [783,] 0.18181818 0.45454545 0.45454545 -1.654222e-03 -8.579895e-03
       [784,] 0.27272727 0.45454545 0.45454545  7.208670e-03  9.387292e-03
       [785,] 0.36363636 0.45454545 0.45454545  8.384901e-03 -8.158409e-03
       [786,] 0.45454545 0.45454545 0.45454545  6.927158e-03 -9.187550e-03
       [787,] 0.54545455 0.45454545 0.45454545  1.125888e-03  6.414583e-03
       [788,] 0.63636364 0.45454545 0.45454545  7.473087e-04  8.618297e-03
       [789,] 0.72727273 0.45454545 0.45454545  2.935396e-03 -8.417354e-03
       [790,] 0.81818182 0.45454545 0.45454545  4.377720e-04 -6.168080e-03
       [791,] 0.90909091 0.45454545 0.45454545  4.500235e-04  7.609835e-04
       [792,] 1.00000000 0.45454545 0.45454545 -1.673121e-03  2.164290e-03
       [793,] 0.00000000 0.54545455 0.45454545 -4.696026e-03  1.649767e-03
       [794,] 0.09090909 0.54545455 0.45454545 -3.010851e-03  4.789921e-03
       [795,] 0.18181818 0.54545455 0.45454545 -3.697113e-03  9.624084e-03
       [796,] 0.27272727 0.54545455 0.45454545  7.912113e-03 -9.311390e-03
       [797,] 0.36363636 0.54545455 0.45454545 -6.952831e-03 -9.492133e-03
       [798,] 0.45454545 0.54545455 0.45454545  8.033111e-03  3.381761e-03
       [799,] 0.54545455 0.54545455 0.45454545 -6.784981e-03  7.085102e-03
       [800,] 0.63636364 0.54545455 0.45454545  1.878618e-03  4.980205e-03
       [801,] 0.72727273 0.54545455 0.45454545  2.787606e-03  9.373710e-03
       [802,] 0.81818182 0.54545455 0.45454545  4.451094e-03 -9.137016e-03
       [803,] 0.90909091 0.54545455 0.45454545  5.476424e-03  3.388504e-04
       [804,] 1.00000000 0.54545455 0.45454545 -6.146959e-03  4.843034e-03
       [805,] 0.00000000 0.63636364 0.45454545  4.991987e-03 -2.897065e-03
       [806,] 0.09090909 0.63636364 0.45454545  8.048586e-03 -6.542604e-03
       [807,] 0.18181818 0.63636364 0.45454545 -9.243947e-03  1.246858e-03
       [808,] 0.27272727 0.63636364 0.45454545  7.864473e-03  9.609636e-03
       [809,] 0.36363636 0.63636364 0.45454545 -4.798042e-03  1.711841e-05
       [810,] 0.45454545 0.63636364 0.45454545  9.752597e-03  4.102459e-04
       [811,] 0.54545455 0.63636364 0.45454545  1.114155e-03  8.967495e-03
       [812,] 0.63636364 0.63636364 0.45454545 -7.438722e-03 -2.174076e-03
       [813,] 0.72727273 0.63636364 0.45454545 -8.728125e-03  6.768080e-04
       [814,] 0.81818182 0.63636364 0.45454545 -7.815505e-03  9.451756e-03
       [815,] 0.90909091 0.63636364 0.45454545 -4.549356e-03  8.813882e-03
       [816,] 1.00000000 0.63636364 0.45454545  5.528222e-03 -2.590723e-03
       [817,] 0.00000000 0.72727273 0.45454545 -8.937630e-03 -4.334243e-03
       [818,] 0.09090909 0.72727273 0.45454545 -3.269954e-04  9.839362e-03
       [819,] 0.18181818 0.72727273 0.45454545  4.802787e-03  6.369089e-03
       [820,] 0.27272727 0.72727273 0.45454545 -3.625321e-03  3.897493e-03
       [821,] 0.36363636 0.72727273 0.45454545  9.844647e-03 -5.059644e-03
       [822,] 0.45454545 0.72727273 0.45454545  6.598407e-03 -1.834186e-03
       [823,] 0.54545455 0.72727273 0.45454545 -1.294873e-03  3.055304e-03
       [824,] 0.63636364 0.72727273 0.45454545 -8.447220e-03 -4.474276e-03
       [825,] 0.72727273 0.72727273 0.45454545  6.896963e-03 -1.805133e-03
       [826,] 0.81818182 0.72727273 0.45454545 -6.105331e-03 -7.683553e-03
       [827,] 0.90909091 0.72727273 0.45454545 -4.623349e-03 -3.972504e-03
       [828,] 1.00000000 0.72727273 0.45454545  3.885720e-03  4.048762e-04
       [829,] 0.00000000 0.81818182 0.45454545  3.437781e-05  7.277917e-04
       [830,] 0.09090909 0.81818182 0.45454545 -6.809614e-03 -8.320538e-03
       [831,] 0.18181818 0.81818182 0.45454545  4.743897e-03  4.421833e-03
       [832,] 0.27272727 0.81818182 0.45454545 -8.685195e-05 -1.959658e-03
       [833,] 0.36363636 0.81818182 0.45454545  9.647035e-03 -5.626424e-03
       [834,] 0.45454545 0.81818182 0.45454545  3.929841e-03 -2.323463e-03
       [835,] 0.54545455 0.81818182 0.45454545 -3.896715e-03  1.436301e-03
       [836,] 0.63636364 0.81818182 0.45454545  3.184997e-03 -6.548300e-03
       [837,] 0.72727273 0.81818182 0.45454545 -4.913338e-03 -4.391517e-03
       [838,] 0.81818182 0.81818182 0.45454545  9.575573e-03 -2.035157e-03
       [839,] 0.90909091 0.81818182 0.45454545 -4.386039e-04  8.369247e-03
       [840,] 1.00000000 0.81818182 0.45454545 -8.335769e-03 -6.481288e-03
       [841,] 0.00000000 0.90909091 0.45454545  4.632210e-03  9.587397e-03
       [842,] 0.09090909 0.90909091 0.45454545  5.246019e-03 -9.393408e-03
       [843,] 0.18181818 0.90909091 0.45454545 -7.406355e-03 -4.804629e-03
       [844,] 0.27272727 0.90909091 0.45454545 -6.926338e-03  4.003287e-03
       [845,] 0.36363636 0.90909091 0.45454545  8.203907e-03 -5.540099e-03
       [846,] 0.45454545 0.90909091 0.45454545  3.321042e-03  7.861477e-04
       [847,] 0.54545455 0.90909091 0.45454545 -6.110416e-03 -5.529426e-03
       [848,] 0.63636364 0.90909091 0.45454545 -4.913510e-03  9.889960e-03
       [849,] 0.72727273 0.90909091 0.45454545 -6.909102e-03  1.647391e-03
       [850,] 0.81818182 0.90909091 0.45454545 -7.017190e-05 -6.046105e-03
       [851,] 0.90909091 0.90909091 0.45454545 -6.811405e-04 -3.911387e-03
       [852,] 1.00000000 0.90909091 0.45454545 -2.372507e-04  8.234591e-03
       [853,] 0.00000000 1.00000000 0.45454545 -2.192069e-03 -9.273160e-03
       [854,] 0.09090909 1.00000000 0.45454545  4.243876e-03 -6.424794e-03
       [855,] 0.18181818 1.00000000 0.45454545 -4.351080e-03 -8.781719e-04
       [856,] 0.27272727 1.00000000 0.45454545 -3.834150e-03  2.256336e-03
       [857,] 0.36363636 1.00000000 0.45454545  8.846689e-03 -2.549711e-03
       [858,] 0.45454545 1.00000000 0.45454545 -4.390183e-03  7.745962e-03
       [859,] 0.54545455 1.00000000 0.45454545 -9.906225e-03 -3.476610e-03
       [860,] 0.63636364 1.00000000 0.45454545  2.276813e-03 -5.083361e-04
       [861,] 0.72727273 1.00000000 0.45454545  3.101797e-03 -5.665579e-03
       [862,] 0.81818182 1.00000000 0.45454545 -8.020438e-03  7.867608e-03
       [863,] 0.90909091 1.00000000 0.45454545  3.269894e-03 -3.360496e-03
       [864,] 1.00000000 1.00000000 0.45454545 -8.507957e-03  1.689351e-04
       [865,] 0.00000000 0.00000000 0.54545455  9.617963e-03  8.222931e-03
       [866,] 0.09090909 0.00000000 0.54545455  6.162168e-03 -5.285769e-03
       [867,] 0.18181818 0.00000000 0.54545455 -1.438103e-03 -9.445951e-03
       [868,] 0.27272727 0.00000000 0.54545455  8.255804e-03 -2.287187e-03
       [869,] 0.36363636 0.00000000 0.54545455 -4.809198e-03  6.738827e-03
       [870,] 0.45454545 0.00000000 0.54545455 -3.867533e-03  8.897279e-03
       [871,] 0.54545455 0.00000000 0.54545455  8.479927e-03  1.059188e-03
       [872,] 0.63636364 0.00000000 0.54545455 -3.699545e-03 -1.717450e-03
       [873,] 0.72727273 0.00000000 0.54545455 -3.979691e-03 -1.203267e-03
       [874,] 0.81818182 0.00000000 0.54545455 -2.338595e-03  8.663317e-03
       [875,] 0.90909091 0.00000000 0.54545455  4.645510e-03 -9.239170e-03
       [876,] 1.00000000 0.00000000 0.54545455 -3.854042e-03 -9.323445e-03
       [877,] 0.00000000 0.09090909 0.54545455 -6.402538e-03 -2.361493e-03
       [878,] 0.09090909 0.09090909 0.54545455 -1.639111e-03  2.000270e-03
       [879,] 0.18181818 0.09090909 0.54545455 -6.270930e-03 -4.791662e-03
       [880,] 0.27272727 0.09090909 0.54545455  4.885500e-03 -1.585253e-03
       [881,] 0.36363636 0.09090909 0.54545455 -3.035768e-03  5.914681e-03
       [882,] 0.45454545 0.09090909 0.54545455 -7.028179e-03 -3.177816e-03
       [883,] 0.54545455 0.09090909 0.54545455  4.301648e-03 -2.432882e-03
       [884,] 0.63636364 0.09090909 0.54545455  5.456970e-04  2.813215e-03
       [885,] 0.72727273 0.09090909 0.54545455  7.742404e-03 -3.626906e-03
       [886,] 0.81818182 0.09090909 0.54545455  4.556764e-03  2.361944e-03
       [887,] 0.90909091 0.09090909 0.54545455  5.024815e-03  8.472416e-03
       [888,] 1.00000000 0.09090909 0.54545455 -9.298652e-03  9.595116e-03
       [889,] 0.00000000 0.18181818 0.54545455  3.990156e-03  9.600618e-03
       [890,] 0.09090909 0.18181818 0.54545455 -5.130297e-03  6.480298e-04
       [891,] 0.18181818 0.18181818 0.54545455 -8.117338e-03 -4.049884e-03
       [892,] 0.27272727 0.18181818 0.54545455  5.746332e-04 -3.134041e-04
       [893,] 0.36363636 0.18181818 0.54545455  8.885512e-03 -6.129644e-03
       [894,] 0.45454545 0.18181818 0.54545455 -9.822231e-03  6.163631e-03
       [895,] 0.54545455 0.18181818 0.54545455 -8.330926e-03  9.041784e-03
       [896,] 0.63636364 0.18181818 0.54545455 -6.839723e-03  8.873184e-03
       [897,] 0.72727273 0.18181818 0.54545455 -1.726179e-03 -2.960542e-03
       [898,] 0.81818182 0.18181818 0.54545455  2.154987e-03  4.790072e-03
       [899,] 0.90909091 0.18181818 0.54545455  3.003085e-03  3.149922e-04
       [900,] 1.00000000 0.18181818 0.54545455  6.499698e-03  6.101242e-03
       [901,] 0.00000000 0.27272727 0.54545455 -7.152015e-03  5.627270e-03
       [902,] 0.09090909 0.27272727 0.54545455 -3.701359e-03  1.275183e-03
       [903,] 0.18181818 0.27272727 0.54545455  5.421063e-03  2.565707e-03
       [904,] 0.27272727 0.27272727 0.54545455  4.471364e-03  6.473047e-04
       [905,] 0.36363636 0.27272727 0.54545455  7.201184e-03 -5.367212e-04
       [906,] 0.45454545 0.27272727 0.54545455 -2.140482e-03  6.360632e-03
       [907,] 0.54545455 0.27272727 0.54545455  3.637172e-03 -2.392264e-03
       [908,] 0.63636364 0.27272727 0.54545455  5.631340e-03 -6.699260e-04
       [909,] 0.72727273 0.27272727 0.54545455 -7.657615e-04 -1.891733e-03
       [910,] 0.81818182 0.27272727 0.54545455 -8.188556e-03  9.571226e-03
       [911,] 0.90909091 0.27272727 0.54545455  6.501867e-03  8.001512e-03
       [912,] 1.00000000 0.27272727 0.54545455 -4.106512e-03  4.684653e-03
       [913,] 0.00000000 0.36363636 0.54545455 -7.118616e-03  2.796084e-03
       [914,] 0.09090909 0.36363636 0.54545455  9.756129e-03  1.526065e-03
       [915,] 0.18181818 0.36363636 0.54545455  8.963838e-03  4.261533e-04
       [916,] 0.27272727 0.36363636 0.54545455 -8.795104e-03  2.849157e-03
       [917,] 0.36363636 0.36363636 0.54545455  7.220617e-03  7.406122e-03
       [918,] 0.45454545 0.36363636 0.54545455 -4.262828e-03 -8.736378e-03
       [919,] 0.54545455 0.36363636 0.54545455  7.273596e-04  6.817372e-03
       [920,] 0.63636364 0.36363636 0.54545455  6.804379e-03  3.564055e-04
       [921,] 0.72727273 0.36363636 0.54545455  6.098874e-03 -9.149714e-03
       [922,] 0.81818182 0.36363636 0.54545455 -1.704101e-03  7.516397e-03
       [923,] 0.90909091 0.36363636 0.54545455  7.345323e-03  6.448441e-03
       [924,] 1.00000000 0.36363636 0.54545455  5.284339e-03  6.659037e-03
       [925,] 0.00000000 0.45454545 0.54545455  1.828949e-03  5.229242e-03
       [926,] 0.09090909 0.45454545 0.54545455 -1.189915e-03 -2.094371e-03
       [927,] 0.18181818 0.45454545 0.54545455  5.632388e-03 -1.907811e-03
       [928,] 0.27272727 0.45454545 0.54545455 -3.453919e-04 -7.165895e-03
       [929,] 0.36363636 0.45454545 0.54545455  5.139669e-03 -9.575307e-03
       [930,] 0.45454545 0.45454545 0.54545455  9.934118e-03  7.847189e-03
       [931,] 0.54545455 0.45454545 0.54545455 -1.027050e-03  1.176284e-04
       [932,] 0.63636364 0.45454545 0.54545455  5.471567e-03  7.476088e-03
       [933,] 0.72727273 0.45454545 0.54545455  2.318309e-03  2.517170e-03
       [934,] 0.81818182 0.45454545 0.54545455 -5.281280e-03  2.310990e-03
       [935,] 0.90909091 0.45454545 0.54545455 -3.970587e-03  5.939332e-04
       [936,] 1.00000000 0.45454545 0.54545455  4.877196e-05 -6.900958e-03
       [937,] 0.00000000 0.54545455 0.54545455  1.061936e-03 -3.402636e-03
       [938,] 0.09090909 0.54545455 0.54545455  7.244590e-03 -3.212510e-04
       [939,] 0.18181818 0.54545455 0.54545455  3.877052e-03  3.030389e-03
       [940,] 0.27272727 0.54545455 0.54545455 -1.865031e-03  3.009104e-03
       [941,] 0.36363636 0.54545455 0.54545455  4.974391e-03  7.833940e-04
       [942,] 0.45454545 0.54545455 0.54545455 -9.461054e-03  6.202302e-03
       [943,] 0.54545455 0.54545455 0.54545455 -4.779549e-03 -2.784762e-03
       [944,] 0.63636364 0.54545455 0.54545455  5.295543e-03  1.961739e-03
       [945,] 0.72727273 0.54545455 0.54545455  3.781181e-03  2.753130e-04
       [946,] 0.81818182 0.54545455 0.54545455  6.995083e-03 -9.443240e-03
       [947,] 0.90909091 0.54545455 0.54545455 -9.143709e-03 -8.275236e-03
       [948,] 1.00000000 0.54545455 0.54545455 -2.161069e-03 -2.796145e-03
       [949,] 0.00000000 0.63636364 0.54545455  8.553565e-03 -4.864187e-04
       [950,] 0.09090909 0.63636364 0.54545455 -3.107808e-03  4.364712e-03
       [951,] 0.18181818 0.63636364 0.54545455  2.052549e-03  4.624696e-05
       [952,] 0.27272727 0.63636364 0.54545455  5.087794e-03  9.353806e-03
       [953,] 0.36363636 0.63636364 0.54545455  3.561989e-03  9.328461e-03
       [954,] 0.45454545 0.63636364 0.54545455  2.106730e-03  3.395885e-03
       [955,] 0.54545455 0.63636364 0.54545455  5.939605e-03 -2.495189e-03
       [956,] 0.63636364 0.63636364 0.54545455  2.636468e-03  2.540611e-03
       [957,] 0.72727273 0.63636364 0.54545455  4.422069e-03 -3.663167e-04
       [958,] 0.81818182 0.63636364 0.54545455  3.899120e-03  4.591425e-03
       [959,] 0.90909091 0.63636364 0.54545455 -6.862048e-03 -1.495187e-03
       [960,] 1.00000000 0.63636364 0.54545455  7.095820e-03  5.908697e-03
       [961,] 0.00000000 0.72727273 0.54545455  9.110619e-03 -9.512337e-03
       [962,] 0.09090909 0.72727273 0.54545455 -8.892672e-03  2.781901e-03
       [963,] 0.18181818 0.72727273 0.54545455  5.563822e-03 -1.156277e-03
       [964,] 0.27272727 0.72727273 0.54545455  2.004112e-03 -4.209382e-03
       [965,] 0.36363636 0.72727273 0.54545455 -4.158302e-03 -8.576341e-03
       [966,] 0.45454545 0.72727273 0.54545455 -3.880426e-03 -4.531182e-03
       [967,] 0.54545455 0.72727273 0.54545455  8.405715e-03 -7.709312e-03
       [968,] 0.63636364 0.72727273 0.54545455 -2.874731e-03 -7.077789e-03
       [969,] 0.72727273 0.72727273 0.54545455 -9.423332e-03 -2.024347e-03
       [970,] 0.81818182 0.72727273 0.54545455 -2.221175e-04 -6.614570e-03
       [971,] 0.90909091 0.72727273 0.54545455 -6.478035e-03  7.888932e-03
       [972,] 1.00000000 0.72727273 0.54545455 -2.678459e-03 -4.243257e-03
       [973,] 0.00000000 0.81818182 0.54545455 -9.290593e-03  4.973780e-03
       [974,] 0.09090909 0.81818182 0.54545455 -2.385461e-03 -1.492829e-05
       [975,] 0.18181818 0.81818182 0.54545455 -4.232371e-03 -7.829154e-03
       [976,] 0.27272727 0.81818182 0.54545455 -3.263288e-03 -4.178346e-03
       [977,] 0.36363636 0.81818182 0.54545455 -3.093206e-03  3.789656e-03
       [978,] 0.45454545 0.81818182 0.54545455  1.388316e-04  8.560327e-03
       [979,] 0.54545455 0.81818182 0.54545455 -5.319908e-03 -9.895061e-03
       [980,] 0.63636364 0.81818182 0.54545455  3.293430e-03 -3.782649e-04
       [981,] 0.72727273 0.81818182 0.54545455 -8.678982e-03 -3.845148e-03
       [982,] 0.81818182 0.81818182 0.54545455  4.291879e-03  5.756713e-03
       [983,] 0.90909091 0.81818182 0.54545455 -1.195546e-03 -5.124070e-03
       [984,] 1.00000000 0.81818182 0.54545455  6.637059e-03 -8.082117e-03
       [985,] 0.00000000 0.90909091 0.54545455  2.499874e-03 -5.156079e-03
       [986,] 0.09090909 0.90909091 0.54545455 -1.306013e-03  9.399988e-03
       [987,] 0.18181818 0.90909091 0.54545455  8.228348e-03 -7.584649e-03
       [988,] 0.27272727 0.90909091 0.54545455  4.956899e-03 -6.499084e-03
       [989,] 0.36363636 0.90909091 0.54545455 -8.705372e-03 -9.341468e-03
       [990,] 0.45454545 0.90909091 0.54545455  9.178463e-03  8.189442e-03
       [991,] 0.54545455 0.90909091 0.54545455 -9.234017e-04  5.630531e-03
       [992,] 0.63636364 0.90909091 0.54545455 -9.015292e-03 -5.270950e-03
       [993,] 0.72727273 0.90909091 0.54545455 -1.188030e-03 -8.980650e-03
       [994,] 0.81818182 0.90909091 0.54545455  1.637673e-03 -2.234812e-03
       [995,] 0.90909091 0.90909091 0.54545455  6.092026e-03 -5.627040e-03
       [996,] 1.00000000 0.90909091 0.54545455  4.165926e-04  9.138432e-03
       [997,] 0.00000000 1.00000000 0.54545455  6.095632e-03 -3.110423e-03
       [998,] 0.09090909 1.00000000 0.54545455 -8.515316e-03 -6.279430e-03
       [999,] 0.18181818 1.00000000 0.54545455  2.283199e-03  5.718223e-03
      [1000,] 0.27272727 1.00000000 0.54545455  4.674814e-03 -2.365114e-03
      [1001,] 0.36363636 1.00000000 0.54545455 -6.781931e-03  3.415807e-03
      [1002,] 0.45454545 1.00000000 0.54545455  8.287549e-03  7.818369e-03
      [1003,] 0.54545455 1.00000000 0.54545455  7.483058e-03  8.568646e-03
      [1004,] 0.63636364 1.00000000 0.54545455 -8.078887e-03 -3.394780e-04
      [1005,] 0.72727273 1.00000000 0.54545455 -5.690709e-03 -3.306951e-03
      [1006,] 0.81818182 1.00000000 0.54545455 -2.868031e-03 -9.990725e-03
      [1007,] 0.90909091 1.00000000 0.54545455 -3.017950e-03 -3.283722e-03
      [1008,] 1.00000000 1.00000000 0.54545455  5.893326e-03 -1.108485e-03
      [1009,] 0.00000000 0.00000000 0.63636364  5.374545e-03 -5.011787e-03
      [1010,] 0.09090909 0.00000000 0.63636364 -4.900201e-03 -6.951779e-03
      [1011,] 0.18181818 0.00000000 0.63636364 -6.472190e-03 -1.364047e-03
      [1012,] 0.27272727 0.00000000 0.63636364  5.668141e-03 -1.667293e-03
      [1013,] 0.36363636 0.00000000 0.63636364 -2.035218e-03  4.212663e-03
      [1014,] 0.45454545 0.00000000 0.63636364  9.902021e-04 -1.249453e-04
      [1015,] 0.54545455 0.00000000 0.63636364  1.865827e-03  7.395089e-03
      [1016,] 0.63636364 0.00000000 0.63636364 -1.847140e-03  5.098023e-03
      [1017,] 0.72727273 0.00000000 0.63636364 -2.848897e-03  5.384125e-04
      [1018,] 0.81818182 0.00000000 0.63636364 -5.531873e-03  9.613007e-03
      [1019,] 0.90909091 0.00000000 0.63636364  4.715045e-03  4.039981e-03
      [1020,] 1.00000000 0.00000000 0.63636364  1.849421e-04  6.127422e-04
      [1021,] 0.00000000 0.09090909 0.63636364 -4.453066e-03 -8.787279e-03
      [1022,] 0.09090909 0.09090909 0.63636364 -2.175273e-03 -2.402766e-03
      [1023,] 0.18181818 0.09090909 0.63636364  9.811651e-04  8.488603e-03
      [1024,] 0.27272727 0.09090909 0.63636364  4.910103e-03  6.437748e-03
      [1025,] 0.36363636 0.09090909 0.63636364  3.290559e-04 -1.698477e-03
      [1026,] 0.45454545 0.09090909 0.63636364  4.676059e-03  5.208674e-03
      [1027,] 0.54545455 0.09090909 0.63636364  9.207879e-03 -3.824901e-03
      [1028,] 0.63636364 0.09090909 0.63636364 -6.657348e-03  1.364783e-03
      [1029,] 0.72727273 0.09090909 0.63636364 -8.129148e-03 -1.437847e-04
      [1030,] 0.81818182 0.09090909 0.63636364  2.596368e-03  4.175144e-03
      [1031,] 0.90909091 0.09090909 0.63636364  2.762491e-04  8.531544e-03
      [1032,] 1.00000000 0.09090909 0.63636364  1.982836e-03  5.580173e-03
      [1033,] 0.00000000 0.18181818 0.63636364  5.061052e-04 -6.149493e-03
      [1034,] 0.09090909 0.18181818 0.63636364  5.459230e-03 -8.570493e-03
      [1035,] 0.18181818 0.18181818 0.63636364 -9.954721e-03  1.153414e-04
      [1036,] 0.27272727 0.18181818 0.63636364  7.476966e-03  4.600610e-03
      [1037,] 0.36363636 0.18181818 0.63636364  3.563791e-03 -4.058727e-03
      [1038,] 0.45454545 0.18181818 0.63636364 -5.819334e-03  9.490769e-03
      [1039,] 0.54545455 0.18181818 0.63636364 -7.531427e-03  3.410821e-03
      [1040,] 0.63636364 0.18181818 0.63636364  2.444505e-03 -3.780586e-03
      [1041,] 0.72727273 0.18181818 0.63636364  4.150418e-03  2.473715e-03
      [1042,] 0.81818182 0.18181818 0.63636364 -9.797493e-03  6.680966e-03
      [1043,] 0.90909091 0.18181818 0.63636364  6.385459e-03 -2.296856e-03
      [1044,] 1.00000000 0.18181818 0.63636364 -4.694689e-03  3.922853e-03
      [1045,] 0.00000000 0.27272727 0.63636364 -7.855978e-03  3.126949e-03
      [1046,] 0.09090909 0.27272727 0.63636364 -8.243424e-03  5.086126e-03
      [1047,] 0.18181818 0.27272727 0.63636364  7.856995e-03 -3.995440e-03
      [1048,] 0.27272727 0.27272727 0.63636364 -7.405071e-03 -5.498928e-03
      [1049,] 0.36363636 0.27272727 0.63636364 -2.907912e-03 -5.380408e-03
      [1050,] 0.45454545 0.27272727 0.63636364 -3.023339e-03 -7.408196e-03
      [1051,] 0.54545455 0.27272727 0.63636364  4.170171e-03 -5.869175e-03
      [1052,] 0.63636364 0.27272727 0.63636364 -5.262552e-03  5.081465e-03
      [1053,] 0.72727273 0.27272727 0.63636364 -7.848877e-03 -1.055914e-03
      [1054,] 0.81818182 0.27272727 0.63636364 -7.925215e-03 -7.615166e-03
      [1055,] 0.90909091 0.27272727 0.63636364 -7.203589e-03  9.927031e-03
      [1056,] 1.00000000 0.27272727 0.63636364  4.264818e-03 -9.613261e-03
      [1057,] 0.00000000 0.36363636 0.63636364  9.599149e-03 -3.532405e-03
      [1058,] 0.09090909 0.36363636 0.63636364  7.910131e-03 -9.809964e-05
      [1059,] 0.18181818 0.36363636 0.63636364  6.707357e-03  6.618567e-03
      [1060,] 0.27272727 0.36363636 0.63636364 -7.498116e-04 -5.837198e-03
      [1061,] 0.36363636 0.36363636 0.63636364 -5.123847e-03 -5.127473e-03
      [1062,] 0.45454545 0.36363636 0.63636364  8.656108e-03  2.361473e-03
      [1063,] 0.54545455 0.36363636 0.63636364  5.314485e-03  3.161187e-03
      [1064,] 0.63636364 0.36363636 0.63636364  4.965873e-04 -8.245978e-03
      [1065,] 0.72727273 0.36363636 0.63636364 -4.134976e-03 -8.605165e-04
      [1066,] 0.81818182 0.36363636 0.63636364  5.819660e-03 -5.749755e-03
      [1067,] 0.90909091 0.36363636 0.63636364 -1.052388e-03 -6.432473e-03
      [1068,] 1.00000000 0.36363636 0.63636364 -2.450621e-04  2.469420e-03
      [1069,] 0.00000000 0.45454545 0.63636364  5.147957e-03 -1.214334e-03
      [1070,] 0.09090909 0.45454545 0.63636364  9.840423e-03  7.931427e-03
      [1071,] 0.18181818 0.45454545 0.63636364 -7.656225e-04 -6.450841e-03
      [1072,] 0.27272727 0.45454545 0.63636364  9.680266e-03 -4.550560e-03
      [1073,] 0.36363636 0.45454545 0.63636364 -3.244842e-03  8.759606e-03
      [1074,] 0.45454545 0.45454545 0.63636364 -9.410919e-03  7.300138e-04
      [1075,] 0.54545455 0.45454545 0.63636364  1.116688e-03  4.509578e-05
      [1076,] 0.63636364 0.45454545 0.63636364  3.712378e-03 -4.183225e-03
      [1077,] 0.72727273 0.45454545 0.63636364  7.863819e-03  8.871560e-03
      [1078,] 0.81818182 0.45454545 0.63636364  4.261928e-03 -7.294018e-03
      [1079,] 0.90909091 0.45454545 0.63636364 -4.685481e-03  6.136302e-03
      [1080,] 1.00000000 0.45454545 0.63636364 -5.867284e-03 -7.452332e-03
      [1081,] 0.00000000 0.54545455 0.63636364  5.342292e-03  4.444123e-03
      [1082,] 0.09090909 0.54545455 0.63636364  5.748868e-04  2.361094e-03
      [1083,] 0.18181818 0.54545455 0.63636364  8.671432e-03  8.878402e-03
      [1084,] 0.27272727 0.54545455 0.63636364 -7.121565e-03  7.553007e-03
      [1085,] 0.36363636 0.54545455 0.63636364  9.518970e-03  6.453760e-03
      [1086,] 0.45454545 0.54545455 0.63636364  4.829693e-03  4.590693e-03
      [1087,] 0.54545455 0.54545455 0.63636364  7.505171e-03 -1.331039e-03
      [1088,] 0.63636364 0.54545455 0.63636364  9.361616e-03 -7.535163e-03
      [1089,] 0.72727273 0.54545455 0.63636364 -7.557629e-03 -8.276817e-03
      [1090,] 0.81818182 0.54545455 0.63636364 -9.807455e-03  7.499722e-05
      [1091,] 0.90909091 0.54545455 0.63636364 -3.393233e-04 -5.109180e-03
      [1092,] 1.00000000 0.54545455 0.63636364 -3.515476e-03 -9.174414e-03
      [1093,] 0.00000000 0.63636364 0.63636364  2.117157e-03 -7.731214e-03
      [1094,] 0.09090909 0.63636364 0.63636364 -7.559761e-03  7.776732e-03
      [1095,] 0.18181818 0.63636364 0.63636364 -1.834826e-03 -5.170858e-03
      [1096,] 0.27272727 0.63636364 0.63636364  9.057311e-03 -7.972686e-03
      [1097,] 0.36363636 0.63636364 0.63636364  5.255012e-03  2.669839e-03
      [1098,] 0.45454545 0.63636364 0.63636364 -4.960460e-03 -2.643562e-03
      [1099,] 0.54545455 0.63636364 0.63636364 -3.727356e-03  7.687984e-03
      [1100,] 0.63636364 0.63636364 0.63636364 -8.856493e-03 -1.640817e-03
      [1101,] 0.72727273 0.63636364 0.63636364 -6.618167e-03  9.302474e-03
      [1102,] 0.81818182 0.63636364 0.63636364 -1.241114e-04  7.071397e-03
      [1103,] 0.90909091 0.63636364 0.63636364 -2.549877e-03  5.455738e-03
      [1104,] 1.00000000 0.63636364 0.63636364 -5.113155e-03  1.414019e-03
      [1105,] 0.00000000 0.72727273 0.63636364  5.408926e-04 -2.793969e-03
      [1106,] 0.09090909 0.72727273 0.63636364  3.431356e-03 -8.034436e-03
      [1107,] 0.18181818 0.72727273 0.63636364 -5.106738e-03  4.273959e-03
      [1108,] 0.27272727 0.72727273 0.63636364  2.684442e-03  2.268454e-03
      [1109,] 0.36363636 0.72727273 0.63636364  4.270484e-03  8.051433e-03
      [1110,] 0.45454545 0.72727273 0.63636364  8.871276e-03  2.462863e-03
      [1111,] 0.54545455 0.72727273 0.63636364  6.960300e-03  9.186391e-03
      [1112,] 0.63636364 0.72727273 0.63636364 -1.468553e-03  2.561553e-03
      [1113,] 0.72727273 0.72727273 0.63636364  1.502855e-03 -3.319126e-03
      [1114,] 0.81818182 0.72727273 0.63636364 -3.995790e-03  5.902059e-03
      [1115,] 0.90909091 0.72727273 0.63636364 -4.274365e-03  7.914975e-03
      [1116,] 1.00000000 0.72727273 0.63636364  1.741195e-03  8.522296e-03
      [1117,] 0.00000000 0.81818182 0.63636364 -3.463503e-03  7.186109e-03
      [1118,] 0.09090909 0.81818182 0.63636364  8.955959e-03 -1.615004e-03
      [1119,] 0.18181818 0.81818182 0.63636364 -8.380865e-03  6.081764e-03
      [1120,] 0.27272727 0.81818182 0.63636364 -4.015975e-03 -2.220291e-04
      [1121,] 0.36363636 0.81818182 0.63636364  6.231887e-03 -6.849003e-03
      [1122,] 0.45454545 0.81818182 0.63636364  4.617252e-03  1.661621e-03
      [1123,] 0.54545455 0.81818182 0.63636364 -6.661480e-03 -2.791040e-03
      [1124,] 0.63636364 0.81818182 0.63636364 -8.831003e-03 -7.814811e-03
      [1125,] 0.72727273 0.81818182 0.63636364  7.669115e-03  8.183848e-05
      [1126,] 0.81818182 0.81818182 0.63636364 -4.618348e-03 -6.846407e-03
      [1127,] 0.90909091 0.81818182 0.63636364  1.667781e-03  9.640794e-03
      [1128,] 1.00000000 0.81818182 0.63636364 -7.624110e-03 -4.365424e-03
      [1129,] 0.00000000 0.90909091 0.63636364 -7.467307e-06  3.688073e-03
      [1130,] 0.09090909 0.90909091 0.63636364  9.448559e-03 -4.071181e-03
      [1131,] 0.18181818 0.90909091 0.63636364  3.788072e-03  1.839817e-04
      [1132,] 0.27272727 0.90909091 0.63636364 -1.586975e-03  8.698823e-03
      [1133,] 0.36363636 0.90909091 0.63636364 -4.942988e-03  2.390774e-03
      [1134,] 0.45454545 0.90909091 0.63636364  1.803178e-03 -3.168662e-03
      [1135,] 0.54545455 0.90909091 0.63636364  4.238139e-04  6.195273e-03
      [1136,] 0.63636364 0.90909091 0.63636364 -5.725031e-03 -3.642854e-03
      [1137,] 0.72727273 0.90909091 0.63636364  9.874436e-03 -3.728790e-04
      [1138,] 0.81818182 0.90909091 0.63636364 -2.379983e-04 -4.718222e-04
      [1139,] 0.90909091 0.90909091 0.63636364  2.104690e-03 -3.293911e-03
      [1140,] 1.00000000 0.90909091 0.63636364 -2.838945e-03 -4.148200e-03
      [1141,] 0.00000000 1.00000000 0.63636364  7.790841e-03 -3.686852e-03
      [1142,] 0.09090909 1.00000000 0.63636364 -3.215552e-03  3.536220e-03
      [1143,] 0.18181818 1.00000000 0.63636364 -7.039901e-03 -5.390231e-03
      [1144,] 0.27272727 1.00000000 0.63636364  8.612470e-03 -9.925732e-03
      [1145,] 0.36363636 1.00000000 0.63636364  5.355847e-03 -6.646488e-03
      [1146,] 0.45454545 1.00000000 0.63636364 -6.740230e-03 -9.801272e-04
      [1147,] 0.54545455 1.00000000 0.63636364  1.525651e-03  1.584967e-03
      [1148,] 0.63636364 1.00000000 0.63636364 -2.949451e-04 -2.242601e-03
      [1149,] 0.72727273 1.00000000 0.63636364 -4.238079e-03 -7.180600e-03
      [1150,] 0.81818182 1.00000000 0.63636364 -2.536762e-03  2.722597e-03
      [1151,] 0.90909091 1.00000000 0.63636364 -2.692013e-03  4.109609e-03
      [1152,] 1.00000000 1.00000000 0.63636364  3.097492e-03 -3.149262e-03
      [1153,] 0.00000000 0.00000000 0.72727273  4.615636e-03  5.490320e-03
      [1154,] 0.09090909 0.00000000 0.72727273 -8.435945e-03 -1.329330e-03
      [1155,] 0.18181818 0.00000000 0.72727273 -9.658966e-03 -7.514673e-03
      [1156,] 0.27272727 0.00000000 0.72727273 -4.144166e-03  2.748109e-03
      [1157,] 0.36363636 0.00000000 0.72727273 -7.400118e-03 -2.627739e-03
      [1158,] 0.45454545 0.00000000 0.72727273  5.365917e-03 -8.080319e-03
      [1159,] 0.54545455 0.00000000 0.72727273 -1.002052e-03  5.628780e-03
      [1160,] 0.63636364 0.00000000 0.72727273 -4.277629e-03  4.927741e-03
      [1161,] 0.72727273 0.00000000 0.72727273 -6.768426e-03 -7.094241e-03
      [1162,] 0.81818182 0.00000000 0.72727273  4.763285e-03 -6.682884e-03
      [1163,] 0.90909091 0.00000000 0.72727273  7.483446e-03  4.858052e-03
      [1164,] 1.00000000 0.00000000 0.72727273  4.971694e-03  3.986745e-03
      [1165,] 0.00000000 0.09090909 0.72727273  2.919472e-04  2.677651e-03
      [1166,] 0.09090909 0.09090909 0.72727273  9.370885e-04  9.028117e-03
      [1167,] 0.18181818 0.09090909 0.72727273  8.042054e-03 -6.700903e-03
      [1168,] 0.27272727 0.09090909 0.72727273 -8.624782e-03 -2.500593e-03
      [1169,] 0.36363636 0.09090909 0.72727273 -2.990224e-03 -3.548097e-03
      [1170,] 0.45454545 0.09090909 0.72727273  2.245910e-03 -8.641868e-03
      [1171,] 0.54545455 0.09090909 0.72727273 -9.442817e-03  4.858555e-03
      [1172,] 0.63636364 0.09090909 0.72727273  9.408891e-03  7.002411e-03
      [1173,] 0.72727273 0.09090909 0.72727273 -1.368544e-03  8.090621e-03
      [1174,] 0.81818182 0.09090909 0.72727273 -2.573295e-03 -6.258397e-03
      [1175,] 0.90909091 0.09090909 0.72727273  6.719574e-03 -3.871597e-03
      [1176,] 1.00000000 0.09090909 0.72727273  8.968097e-03  2.075294e-04
      [1177,] 0.00000000 0.18181818 0.72727273  8.482178e-03  8.613554e-03
      [1178,] 0.09090909 0.18181818 0.72727273  6.742824e-03  6.921342e-03
      [1179,] 0.18181818 0.18181818 0.72727273  3.318038e-03  8.355630e-03
      [1180,] 0.27272727 0.18181818 0.72727273  4.000088e-03 -1.773899e-03
      [1181,] 0.36363636 0.18181818 0.72727273 -3.380679e-03 -6.942943e-03
      [1182,] 0.45454545 0.18181818 0.72727273  1.992372e-03 -6.158170e-03
      [1183,] 0.54545455 0.18181818 0.72727273  5.776684e-03  5.173599e-03
      [1184,] 0.63636364 0.18181818 0.72727273  5.860409e-03  2.946349e-03
      [1185,] 0.72727273 0.18181818 0.72727273  8.677449e-03 -2.476255e-03
      [1186,] 0.81818182 0.18181818 0.72727273 -2.050726e-04 -4.234281e-03
      [1187,] 0.90909091 0.18181818 0.72727273 -1.389486e-03 -2.320283e-03
      [1188,] 1.00000000 0.18181818 0.72727273  6.214614e-03 -7.530977e-03
      [1189,] 0.00000000 0.27272727 0.72727273  5.966119e-03  1.289457e-03
      [1190,] 0.09090909 0.27272727 0.72727273  7.174928e-04  6.268465e-03
      [1191,] 0.18181818 0.27272727 0.72727273 -7.325672e-03 -7.135109e-04
      [1192,] 0.27272727 0.27272727 0.72727273  5.114260e-03 -8.611530e-03
      [1193,] 0.36363636 0.27272727 0.72727273  9.641201e-03 -6.575903e-03
      [1194,] 0.45454545 0.27272727 0.72727273  9.941167e-03  5.789057e-03
      [1195,] 0.54545455 0.27272727 0.72727273 -2.424278e-03 -7.998376e-03
      [1196,] 0.63636364 0.27272727 0.72727273 -6.588650e-03 -7.646393e-03
      [1197,] 0.72727273 0.27272727 0.72727273 -2.516530e-03 -6.189202e-03
      [1198,] 0.81818182 0.27272727 0.72727273  3.139829e-05  8.380996e-03
      [1199,] 0.90909091 0.27272727 0.72727273  3.082767e-03 -8.470734e-03
      [1200,] 1.00000000 0.27272727 0.72727273 -6.712303e-03  7.417993e-03
      [1201,] 0.00000000 0.36363636 0.72727273  1.373662e-03 -5.400368e-04
      [1202,] 0.09090909 0.36363636 0.72727273 -5.228171e-03 -4.309036e-03
      [1203,] 0.18181818 0.36363636 0.72727273 -4.642238e-03  7.042681e-03
      [1204,] 0.27272727 0.36363636 0.72727273  8.303129e-03 -8.226037e-03
      [1205,] 0.36363636 0.36363636 0.72727273 -1.372496e-03  5.370593e-03
      [1206,] 0.45454545 0.36363636 0.72727273 -7.645477e-03 -5.931408e-03
      [1207,] 0.54545455 0.36363636 0.72727273 -5.363035e-03  3.651970e-03
      [1208,] 0.63636364 0.36363636 0.72727273  7.033514e-03 -1.477976e-03
      [1209,] 0.72727273 0.36363636 0.72727273 -8.350512e-04 -5.515949e-03
      [1210,] 0.81818182 0.36363636 0.72727273  9.245942e-03 -9.207475e-04
      [1211,] 0.90909091 0.36363636 0.72727273 -6.386577e-03  1.777043e-04
      [1212,] 1.00000000 0.36363636 0.72727273  3.352984e-03 -7.556469e-03
      [1213,] 0.00000000 0.45454545 0.72727273 -7.053812e-03 -6.178277e-03
      [1214,] 0.09090909 0.45454545 0.72727273 -6.175208e-03  7.118901e-04
      [1215,] 0.18181818 0.45454545 0.72727273 -2.140159e-03 -9.307591e-03
      [1216,] 0.27272727 0.45454545 0.72727273 -6.459496e-03  4.385637e-03
      [1217,] 0.36363636 0.45454545 0.72727273 -9.084246e-03  4.542896e-03
      [1218,] 0.45454545 0.45454545 0.72727273 -3.311787e-03  3.924872e-03
      [1219,] 0.54545455 0.45454545 0.72727273 -3.495426e-04 -6.349949e-03
      [1220,] 0.63636364 0.45454545 0.72727273  6.588879e-03 -9.011818e-03
      [1221,] 0.72727273 0.45454545 0.72727273 -9.126518e-03  3.061704e-03
      [1222,] 0.81818182 0.45454545 0.72727273 -7.070281e-04  9.044222e-03
      [1223,] 0.90909091 0.45454545 0.72727273 -3.157866e-03  4.727272e-03
      [1224,] 1.00000000 0.45454545 0.72727273 -8.565903e-03 -1.366173e-04
      [1225,] 0.00000000 0.54545455 0.72727273  9.754369e-03  7.922813e-03
      [1226,] 0.09090909 0.54545455 0.72727273  2.401945e-03  3.544948e-03
      [1227,] 0.18181818 0.54545455 0.72727273 -5.827555e-03 -8.926049e-03
      [1228,] 0.27272727 0.54545455 0.72727273  2.448532e-03 -2.518943e-03
      [1229,] 0.36363636 0.54545455 0.72727273 -3.493280e-03 -1.113410e-04
      [1230,] 0.45454545 0.54545455 0.72727273  2.991725e-03  1.755732e-03
      [1231,] 0.54545455 0.54545455 0.72727273 -6.365806e-03 -3.319160e-04
      [1232,] 0.63636364 0.54545455 0.72727273 -2.170962e-05 -2.383723e-03
      [1233,] 0.72727273 0.54545455 0.72727273 -6.600702e-03 -6.404207e-03
      [1234,] 0.81818182 0.54545455 0.72727273  7.106479e-03  5.257764e-04
      [1235,] 0.90909091 0.54545455 0.72727273 -4.711215e-04  4.887111e-03
      [1236,] 1.00000000 0.54545455 0.72727273  4.962766e-03  5.149218e-03
      [1237,] 0.00000000 0.63636364 0.72727273 -8.889458e-03 -8.578625e-03
      [1238,] 0.09090909 0.63636364 0.72727273 -6.769537e-03  1.551937e-03
      [1239,] 0.18181818 0.63636364 0.72727273 -7.970074e-03  7.812598e-03
      [1240,] 0.27272727 0.63636364 0.72727273 -4.434012e-03 -5.217228e-03
      [1241,] 0.36363636 0.63636364 0.72727273 -4.801545e-03  8.540591e-03
      [1242,] 0.45454545 0.63636364 0.72727273 -7.213759e-04 -2.775511e-03
      [1243,] 0.54545455 0.63636364 0.72727273  6.160456e-03 -3.949363e-03
      [1244,] 0.63636364 0.63636364 0.72727273  5.073485e-03 -2.937623e-03
      [1245,] 0.72727273 0.63636364 0.72727273  2.694222e-03  7.143450e-03
      [1246,] 0.81818182 0.63636364 0.72727273  8.088663e-03 -5.698827e-03
      [1247,] 0.90909091 0.63636364 0.72727273  1.192388e-03 -3.244852e-03
      [1248,] 1.00000000 0.63636364 0.72727273 -8.739367e-03  8.594727e-03
      [1249,] 0.00000000 0.72727273 0.72727273 -7.057752e-03 -5.696307e-03
      [1250,] 0.09090909 0.72727273 0.72727273  7.934177e-03 -2.187239e-03
      [1251,] 0.18181818 0.72727273 0.72727273  2.562161e-03 -4.566676e-03
      [1252,] 0.27272727 0.72727273 0.72727273  1.268018e-03 -7.743735e-03
      [1253,] 0.36363636 0.72727273 0.72727273  4.271594e-03  3.772355e-03
      [1254,] 0.45454545 0.72727273 0.72727273 -3.726241e-03  6.841244e-03
      [1255,] 0.54545455 0.72727273 0.72727273 -4.895750e-03 -3.989954e-03
      [1256,] 0.63636364 0.72727273 0.72727273  7.469659e-03  6.328442e-03
      [1257,] 0.72727273 0.72727273 0.72727273 -8.677236e-04 -6.656938e-03
      [1258,] 0.81818182 0.72727273 0.72727273 -8.563107e-03 -7.569947e-03
      [1259,] 0.90909091 0.72727273 0.72727273  1.048945e-04 -5.222435e-03
      [1260,] 1.00000000 0.72727273 0.72727273 -3.856202e-03  5.721997e-03
      [1261,] 0.00000000 0.81818182 0.72727273  7.136235e-03 -4.732060e-03
      [1262,] 0.09090909 0.81818182 0.72727273  4.451619e-03 -5.993720e-03
      [1263,] 0.18181818 0.81818182 0.72727273 -7.964761e-03  1.485443e-03
      [1264,] 0.27272727 0.81818182 0.72727273 -8.340821e-03  7.940313e-03
      [1265,] 0.36363636 0.81818182 0.72727273 -7.430361e-03  4.390419e-03
      [1266,] 0.45454545 0.81818182 0.72727273  8.440140e-03  7.201192e-03
      [1267,] 0.54545455 0.81818182 0.72727273 -5.037655e-04  8.546508e-03
      [1268,] 0.63636364 0.81818182 0.72727273  7.318078e-03  9.353874e-03
      [1269,] 0.72727273 0.81818182 0.72727273 -7.433207e-03 -7.717227e-03
      [1270,] 0.81818182 0.81818182 0.72727273  6.436257e-03  4.673383e-03
      [1271,] 0.90909091 0.81818182 0.72727273 -5.501597e-03  2.651732e-03
      [1272,] 1.00000000 0.81818182 0.72727273  3.402120e-03  4.529520e-03
      [1273,] 0.00000000 0.90909091 0.72727273 -6.117549e-03 -2.141849e-03
      [1274,] 0.09090909 0.90909091 0.72727273 -5.083098e-03  7.263452e-03
      [1275,] 0.18181818 0.90909091 0.72727273  5.289158e-03  6.969980e-03
      [1276,] 0.27272727 0.90909091 0.72727273 -7.593421e-04  2.354494e-03
      [1277,] 0.36363636 0.90909091 0.72727273  4.482100e-03 -7.670211e-03
      [1278,] 0.45454545 0.90909091 0.72727273  6.551829e-03 -2.216432e-03
      [1279,] 0.54545455 0.90909091 0.72727273  2.060307e-03  9.643524e-03
      [1280,] 0.63636364 0.90909091 0.72727273  5.697836e-03 -3.493010e-04
      [1281,] 0.72727273 0.90909091 0.72727273 -9.617557e-03  6.955104e-03
      [1282,] 0.81818182 0.90909091 0.72727273 -6.183346e-03 -7.814709e-03
      [1283,] 0.90909091 0.90909091 0.72727273  5.558815e-03  3.759365e-03
      [1284,] 1.00000000 0.90909091 0.72727273  3.214119e-03 -7.003036e-03
      [1285,] 0.00000000 1.00000000 0.72727273 -8.890253e-05  8.609085e-03
      [1286,] 0.09090909 1.00000000 0.72727273 -1.070092e-03  2.602816e-03
      [1287,] 0.18181818 1.00000000 0.72727273  6.296524e-03  4.627480e-03
      [1288,] 0.27272727 1.00000000 0.72727273  3.371627e-03  6.706567e-03
      [1289,] 0.36363636 1.00000000 0.72727273 -2.421324e-04  4.320225e-03
      [1290,] 0.45454545 1.00000000 0.72727273 -9.700813e-03  2.860343e-03
      [1291,] 0.54545455 1.00000000 0.72727273 -7.281134e-03  1.406938e-03
      [1292,] 0.63636364 1.00000000 0.72727273  8.911240e-03  1.782180e-03
      [1293,] 0.72727273 1.00000000 0.72727273  1.243818e-03 -4.163578e-03
      [1294,] 0.81818182 1.00000000 0.72727273  8.190202e-04  9.895389e-04
      [1295,] 0.90909091 1.00000000 0.72727273  1.302994e-03 -3.605983e-03
      [1296,] 1.00000000 1.00000000 0.72727273 -7.214195e-03 -4.089046e-03
      [1297,] 0.00000000 0.00000000 0.81818182  7.223807e-03 -4.909510e-03
      [1298,] 0.09090909 0.00000000 0.81818182 -8.354762e-03  6.506443e-03
      [1299,] 0.18181818 0.00000000 0.81818182  7.374214e-03  9.106122e-03
      [1300,] 0.27272727 0.00000000 0.81818182  6.179174e-03 -5.576154e-03
      [1301,] 0.36363636 0.00000000 0.81818182  9.683892e-03 -8.093001e-03
      [1302,] 0.45454545 0.00000000 0.81818182  6.959177e-03 -6.791562e-03
      [1303,] 0.54545455 0.00000000 0.81818182  1.553048e-03 -5.114958e-03
      [1304,] 0.63636364 0.00000000 0.81818182 -1.698602e-03  2.000756e-03
      [1305,] 0.72727273 0.00000000 0.81818182  8.734675e-03 -9.101171e-03
      [1306,] 0.81818182 0.00000000 0.81818182 -3.466970e-03 -7.689222e-03
      [1307,] 0.90909091 0.00000000 0.81818182  4.154600e-03 -3.075121e-03
      [1308,] 1.00000000 0.00000000 0.81818182  3.162253e-04  8.000048e-03
      [1309,] 0.00000000 0.09090909 0.81818182 -5.157060e-03  2.939172e-04
      [1310,] 0.09090909 0.09090909 0.81818182  8.317120e-03  7.363739e-03
      [1311,] 0.18181818 0.09090909 0.81818182 -6.478801e-03  2.932976e-03
      [1312,] 0.27272727 0.09090909 0.81818182  7.142680e-04 -4.841696e-03
      [1313,] 0.36363636 0.09090909 0.81818182 -5.609875e-03 -2.706277e-03
      [1314,] 0.45454545 0.09090909 0.81818182  3.271278e-03 -9.755061e-03
      [1315,] 0.54545455 0.09090909 0.81818182 -2.918022e-03  8.508549e-03
      [1316,] 0.63636364 0.09090909 0.81818182  3.792883e-03  9.779846e-03
      [1317,] 0.72727273 0.09090909 0.81818182 -1.611428e-03 -9.525138e-03
      [1318,] 0.81818182 0.09090909 0.81818182 -8.387588e-03 -6.698261e-03
      [1319,] 0.90909091 0.09090909 0.81818182 -1.877439e-03  8.521716e-03
      [1320,] 1.00000000 0.09090909 0.81818182 -1.470605e-03 -7.053611e-03
      [1321,] 0.00000000 0.18181818 0.81818182 -8.098518e-03  4.609123e-03
      [1322,] 0.09090909 0.18181818 0.81818182 -2.971400e-03 -4.798876e-03
      [1323,] 0.18181818 0.18181818 0.81818182  4.607844e-03 -1.623307e-03
      [1324,] 0.27272727 0.18181818 0.81818182  3.916161e-03  5.184545e-03
      [1325,] 0.36363636 0.18181818 0.81818182 -4.878608e-03  3.138225e-03
      [1326,] 0.45454545 0.18181818 0.81818182  2.415293e-03 -7.997103e-03
      [1327,] 0.54545455 0.18181818 0.81818182 -2.993973e-03 -5.992877e-03
      [1328,] 0.63636364 0.18181818 0.81818182 -4.469117e-04  2.086331e-03
      [1329,] 0.72727273 0.18181818 0.81818182  5.673328e-03 -9.460566e-03
      [1330,] 0.81818182 0.18181818 0.81818182  9.762122e-03  9.043897e-03
      [1331,] 0.90909091 0.18181818 0.81818182 -9.870467e-03 -8.260436e-03
      [1332,] 1.00000000 0.18181818 0.81818182 -2.828163e-03  3.378961e-03
      [1333,] 0.00000000 0.27272727 0.81818182 -1.433900e-03  4.342621e-03
      [1334,] 0.09090909 0.27272727 0.81818182  6.081174e-03  9.680342e-03
      [1335,] 0.18181818 0.27272727 0.81818182  6.402705e-03  6.502457e-03
      [1336,] 0.27272727 0.27272727 0.81818182  8.205720e-03  3.560936e-03
      [1337,] 0.36363636 0.27272727 0.81818182 -8.022395e-03 -6.866218e-03
      [1338,] 0.45454545 0.27272727 0.81818182 -7.646953e-04 -3.971127e-03
      [1339,] 0.54545455 0.27272727 0.81818182  2.980328e-03  4.061963e-03
      [1340,] 0.63636364 0.27272727 0.81818182  9.875608e-03 -2.859441e-03
      [1341,] 0.72727273 0.27272727 0.81818182 -5.951792e-03  5.233693e-03
      [1342,] 0.81818182 0.27272727 0.81818182  9.768151e-03 -4.428957e-03
      [1343,] 0.90909091 0.27272727 0.81818182  3.717920e-03 -3.020958e-03
      [1344,] 1.00000000 0.27272727 0.81818182 -1.760280e-03 -2.065834e-03
      [1345,] 0.00000000 0.36363636 0.81818182 -2.678552e-04  4.215836e-03
      [1346,] 0.09090909 0.36363636 0.81818182 -3.529488e-03 -2.146096e-03
      [1347,] 0.18181818 0.36363636 0.81818182 -5.404252e-04 -2.860389e-03
      [1348,] 0.27272727 0.36363636 0.81818182  8.181239e-03 -9.973961e-03
      [1349,] 0.36363636 0.36363636 0.81818182  1.277069e-03 -9.168625e-03
      [1350,] 0.45454545 0.36363636 0.81818182  7.371809e-03 -9.088987e-03
      [1351,] 0.54545455 0.36363636 0.81818182 -7.006224e-03 -2.293689e-03
      [1352,] 0.63636364 0.36363636 0.81818182  1.645596e-03  9.329741e-04
      [1353,] 0.72727273 0.36363636 0.81818182 -8.636643e-03 -4.832743e-04
      [1354,] 0.81818182 0.36363636 0.81818182  8.537773e-03 -5.517979e-03
      [1355,] 0.90909091 0.36363636 0.81818182 -7.090920e-03 -5.452440e-03
      [1356,] 1.00000000 0.36363636 0.81818182  4.619721e-03 -7.285870e-03
      [1357,] 0.00000000 0.45454545 0.81818182  6.754211e-03 -6.186547e-03
      [1358,] 0.09090909 0.45454545 0.81818182  7.426737e-03  5.930400e-03
      [1359,] 0.18181818 0.45454545 0.81818182  5.008155e-03  4.119001e-03
      [1360,] 0.27272727 0.45454545 0.81818182  4.404289e-03  9.184555e-03
      [1361,] 0.36363636 0.45454545 0.81818182 -5.152397e-03  9.558086e-03
      [1362,] 0.45454545 0.45454545 0.81818182 -8.216286e-03 -8.104903e-03
      [1363,] 0.54545455 0.45454545 0.81818182 -9.773805e-03  6.097006e-03
      [1364,] 0.63636364 0.45454545 0.81818182  4.140785e-03 -3.145263e-03
      [1365,] 0.72727273 0.45454545 0.81818182 -4.958551e-03  7.841135e-03
      [1366,] 0.81818182 0.45454545 0.81818182 -7.507370e-03 -7.457866e-04
      [1367,] 0.90909091 0.45454545 0.81818182  8.948176e-03  4.335554e-03
      [1368,] 1.00000000 0.45454545 0.81818182  9.643118e-03 -7.937634e-03
      [1369,] 0.00000000 0.54545455 0.81818182  7.598340e-03  7.337483e-03
      [1370,] 0.09090909 0.54545455 0.81818182  4.929457e-03  3.853425e-03
      [1371,] 0.18181818 0.54545455 0.81818182  1.677600e-03  3.261560e-03
      [1372,] 0.27272727 0.54545455 0.81818182  5.322725e-03  9.569462e-03
      [1373,] 0.36363636 0.54545455 0.81818182 -3.588168e-03  7.965596e-03
      [1374,] 0.45454545 0.54545455 0.81818182 -7.774503e-03 -9.529233e-03
      [1375,] 0.54545455 0.54545455 0.81818182  8.749547e-03  2.314622e-03
      [1376,] 0.63636364 0.54545455 0.81818182  5.359288e-03  9.616636e-03
      [1377,] 0.72727273 0.54545455 0.81818182  7.466373e-03  4.767297e-03
      [1378,] 0.81818182 0.54545455 0.81818182 -2.593664e-03  2.590703e-03
      [1379,] 0.90909091 0.54545455 0.81818182  7.577421e-03 -8.729189e-04
      [1380,] 1.00000000 0.54545455 0.81818182 -3.095226e-03 -9.819614e-04
      [1381,] 0.00000000 0.63636364 0.81818182 -9.396330e-03  4.997669e-03
      [1382,] 0.09090909 0.63636364 0.81818182 -7.712582e-03  2.196255e-03
      [1383,] 0.18181818 0.63636364 0.81818182  1.751532e-03  2.182102e-03
      [1384,] 0.27272727 0.63636364 0.81818182  5.722064e-03  1.975730e-03
      [1385,] 0.36363636 0.63636364 0.81818182 -5.681892e-03 -9.837123e-03
      [1386,] 0.45454545 0.63636364 0.81818182 -1.073915e-03 -1.862038e-03
      [1387,] 0.54545455 0.63636364 0.81818182  6.454179e-03 -3.484970e-03
      [1388,] 0.63636364 0.63636364 0.81818182  7.085446e-03 -9.229190e-03
      [1389,] 0.72727273 0.63636364 0.81818182  7.078398e-04  8.540212e-03
      [1390,] 0.81818182 0.63636364 0.81818182  2.797693e-03  2.374730e-03
      [1391,] 0.90909091 0.63636364 0.81818182  7.216217e-03  4.804802e-03
      [1392,] 1.00000000 0.63636364 0.81818182 -9.874102e-04 -3.725355e-03
      [1393,] 0.00000000 0.72727273 0.81818182 -9.791371e-03 -9.170540e-03
      [1394,] 0.09090909 0.72727273 0.81818182  7.394795e-03 -3.063492e-03
      [1395,] 0.18181818 0.72727273 0.81818182 -5.363622e-03 -5.881558e-03
      [1396,] 0.27272727 0.72727273 0.81818182 -7.615855e-03  1.913348e-03
      [1397,] 0.36363636 0.72727273 0.81818182  1.539400e-03 -8.182688e-03
      [1398,] 0.45454545 0.72727273 0.81818182  4.610645e-03 -1.575766e-03
      [1399,] 0.54545455 0.72727273 0.81818182  8.600674e-03 -6.975634e-03
      [1400,] 0.63636364 0.72727273 0.81818182 -9.691225e-03 -9.878860e-03
      [1401,] 0.72727273 0.72727273 0.81818182 -5.139707e-03  7.211132e-03
      [1402,] 0.81818182 0.72727273 0.81818182 -2.085742e-03  2.091399e-03
      [1403,] 0.90909091 0.72727273 0.81818182 -8.876084e-03  7.033348e-03
      [1404,] 1.00000000 0.72727273 0.81818182 -1.506199e-03  2.330516e-03
      [1405,] 0.00000000 0.81818182 0.81818182 -5.739632e-03 -1.548533e-04
      [1406,] 0.09090909 0.81818182 0.81818182  2.028377e-04 -7.939491e-03
      [1407,] 0.18181818 0.81818182 0.81818182 -1.635366e-03 -5.433033e-03
      [1408,] 0.27272727 0.81818182 0.81818182 -9.383784e-03 -6.257712e-03
      [1409,] 0.36363636 0.81818182 0.81818182 -2.009945e-04 -5.705286e-03
      [1410,] 0.45454545 0.81818182 0.81818182  1.518133e-03  7.935574e-03
      [1411,] 0.54545455 0.81818182 0.81818182  2.358417e-03 -9.218855e-03
      [1412,] 0.63636364 0.81818182 0.81818182  6.236670e-03 -8.197617e-03
      [1413,] 0.72727273 0.81818182 0.81818182  9.911832e-03  2.506793e-03
      [1414,] 0.81818182 0.81818182 0.81818182 -3.946121e-03  4.956256e-03
      [1415,] 0.90909091 0.81818182 0.81818182  2.150619e-03  3.387849e-03
      [1416,] 1.00000000 0.81818182 0.81818182 -7.207185e-03 -9.905207e-03
      [1417,] 0.00000000 0.90909091 0.81818182 -7.184857e-03  6.546886e-03
      [1418,] 0.09090909 0.90909091 0.81818182 -5.410525e-03 -2.211561e-03
      [1419,] 0.18181818 0.90909091 0.81818182  9.435210e-03  1.959545e-03
      [1420,] 0.27272727 0.90909091 0.81818182 -7.709262e-03  1.798674e-03
      [1421,] 0.36363636 0.90909091 0.81818182  9.692423e-03 -2.464672e-03
      [1422,] 0.45454545 0.90909091 0.81818182  8.176556e-03 -4.727416e-03
      [1423,] 0.54545455 0.90909091 0.81818182 -2.490836e-03 -6.296164e-03
      [1424,] 0.63636364 0.90909091 0.81818182  6.138091e-03  1.055282e-03
      [1425,] 0.72727273 0.90909091 0.81818182 -3.633123e-03  4.910132e-03
      [1426,] 0.81818182 0.90909091 0.81818182  1.308641e-03 -5.903480e-03
      [1427,] 0.90909091 0.90909091 0.81818182 -5.221317e-03 -6.822425e-03
      [1428,] 1.00000000 0.90909091 0.81818182 -7.136652e-03 -5.876619e-03
      [1429,] 0.00000000 1.00000000 0.81818182 -4.050678e-03  8.599066e-03
      [1430,] 0.09090909 1.00000000 0.81818182 -9.966920e-04 -4.761952e-03
      [1431,] 0.18181818 1.00000000 0.81818182 -1.957858e-03  8.111243e-04
      [1432,] 0.27272727 1.00000000 0.81818182 -5.066012e-03 -5.818434e-03
      [1433,] 0.36363636 1.00000000 0.81818182 -8.429543e-03  5.654933e-03
      [1434,] 0.45454545 1.00000000 0.81818182  2.673356e-03  3.151395e-03
      [1435,] 0.54545455 1.00000000 0.81818182 -1.888618e-03 -3.879479e-03
      [1436,] 0.63636364 1.00000000 0.81818182  7.363031e-03 -1.588437e-03
      [1437,] 0.72727273 1.00000000 0.81818182 -9.088602e-03  9.758388e-03
      [1438,] 0.81818182 1.00000000 0.81818182  9.374634e-03  6.118684e-03
      [1439,] 0.90909091 1.00000000 0.81818182 -7.319134e-03 -2.176497e-03
      [1440,] 1.00000000 1.00000000 0.81818182  8.152783e-03 -1.700964e-04
      [1441,] 0.00000000 0.00000000 0.90909091  3.829878e-03 -3.408348e-03
      [1442,] 0.09090909 0.00000000 0.90909091 -1.492620e-03 -9.283685e-03
      [1443,] 0.18181818 0.00000000 0.90909091  5.505340e-03 -2.363967e-03
      [1444,] 0.27272727 0.00000000 0.90909091  7.006433e-03 -4.465304e-03
      [1445,] 0.36363636 0.00000000 0.90909091 -8.418178e-03 -3.313799e-03
      [1446,] 0.45454545 0.00000000 0.90909091 -6.371708e-03  3.436774e-03
      [1447,] 0.54545455 0.00000000 0.90909091 -7.127153e-03 -8.437011e-04
      [1448,] 0.63636364 0.00000000 0.90909091  2.103639e-03  4.987193e-03
      [1449,] 0.72727273 0.00000000 0.90909091  7.878935e-03  5.979384e-03
      [1450,] 0.81818182 0.00000000 0.90909091  9.733100e-03 -2.193494e-03
      [1451,] 0.90909091 0.00000000 0.90909091 -3.174678e-03  6.541074e-04
      [1452,] 1.00000000 0.00000000 0.90909091 -6.793681e-03 -2.908856e-03
      [1453,] 0.00000000 0.09090909 0.90909091 -1.036740e-03  3.210303e-03
      [1454,] 0.09090909 0.09090909 0.90909091  1.178854e-03 -3.909417e-03
      [1455,] 0.18181818 0.09090909 0.90909091 -4.080185e-03  9.058991e-04
      [1456,] 0.27272727 0.09090909 0.90909091 -6.058044e-03 -9.602515e-03
      [1457,] 0.36363636 0.09090909 0.90909091 -5.050518e-03  3.785354e-04
      [1458,] 0.45454545 0.09090909 0.90909091  7.618555e-03  6.388407e-03
      [1459,] 0.54545455 0.09090909 0.90909091  3.444424e-03  3.667392e-03
      [1460,] 0.63636364 0.09090909 0.90909091 -1.059139e-03 -9.185231e-03
      [1461,] 0.72727273 0.09090909 0.90909091  6.505885e-03 -4.176880e-03
      [1462,] 0.81818182 0.09090909 0.90909091  7.762007e-03  2.999095e-03
      [1463,] 0.90909091 0.09090909 0.90909091 -6.864325e-03  4.944799e-03
      [1464,] 1.00000000 0.09090909 0.90909091  6.615466e-04 -5.296093e-03
      [1465,] 0.00000000 0.18181818 0.90909091 -7.729484e-03  2.799050e-03
      [1466,] 0.09090909 0.18181818 0.90909091  5.870296e-03  4.153146e-03
      [1467,] 0.18181818 0.18181818 0.90909091 -6.748294e-03 -5.969599e-03
      [1468,] 0.27272727 0.18181818 0.90909091  8.917300e-03 -9.363541e-03
      [1469,] 0.36363636 0.18181818 0.90909091  2.155571e-03  9.355699e-03
      [1470,] 0.45454545 0.18181818 0.90909091  5.115548e-03 -4.599422e-03
      [1471,] 0.54545455 0.18181818 0.90909091  8.666317e-03 -5.802217e-03
      [1472,] 0.63636364 0.18181818 0.90909091 -4.002192e-03  3.260616e-03
      [1473,] 0.72727273 0.18181818 0.90909091 -1.417515e-03  7.198604e-03
      [1474,] 0.81818182 0.18181818 0.90909091  7.843698e-03  7.836581e-03
      [1475,] 0.90909091 0.18181818 0.90909091  3.383654e-03 -1.559551e-04
      [1476,] 1.00000000 0.18181818 0.90909091 -5.261601e-03 -5.154110e-03
      [1477,] 0.00000000 0.27272727 0.90909091  8.186237e-03 -7.190669e-05
      [1478,] 0.09090909 0.27272727 0.90909091 -9.134794e-03 -6.357324e-03
      [1479,] 0.18181818 0.27272727 0.90909091 -4.736658e-03  1.517092e-03
      [1480,] 0.27272727 0.27272727 0.90909091 -5.612908e-03  7.383377e-03
      [1481,] 0.36363636 0.27272727 0.90909091 -4.426879e-03  9.436979e-03
      [1482,] 0.45454545 0.27272727 0.90909091  8.371086e-04 -8.963708e-03
      [1483,] 0.54545455 0.27272727 0.90909091  7.317145e-03 -4.873705e-03
      [1484,] 0.63636364 0.27272727 0.90909091  8.753197e-03  6.121457e-03
      [1485,] 0.72727273 0.27272727 0.90909091  3.565478e-03 -4.096579e-03
      [1486,] 0.81818182 0.27272727 0.90909091 -8.172221e-03 -5.724192e-03
      [1487,] 0.90909091 0.27272727 0.90909091  8.600331e-03  8.837968e-03
      [1488,] 1.00000000 0.27272727 0.90909091  5.542899e-03  4.997470e-03
      [1489,] 0.00000000 0.36363636 0.90909091 -8.969759e-04 -8.903227e-03
      [1490,] 0.09090909 0.36363636 0.90909091 -2.649003e-04  6.358838e-03
      [1491,] 0.18181818 0.36363636 0.90909091 -6.319983e-03  2.971665e-03
      [1492,] 0.27272727 0.36363636 0.90909091  5.501618e-03  1.650509e-03
      [1493,] 0.36363636 0.36363636 0.90909091  9.097185e-03  1.684356e-03
      [1494,] 0.45454545 0.36363636 0.90909091  1.562598e-03 -2.513560e-03
      [1495,] 0.54545455 0.36363636 0.90909091 -3.781837e-03 -8.840671e-03
      [1496,] 0.63636364 0.36363636 0.90909091 -6.676765e-03 -2.176652e-03
      [1497,] 0.72727273 0.36363636 0.90909091 -2.871410e-03  7.156344e-03
      [1498,] 0.81818182 0.36363636 0.90909091  9.614953e-03 -8.543247e-03
      [1499,] 0.90909091 0.36363636 0.90909091  1.769026e-03  3.832904e-03
      [1500,] 1.00000000 0.36363636 0.90909091 -1.766283e-03  8.171858e-03
      [1501,] 0.00000000 0.45454545 0.90909091  9.128308e-03 -9.220040e-03
      [1502,] 0.09090909 0.45454545 0.90909091  7.316170e-03 -3.428726e-04
      [1503,] 0.18181818 0.45454545 0.90909091 -1.784292e-03  4.089358e-03
      [1504,] 0.27272727 0.45454545 0.90909091  6.702685e-03 -7.249770e-03
      [1505,] 0.36363636 0.45454545 0.90909091  4.145140e-03  9.453756e-04
      [1506,] 0.45454545 0.45454545 0.90909091  1.608556e-03 -7.857137e-03
      [1507,] 0.54545455 0.45454545 0.90909091 -8.332041e-03  6.323153e-03
      [1508,] 0.63636364 0.45454545 0.90909091 -4.988867e-03 -2.321528e-03
      [1509,] 0.72727273 0.45454545 0.90909091  9.107235e-03 -1.358095e-03
      [1510,] 0.81818182 0.45454545 0.90909091 -3.430959e-03  7.465406e-03
      [1511,] 0.90909091 0.45454545 0.90909091  3.476740e-03 -3.739053e-03
      [1512,] 1.00000000 0.45454545 0.90909091 -6.725628e-03  1.117280e-03
      [1513,] 0.00000000 0.54545455 0.90909091  8.606445e-03 -5.344141e-03
      [1514,] 0.09090909 0.54545455 0.90909091 -6.700559e-03  9.539390e-03
      [1515,] 0.18181818 0.54545455 0.90909091  3.873678e-03 -8.166553e-03
      [1516,] 0.27272727 0.54545455 0.90909091  3.888507e-03 -6.014790e-03
      [1517,] 0.36363636 0.54545455 0.90909091  3.818160e-03  2.566194e-03
      [1518,] 0.45454545 0.54545455 0.90909091 -6.085470e-03 -5.099965e-03
      [1519,] 0.54545455 0.54545455 0.90909091 -7.684851e-03  7.360782e-03
      [1520,] 0.63636364 0.54545455 0.90909091  6.931949e-03  8.089040e-03
      [1521,] 0.72727273 0.54545455 0.90909091 -8.708093e-04  2.281411e-03
      [1522,] 0.81818182 0.54545455 0.90909091 -2.029225e-03  7.201636e-03
      [1523,] 0.90909091 0.54545455 0.90909091  7.846030e-03 -4.483877e-03
      [1524,] 1.00000000 0.54545455 0.90909091  3.536761e-04  6.030873e-03
      [1525,] 0.00000000 0.63636364 0.90909091  8.804081e-04  2.800410e-03
      [1526,] 0.09090909 0.63636364 0.90909091 -7.721261e-03 -3.874501e-03
      [1527,] 0.18181818 0.63636364 0.90909091 -5.528604e-03 -3.967484e-03
      [1528,] 0.27272727 0.63636364 0.90909091 -4.635936e-03 -5.988467e-03
      [1529,] 0.36363636 0.63636364 0.90909091 -7.980022e-03  8.753015e-04
      [1530,] 0.45454545 0.63636364 0.90909091  5.043649e-03  2.603066e-03
      [1531,] 0.54545455 0.63636364 0.90909091  5.433775e-03  8.919148e-03
      [1532,] 0.63636364 0.63636364 0.90909091  8.117363e-03  3.318421e-03
      [1533,] 0.72727273 0.63636364 0.90909091  9.233020e-03  2.881196e-03
      [1534,] 0.81818182 0.63636364 0.90909091  4.793723e-03 -5.734749e-03
      [1535,] 0.90909091 0.63636364 0.90909091  5.687105e-03 -9.185305e-03
      [1536,] 1.00000000 0.63636364 0.90909091  8.644735e-03 -9.899119e-03
      [1537,] 0.00000000 0.72727273 0.90909091  1.688951e-04 -4.093068e-03
      [1538,] 0.09090909 0.72727273 0.90909091  8.626050e-03 -7.077705e-03
      [1539,] 0.18181818 0.72727273 0.90909091  2.702766e-03  6.254494e-03
      [1540,] 0.27272727 0.72727273 0.90909091  4.807017e-03  7.153866e-03
      [1541,] 0.36363636 0.72727273 0.90909091  5.244299e-03  1.362580e-03
      [1542,] 0.45454545 0.72727273 0.90909091 -5.075688e-03 -8.407667e-03
      [1543,] 0.54545455 0.72727273 0.90909091  8.033669e-03  8.529652e-03
      [1544,] 0.63636364 0.72727273 0.90909091 -2.964037e-03 -1.284062e-03
      [1545,] 0.72727273 0.72727273 0.90909091 -2.913973e-03  4.440350e-03
      [1546,] 0.81818182 0.72727273 0.90909091  8.555142e-03  9.326549e-03
      [1547,] 0.90909091 0.72727273 0.90909091  5.896084e-03 -1.348137e-03
      [1548,] 1.00000000 0.72727273 0.90909091  2.135097e-03 -2.271603e-03
      [1549,] 0.00000000 0.81818182 0.90909091 -9.027325e-03  4.970718e-03
      [1550,] 0.09090909 0.81818182 0.90909091  9.074257e-03 -4.838630e-05
      [1551,] 0.18181818 0.81818182 0.90909091 -7.568855e-03  9.361492e-03
      [1552,] 0.27272727 0.81818182 0.90909091  6.757193e-03  1.494727e-03
      [1553,] 0.36363636 0.81818182 0.90909091 -8.345460e-03 -4.598057e-03
      [1554,] 0.45454545 0.81818182 0.90909091  7.450560e-03  6.640423e-03
      [1555,] 0.54545455 0.81818182 0.90909091 -5.925311e-03 -7.743415e-03
      [1556,] 0.63636364 0.81818182 0.90909091  9.576564e-03  8.432915e-03
      [1557,] 0.72727273 0.81818182 0.90909091  8.095627e-03  9.886438e-03
      [1558,] 0.81818182 0.81818182 0.90909091 -4.141652e-03  4.445471e-03
      [1559,] 0.90909091 0.81818182 0.90909091  1.934282e-03 -5.286172e-03
      [1560,] 1.00000000 0.81818182 0.90909091 -8.542863e-05 -1.860785e-03
      [1561,] 0.00000000 0.90909091 0.90909091  8.296134e-03  5.478673e-03
      [1562,] 0.09090909 0.90909091 0.90909091 -5.219655e-04 -8.694733e-03
      [1563,] 0.18181818 0.90909091 0.90909091 -2.409001e-03 -3.732696e-03
      [1564,] 0.27272727 0.90909091 0.90909091 -3.037067e-03 -4.417525e-03
      [1565,] 0.36363636 0.90909091 0.90909091 -8.091607e-03 -4.530076e-03
      [1566,] 0.45454545 0.90909091 0.90909091  8.129465e-03  4.859083e-03
      [1567,] 0.54545455 0.90909091 0.90909091  9.084222e-03  7.115666e-03
      [1568,] 0.63636364 0.90909091 0.90909091 -4.656716e-03  9.189307e-03
      [1569,] 0.72727273 0.90909091 0.90909091  3.202231e-03 -6.404739e-03
      [1570,] 0.81818182 0.90909091 0.90909091  1.922597e-03 -4.102911e-03
      [1571,] 0.90909091 0.90909091 0.90909091 -6.729032e-03  3.054100e-03
      [1572,] 1.00000000 0.90909091 0.90909091 -7.350128e-03 -3.065058e-03
      [1573,] 0.00000000 1.00000000 0.90909091 -9.996406e-03 -4.500924e-03
      [1574,] 0.09090909 1.00000000 0.90909091 -9.004911e-03 -3.909915e-03
      [1575,] 0.18181818 1.00000000 0.90909091  6.518709e-03 -3.427631e-03
      [1576,] 0.27272727 1.00000000 0.90909091  2.846843e-03 -1.458033e-03
      [1577,] 0.36363636 1.00000000 0.90909091 -8.371930e-03  6.229798e-03
      [1578,] 0.45454545 1.00000000 0.90909091 -5.478929e-03  8.781023e-03
      [1579,] 0.54545455 1.00000000 0.90909091  5.819187e-03  1.078352e-03
      [1580,] 0.63636364 1.00000000 0.90909091 -8.815224e-03  8.335216e-03
      [1581,] 0.72727273 1.00000000 0.90909091 -5.044006e-03 -2.265286e-03
      [1582,] 0.81818182 1.00000000 0.90909091  6.403191e-04  5.180697e-03
      [1583,] 0.90909091 1.00000000 0.90909091 -6.688153e-03  1.313714e-03
      [1584,] 1.00000000 1.00000000 0.90909091 -2.018944e-03 -8.714355e-03
      [1585,] 0.00000000 0.00000000 1.00000000  6.104885e-03 -1.413538e-03
      [1586,] 0.09090909 0.00000000 1.00000000 -2.321193e-03  2.602344e-03
      [1587,] 0.18181818 0.00000000 1.00000000  7.584225e-03 -9.842067e-03
      [1588,] 0.27272727 0.00000000 1.00000000 -6.316232e-03  8.483869e-03
      [1589,] 0.36363636 0.00000000 1.00000000  2.889475e-07 -1.603122e-03
      [1590,] 0.45454545 0.00000000 1.00000000  9.561405e-03  4.959655e-03
      [1591,] 0.54545455 0.00000000 1.00000000 -3.573121e-03 -9.887722e-03
      [1592,] 0.63636364 0.00000000 1.00000000  1.657902e-03 -6.200351e-04
      [1593,] 0.72727273 0.00000000 1.00000000 -8.284473e-04  7.696748e-03
      [1594,] 0.81818182 0.00000000 1.00000000 -5.756071e-03 -2.678921e-03
      [1595,] 0.90909091 0.00000000 1.00000000 -9.356224e-03 -8.886881e-03
      [1596,] 1.00000000 0.00000000 1.00000000 -1.449756e-03 -8.241763e-03
      [1597,] 0.00000000 0.09090909 1.00000000 -4.774053e-03  9.653803e-03
      [1598,] 0.09090909 0.09090909 1.00000000 -5.576625e-03  5.774612e-03
      [1599,] 0.18181818 0.09090909 1.00000000  4.711577e-03  9.477345e-03
      [1600,] 0.27272727 0.09090909 1.00000000  1.814793e-03 -6.371466e-03
      [1601,] 0.36363636 0.09090909 1.00000000  2.771913e-03 -2.543030e-03
      [1602,] 0.45454545 0.09090909 1.00000000  9.133286e-03  6.217493e-03
      [1603,] 0.54545455 0.09090909 1.00000000  2.435664e-03 -8.314024e-03
      [1604,] 0.63636364 0.09090909 1.00000000 -4.273178e-03  9.206720e-04
      [1605,] 0.72727273 0.09090909 1.00000000 -8.201059e-04  2.201468e-03
      [1606,] 0.81818182 0.09090909 1.00000000 -6.726725e-03 -8.412112e-04
      [1607,] 0.90909091 0.09090909 1.00000000  2.059461e-04  2.950300e-03
      [1608,] 1.00000000 0.09090909 1.00000000  1.528113e-03  9.217839e-03
      [1609,] 0.00000000 0.18181818 1.00000000  4.444573e-03 -1.188735e-03
      [1610,] 0.09090909 0.18181818 1.00000000  1.190156e-03  7.939435e-03
      [1611,] 0.18181818 0.18181818 1.00000000  6.645194e-03  4.867917e-03
      [1612,] 0.27272727 0.18181818 1.00000000 -5.155482e-03 -5.506128e-03
      [1613,] 0.36363636 0.18181818 1.00000000 -9.627298e-04 -6.243836e-03
      [1614,] 0.45454545 0.18181818 1.00000000 -3.620473e-03 -1.546055e-03
      [1615,] 0.54545455 0.18181818 1.00000000  7.805396e-03  1.810432e-03
      [1616,] 0.63636364 0.18181818 1.00000000  2.872391e-03 -2.599188e-03
      [1617,] 0.72727273 0.18181818 1.00000000  5.179339e-03  1.067395e-03
      [1618,] 0.81818182 0.18181818 1.00000000  7.983316e-03  1.379886e-04
      [1619,] 0.90909091 0.18181818 1.00000000  6.948620e-03  8.670693e-03
      [1620,] 1.00000000 0.18181818 1.00000000  4.357475e-03  4.665708e-04
      [1621,] 0.00000000 0.27272727 1.00000000  2.782787e-03 -2.617568e-03
      [1622,] 0.09090909 0.27272727 1.00000000 -3.245281e-03  2.982378e-03
      [1623,] 0.18181818 0.27272727 1.00000000 -8.431883e-03  2.573354e-03
      [1624,] 0.27272727 0.27272727 1.00000000 -3.089068e-03  8.604834e-03
      [1625,] 0.36363636 0.27272727 1.00000000 -8.581568e-03 -2.863751e-03
      [1626,] 0.45454545 0.27272727 1.00000000 -8.024913e-04  8.925753e-04
      [1627,] 0.54545455 0.27272727 1.00000000 -2.414034e-03 -4.875963e-03
      [1628,] 0.63636364 0.27272727 1.00000000  4.784999e-03 -4.124806e-03
      [1629,] 0.72727273 0.27272727 1.00000000 -6.674164e-03 -8.697546e-04
      [1630,] 0.81818182 0.27272727 1.00000000 -2.901029e-03  6.274546e-03
      [1631,] 0.90909091 0.27272727 1.00000000 -8.555052e-03 -8.471369e-03
      [1632,] 1.00000000 0.27272727 1.00000000 -5.914284e-03  2.109654e-04
      [1633,] 0.00000000 0.36363636 1.00000000  3.729403e-03  1.299353e-04
      [1634,] 0.09090909 0.36363636 1.00000000  1.173164e-03  4.991812e-04
      [1635,] 0.18181818 0.36363636 1.00000000 -1.818492e-03  1.597107e-03
      [1636,] 0.27272727 0.36363636 1.00000000 -2.928133e-03 -2.462527e-03
      [1637,] 0.36363636 0.36363636 1.00000000  1.311911e-04  8.522693e-04
      [1638,] 0.45454545 0.36363636 1.00000000  1.824795e-04  8.280233e-03
      [1639,] 0.54545455 0.36363636 1.00000000  3.976408e-03 -1.257185e-04
      [1640,] 0.63636364 0.36363636 1.00000000  4.634903e-03  5.086198e-04
      [1641,] 0.72727273 0.36363636 1.00000000  3.873971e-03 -8.539769e-03
      [1642,] 0.81818182 0.36363636 1.00000000  2.042103e-03 -8.432307e-03
      [1643,] 0.90909091 0.36363636 1.00000000 -4.443782e-03  2.646365e-03
      [1644,] 1.00000000 0.36363636 1.00000000 -3.106501e-03 -9.333927e-03
      [1645,] 0.00000000 0.45454545 1.00000000  5.969514e-03 -7.625488e-03
      [1646,] 0.09090909 0.45454545 1.00000000  6.822768e-04  2.649410e-03
      [1647,] 0.18181818 0.45454545 1.00000000  1.702835e-03 -4.249591e-04
      [1648,] 0.27272727 0.45454545 1.00000000  4.805151e-03 -9.066235e-03
      [1649,] 0.36363636 0.45454545 1.00000000 -2.758698e-03  4.279720e-03
      [1650,] 0.45454545 0.45454545 1.00000000 -3.135789e-03  4.875665e-03
      [1651,] 0.54545455 0.45454545 1.00000000 -7.607304e-03  8.874256e-04
      [1652,] 0.63636364 0.45454545 1.00000000  3.253354e-03  8.762683e-04
      [1653,] 0.72727273 0.45454545 1.00000000 -5.826511e-03  3.613380e-03
      [1654,] 0.81818182 0.45454545 1.00000000 -6.233085e-03 -4.133798e-03
      [1655,] 0.90909091 0.45454545 1.00000000  9.074114e-04 -5.127050e-03
      [1656,] 1.00000000 0.45454545 1.00000000 -5.506149e-03  4.242383e-03
      [1657,] 0.00000000 0.54545455 1.00000000 -5.956223e-03 -1.944740e-03
      [1658,] 0.09090909 0.54545455 1.00000000  6.779641e-03 -6.271885e-03
      [1659,] 0.18181818 0.54545455 1.00000000 -7.225592e-03  2.188998e-03
      [1660,] 0.27272727 0.54545455 1.00000000 -1.140536e-03 -6.695109e-04
      [1661,] 0.36363636 0.54545455 1.00000000 -3.673408e-03  7.724930e-03
      [1662,] 0.45454545 0.54545455 1.00000000 -9.096824e-03 -8.937437e-03
      [1663,] 0.54545455 0.54545455 1.00000000 -9.877305e-03  8.042793e-03
      [1664,] 0.63636364 0.54545455 1.00000000  1.353424e-03 -2.543047e-03
      [1665,] 0.72727273 0.54545455 1.00000000  9.151178e-03 -8.281311e-03
      [1666,] 0.81818182 0.54545455 1.00000000  6.052484e-03  6.056614e-03
      [1667,] 0.90909091 0.54545455 1.00000000 -4.406545e-03 -7.458168e-03
      [1668,] 1.00000000 0.54545455 1.00000000 -5.144215e-03  5.546472e-03
      [1669,] 0.00000000 0.63636364 1.00000000 -3.473737e-03  8.634533e-03
      [1670,] 0.09090909 0.63636364 1.00000000 -1.650987e-03 -5.039590e-03
      [1671,] 0.18181818 0.63636364 1.00000000 -5.256711e-04  5.749846e-03
      [1672,] 0.27272727 0.63636364 1.00000000  2.104814e-03  1.323998e-03
      [1673,] 0.36363636 0.63636364 1.00000000 -9.312075e-03 -9.666541e-03
      [1674,] 0.45454545 0.63636364 1.00000000  5.493203e-03  7.152049e-03
      [1675,] 0.54545455 0.63636364 1.00000000 -6.610695e-03 -4.744296e-03
      [1676,] 0.63636364 0.63636364 1.00000000  4.116141e-03 -9.262513e-03
      [1677,] 0.72727273 0.63636364 1.00000000 -4.487776e-03 -5.978624e-03
      [1678,] 0.81818182 0.63636364 1.00000000  8.415479e-03 -9.971959e-03
      [1679,] 0.90909091 0.63636364 1.00000000 -2.784945e-03  9.969195e-03
      [1680,] 1.00000000 0.63636364 1.00000000 -4.283962e-03 -9.383352e-03
      [1681,] 0.00000000 0.72727273 1.00000000 -1.404238e-03 -4.596370e-03
      [1682,] 0.09090909 0.72727273 1.00000000  9.196774e-03  5.663406e-03
      [1683,] 0.18181818 0.72727273 1.00000000 -2.757855e-03 -5.134904e-03
      [1684,] 0.27272727 0.72727273 1.00000000  3.938986e-03 -6.847528e-03
      [1685,] 0.36363636 0.72727273 1.00000000  6.966994e-03 -9.045184e-03
      [1686,] 0.45454545 0.72727273 1.00000000  5.814768e-03  7.696430e-03
      [1687,] 0.54545455 0.72727273 1.00000000  2.742251e-03 -1.522068e-03
      [1688,] 0.63636364 0.72727273 1.00000000 -4.026530e-03  7.395455e-03
      [1689,] 0.72727273 0.72727273 1.00000000 -6.168054e-03 -6.280896e-03
      [1690,] 0.81818182 0.72727273 1.00000000 -7.736905e-03  3.946389e-03
      [1691,] 0.90909091 0.72727273 1.00000000  3.452651e-04 -8.295309e-03
      [1692,] 1.00000000 0.72727273 1.00000000  6.032109e-03 -9.557919e-03
      [1693,] 0.00000000 0.81818182 1.00000000  7.895923e-03 -9.181371e-03
      [1694,] 0.09090909 0.81818182 1.00000000  5.224800e-03 -3.712648e-03
      [1695,] 0.18181818 0.81818182 1.00000000  7.660326e-03 -6.911674e-03
      [1696,] 0.27272727 0.81818182 1.00000000  8.060702e-03  7.537608e-03
      [1697,] 0.36363636 0.81818182 1.00000000 -6.150429e-03 -3.662043e-03
      [1698,] 0.45454545 0.81818182 1.00000000  5.651128e-03 -9.292303e-03
      [1699,] 0.54545455 0.81818182 1.00000000  7.374462e-04 -6.164989e-03
      [1700,] 0.63636364 0.81818182 1.00000000  1.187464e-03  9.544814e-03
      [1701,] 0.72727273 0.81818182 1.00000000 -7.782446e-03 -8.556072e-03
      [1702,] 0.81818182 0.81818182 1.00000000 -9.830652e-03  6.055710e-03
      [1703,] 0.90909091 0.81818182 1.00000000  2.298624e-03  9.335329e-03
      [1704,] 1.00000000 0.81818182 1.00000000 -3.416932e-03 -8.424729e-03
      [1705,] 0.00000000 0.90909091 1.00000000  4.291821e-04  4.648450e-03
      [1706,] 0.09090909 0.90909091 1.00000000 -4.448861e-03  1.304070e-03
      [1707,] 0.18181818 0.90909091 1.00000000 -7.495962e-03 -5.454505e-03
      [1708,] 0.27272727 0.90909091 1.00000000 -5.873161e-03  4.939192e-03
      [1709,] 0.36363636 0.90909091 1.00000000 -4.904083e-03  5.463492e-03
      [1710,] 0.45454545 0.90909091 1.00000000 -3.723501e-03  5.917703e-03
      [1711,] 0.54545455 0.90909091 1.00000000  6.454152e-03  9.534715e-03
      [1712,] 0.63636364 0.90909091 1.00000000  3.396292e-03 -3.441850e-03
      [1713,] 0.72727273 0.90909091 1.00000000  8.105398e-03  4.973455e-03
      [1714,] 0.81818182 0.90909091 1.00000000 -1.859781e-03 -6.054568e-03
      [1715,] 0.90909091 0.90909091 1.00000000 -3.102750e-04  8.857937e-03
      [1716,] 1.00000000 0.90909091 1.00000000 -2.198128e-03 -8.725928e-03
      [1717,] 0.00000000 1.00000000 1.00000000  8.285061e-03  5.819579e-03
      [1718,] 0.09090909 1.00000000 1.00000000 -4.893654e-03  9.796202e-03
      [1719,] 0.18181818 1.00000000 1.00000000 -9.517211e-03 -9.447374e-03
      [1720,] 0.27272727 1.00000000 1.00000000 -9.302805e-05  1.474461e-04
      [1721,] 0.36363636 1.00000000 1.00000000 -9.492665e-03  3.242945e-03
      [1722,] 0.45454545 1.00000000 1.00000000  6.081180e-03  1.397690e-03
      [1723,] 0.54545455 1.00000000 1.00000000 -9.436660e-03 -2.539156e-03
      [1724,] 0.63636364 1.00000000 1.00000000  2.989624e-03 -4.150173e-03
      [1725,] 0.72727273 1.00000000 1.00000000 -8.443475e-04  7.936131e-03
      [1726,] 0.81818182 1.00000000 1.00000000  7.462067e-03 -2.298748e-03
      [1727,] 0.90909091 1.00000000 1.00000000 -8.667500e-03  5.050174e-03
      [1728,] 1.00000000 1.00000000 1.00000000 -1.135952e-03  7.939331e-03
      
      $n
      [1] 1728
      

---

    Code
      cube_3d(num_dims = 3, num_noise = 0)
    Output
      $df
                    Var1       Var2       Var3
         [1,] 0.00000000 0.00000000 0.00000000
         [2,] 0.09090909 0.00000000 0.00000000
         [3,] 0.18181818 0.00000000 0.00000000
         [4,] 0.27272727 0.00000000 0.00000000
         [5,] 0.36363636 0.00000000 0.00000000
         [6,] 0.45454545 0.00000000 0.00000000
         [7,] 0.54545455 0.00000000 0.00000000
         [8,] 0.63636364 0.00000000 0.00000000
         [9,] 0.72727273 0.00000000 0.00000000
        [10,] 0.81818182 0.00000000 0.00000000
        [11,] 0.90909091 0.00000000 0.00000000
        [12,] 1.00000000 0.00000000 0.00000000
        [13,] 0.00000000 0.09090909 0.00000000
        [14,] 0.09090909 0.09090909 0.00000000
        [15,] 0.18181818 0.09090909 0.00000000
        [16,] 0.27272727 0.09090909 0.00000000
        [17,] 0.36363636 0.09090909 0.00000000
        [18,] 0.45454545 0.09090909 0.00000000
        [19,] 0.54545455 0.09090909 0.00000000
        [20,] 0.63636364 0.09090909 0.00000000
        [21,] 0.72727273 0.09090909 0.00000000
        [22,] 0.81818182 0.09090909 0.00000000
        [23,] 0.90909091 0.09090909 0.00000000
        [24,] 1.00000000 0.09090909 0.00000000
        [25,] 0.00000000 0.18181818 0.00000000
        [26,] 0.09090909 0.18181818 0.00000000
        [27,] 0.18181818 0.18181818 0.00000000
        [28,] 0.27272727 0.18181818 0.00000000
        [29,] 0.36363636 0.18181818 0.00000000
        [30,] 0.45454545 0.18181818 0.00000000
        [31,] 0.54545455 0.18181818 0.00000000
        [32,] 0.63636364 0.18181818 0.00000000
        [33,] 0.72727273 0.18181818 0.00000000
        [34,] 0.81818182 0.18181818 0.00000000
        [35,] 0.90909091 0.18181818 0.00000000
        [36,] 1.00000000 0.18181818 0.00000000
        [37,] 0.00000000 0.27272727 0.00000000
        [38,] 0.09090909 0.27272727 0.00000000
        [39,] 0.18181818 0.27272727 0.00000000
        [40,] 0.27272727 0.27272727 0.00000000
        [41,] 0.36363636 0.27272727 0.00000000
        [42,] 0.45454545 0.27272727 0.00000000
        [43,] 0.54545455 0.27272727 0.00000000
        [44,] 0.63636364 0.27272727 0.00000000
        [45,] 0.72727273 0.27272727 0.00000000
        [46,] 0.81818182 0.27272727 0.00000000
        [47,] 0.90909091 0.27272727 0.00000000
        [48,] 1.00000000 0.27272727 0.00000000
        [49,] 0.00000000 0.36363636 0.00000000
        [50,] 0.09090909 0.36363636 0.00000000
        [51,] 0.18181818 0.36363636 0.00000000
        [52,] 0.27272727 0.36363636 0.00000000
        [53,] 0.36363636 0.36363636 0.00000000
        [54,] 0.45454545 0.36363636 0.00000000
        [55,] 0.54545455 0.36363636 0.00000000
        [56,] 0.63636364 0.36363636 0.00000000
        [57,] 0.72727273 0.36363636 0.00000000
        [58,] 0.81818182 0.36363636 0.00000000
        [59,] 0.90909091 0.36363636 0.00000000
        [60,] 1.00000000 0.36363636 0.00000000
        [61,] 0.00000000 0.45454545 0.00000000
        [62,] 0.09090909 0.45454545 0.00000000
        [63,] 0.18181818 0.45454545 0.00000000
        [64,] 0.27272727 0.45454545 0.00000000
        [65,] 0.36363636 0.45454545 0.00000000
        [66,] 0.45454545 0.45454545 0.00000000
        [67,] 0.54545455 0.45454545 0.00000000
        [68,] 0.63636364 0.45454545 0.00000000
        [69,] 0.72727273 0.45454545 0.00000000
        [70,] 0.81818182 0.45454545 0.00000000
        [71,] 0.90909091 0.45454545 0.00000000
        [72,] 1.00000000 0.45454545 0.00000000
        [73,] 0.00000000 0.54545455 0.00000000
        [74,] 0.09090909 0.54545455 0.00000000
        [75,] 0.18181818 0.54545455 0.00000000
        [76,] 0.27272727 0.54545455 0.00000000
        [77,] 0.36363636 0.54545455 0.00000000
        [78,] 0.45454545 0.54545455 0.00000000
        [79,] 0.54545455 0.54545455 0.00000000
        [80,] 0.63636364 0.54545455 0.00000000
        [81,] 0.72727273 0.54545455 0.00000000
        [82,] 0.81818182 0.54545455 0.00000000
        [83,] 0.90909091 0.54545455 0.00000000
        [84,] 1.00000000 0.54545455 0.00000000
        [85,] 0.00000000 0.63636364 0.00000000
        [86,] 0.09090909 0.63636364 0.00000000
        [87,] 0.18181818 0.63636364 0.00000000
        [88,] 0.27272727 0.63636364 0.00000000
        [89,] 0.36363636 0.63636364 0.00000000
        [90,] 0.45454545 0.63636364 0.00000000
        [91,] 0.54545455 0.63636364 0.00000000
        [92,] 0.63636364 0.63636364 0.00000000
        [93,] 0.72727273 0.63636364 0.00000000
        [94,] 0.81818182 0.63636364 0.00000000
        [95,] 0.90909091 0.63636364 0.00000000
        [96,] 1.00000000 0.63636364 0.00000000
        [97,] 0.00000000 0.72727273 0.00000000
        [98,] 0.09090909 0.72727273 0.00000000
        [99,] 0.18181818 0.72727273 0.00000000
       [100,] 0.27272727 0.72727273 0.00000000
       [101,] 0.36363636 0.72727273 0.00000000
       [102,] 0.45454545 0.72727273 0.00000000
       [103,] 0.54545455 0.72727273 0.00000000
       [104,] 0.63636364 0.72727273 0.00000000
       [105,] 0.72727273 0.72727273 0.00000000
       [106,] 0.81818182 0.72727273 0.00000000
       [107,] 0.90909091 0.72727273 0.00000000
       [108,] 1.00000000 0.72727273 0.00000000
       [109,] 0.00000000 0.81818182 0.00000000
       [110,] 0.09090909 0.81818182 0.00000000
       [111,] 0.18181818 0.81818182 0.00000000
       [112,] 0.27272727 0.81818182 0.00000000
       [113,] 0.36363636 0.81818182 0.00000000
       [114,] 0.45454545 0.81818182 0.00000000
       [115,] 0.54545455 0.81818182 0.00000000
       [116,] 0.63636364 0.81818182 0.00000000
       [117,] 0.72727273 0.81818182 0.00000000
       [118,] 0.81818182 0.81818182 0.00000000
       [119,] 0.90909091 0.81818182 0.00000000
       [120,] 1.00000000 0.81818182 0.00000000
       [121,] 0.00000000 0.90909091 0.00000000
       [122,] 0.09090909 0.90909091 0.00000000
       [123,] 0.18181818 0.90909091 0.00000000
       [124,] 0.27272727 0.90909091 0.00000000
       [125,] 0.36363636 0.90909091 0.00000000
       [126,] 0.45454545 0.90909091 0.00000000
       [127,] 0.54545455 0.90909091 0.00000000
       [128,] 0.63636364 0.90909091 0.00000000
       [129,] 0.72727273 0.90909091 0.00000000
       [130,] 0.81818182 0.90909091 0.00000000
       [131,] 0.90909091 0.90909091 0.00000000
       [132,] 1.00000000 0.90909091 0.00000000
       [133,] 0.00000000 1.00000000 0.00000000
       [134,] 0.09090909 1.00000000 0.00000000
       [135,] 0.18181818 1.00000000 0.00000000
       [136,] 0.27272727 1.00000000 0.00000000
       [137,] 0.36363636 1.00000000 0.00000000
       [138,] 0.45454545 1.00000000 0.00000000
       [139,] 0.54545455 1.00000000 0.00000000
       [140,] 0.63636364 1.00000000 0.00000000
       [141,] 0.72727273 1.00000000 0.00000000
       [142,] 0.81818182 1.00000000 0.00000000
       [143,] 0.90909091 1.00000000 0.00000000
       [144,] 1.00000000 1.00000000 0.00000000
       [145,] 0.00000000 0.00000000 0.09090909
       [146,] 0.09090909 0.00000000 0.09090909
       [147,] 0.18181818 0.00000000 0.09090909
       [148,] 0.27272727 0.00000000 0.09090909
       [149,] 0.36363636 0.00000000 0.09090909
       [150,] 0.45454545 0.00000000 0.09090909
       [151,] 0.54545455 0.00000000 0.09090909
       [152,] 0.63636364 0.00000000 0.09090909
       [153,] 0.72727273 0.00000000 0.09090909
       [154,] 0.81818182 0.00000000 0.09090909
       [155,] 0.90909091 0.00000000 0.09090909
       [156,] 1.00000000 0.00000000 0.09090909
       [157,] 0.00000000 0.09090909 0.09090909
       [158,] 0.09090909 0.09090909 0.09090909
       [159,] 0.18181818 0.09090909 0.09090909
       [160,] 0.27272727 0.09090909 0.09090909
       [161,] 0.36363636 0.09090909 0.09090909
       [162,] 0.45454545 0.09090909 0.09090909
       [163,] 0.54545455 0.09090909 0.09090909
       [164,] 0.63636364 0.09090909 0.09090909
       [165,] 0.72727273 0.09090909 0.09090909
       [166,] 0.81818182 0.09090909 0.09090909
       [167,] 0.90909091 0.09090909 0.09090909
       [168,] 1.00000000 0.09090909 0.09090909
       [169,] 0.00000000 0.18181818 0.09090909
       [170,] 0.09090909 0.18181818 0.09090909
       [171,] 0.18181818 0.18181818 0.09090909
       [172,] 0.27272727 0.18181818 0.09090909
       [173,] 0.36363636 0.18181818 0.09090909
       [174,] 0.45454545 0.18181818 0.09090909
       [175,] 0.54545455 0.18181818 0.09090909
       [176,] 0.63636364 0.18181818 0.09090909
       [177,] 0.72727273 0.18181818 0.09090909
       [178,] 0.81818182 0.18181818 0.09090909
       [179,] 0.90909091 0.18181818 0.09090909
       [180,] 1.00000000 0.18181818 0.09090909
       [181,] 0.00000000 0.27272727 0.09090909
       [182,] 0.09090909 0.27272727 0.09090909
       [183,] 0.18181818 0.27272727 0.09090909
       [184,] 0.27272727 0.27272727 0.09090909
       [185,] 0.36363636 0.27272727 0.09090909
       [186,] 0.45454545 0.27272727 0.09090909
       [187,] 0.54545455 0.27272727 0.09090909
       [188,] 0.63636364 0.27272727 0.09090909
       [189,] 0.72727273 0.27272727 0.09090909
       [190,] 0.81818182 0.27272727 0.09090909
       [191,] 0.90909091 0.27272727 0.09090909
       [192,] 1.00000000 0.27272727 0.09090909
       [193,] 0.00000000 0.36363636 0.09090909
       [194,] 0.09090909 0.36363636 0.09090909
       [195,] 0.18181818 0.36363636 0.09090909
       [196,] 0.27272727 0.36363636 0.09090909
       [197,] 0.36363636 0.36363636 0.09090909
       [198,] 0.45454545 0.36363636 0.09090909
       [199,] 0.54545455 0.36363636 0.09090909
       [200,] 0.63636364 0.36363636 0.09090909
       [201,] 0.72727273 0.36363636 0.09090909
       [202,] 0.81818182 0.36363636 0.09090909
       [203,] 0.90909091 0.36363636 0.09090909
       [204,] 1.00000000 0.36363636 0.09090909
       [205,] 0.00000000 0.45454545 0.09090909
       [206,] 0.09090909 0.45454545 0.09090909
       [207,] 0.18181818 0.45454545 0.09090909
       [208,] 0.27272727 0.45454545 0.09090909
       [209,] 0.36363636 0.45454545 0.09090909
       [210,] 0.45454545 0.45454545 0.09090909
       [211,] 0.54545455 0.45454545 0.09090909
       [212,] 0.63636364 0.45454545 0.09090909
       [213,] 0.72727273 0.45454545 0.09090909
       [214,] 0.81818182 0.45454545 0.09090909
       [215,] 0.90909091 0.45454545 0.09090909
       [216,] 1.00000000 0.45454545 0.09090909
       [217,] 0.00000000 0.54545455 0.09090909
       [218,] 0.09090909 0.54545455 0.09090909
       [219,] 0.18181818 0.54545455 0.09090909
       [220,] 0.27272727 0.54545455 0.09090909
       [221,] 0.36363636 0.54545455 0.09090909
       [222,] 0.45454545 0.54545455 0.09090909
       [223,] 0.54545455 0.54545455 0.09090909
       [224,] 0.63636364 0.54545455 0.09090909
       [225,] 0.72727273 0.54545455 0.09090909
       [226,] 0.81818182 0.54545455 0.09090909
       [227,] 0.90909091 0.54545455 0.09090909
       [228,] 1.00000000 0.54545455 0.09090909
       [229,] 0.00000000 0.63636364 0.09090909
       [230,] 0.09090909 0.63636364 0.09090909
       [231,] 0.18181818 0.63636364 0.09090909
       [232,] 0.27272727 0.63636364 0.09090909
       [233,] 0.36363636 0.63636364 0.09090909
       [234,] 0.45454545 0.63636364 0.09090909
       [235,] 0.54545455 0.63636364 0.09090909
       [236,] 0.63636364 0.63636364 0.09090909
       [237,] 0.72727273 0.63636364 0.09090909
       [238,] 0.81818182 0.63636364 0.09090909
       [239,] 0.90909091 0.63636364 0.09090909
       [240,] 1.00000000 0.63636364 0.09090909
       [241,] 0.00000000 0.72727273 0.09090909
       [242,] 0.09090909 0.72727273 0.09090909
       [243,] 0.18181818 0.72727273 0.09090909
       [244,] 0.27272727 0.72727273 0.09090909
       [245,] 0.36363636 0.72727273 0.09090909
       [246,] 0.45454545 0.72727273 0.09090909
       [247,] 0.54545455 0.72727273 0.09090909
       [248,] 0.63636364 0.72727273 0.09090909
       [249,] 0.72727273 0.72727273 0.09090909
       [250,] 0.81818182 0.72727273 0.09090909
       [251,] 0.90909091 0.72727273 0.09090909
       [252,] 1.00000000 0.72727273 0.09090909
       [253,] 0.00000000 0.81818182 0.09090909
       [254,] 0.09090909 0.81818182 0.09090909
       [255,] 0.18181818 0.81818182 0.09090909
       [256,] 0.27272727 0.81818182 0.09090909
       [257,] 0.36363636 0.81818182 0.09090909
       [258,] 0.45454545 0.81818182 0.09090909
       [259,] 0.54545455 0.81818182 0.09090909
       [260,] 0.63636364 0.81818182 0.09090909
       [261,] 0.72727273 0.81818182 0.09090909
       [262,] 0.81818182 0.81818182 0.09090909
       [263,] 0.90909091 0.81818182 0.09090909
       [264,] 1.00000000 0.81818182 0.09090909
       [265,] 0.00000000 0.90909091 0.09090909
       [266,] 0.09090909 0.90909091 0.09090909
       [267,] 0.18181818 0.90909091 0.09090909
       [268,] 0.27272727 0.90909091 0.09090909
       [269,] 0.36363636 0.90909091 0.09090909
       [270,] 0.45454545 0.90909091 0.09090909
       [271,] 0.54545455 0.90909091 0.09090909
       [272,] 0.63636364 0.90909091 0.09090909
       [273,] 0.72727273 0.90909091 0.09090909
       [274,] 0.81818182 0.90909091 0.09090909
       [275,] 0.90909091 0.90909091 0.09090909
       [276,] 1.00000000 0.90909091 0.09090909
       [277,] 0.00000000 1.00000000 0.09090909
       [278,] 0.09090909 1.00000000 0.09090909
       [279,] 0.18181818 1.00000000 0.09090909
       [280,] 0.27272727 1.00000000 0.09090909
       [281,] 0.36363636 1.00000000 0.09090909
       [282,] 0.45454545 1.00000000 0.09090909
       [283,] 0.54545455 1.00000000 0.09090909
       [284,] 0.63636364 1.00000000 0.09090909
       [285,] 0.72727273 1.00000000 0.09090909
       [286,] 0.81818182 1.00000000 0.09090909
       [287,] 0.90909091 1.00000000 0.09090909
       [288,] 1.00000000 1.00000000 0.09090909
       [289,] 0.00000000 0.00000000 0.18181818
       [290,] 0.09090909 0.00000000 0.18181818
       [291,] 0.18181818 0.00000000 0.18181818
       [292,] 0.27272727 0.00000000 0.18181818
       [293,] 0.36363636 0.00000000 0.18181818
       [294,] 0.45454545 0.00000000 0.18181818
       [295,] 0.54545455 0.00000000 0.18181818
       [296,] 0.63636364 0.00000000 0.18181818
       [297,] 0.72727273 0.00000000 0.18181818
       [298,] 0.81818182 0.00000000 0.18181818
       [299,] 0.90909091 0.00000000 0.18181818
       [300,] 1.00000000 0.00000000 0.18181818
       [301,] 0.00000000 0.09090909 0.18181818
       [302,] 0.09090909 0.09090909 0.18181818
       [303,] 0.18181818 0.09090909 0.18181818
       [304,] 0.27272727 0.09090909 0.18181818
       [305,] 0.36363636 0.09090909 0.18181818
       [306,] 0.45454545 0.09090909 0.18181818
       [307,] 0.54545455 0.09090909 0.18181818
       [308,] 0.63636364 0.09090909 0.18181818
       [309,] 0.72727273 0.09090909 0.18181818
       [310,] 0.81818182 0.09090909 0.18181818
       [311,] 0.90909091 0.09090909 0.18181818
       [312,] 1.00000000 0.09090909 0.18181818
       [313,] 0.00000000 0.18181818 0.18181818
       [314,] 0.09090909 0.18181818 0.18181818
       [315,] 0.18181818 0.18181818 0.18181818
       [316,] 0.27272727 0.18181818 0.18181818
       [317,] 0.36363636 0.18181818 0.18181818
       [318,] 0.45454545 0.18181818 0.18181818
       [319,] 0.54545455 0.18181818 0.18181818
       [320,] 0.63636364 0.18181818 0.18181818
       [321,] 0.72727273 0.18181818 0.18181818
       [322,] 0.81818182 0.18181818 0.18181818
       [323,] 0.90909091 0.18181818 0.18181818
       [324,] 1.00000000 0.18181818 0.18181818
       [325,] 0.00000000 0.27272727 0.18181818
       [326,] 0.09090909 0.27272727 0.18181818
       [327,] 0.18181818 0.27272727 0.18181818
       [328,] 0.27272727 0.27272727 0.18181818
       [329,] 0.36363636 0.27272727 0.18181818
       [330,] 0.45454545 0.27272727 0.18181818
       [331,] 0.54545455 0.27272727 0.18181818
       [332,] 0.63636364 0.27272727 0.18181818
       [333,] 0.72727273 0.27272727 0.18181818
       [334,] 0.81818182 0.27272727 0.18181818
       [335,] 0.90909091 0.27272727 0.18181818
       [336,] 1.00000000 0.27272727 0.18181818
       [337,] 0.00000000 0.36363636 0.18181818
       [338,] 0.09090909 0.36363636 0.18181818
       [339,] 0.18181818 0.36363636 0.18181818
       [340,] 0.27272727 0.36363636 0.18181818
       [341,] 0.36363636 0.36363636 0.18181818
       [342,] 0.45454545 0.36363636 0.18181818
       [343,] 0.54545455 0.36363636 0.18181818
       [344,] 0.63636364 0.36363636 0.18181818
       [345,] 0.72727273 0.36363636 0.18181818
       [346,] 0.81818182 0.36363636 0.18181818
       [347,] 0.90909091 0.36363636 0.18181818
       [348,] 1.00000000 0.36363636 0.18181818
       [349,] 0.00000000 0.45454545 0.18181818
       [350,] 0.09090909 0.45454545 0.18181818
       [351,] 0.18181818 0.45454545 0.18181818
       [352,] 0.27272727 0.45454545 0.18181818
       [353,] 0.36363636 0.45454545 0.18181818
       [354,] 0.45454545 0.45454545 0.18181818
       [355,] 0.54545455 0.45454545 0.18181818
       [356,] 0.63636364 0.45454545 0.18181818
       [357,] 0.72727273 0.45454545 0.18181818
       [358,] 0.81818182 0.45454545 0.18181818
       [359,] 0.90909091 0.45454545 0.18181818
       [360,] 1.00000000 0.45454545 0.18181818
       [361,] 0.00000000 0.54545455 0.18181818
       [362,] 0.09090909 0.54545455 0.18181818
       [363,] 0.18181818 0.54545455 0.18181818
       [364,] 0.27272727 0.54545455 0.18181818
       [365,] 0.36363636 0.54545455 0.18181818
       [366,] 0.45454545 0.54545455 0.18181818
       [367,] 0.54545455 0.54545455 0.18181818
       [368,] 0.63636364 0.54545455 0.18181818
       [369,] 0.72727273 0.54545455 0.18181818
       [370,] 0.81818182 0.54545455 0.18181818
       [371,] 0.90909091 0.54545455 0.18181818
       [372,] 1.00000000 0.54545455 0.18181818
       [373,] 0.00000000 0.63636364 0.18181818
       [374,] 0.09090909 0.63636364 0.18181818
       [375,] 0.18181818 0.63636364 0.18181818
       [376,] 0.27272727 0.63636364 0.18181818
       [377,] 0.36363636 0.63636364 0.18181818
       [378,] 0.45454545 0.63636364 0.18181818
       [379,] 0.54545455 0.63636364 0.18181818
       [380,] 0.63636364 0.63636364 0.18181818
       [381,] 0.72727273 0.63636364 0.18181818
       [382,] 0.81818182 0.63636364 0.18181818
       [383,] 0.90909091 0.63636364 0.18181818
       [384,] 1.00000000 0.63636364 0.18181818
       [385,] 0.00000000 0.72727273 0.18181818
       [386,] 0.09090909 0.72727273 0.18181818
       [387,] 0.18181818 0.72727273 0.18181818
       [388,] 0.27272727 0.72727273 0.18181818
       [389,] 0.36363636 0.72727273 0.18181818
       [390,] 0.45454545 0.72727273 0.18181818
       [391,] 0.54545455 0.72727273 0.18181818
       [392,] 0.63636364 0.72727273 0.18181818
       [393,] 0.72727273 0.72727273 0.18181818
       [394,] 0.81818182 0.72727273 0.18181818
       [395,] 0.90909091 0.72727273 0.18181818
       [396,] 1.00000000 0.72727273 0.18181818
       [397,] 0.00000000 0.81818182 0.18181818
       [398,] 0.09090909 0.81818182 0.18181818
       [399,] 0.18181818 0.81818182 0.18181818
       [400,] 0.27272727 0.81818182 0.18181818
       [401,] 0.36363636 0.81818182 0.18181818
       [402,] 0.45454545 0.81818182 0.18181818
       [403,] 0.54545455 0.81818182 0.18181818
       [404,] 0.63636364 0.81818182 0.18181818
       [405,] 0.72727273 0.81818182 0.18181818
       [406,] 0.81818182 0.81818182 0.18181818
       [407,] 0.90909091 0.81818182 0.18181818
       [408,] 1.00000000 0.81818182 0.18181818
       [409,] 0.00000000 0.90909091 0.18181818
       [410,] 0.09090909 0.90909091 0.18181818
       [411,] 0.18181818 0.90909091 0.18181818
       [412,] 0.27272727 0.90909091 0.18181818
       [413,] 0.36363636 0.90909091 0.18181818
       [414,] 0.45454545 0.90909091 0.18181818
       [415,] 0.54545455 0.90909091 0.18181818
       [416,] 0.63636364 0.90909091 0.18181818
       [417,] 0.72727273 0.90909091 0.18181818
       [418,] 0.81818182 0.90909091 0.18181818
       [419,] 0.90909091 0.90909091 0.18181818
       [420,] 1.00000000 0.90909091 0.18181818
       [421,] 0.00000000 1.00000000 0.18181818
       [422,] 0.09090909 1.00000000 0.18181818
       [423,] 0.18181818 1.00000000 0.18181818
       [424,] 0.27272727 1.00000000 0.18181818
       [425,] 0.36363636 1.00000000 0.18181818
       [426,] 0.45454545 1.00000000 0.18181818
       [427,] 0.54545455 1.00000000 0.18181818
       [428,] 0.63636364 1.00000000 0.18181818
       [429,] 0.72727273 1.00000000 0.18181818
       [430,] 0.81818182 1.00000000 0.18181818
       [431,] 0.90909091 1.00000000 0.18181818
       [432,] 1.00000000 1.00000000 0.18181818
       [433,] 0.00000000 0.00000000 0.27272727
       [434,] 0.09090909 0.00000000 0.27272727
       [435,] 0.18181818 0.00000000 0.27272727
       [436,] 0.27272727 0.00000000 0.27272727
       [437,] 0.36363636 0.00000000 0.27272727
       [438,] 0.45454545 0.00000000 0.27272727
       [439,] 0.54545455 0.00000000 0.27272727
       [440,] 0.63636364 0.00000000 0.27272727
       [441,] 0.72727273 0.00000000 0.27272727
       [442,] 0.81818182 0.00000000 0.27272727
       [443,] 0.90909091 0.00000000 0.27272727
       [444,] 1.00000000 0.00000000 0.27272727
       [445,] 0.00000000 0.09090909 0.27272727
       [446,] 0.09090909 0.09090909 0.27272727
       [447,] 0.18181818 0.09090909 0.27272727
       [448,] 0.27272727 0.09090909 0.27272727
       [449,] 0.36363636 0.09090909 0.27272727
       [450,] 0.45454545 0.09090909 0.27272727
       [451,] 0.54545455 0.09090909 0.27272727
       [452,] 0.63636364 0.09090909 0.27272727
       [453,] 0.72727273 0.09090909 0.27272727
       [454,] 0.81818182 0.09090909 0.27272727
       [455,] 0.90909091 0.09090909 0.27272727
       [456,] 1.00000000 0.09090909 0.27272727
       [457,] 0.00000000 0.18181818 0.27272727
       [458,] 0.09090909 0.18181818 0.27272727
       [459,] 0.18181818 0.18181818 0.27272727
       [460,] 0.27272727 0.18181818 0.27272727
       [461,] 0.36363636 0.18181818 0.27272727
       [462,] 0.45454545 0.18181818 0.27272727
       [463,] 0.54545455 0.18181818 0.27272727
       [464,] 0.63636364 0.18181818 0.27272727
       [465,] 0.72727273 0.18181818 0.27272727
       [466,] 0.81818182 0.18181818 0.27272727
       [467,] 0.90909091 0.18181818 0.27272727
       [468,] 1.00000000 0.18181818 0.27272727
       [469,] 0.00000000 0.27272727 0.27272727
       [470,] 0.09090909 0.27272727 0.27272727
       [471,] 0.18181818 0.27272727 0.27272727
       [472,] 0.27272727 0.27272727 0.27272727
       [473,] 0.36363636 0.27272727 0.27272727
       [474,] 0.45454545 0.27272727 0.27272727
       [475,] 0.54545455 0.27272727 0.27272727
       [476,] 0.63636364 0.27272727 0.27272727
       [477,] 0.72727273 0.27272727 0.27272727
       [478,] 0.81818182 0.27272727 0.27272727
       [479,] 0.90909091 0.27272727 0.27272727
       [480,] 1.00000000 0.27272727 0.27272727
       [481,] 0.00000000 0.36363636 0.27272727
       [482,] 0.09090909 0.36363636 0.27272727
       [483,] 0.18181818 0.36363636 0.27272727
       [484,] 0.27272727 0.36363636 0.27272727
       [485,] 0.36363636 0.36363636 0.27272727
       [486,] 0.45454545 0.36363636 0.27272727
       [487,] 0.54545455 0.36363636 0.27272727
       [488,] 0.63636364 0.36363636 0.27272727
       [489,] 0.72727273 0.36363636 0.27272727
       [490,] 0.81818182 0.36363636 0.27272727
       [491,] 0.90909091 0.36363636 0.27272727
       [492,] 1.00000000 0.36363636 0.27272727
       [493,] 0.00000000 0.45454545 0.27272727
       [494,] 0.09090909 0.45454545 0.27272727
       [495,] 0.18181818 0.45454545 0.27272727
       [496,] 0.27272727 0.45454545 0.27272727
       [497,] 0.36363636 0.45454545 0.27272727
       [498,] 0.45454545 0.45454545 0.27272727
       [499,] 0.54545455 0.45454545 0.27272727
       [500,] 0.63636364 0.45454545 0.27272727
       [501,] 0.72727273 0.45454545 0.27272727
       [502,] 0.81818182 0.45454545 0.27272727
       [503,] 0.90909091 0.45454545 0.27272727
       [504,] 1.00000000 0.45454545 0.27272727
       [505,] 0.00000000 0.54545455 0.27272727
       [506,] 0.09090909 0.54545455 0.27272727
       [507,] 0.18181818 0.54545455 0.27272727
       [508,] 0.27272727 0.54545455 0.27272727
       [509,] 0.36363636 0.54545455 0.27272727
       [510,] 0.45454545 0.54545455 0.27272727
       [511,] 0.54545455 0.54545455 0.27272727
       [512,] 0.63636364 0.54545455 0.27272727
       [513,] 0.72727273 0.54545455 0.27272727
       [514,] 0.81818182 0.54545455 0.27272727
       [515,] 0.90909091 0.54545455 0.27272727
       [516,] 1.00000000 0.54545455 0.27272727
       [517,] 0.00000000 0.63636364 0.27272727
       [518,] 0.09090909 0.63636364 0.27272727
       [519,] 0.18181818 0.63636364 0.27272727
       [520,] 0.27272727 0.63636364 0.27272727
       [521,] 0.36363636 0.63636364 0.27272727
       [522,] 0.45454545 0.63636364 0.27272727
       [523,] 0.54545455 0.63636364 0.27272727
       [524,] 0.63636364 0.63636364 0.27272727
       [525,] 0.72727273 0.63636364 0.27272727
       [526,] 0.81818182 0.63636364 0.27272727
       [527,] 0.90909091 0.63636364 0.27272727
       [528,] 1.00000000 0.63636364 0.27272727
       [529,] 0.00000000 0.72727273 0.27272727
       [530,] 0.09090909 0.72727273 0.27272727
       [531,] 0.18181818 0.72727273 0.27272727
       [532,] 0.27272727 0.72727273 0.27272727
       [533,] 0.36363636 0.72727273 0.27272727
       [534,] 0.45454545 0.72727273 0.27272727
       [535,] 0.54545455 0.72727273 0.27272727
       [536,] 0.63636364 0.72727273 0.27272727
       [537,] 0.72727273 0.72727273 0.27272727
       [538,] 0.81818182 0.72727273 0.27272727
       [539,] 0.90909091 0.72727273 0.27272727
       [540,] 1.00000000 0.72727273 0.27272727
       [541,] 0.00000000 0.81818182 0.27272727
       [542,] 0.09090909 0.81818182 0.27272727
       [543,] 0.18181818 0.81818182 0.27272727
       [544,] 0.27272727 0.81818182 0.27272727
       [545,] 0.36363636 0.81818182 0.27272727
       [546,] 0.45454545 0.81818182 0.27272727
       [547,] 0.54545455 0.81818182 0.27272727
       [548,] 0.63636364 0.81818182 0.27272727
       [549,] 0.72727273 0.81818182 0.27272727
       [550,] 0.81818182 0.81818182 0.27272727
       [551,] 0.90909091 0.81818182 0.27272727
       [552,] 1.00000000 0.81818182 0.27272727
       [553,] 0.00000000 0.90909091 0.27272727
       [554,] 0.09090909 0.90909091 0.27272727
       [555,] 0.18181818 0.90909091 0.27272727
       [556,] 0.27272727 0.90909091 0.27272727
       [557,] 0.36363636 0.90909091 0.27272727
       [558,] 0.45454545 0.90909091 0.27272727
       [559,] 0.54545455 0.90909091 0.27272727
       [560,] 0.63636364 0.90909091 0.27272727
       [561,] 0.72727273 0.90909091 0.27272727
       [562,] 0.81818182 0.90909091 0.27272727
       [563,] 0.90909091 0.90909091 0.27272727
       [564,] 1.00000000 0.90909091 0.27272727
       [565,] 0.00000000 1.00000000 0.27272727
       [566,] 0.09090909 1.00000000 0.27272727
       [567,] 0.18181818 1.00000000 0.27272727
       [568,] 0.27272727 1.00000000 0.27272727
       [569,] 0.36363636 1.00000000 0.27272727
       [570,] 0.45454545 1.00000000 0.27272727
       [571,] 0.54545455 1.00000000 0.27272727
       [572,] 0.63636364 1.00000000 0.27272727
       [573,] 0.72727273 1.00000000 0.27272727
       [574,] 0.81818182 1.00000000 0.27272727
       [575,] 0.90909091 1.00000000 0.27272727
       [576,] 1.00000000 1.00000000 0.27272727
       [577,] 0.00000000 0.00000000 0.36363636
       [578,] 0.09090909 0.00000000 0.36363636
       [579,] 0.18181818 0.00000000 0.36363636
       [580,] 0.27272727 0.00000000 0.36363636
       [581,] 0.36363636 0.00000000 0.36363636
       [582,] 0.45454545 0.00000000 0.36363636
       [583,] 0.54545455 0.00000000 0.36363636
       [584,] 0.63636364 0.00000000 0.36363636
       [585,] 0.72727273 0.00000000 0.36363636
       [586,] 0.81818182 0.00000000 0.36363636
       [587,] 0.90909091 0.00000000 0.36363636
       [588,] 1.00000000 0.00000000 0.36363636
       [589,] 0.00000000 0.09090909 0.36363636
       [590,] 0.09090909 0.09090909 0.36363636
       [591,] 0.18181818 0.09090909 0.36363636
       [592,] 0.27272727 0.09090909 0.36363636
       [593,] 0.36363636 0.09090909 0.36363636
       [594,] 0.45454545 0.09090909 0.36363636
       [595,] 0.54545455 0.09090909 0.36363636
       [596,] 0.63636364 0.09090909 0.36363636
       [597,] 0.72727273 0.09090909 0.36363636
       [598,] 0.81818182 0.09090909 0.36363636
       [599,] 0.90909091 0.09090909 0.36363636
       [600,] 1.00000000 0.09090909 0.36363636
       [601,] 0.00000000 0.18181818 0.36363636
       [602,] 0.09090909 0.18181818 0.36363636
       [603,] 0.18181818 0.18181818 0.36363636
       [604,] 0.27272727 0.18181818 0.36363636
       [605,] 0.36363636 0.18181818 0.36363636
       [606,] 0.45454545 0.18181818 0.36363636
       [607,] 0.54545455 0.18181818 0.36363636
       [608,] 0.63636364 0.18181818 0.36363636
       [609,] 0.72727273 0.18181818 0.36363636
       [610,] 0.81818182 0.18181818 0.36363636
       [611,] 0.90909091 0.18181818 0.36363636
       [612,] 1.00000000 0.18181818 0.36363636
       [613,] 0.00000000 0.27272727 0.36363636
       [614,] 0.09090909 0.27272727 0.36363636
       [615,] 0.18181818 0.27272727 0.36363636
       [616,] 0.27272727 0.27272727 0.36363636
       [617,] 0.36363636 0.27272727 0.36363636
       [618,] 0.45454545 0.27272727 0.36363636
       [619,] 0.54545455 0.27272727 0.36363636
       [620,] 0.63636364 0.27272727 0.36363636
       [621,] 0.72727273 0.27272727 0.36363636
       [622,] 0.81818182 0.27272727 0.36363636
       [623,] 0.90909091 0.27272727 0.36363636
       [624,] 1.00000000 0.27272727 0.36363636
       [625,] 0.00000000 0.36363636 0.36363636
       [626,] 0.09090909 0.36363636 0.36363636
       [627,] 0.18181818 0.36363636 0.36363636
       [628,] 0.27272727 0.36363636 0.36363636
       [629,] 0.36363636 0.36363636 0.36363636
       [630,] 0.45454545 0.36363636 0.36363636
       [631,] 0.54545455 0.36363636 0.36363636
       [632,] 0.63636364 0.36363636 0.36363636
       [633,] 0.72727273 0.36363636 0.36363636
       [634,] 0.81818182 0.36363636 0.36363636
       [635,] 0.90909091 0.36363636 0.36363636
       [636,] 1.00000000 0.36363636 0.36363636
       [637,] 0.00000000 0.45454545 0.36363636
       [638,] 0.09090909 0.45454545 0.36363636
       [639,] 0.18181818 0.45454545 0.36363636
       [640,] 0.27272727 0.45454545 0.36363636
       [641,] 0.36363636 0.45454545 0.36363636
       [642,] 0.45454545 0.45454545 0.36363636
       [643,] 0.54545455 0.45454545 0.36363636
       [644,] 0.63636364 0.45454545 0.36363636
       [645,] 0.72727273 0.45454545 0.36363636
       [646,] 0.81818182 0.45454545 0.36363636
       [647,] 0.90909091 0.45454545 0.36363636
       [648,] 1.00000000 0.45454545 0.36363636
       [649,] 0.00000000 0.54545455 0.36363636
       [650,] 0.09090909 0.54545455 0.36363636
       [651,] 0.18181818 0.54545455 0.36363636
       [652,] 0.27272727 0.54545455 0.36363636
       [653,] 0.36363636 0.54545455 0.36363636
       [654,] 0.45454545 0.54545455 0.36363636
       [655,] 0.54545455 0.54545455 0.36363636
       [656,] 0.63636364 0.54545455 0.36363636
       [657,] 0.72727273 0.54545455 0.36363636
       [658,] 0.81818182 0.54545455 0.36363636
       [659,] 0.90909091 0.54545455 0.36363636
       [660,] 1.00000000 0.54545455 0.36363636
       [661,] 0.00000000 0.63636364 0.36363636
       [662,] 0.09090909 0.63636364 0.36363636
       [663,] 0.18181818 0.63636364 0.36363636
       [664,] 0.27272727 0.63636364 0.36363636
       [665,] 0.36363636 0.63636364 0.36363636
       [666,] 0.45454545 0.63636364 0.36363636
       [667,] 0.54545455 0.63636364 0.36363636
       [668,] 0.63636364 0.63636364 0.36363636
       [669,] 0.72727273 0.63636364 0.36363636
       [670,] 0.81818182 0.63636364 0.36363636
       [671,] 0.90909091 0.63636364 0.36363636
       [672,] 1.00000000 0.63636364 0.36363636
       [673,] 0.00000000 0.72727273 0.36363636
       [674,] 0.09090909 0.72727273 0.36363636
       [675,] 0.18181818 0.72727273 0.36363636
       [676,] 0.27272727 0.72727273 0.36363636
       [677,] 0.36363636 0.72727273 0.36363636
       [678,] 0.45454545 0.72727273 0.36363636
       [679,] 0.54545455 0.72727273 0.36363636
       [680,] 0.63636364 0.72727273 0.36363636
       [681,] 0.72727273 0.72727273 0.36363636
       [682,] 0.81818182 0.72727273 0.36363636
       [683,] 0.90909091 0.72727273 0.36363636
       [684,] 1.00000000 0.72727273 0.36363636
       [685,] 0.00000000 0.81818182 0.36363636
       [686,] 0.09090909 0.81818182 0.36363636
       [687,] 0.18181818 0.81818182 0.36363636
       [688,] 0.27272727 0.81818182 0.36363636
       [689,] 0.36363636 0.81818182 0.36363636
       [690,] 0.45454545 0.81818182 0.36363636
       [691,] 0.54545455 0.81818182 0.36363636
       [692,] 0.63636364 0.81818182 0.36363636
       [693,] 0.72727273 0.81818182 0.36363636
       [694,] 0.81818182 0.81818182 0.36363636
       [695,] 0.90909091 0.81818182 0.36363636
       [696,] 1.00000000 0.81818182 0.36363636
       [697,] 0.00000000 0.90909091 0.36363636
       [698,] 0.09090909 0.90909091 0.36363636
       [699,] 0.18181818 0.90909091 0.36363636
       [700,] 0.27272727 0.90909091 0.36363636
       [701,] 0.36363636 0.90909091 0.36363636
       [702,] 0.45454545 0.90909091 0.36363636
       [703,] 0.54545455 0.90909091 0.36363636
       [704,] 0.63636364 0.90909091 0.36363636
       [705,] 0.72727273 0.90909091 0.36363636
       [706,] 0.81818182 0.90909091 0.36363636
       [707,] 0.90909091 0.90909091 0.36363636
       [708,] 1.00000000 0.90909091 0.36363636
       [709,] 0.00000000 1.00000000 0.36363636
       [710,] 0.09090909 1.00000000 0.36363636
       [711,] 0.18181818 1.00000000 0.36363636
       [712,] 0.27272727 1.00000000 0.36363636
       [713,] 0.36363636 1.00000000 0.36363636
       [714,] 0.45454545 1.00000000 0.36363636
       [715,] 0.54545455 1.00000000 0.36363636
       [716,] 0.63636364 1.00000000 0.36363636
       [717,] 0.72727273 1.00000000 0.36363636
       [718,] 0.81818182 1.00000000 0.36363636
       [719,] 0.90909091 1.00000000 0.36363636
       [720,] 1.00000000 1.00000000 0.36363636
       [721,] 0.00000000 0.00000000 0.45454545
       [722,] 0.09090909 0.00000000 0.45454545
       [723,] 0.18181818 0.00000000 0.45454545
       [724,] 0.27272727 0.00000000 0.45454545
       [725,] 0.36363636 0.00000000 0.45454545
       [726,] 0.45454545 0.00000000 0.45454545
       [727,] 0.54545455 0.00000000 0.45454545
       [728,] 0.63636364 0.00000000 0.45454545
       [729,] 0.72727273 0.00000000 0.45454545
       [730,] 0.81818182 0.00000000 0.45454545
       [731,] 0.90909091 0.00000000 0.45454545
       [732,] 1.00000000 0.00000000 0.45454545
       [733,] 0.00000000 0.09090909 0.45454545
       [734,] 0.09090909 0.09090909 0.45454545
       [735,] 0.18181818 0.09090909 0.45454545
       [736,] 0.27272727 0.09090909 0.45454545
       [737,] 0.36363636 0.09090909 0.45454545
       [738,] 0.45454545 0.09090909 0.45454545
       [739,] 0.54545455 0.09090909 0.45454545
       [740,] 0.63636364 0.09090909 0.45454545
       [741,] 0.72727273 0.09090909 0.45454545
       [742,] 0.81818182 0.09090909 0.45454545
       [743,] 0.90909091 0.09090909 0.45454545
       [744,] 1.00000000 0.09090909 0.45454545
       [745,] 0.00000000 0.18181818 0.45454545
       [746,] 0.09090909 0.18181818 0.45454545
       [747,] 0.18181818 0.18181818 0.45454545
       [748,] 0.27272727 0.18181818 0.45454545
       [749,] 0.36363636 0.18181818 0.45454545
       [750,] 0.45454545 0.18181818 0.45454545
       [751,] 0.54545455 0.18181818 0.45454545
       [752,] 0.63636364 0.18181818 0.45454545
       [753,] 0.72727273 0.18181818 0.45454545
       [754,] 0.81818182 0.18181818 0.45454545
       [755,] 0.90909091 0.18181818 0.45454545
       [756,] 1.00000000 0.18181818 0.45454545
       [757,] 0.00000000 0.27272727 0.45454545
       [758,] 0.09090909 0.27272727 0.45454545
       [759,] 0.18181818 0.27272727 0.45454545
       [760,] 0.27272727 0.27272727 0.45454545
       [761,] 0.36363636 0.27272727 0.45454545
       [762,] 0.45454545 0.27272727 0.45454545
       [763,] 0.54545455 0.27272727 0.45454545
       [764,] 0.63636364 0.27272727 0.45454545
       [765,] 0.72727273 0.27272727 0.45454545
       [766,] 0.81818182 0.27272727 0.45454545
       [767,] 0.90909091 0.27272727 0.45454545
       [768,] 1.00000000 0.27272727 0.45454545
       [769,] 0.00000000 0.36363636 0.45454545
       [770,] 0.09090909 0.36363636 0.45454545
       [771,] 0.18181818 0.36363636 0.45454545
       [772,] 0.27272727 0.36363636 0.45454545
       [773,] 0.36363636 0.36363636 0.45454545
       [774,] 0.45454545 0.36363636 0.45454545
       [775,] 0.54545455 0.36363636 0.45454545
       [776,] 0.63636364 0.36363636 0.45454545
       [777,] 0.72727273 0.36363636 0.45454545
       [778,] 0.81818182 0.36363636 0.45454545
       [779,] 0.90909091 0.36363636 0.45454545
       [780,] 1.00000000 0.36363636 0.45454545
       [781,] 0.00000000 0.45454545 0.45454545
       [782,] 0.09090909 0.45454545 0.45454545
       [783,] 0.18181818 0.45454545 0.45454545
       [784,] 0.27272727 0.45454545 0.45454545
       [785,] 0.36363636 0.45454545 0.45454545
       [786,] 0.45454545 0.45454545 0.45454545
       [787,] 0.54545455 0.45454545 0.45454545
       [788,] 0.63636364 0.45454545 0.45454545
       [789,] 0.72727273 0.45454545 0.45454545
       [790,] 0.81818182 0.45454545 0.45454545
       [791,] 0.90909091 0.45454545 0.45454545
       [792,] 1.00000000 0.45454545 0.45454545
       [793,] 0.00000000 0.54545455 0.45454545
       [794,] 0.09090909 0.54545455 0.45454545
       [795,] 0.18181818 0.54545455 0.45454545
       [796,] 0.27272727 0.54545455 0.45454545
       [797,] 0.36363636 0.54545455 0.45454545
       [798,] 0.45454545 0.54545455 0.45454545
       [799,] 0.54545455 0.54545455 0.45454545
       [800,] 0.63636364 0.54545455 0.45454545
       [801,] 0.72727273 0.54545455 0.45454545
       [802,] 0.81818182 0.54545455 0.45454545
       [803,] 0.90909091 0.54545455 0.45454545
       [804,] 1.00000000 0.54545455 0.45454545
       [805,] 0.00000000 0.63636364 0.45454545
       [806,] 0.09090909 0.63636364 0.45454545
       [807,] 0.18181818 0.63636364 0.45454545
       [808,] 0.27272727 0.63636364 0.45454545
       [809,] 0.36363636 0.63636364 0.45454545
       [810,] 0.45454545 0.63636364 0.45454545
       [811,] 0.54545455 0.63636364 0.45454545
       [812,] 0.63636364 0.63636364 0.45454545
       [813,] 0.72727273 0.63636364 0.45454545
       [814,] 0.81818182 0.63636364 0.45454545
       [815,] 0.90909091 0.63636364 0.45454545
       [816,] 1.00000000 0.63636364 0.45454545
       [817,] 0.00000000 0.72727273 0.45454545
       [818,] 0.09090909 0.72727273 0.45454545
       [819,] 0.18181818 0.72727273 0.45454545
       [820,] 0.27272727 0.72727273 0.45454545
       [821,] 0.36363636 0.72727273 0.45454545
       [822,] 0.45454545 0.72727273 0.45454545
       [823,] 0.54545455 0.72727273 0.45454545
       [824,] 0.63636364 0.72727273 0.45454545
       [825,] 0.72727273 0.72727273 0.45454545
       [826,] 0.81818182 0.72727273 0.45454545
       [827,] 0.90909091 0.72727273 0.45454545
       [828,] 1.00000000 0.72727273 0.45454545
       [829,] 0.00000000 0.81818182 0.45454545
       [830,] 0.09090909 0.81818182 0.45454545
       [831,] 0.18181818 0.81818182 0.45454545
       [832,] 0.27272727 0.81818182 0.45454545
       [833,] 0.36363636 0.81818182 0.45454545
       [834,] 0.45454545 0.81818182 0.45454545
       [835,] 0.54545455 0.81818182 0.45454545
       [836,] 0.63636364 0.81818182 0.45454545
       [837,] 0.72727273 0.81818182 0.45454545
       [838,] 0.81818182 0.81818182 0.45454545
       [839,] 0.90909091 0.81818182 0.45454545
       [840,] 1.00000000 0.81818182 0.45454545
       [841,] 0.00000000 0.90909091 0.45454545
       [842,] 0.09090909 0.90909091 0.45454545
       [843,] 0.18181818 0.90909091 0.45454545
       [844,] 0.27272727 0.90909091 0.45454545
       [845,] 0.36363636 0.90909091 0.45454545
       [846,] 0.45454545 0.90909091 0.45454545
       [847,] 0.54545455 0.90909091 0.45454545
       [848,] 0.63636364 0.90909091 0.45454545
       [849,] 0.72727273 0.90909091 0.45454545
       [850,] 0.81818182 0.90909091 0.45454545
       [851,] 0.90909091 0.90909091 0.45454545
       [852,] 1.00000000 0.90909091 0.45454545
       [853,] 0.00000000 1.00000000 0.45454545
       [854,] 0.09090909 1.00000000 0.45454545
       [855,] 0.18181818 1.00000000 0.45454545
       [856,] 0.27272727 1.00000000 0.45454545
       [857,] 0.36363636 1.00000000 0.45454545
       [858,] 0.45454545 1.00000000 0.45454545
       [859,] 0.54545455 1.00000000 0.45454545
       [860,] 0.63636364 1.00000000 0.45454545
       [861,] 0.72727273 1.00000000 0.45454545
       [862,] 0.81818182 1.00000000 0.45454545
       [863,] 0.90909091 1.00000000 0.45454545
       [864,] 1.00000000 1.00000000 0.45454545
       [865,] 0.00000000 0.00000000 0.54545455
       [866,] 0.09090909 0.00000000 0.54545455
       [867,] 0.18181818 0.00000000 0.54545455
       [868,] 0.27272727 0.00000000 0.54545455
       [869,] 0.36363636 0.00000000 0.54545455
       [870,] 0.45454545 0.00000000 0.54545455
       [871,] 0.54545455 0.00000000 0.54545455
       [872,] 0.63636364 0.00000000 0.54545455
       [873,] 0.72727273 0.00000000 0.54545455
       [874,] 0.81818182 0.00000000 0.54545455
       [875,] 0.90909091 0.00000000 0.54545455
       [876,] 1.00000000 0.00000000 0.54545455
       [877,] 0.00000000 0.09090909 0.54545455
       [878,] 0.09090909 0.09090909 0.54545455
       [879,] 0.18181818 0.09090909 0.54545455
       [880,] 0.27272727 0.09090909 0.54545455
       [881,] 0.36363636 0.09090909 0.54545455
       [882,] 0.45454545 0.09090909 0.54545455
       [883,] 0.54545455 0.09090909 0.54545455
       [884,] 0.63636364 0.09090909 0.54545455
       [885,] 0.72727273 0.09090909 0.54545455
       [886,] 0.81818182 0.09090909 0.54545455
       [887,] 0.90909091 0.09090909 0.54545455
       [888,] 1.00000000 0.09090909 0.54545455
       [889,] 0.00000000 0.18181818 0.54545455
       [890,] 0.09090909 0.18181818 0.54545455
       [891,] 0.18181818 0.18181818 0.54545455
       [892,] 0.27272727 0.18181818 0.54545455
       [893,] 0.36363636 0.18181818 0.54545455
       [894,] 0.45454545 0.18181818 0.54545455
       [895,] 0.54545455 0.18181818 0.54545455
       [896,] 0.63636364 0.18181818 0.54545455
       [897,] 0.72727273 0.18181818 0.54545455
       [898,] 0.81818182 0.18181818 0.54545455
       [899,] 0.90909091 0.18181818 0.54545455
       [900,] 1.00000000 0.18181818 0.54545455
       [901,] 0.00000000 0.27272727 0.54545455
       [902,] 0.09090909 0.27272727 0.54545455
       [903,] 0.18181818 0.27272727 0.54545455
       [904,] 0.27272727 0.27272727 0.54545455
       [905,] 0.36363636 0.27272727 0.54545455
       [906,] 0.45454545 0.27272727 0.54545455
       [907,] 0.54545455 0.27272727 0.54545455
       [908,] 0.63636364 0.27272727 0.54545455
       [909,] 0.72727273 0.27272727 0.54545455
       [910,] 0.81818182 0.27272727 0.54545455
       [911,] 0.90909091 0.27272727 0.54545455
       [912,] 1.00000000 0.27272727 0.54545455
       [913,] 0.00000000 0.36363636 0.54545455
       [914,] 0.09090909 0.36363636 0.54545455
       [915,] 0.18181818 0.36363636 0.54545455
       [916,] 0.27272727 0.36363636 0.54545455
       [917,] 0.36363636 0.36363636 0.54545455
       [918,] 0.45454545 0.36363636 0.54545455
       [919,] 0.54545455 0.36363636 0.54545455
       [920,] 0.63636364 0.36363636 0.54545455
       [921,] 0.72727273 0.36363636 0.54545455
       [922,] 0.81818182 0.36363636 0.54545455
       [923,] 0.90909091 0.36363636 0.54545455
       [924,] 1.00000000 0.36363636 0.54545455
       [925,] 0.00000000 0.45454545 0.54545455
       [926,] 0.09090909 0.45454545 0.54545455
       [927,] 0.18181818 0.45454545 0.54545455
       [928,] 0.27272727 0.45454545 0.54545455
       [929,] 0.36363636 0.45454545 0.54545455
       [930,] 0.45454545 0.45454545 0.54545455
       [931,] 0.54545455 0.45454545 0.54545455
       [932,] 0.63636364 0.45454545 0.54545455
       [933,] 0.72727273 0.45454545 0.54545455
       [934,] 0.81818182 0.45454545 0.54545455
       [935,] 0.90909091 0.45454545 0.54545455
       [936,] 1.00000000 0.45454545 0.54545455
       [937,] 0.00000000 0.54545455 0.54545455
       [938,] 0.09090909 0.54545455 0.54545455
       [939,] 0.18181818 0.54545455 0.54545455
       [940,] 0.27272727 0.54545455 0.54545455
       [941,] 0.36363636 0.54545455 0.54545455
       [942,] 0.45454545 0.54545455 0.54545455
       [943,] 0.54545455 0.54545455 0.54545455
       [944,] 0.63636364 0.54545455 0.54545455
       [945,] 0.72727273 0.54545455 0.54545455
       [946,] 0.81818182 0.54545455 0.54545455
       [947,] 0.90909091 0.54545455 0.54545455
       [948,] 1.00000000 0.54545455 0.54545455
       [949,] 0.00000000 0.63636364 0.54545455
       [950,] 0.09090909 0.63636364 0.54545455
       [951,] 0.18181818 0.63636364 0.54545455
       [952,] 0.27272727 0.63636364 0.54545455
       [953,] 0.36363636 0.63636364 0.54545455
       [954,] 0.45454545 0.63636364 0.54545455
       [955,] 0.54545455 0.63636364 0.54545455
       [956,] 0.63636364 0.63636364 0.54545455
       [957,] 0.72727273 0.63636364 0.54545455
       [958,] 0.81818182 0.63636364 0.54545455
       [959,] 0.90909091 0.63636364 0.54545455
       [960,] 1.00000000 0.63636364 0.54545455
       [961,] 0.00000000 0.72727273 0.54545455
       [962,] 0.09090909 0.72727273 0.54545455
       [963,] 0.18181818 0.72727273 0.54545455
       [964,] 0.27272727 0.72727273 0.54545455
       [965,] 0.36363636 0.72727273 0.54545455
       [966,] 0.45454545 0.72727273 0.54545455
       [967,] 0.54545455 0.72727273 0.54545455
       [968,] 0.63636364 0.72727273 0.54545455
       [969,] 0.72727273 0.72727273 0.54545455
       [970,] 0.81818182 0.72727273 0.54545455
       [971,] 0.90909091 0.72727273 0.54545455
       [972,] 1.00000000 0.72727273 0.54545455
       [973,] 0.00000000 0.81818182 0.54545455
       [974,] 0.09090909 0.81818182 0.54545455
       [975,] 0.18181818 0.81818182 0.54545455
       [976,] 0.27272727 0.81818182 0.54545455
       [977,] 0.36363636 0.81818182 0.54545455
       [978,] 0.45454545 0.81818182 0.54545455
       [979,] 0.54545455 0.81818182 0.54545455
       [980,] 0.63636364 0.81818182 0.54545455
       [981,] 0.72727273 0.81818182 0.54545455
       [982,] 0.81818182 0.81818182 0.54545455
       [983,] 0.90909091 0.81818182 0.54545455
       [984,] 1.00000000 0.81818182 0.54545455
       [985,] 0.00000000 0.90909091 0.54545455
       [986,] 0.09090909 0.90909091 0.54545455
       [987,] 0.18181818 0.90909091 0.54545455
       [988,] 0.27272727 0.90909091 0.54545455
       [989,] 0.36363636 0.90909091 0.54545455
       [990,] 0.45454545 0.90909091 0.54545455
       [991,] 0.54545455 0.90909091 0.54545455
       [992,] 0.63636364 0.90909091 0.54545455
       [993,] 0.72727273 0.90909091 0.54545455
       [994,] 0.81818182 0.90909091 0.54545455
       [995,] 0.90909091 0.90909091 0.54545455
       [996,] 1.00000000 0.90909091 0.54545455
       [997,] 0.00000000 1.00000000 0.54545455
       [998,] 0.09090909 1.00000000 0.54545455
       [999,] 0.18181818 1.00000000 0.54545455
      [1000,] 0.27272727 1.00000000 0.54545455
      [1001,] 0.36363636 1.00000000 0.54545455
      [1002,] 0.45454545 1.00000000 0.54545455
      [1003,] 0.54545455 1.00000000 0.54545455
      [1004,] 0.63636364 1.00000000 0.54545455
      [1005,] 0.72727273 1.00000000 0.54545455
      [1006,] 0.81818182 1.00000000 0.54545455
      [1007,] 0.90909091 1.00000000 0.54545455
      [1008,] 1.00000000 1.00000000 0.54545455
      [1009,] 0.00000000 0.00000000 0.63636364
      [1010,] 0.09090909 0.00000000 0.63636364
      [1011,] 0.18181818 0.00000000 0.63636364
      [1012,] 0.27272727 0.00000000 0.63636364
      [1013,] 0.36363636 0.00000000 0.63636364
      [1014,] 0.45454545 0.00000000 0.63636364
      [1015,] 0.54545455 0.00000000 0.63636364
      [1016,] 0.63636364 0.00000000 0.63636364
      [1017,] 0.72727273 0.00000000 0.63636364
      [1018,] 0.81818182 0.00000000 0.63636364
      [1019,] 0.90909091 0.00000000 0.63636364
      [1020,] 1.00000000 0.00000000 0.63636364
      [1021,] 0.00000000 0.09090909 0.63636364
      [1022,] 0.09090909 0.09090909 0.63636364
      [1023,] 0.18181818 0.09090909 0.63636364
      [1024,] 0.27272727 0.09090909 0.63636364
      [1025,] 0.36363636 0.09090909 0.63636364
      [1026,] 0.45454545 0.09090909 0.63636364
      [1027,] 0.54545455 0.09090909 0.63636364
      [1028,] 0.63636364 0.09090909 0.63636364
      [1029,] 0.72727273 0.09090909 0.63636364
      [1030,] 0.81818182 0.09090909 0.63636364
      [1031,] 0.90909091 0.09090909 0.63636364
      [1032,] 1.00000000 0.09090909 0.63636364
      [1033,] 0.00000000 0.18181818 0.63636364
      [1034,] 0.09090909 0.18181818 0.63636364
      [1035,] 0.18181818 0.18181818 0.63636364
      [1036,] 0.27272727 0.18181818 0.63636364
      [1037,] 0.36363636 0.18181818 0.63636364
      [1038,] 0.45454545 0.18181818 0.63636364
      [1039,] 0.54545455 0.18181818 0.63636364
      [1040,] 0.63636364 0.18181818 0.63636364
      [1041,] 0.72727273 0.18181818 0.63636364
      [1042,] 0.81818182 0.18181818 0.63636364
      [1043,] 0.90909091 0.18181818 0.63636364
      [1044,] 1.00000000 0.18181818 0.63636364
      [1045,] 0.00000000 0.27272727 0.63636364
      [1046,] 0.09090909 0.27272727 0.63636364
      [1047,] 0.18181818 0.27272727 0.63636364
      [1048,] 0.27272727 0.27272727 0.63636364
      [1049,] 0.36363636 0.27272727 0.63636364
      [1050,] 0.45454545 0.27272727 0.63636364
      [1051,] 0.54545455 0.27272727 0.63636364
      [1052,] 0.63636364 0.27272727 0.63636364
      [1053,] 0.72727273 0.27272727 0.63636364
      [1054,] 0.81818182 0.27272727 0.63636364
      [1055,] 0.90909091 0.27272727 0.63636364
      [1056,] 1.00000000 0.27272727 0.63636364
      [1057,] 0.00000000 0.36363636 0.63636364
      [1058,] 0.09090909 0.36363636 0.63636364
      [1059,] 0.18181818 0.36363636 0.63636364
      [1060,] 0.27272727 0.36363636 0.63636364
      [1061,] 0.36363636 0.36363636 0.63636364
      [1062,] 0.45454545 0.36363636 0.63636364
      [1063,] 0.54545455 0.36363636 0.63636364
      [1064,] 0.63636364 0.36363636 0.63636364
      [1065,] 0.72727273 0.36363636 0.63636364
      [1066,] 0.81818182 0.36363636 0.63636364
      [1067,] 0.90909091 0.36363636 0.63636364
      [1068,] 1.00000000 0.36363636 0.63636364
      [1069,] 0.00000000 0.45454545 0.63636364
      [1070,] 0.09090909 0.45454545 0.63636364
      [1071,] 0.18181818 0.45454545 0.63636364
      [1072,] 0.27272727 0.45454545 0.63636364
      [1073,] 0.36363636 0.45454545 0.63636364
      [1074,] 0.45454545 0.45454545 0.63636364
      [1075,] 0.54545455 0.45454545 0.63636364
      [1076,] 0.63636364 0.45454545 0.63636364
      [1077,] 0.72727273 0.45454545 0.63636364
      [1078,] 0.81818182 0.45454545 0.63636364
      [1079,] 0.90909091 0.45454545 0.63636364
      [1080,] 1.00000000 0.45454545 0.63636364
      [1081,] 0.00000000 0.54545455 0.63636364
      [1082,] 0.09090909 0.54545455 0.63636364
      [1083,] 0.18181818 0.54545455 0.63636364
      [1084,] 0.27272727 0.54545455 0.63636364
      [1085,] 0.36363636 0.54545455 0.63636364
      [1086,] 0.45454545 0.54545455 0.63636364
      [1087,] 0.54545455 0.54545455 0.63636364
      [1088,] 0.63636364 0.54545455 0.63636364
      [1089,] 0.72727273 0.54545455 0.63636364
      [1090,] 0.81818182 0.54545455 0.63636364
      [1091,] 0.90909091 0.54545455 0.63636364
      [1092,] 1.00000000 0.54545455 0.63636364
      [1093,] 0.00000000 0.63636364 0.63636364
      [1094,] 0.09090909 0.63636364 0.63636364
      [1095,] 0.18181818 0.63636364 0.63636364
      [1096,] 0.27272727 0.63636364 0.63636364
      [1097,] 0.36363636 0.63636364 0.63636364
      [1098,] 0.45454545 0.63636364 0.63636364
      [1099,] 0.54545455 0.63636364 0.63636364
      [1100,] 0.63636364 0.63636364 0.63636364
      [1101,] 0.72727273 0.63636364 0.63636364
      [1102,] 0.81818182 0.63636364 0.63636364
      [1103,] 0.90909091 0.63636364 0.63636364
      [1104,] 1.00000000 0.63636364 0.63636364
      [1105,] 0.00000000 0.72727273 0.63636364
      [1106,] 0.09090909 0.72727273 0.63636364
      [1107,] 0.18181818 0.72727273 0.63636364
      [1108,] 0.27272727 0.72727273 0.63636364
      [1109,] 0.36363636 0.72727273 0.63636364
      [1110,] 0.45454545 0.72727273 0.63636364
      [1111,] 0.54545455 0.72727273 0.63636364
      [1112,] 0.63636364 0.72727273 0.63636364
      [1113,] 0.72727273 0.72727273 0.63636364
      [1114,] 0.81818182 0.72727273 0.63636364
      [1115,] 0.90909091 0.72727273 0.63636364
      [1116,] 1.00000000 0.72727273 0.63636364
      [1117,] 0.00000000 0.81818182 0.63636364
      [1118,] 0.09090909 0.81818182 0.63636364
      [1119,] 0.18181818 0.81818182 0.63636364
      [1120,] 0.27272727 0.81818182 0.63636364
      [1121,] 0.36363636 0.81818182 0.63636364
      [1122,] 0.45454545 0.81818182 0.63636364
      [1123,] 0.54545455 0.81818182 0.63636364
      [1124,] 0.63636364 0.81818182 0.63636364
      [1125,] 0.72727273 0.81818182 0.63636364
      [1126,] 0.81818182 0.81818182 0.63636364
      [1127,] 0.90909091 0.81818182 0.63636364
      [1128,] 1.00000000 0.81818182 0.63636364
      [1129,] 0.00000000 0.90909091 0.63636364
      [1130,] 0.09090909 0.90909091 0.63636364
      [1131,] 0.18181818 0.90909091 0.63636364
      [1132,] 0.27272727 0.90909091 0.63636364
      [1133,] 0.36363636 0.90909091 0.63636364
      [1134,] 0.45454545 0.90909091 0.63636364
      [1135,] 0.54545455 0.90909091 0.63636364
      [1136,] 0.63636364 0.90909091 0.63636364
      [1137,] 0.72727273 0.90909091 0.63636364
      [1138,] 0.81818182 0.90909091 0.63636364
      [1139,] 0.90909091 0.90909091 0.63636364
      [1140,] 1.00000000 0.90909091 0.63636364
      [1141,] 0.00000000 1.00000000 0.63636364
      [1142,] 0.09090909 1.00000000 0.63636364
      [1143,] 0.18181818 1.00000000 0.63636364
      [1144,] 0.27272727 1.00000000 0.63636364
      [1145,] 0.36363636 1.00000000 0.63636364
      [1146,] 0.45454545 1.00000000 0.63636364
      [1147,] 0.54545455 1.00000000 0.63636364
      [1148,] 0.63636364 1.00000000 0.63636364
      [1149,] 0.72727273 1.00000000 0.63636364
      [1150,] 0.81818182 1.00000000 0.63636364
      [1151,] 0.90909091 1.00000000 0.63636364
      [1152,] 1.00000000 1.00000000 0.63636364
      [1153,] 0.00000000 0.00000000 0.72727273
      [1154,] 0.09090909 0.00000000 0.72727273
      [1155,] 0.18181818 0.00000000 0.72727273
      [1156,] 0.27272727 0.00000000 0.72727273
      [1157,] 0.36363636 0.00000000 0.72727273
      [1158,] 0.45454545 0.00000000 0.72727273
      [1159,] 0.54545455 0.00000000 0.72727273
      [1160,] 0.63636364 0.00000000 0.72727273
      [1161,] 0.72727273 0.00000000 0.72727273
      [1162,] 0.81818182 0.00000000 0.72727273
      [1163,] 0.90909091 0.00000000 0.72727273
      [1164,] 1.00000000 0.00000000 0.72727273
      [1165,] 0.00000000 0.09090909 0.72727273
      [1166,] 0.09090909 0.09090909 0.72727273
      [1167,] 0.18181818 0.09090909 0.72727273
      [1168,] 0.27272727 0.09090909 0.72727273
      [1169,] 0.36363636 0.09090909 0.72727273
      [1170,] 0.45454545 0.09090909 0.72727273
      [1171,] 0.54545455 0.09090909 0.72727273
      [1172,] 0.63636364 0.09090909 0.72727273
      [1173,] 0.72727273 0.09090909 0.72727273
      [1174,] 0.81818182 0.09090909 0.72727273
      [1175,] 0.90909091 0.09090909 0.72727273
      [1176,] 1.00000000 0.09090909 0.72727273
      [1177,] 0.00000000 0.18181818 0.72727273
      [1178,] 0.09090909 0.18181818 0.72727273
      [1179,] 0.18181818 0.18181818 0.72727273
      [1180,] 0.27272727 0.18181818 0.72727273
      [1181,] 0.36363636 0.18181818 0.72727273
      [1182,] 0.45454545 0.18181818 0.72727273
      [1183,] 0.54545455 0.18181818 0.72727273
      [1184,] 0.63636364 0.18181818 0.72727273
      [1185,] 0.72727273 0.18181818 0.72727273
      [1186,] 0.81818182 0.18181818 0.72727273
      [1187,] 0.90909091 0.18181818 0.72727273
      [1188,] 1.00000000 0.18181818 0.72727273
      [1189,] 0.00000000 0.27272727 0.72727273
      [1190,] 0.09090909 0.27272727 0.72727273
      [1191,] 0.18181818 0.27272727 0.72727273
      [1192,] 0.27272727 0.27272727 0.72727273
      [1193,] 0.36363636 0.27272727 0.72727273
      [1194,] 0.45454545 0.27272727 0.72727273
      [1195,] 0.54545455 0.27272727 0.72727273
      [1196,] 0.63636364 0.27272727 0.72727273
      [1197,] 0.72727273 0.27272727 0.72727273
      [1198,] 0.81818182 0.27272727 0.72727273
      [1199,] 0.90909091 0.27272727 0.72727273
      [1200,] 1.00000000 0.27272727 0.72727273
      [1201,] 0.00000000 0.36363636 0.72727273
      [1202,] 0.09090909 0.36363636 0.72727273
      [1203,] 0.18181818 0.36363636 0.72727273
      [1204,] 0.27272727 0.36363636 0.72727273
      [1205,] 0.36363636 0.36363636 0.72727273
      [1206,] 0.45454545 0.36363636 0.72727273
      [1207,] 0.54545455 0.36363636 0.72727273
      [1208,] 0.63636364 0.36363636 0.72727273
      [1209,] 0.72727273 0.36363636 0.72727273
      [1210,] 0.81818182 0.36363636 0.72727273
      [1211,] 0.90909091 0.36363636 0.72727273
      [1212,] 1.00000000 0.36363636 0.72727273
      [1213,] 0.00000000 0.45454545 0.72727273
      [1214,] 0.09090909 0.45454545 0.72727273
      [1215,] 0.18181818 0.45454545 0.72727273
      [1216,] 0.27272727 0.45454545 0.72727273
      [1217,] 0.36363636 0.45454545 0.72727273
      [1218,] 0.45454545 0.45454545 0.72727273
      [1219,] 0.54545455 0.45454545 0.72727273
      [1220,] 0.63636364 0.45454545 0.72727273
      [1221,] 0.72727273 0.45454545 0.72727273
      [1222,] 0.81818182 0.45454545 0.72727273
      [1223,] 0.90909091 0.45454545 0.72727273
      [1224,] 1.00000000 0.45454545 0.72727273
      [1225,] 0.00000000 0.54545455 0.72727273
      [1226,] 0.09090909 0.54545455 0.72727273
      [1227,] 0.18181818 0.54545455 0.72727273
      [1228,] 0.27272727 0.54545455 0.72727273
      [1229,] 0.36363636 0.54545455 0.72727273
      [1230,] 0.45454545 0.54545455 0.72727273
      [1231,] 0.54545455 0.54545455 0.72727273
      [1232,] 0.63636364 0.54545455 0.72727273
      [1233,] 0.72727273 0.54545455 0.72727273
      [1234,] 0.81818182 0.54545455 0.72727273
      [1235,] 0.90909091 0.54545455 0.72727273
      [1236,] 1.00000000 0.54545455 0.72727273
      [1237,] 0.00000000 0.63636364 0.72727273
      [1238,] 0.09090909 0.63636364 0.72727273
      [1239,] 0.18181818 0.63636364 0.72727273
      [1240,] 0.27272727 0.63636364 0.72727273
      [1241,] 0.36363636 0.63636364 0.72727273
      [1242,] 0.45454545 0.63636364 0.72727273
      [1243,] 0.54545455 0.63636364 0.72727273
      [1244,] 0.63636364 0.63636364 0.72727273
      [1245,] 0.72727273 0.63636364 0.72727273
      [1246,] 0.81818182 0.63636364 0.72727273
      [1247,] 0.90909091 0.63636364 0.72727273
      [1248,] 1.00000000 0.63636364 0.72727273
      [1249,] 0.00000000 0.72727273 0.72727273
      [1250,] 0.09090909 0.72727273 0.72727273
      [1251,] 0.18181818 0.72727273 0.72727273
      [1252,] 0.27272727 0.72727273 0.72727273
      [1253,] 0.36363636 0.72727273 0.72727273
      [1254,] 0.45454545 0.72727273 0.72727273
      [1255,] 0.54545455 0.72727273 0.72727273
      [1256,] 0.63636364 0.72727273 0.72727273
      [1257,] 0.72727273 0.72727273 0.72727273
      [1258,] 0.81818182 0.72727273 0.72727273
      [1259,] 0.90909091 0.72727273 0.72727273
      [1260,] 1.00000000 0.72727273 0.72727273
      [1261,] 0.00000000 0.81818182 0.72727273
      [1262,] 0.09090909 0.81818182 0.72727273
      [1263,] 0.18181818 0.81818182 0.72727273
      [1264,] 0.27272727 0.81818182 0.72727273
      [1265,] 0.36363636 0.81818182 0.72727273
      [1266,] 0.45454545 0.81818182 0.72727273
      [1267,] 0.54545455 0.81818182 0.72727273
      [1268,] 0.63636364 0.81818182 0.72727273
      [1269,] 0.72727273 0.81818182 0.72727273
      [1270,] 0.81818182 0.81818182 0.72727273
      [1271,] 0.90909091 0.81818182 0.72727273
      [1272,] 1.00000000 0.81818182 0.72727273
      [1273,] 0.00000000 0.90909091 0.72727273
      [1274,] 0.09090909 0.90909091 0.72727273
      [1275,] 0.18181818 0.90909091 0.72727273
      [1276,] 0.27272727 0.90909091 0.72727273
      [1277,] 0.36363636 0.90909091 0.72727273
      [1278,] 0.45454545 0.90909091 0.72727273
      [1279,] 0.54545455 0.90909091 0.72727273
      [1280,] 0.63636364 0.90909091 0.72727273
      [1281,] 0.72727273 0.90909091 0.72727273
      [1282,] 0.81818182 0.90909091 0.72727273
      [1283,] 0.90909091 0.90909091 0.72727273
      [1284,] 1.00000000 0.90909091 0.72727273
      [1285,] 0.00000000 1.00000000 0.72727273
      [1286,] 0.09090909 1.00000000 0.72727273
      [1287,] 0.18181818 1.00000000 0.72727273
      [1288,] 0.27272727 1.00000000 0.72727273
      [1289,] 0.36363636 1.00000000 0.72727273
      [1290,] 0.45454545 1.00000000 0.72727273
      [1291,] 0.54545455 1.00000000 0.72727273
      [1292,] 0.63636364 1.00000000 0.72727273
      [1293,] 0.72727273 1.00000000 0.72727273
      [1294,] 0.81818182 1.00000000 0.72727273
      [1295,] 0.90909091 1.00000000 0.72727273
      [1296,] 1.00000000 1.00000000 0.72727273
      [1297,] 0.00000000 0.00000000 0.81818182
      [1298,] 0.09090909 0.00000000 0.81818182
      [1299,] 0.18181818 0.00000000 0.81818182
      [1300,] 0.27272727 0.00000000 0.81818182
      [1301,] 0.36363636 0.00000000 0.81818182
      [1302,] 0.45454545 0.00000000 0.81818182
      [1303,] 0.54545455 0.00000000 0.81818182
      [1304,] 0.63636364 0.00000000 0.81818182
      [1305,] 0.72727273 0.00000000 0.81818182
      [1306,] 0.81818182 0.00000000 0.81818182
      [1307,] 0.90909091 0.00000000 0.81818182
      [1308,] 1.00000000 0.00000000 0.81818182
      [1309,] 0.00000000 0.09090909 0.81818182
      [1310,] 0.09090909 0.09090909 0.81818182
      [1311,] 0.18181818 0.09090909 0.81818182
      [1312,] 0.27272727 0.09090909 0.81818182
      [1313,] 0.36363636 0.09090909 0.81818182
      [1314,] 0.45454545 0.09090909 0.81818182
      [1315,] 0.54545455 0.09090909 0.81818182
      [1316,] 0.63636364 0.09090909 0.81818182
      [1317,] 0.72727273 0.09090909 0.81818182
      [1318,] 0.81818182 0.09090909 0.81818182
      [1319,] 0.90909091 0.09090909 0.81818182
      [1320,] 1.00000000 0.09090909 0.81818182
      [1321,] 0.00000000 0.18181818 0.81818182
      [1322,] 0.09090909 0.18181818 0.81818182
      [1323,] 0.18181818 0.18181818 0.81818182
      [1324,] 0.27272727 0.18181818 0.81818182
      [1325,] 0.36363636 0.18181818 0.81818182
      [1326,] 0.45454545 0.18181818 0.81818182
      [1327,] 0.54545455 0.18181818 0.81818182
      [1328,] 0.63636364 0.18181818 0.81818182
      [1329,] 0.72727273 0.18181818 0.81818182
      [1330,] 0.81818182 0.18181818 0.81818182
      [1331,] 0.90909091 0.18181818 0.81818182
      [1332,] 1.00000000 0.18181818 0.81818182
      [1333,] 0.00000000 0.27272727 0.81818182
      [1334,] 0.09090909 0.27272727 0.81818182
      [1335,] 0.18181818 0.27272727 0.81818182
      [1336,] 0.27272727 0.27272727 0.81818182
      [1337,] 0.36363636 0.27272727 0.81818182
      [1338,] 0.45454545 0.27272727 0.81818182
      [1339,] 0.54545455 0.27272727 0.81818182
      [1340,] 0.63636364 0.27272727 0.81818182
      [1341,] 0.72727273 0.27272727 0.81818182
      [1342,] 0.81818182 0.27272727 0.81818182
      [1343,] 0.90909091 0.27272727 0.81818182
      [1344,] 1.00000000 0.27272727 0.81818182
      [1345,] 0.00000000 0.36363636 0.81818182
      [1346,] 0.09090909 0.36363636 0.81818182
      [1347,] 0.18181818 0.36363636 0.81818182
      [1348,] 0.27272727 0.36363636 0.81818182
      [1349,] 0.36363636 0.36363636 0.81818182
      [1350,] 0.45454545 0.36363636 0.81818182
      [1351,] 0.54545455 0.36363636 0.81818182
      [1352,] 0.63636364 0.36363636 0.81818182
      [1353,] 0.72727273 0.36363636 0.81818182
      [1354,] 0.81818182 0.36363636 0.81818182
      [1355,] 0.90909091 0.36363636 0.81818182
      [1356,] 1.00000000 0.36363636 0.81818182
      [1357,] 0.00000000 0.45454545 0.81818182
      [1358,] 0.09090909 0.45454545 0.81818182
      [1359,] 0.18181818 0.45454545 0.81818182
      [1360,] 0.27272727 0.45454545 0.81818182
      [1361,] 0.36363636 0.45454545 0.81818182
      [1362,] 0.45454545 0.45454545 0.81818182
      [1363,] 0.54545455 0.45454545 0.81818182
      [1364,] 0.63636364 0.45454545 0.81818182
      [1365,] 0.72727273 0.45454545 0.81818182
      [1366,] 0.81818182 0.45454545 0.81818182
      [1367,] 0.90909091 0.45454545 0.81818182
      [1368,] 1.00000000 0.45454545 0.81818182
      [1369,] 0.00000000 0.54545455 0.81818182
      [1370,] 0.09090909 0.54545455 0.81818182
      [1371,] 0.18181818 0.54545455 0.81818182
      [1372,] 0.27272727 0.54545455 0.81818182
      [1373,] 0.36363636 0.54545455 0.81818182
      [1374,] 0.45454545 0.54545455 0.81818182
      [1375,] 0.54545455 0.54545455 0.81818182
      [1376,] 0.63636364 0.54545455 0.81818182
      [1377,] 0.72727273 0.54545455 0.81818182
      [1378,] 0.81818182 0.54545455 0.81818182
      [1379,] 0.90909091 0.54545455 0.81818182
      [1380,] 1.00000000 0.54545455 0.81818182
      [1381,] 0.00000000 0.63636364 0.81818182
      [1382,] 0.09090909 0.63636364 0.81818182
      [1383,] 0.18181818 0.63636364 0.81818182
      [1384,] 0.27272727 0.63636364 0.81818182
      [1385,] 0.36363636 0.63636364 0.81818182
      [1386,] 0.45454545 0.63636364 0.81818182
      [1387,] 0.54545455 0.63636364 0.81818182
      [1388,] 0.63636364 0.63636364 0.81818182
      [1389,] 0.72727273 0.63636364 0.81818182
      [1390,] 0.81818182 0.63636364 0.81818182
      [1391,] 0.90909091 0.63636364 0.81818182
      [1392,] 1.00000000 0.63636364 0.81818182
      [1393,] 0.00000000 0.72727273 0.81818182
      [1394,] 0.09090909 0.72727273 0.81818182
      [1395,] 0.18181818 0.72727273 0.81818182
      [1396,] 0.27272727 0.72727273 0.81818182
      [1397,] 0.36363636 0.72727273 0.81818182
      [1398,] 0.45454545 0.72727273 0.81818182
      [1399,] 0.54545455 0.72727273 0.81818182
      [1400,] 0.63636364 0.72727273 0.81818182
      [1401,] 0.72727273 0.72727273 0.81818182
      [1402,] 0.81818182 0.72727273 0.81818182
      [1403,] 0.90909091 0.72727273 0.81818182
      [1404,] 1.00000000 0.72727273 0.81818182
      [1405,] 0.00000000 0.81818182 0.81818182
      [1406,] 0.09090909 0.81818182 0.81818182
      [1407,] 0.18181818 0.81818182 0.81818182
      [1408,] 0.27272727 0.81818182 0.81818182
      [1409,] 0.36363636 0.81818182 0.81818182
      [1410,] 0.45454545 0.81818182 0.81818182
      [1411,] 0.54545455 0.81818182 0.81818182
      [1412,] 0.63636364 0.81818182 0.81818182
      [1413,] 0.72727273 0.81818182 0.81818182
      [1414,] 0.81818182 0.81818182 0.81818182
      [1415,] 0.90909091 0.81818182 0.81818182
      [1416,] 1.00000000 0.81818182 0.81818182
      [1417,] 0.00000000 0.90909091 0.81818182
      [1418,] 0.09090909 0.90909091 0.81818182
      [1419,] 0.18181818 0.90909091 0.81818182
      [1420,] 0.27272727 0.90909091 0.81818182
      [1421,] 0.36363636 0.90909091 0.81818182
      [1422,] 0.45454545 0.90909091 0.81818182
      [1423,] 0.54545455 0.90909091 0.81818182
      [1424,] 0.63636364 0.90909091 0.81818182
      [1425,] 0.72727273 0.90909091 0.81818182
      [1426,] 0.81818182 0.90909091 0.81818182
      [1427,] 0.90909091 0.90909091 0.81818182
      [1428,] 1.00000000 0.90909091 0.81818182
      [1429,] 0.00000000 1.00000000 0.81818182
      [1430,] 0.09090909 1.00000000 0.81818182
      [1431,] 0.18181818 1.00000000 0.81818182
      [1432,] 0.27272727 1.00000000 0.81818182
      [1433,] 0.36363636 1.00000000 0.81818182
      [1434,] 0.45454545 1.00000000 0.81818182
      [1435,] 0.54545455 1.00000000 0.81818182
      [1436,] 0.63636364 1.00000000 0.81818182
      [1437,] 0.72727273 1.00000000 0.81818182
      [1438,] 0.81818182 1.00000000 0.81818182
      [1439,] 0.90909091 1.00000000 0.81818182
      [1440,] 1.00000000 1.00000000 0.81818182
      [1441,] 0.00000000 0.00000000 0.90909091
      [1442,] 0.09090909 0.00000000 0.90909091
      [1443,] 0.18181818 0.00000000 0.90909091
      [1444,] 0.27272727 0.00000000 0.90909091
      [1445,] 0.36363636 0.00000000 0.90909091
      [1446,] 0.45454545 0.00000000 0.90909091
      [1447,] 0.54545455 0.00000000 0.90909091
      [1448,] 0.63636364 0.00000000 0.90909091
      [1449,] 0.72727273 0.00000000 0.90909091
      [1450,] 0.81818182 0.00000000 0.90909091
      [1451,] 0.90909091 0.00000000 0.90909091
      [1452,] 1.00000000 0.00000000 0.90909091
      [1453,] 0.00000000 0.09090909 0.90909091
      [1454,] 0.09090909 0.09090909 0.90909091
      [1455,] 0.18181818 0.09090909 0.90909091
      [1456,] 0.27272727 0.09090909 0.90909091
      [1457,] 0.36363636 0.09090909 0.90909091
      [1458,] 0.45454545 0.09090909 0.90909091
      [1459,] 0.54545455 0.09090909 0.90909091
      [1460,] 0.63636364 0.09090909 0.90909091
      [1461,] 0.72727273 0.09090909 0.90909091
      [1462,] 0.81818182 0.09090909 0.90909091
      [1463,] 0.90909091 0.09090909 0.90909091
      [1464,] 1.00000000 0.09090909 0.90909091
      [1465,] 0.00000000 0.18181818 0.90909091
      [1466,] 0.09090909 0.18181818 0.90909091
      [1467,] 0.18181818 0.18181818 0.90909091
      [1468,] 0.27272727 0.18181818 0.90909091
      [1469,] 0.36363636 0.18181818 0.90909091
      [1470,] 0.45454545 0.18181818 0.90909091
      [1471,] 0.54545455 0.18181818 0.90909091
      [1472,] 0.63636364 0.18181818 0.90909091
      [1473,] 0.72727273 0.18181818 0.90909091
      [1474,] 0.81818182 0.18181818 0.90909091
      [1475,] 0.90909091 0.18181818 0.90909091
      [1476,] 1.00000000 0.18181818 0.90909091
      [1477,] 0.00000000 0.27272727 0.90909091
      [1478,] 0.09090909 0.27272727 0.90909091
      [1479,] 0.18181818 0.27272727 0.90909091
      [1480,] 0.27272727 0.27272727 0.90909091
      [1481,] 0.36363636 0.27272727 0.90909091
      [1482,] 0.45454545 0.27272727 0.90909091
      [1483,] 0.54545455 0.27272727 0.90909091
      [1484,] 0.63636364 0.27272727 0.90909091
      [1485,] 0.72727273 0.27272727 0.90909091
      [1486,] 0.81818182 0.27272727 0.90909091
      [1487,] 0.90909091 0.27272727 0.90909091
      [1488,] 1.00000000 0.27272727 0.90909091
      [1489,] 0.00000000 0.36363636 0.90909091
      [1490,] 0.09090909 0.36363636 0.90909091
      [1491,] 0.18181818 0.36363636 0.90909091
      [1492,] 0.27272727 0.36363636 0.90909091
      [1493,] 0.36363636 0.36363636 0.90909091
      [1494,] 0.45454545 0.36363636 0.90909091
      [1495,] 0.54545455 0.36363636 0.90909091
      [1496,] 0.63636364 0.36363636 0.90909091
      [1497,] 0.72727273 0.36363636 0.90909091
      [1498,] 0.81818182 0.36363636 0.90909091
      [1499,] 0.90909091 0.36363636 0.90909091
      [1500,] 1.00000000 0.36363636 0.90909091
      [1501,] 0.00000000 0.45454545 0.90909091
      [1502,] 0.09090909 0.45454545 0.90909091
      [1503,] 0.18181818 0.45454545 0.90909091
      [1504,] 0.27272727 0.45454545 0.90909091
      [1505,] 0.36363636 0.45454545 0.90909091
      [1506,] 0.45454545 0.45454545 0.90909091
      [1507,] 0.54545455 0.45454545 0.90909091
      [1508,] 0.63636364 0.45454545 0.90909091
      [1509,] 0.72727273 0.45454545 0.90909091
      [1510,] 0.81818182 0.45454545 0.90909091
      [1511,] 0.90909091 0.45454545 0.90909091
      [1512,] 1.00000000 0.45454545 0.90909091
      [1513,] 0.00000000 0.54545455 0.90909091
      [1514,] 0.09090909 0.54545455 0.90909091
      [1515,] 0.18181818 0.54545455 0.90909091
      [1516,] 0.27272727 0.54545455 0.90909091
      [1517,] 0.36363636 0.54545455 0.90909091
      [1518,] 0.45454545 0.54545455 0.90909091
      [1519,] 0.54545455 0.54545455 0.90909091
      [1520,] 0.63636364 0.54545455 0.90909091
      [1521,] 0.72727273 0.54545455 0.90909091
      [1522,] 0.81818182 0.54545455 0.90909091
      [1523,] 0.90909091 0.54545455 0.90909091
      [1524,] 1.00000000 0.54545455 0.90909091
      [1525,] 0.00000000 0.63636364 0.90909091
      [1526,] 0.09090909 0.63636364 0.90909091
      [1527,] 0.18181818 0.63636364 0.90909091
      [1528,] 0.27272727 0.63636364 0.90909091
      [1529,] 0.36363636 0.63636364 0.90909091
      [1530,] 0.45454545 0.63636364 0.90909091
      [1531,] 0.54545455 0.63636364 0.90909091
      [1532,] 0.63636364 0.63636364 0.90909091
      [1533,] 0.72727273 0.63636364 0.90909091
      [1534,] 0.81818182 0.63636364 0.90909091
      [1535,] 0.90909091 0.63636364 0.90909091
      [1536,] 1.00000000 0.63636364 0.90909091
      [1537,] 0.00000000 0.72727273 0.90909091
      [1538,] 0.09090909 0.72727273 0.90909091
      [1539,] 0.18181818 0.72727273 0.90909091
      [1540,] 0.27272727 0.72727273 0.90909091
      [1541,] 0.36363636 0.72727273 0.90909091
      [1542,] 0.45454545 0.72727273 0.90909091
      [1543,] 0.54545455 0.72727273 0.90909091
      [1544,] 0.63636364 0.72727273 0.90909091
      [1545,] 0.72727273 0.72727273 0.90909091
      [1546,] 0.81818182 0.72727273 0.90909091
      [1547,] 0.90909091 0.72727273 0.90909091
      [1548,] 1.00000000 0.72727273 0.90909091
      [1549,] 0.00000000 0.81818182 0.90909091
      [1550,] 0.09090909 0.81818182 0.90909091
      [1551,] 0.18181818 0.81818182 0.90909091
      [1552,] 0.27272727 0.81818182 0.90909091
      [1553,] 0.36363636 0.81818182 0.90909091
      [1554,] 0.45454545 0.81818182 0.90909091
      [1555,] 0.54545455 0.81818182 0.90909091
      [1556,] 0.63636364 0.81818182 0.90909091
      [1557,] 0.72727273 0.81818182 0.90909091
      [1558,] 0.81818182 0.81818182 0.90909091
      [1559,] 0.90909091 0.81818182 0.90909091
      [1560,] 1.00000000 0.81818182 0.90909091
      [1561,] 0.00000000 0.90909091 0.90909091
      [1562,] 0.09090909 0.90909091 0.90909091
      [1563,] 0.18181818 0.90909091 0.90909091
      [1564,] 0.27272727 0.90909091 0.90909091
      [1565,] 0.36363636 0.90909091 0.90909091
      [1566,] 0.45454545 0.90909091 0.90909091
      [1567,] 0.54545455 0.90909091 0.90909091
      [1568,] 0.63636364 0.90909091 0.90909091
      [1569,] 0.72727273 0.90909091 0.90909091
      [1570,] 0.81818182 0.90909091 0.90909091
      [1571,] 0.90909091 0.90909091 0.90909091
      [1572,] 1.00000000 0.90909091 0.90909091
      [1573,] 0.00000000 1.00000000 0.90909091
      [1574,] 0.09090909 1.00000000 0.90909091
      [1575,] 0.18181818 1.00000000 0.90909091
      [1576,] 0.27272727 1.00000000 0.90909091
      [1577,] 0.36363636 1.00000000 0.90909091
      [1578,] 0.45454545 1.00000000 0.90909091
      [1579,] 0.54545455 1.00000000 0.90909091
      [1580,] 0.63636364 1.00000000 0.90909091
      [1581,] 0.72727273 1.00000000 0.90909091
      [1582,] 0.81818182 1.00000000 0.90909091
      [1583,] 0.90909091 1.00000000 0.90909091
      [1584,] 1.00000000 1.00000000 0.90909091
      [1585,] 0.00000000 0.00000000 1.00000000
      [1586,] 0.09090909 0.00000000 1.00000000
      [1587,] 0.18181818 0.00000000 1.00000000
      [1588,] 0.27272727 0.00000000 1.00000000
      [1589,] 0.36363636 0.00000000 1.00000000
      [1590,] 0.45454545 0.00000000 1.00000000
      [1591,] 0.54545455 0.00000000 1.00000000
      [1592,] 0.63636364 0.00000000 1.00000000
      [1593,] 0.72727273 0.00000000 1.00000000
      [1594,] 0.81818182 0.00000000 1.00000000
      [1595,] 0.90909091 0.00000000 1.00000000
      [1596,] 1.00000000 0.00000000 1.00000000
      [1597,] 0.00000000 0.09090909 1.00000000
      [1598,] 0.09090909 0.09090909 1.00000000
      [1599,] 0.18181818 0.09090909 1.00000000
      [1600,] 0.27272727 0.09090909 1.00000000
      [1601,] 0.36363636 0.09090909 1.00000000
      [1602,] 0.45454545 0.09090909 1.00000000
      [1603,] 0.54545455 0.09090909 1.00000000
      [1604,] 0.63636364 0.09090909 1.00000000
      [1605,] 0.72727273 0.09090909 1.00000000
      [1606,] 0.81818182 0.09090909 1.00000000
      [1607,] 0.90909091 0.09090909 1.00000000
      [1608,] 1.00000000 0.09090909 1.00000000
      [1609,] 0.00000000 0.18181818 1.00000000
      [1610,] 0.09090909 0.18181818 1.00000000
      [1611,] 0.18181818 0.18181818 1.00000000
      [1612,] 0.27272727 0.18181818 1.00000000
      [1613,] 0.36363636 0.18181818 1.00000000
      [1614,] 0.45454545 0.18181818 1.00000000
      [1615,] 0.54545455 0.18181818 1.00000000
      [1616,] 0.63636364 0.18181818 1.00000000
      [1617,] 0.72727273 0.18181818 1.00000000
      [1618,] 0.81818182 0.18181818 1.00000000
      [1619,] 0.90909091 0.18181818 1.00000000
      [1620,] 1.00000000 0.18181818 1.00000000
      [1621,] 0.00000000 0.27272727 1.00000000
      [1622,] 0.09090909 0.27272727 1.00000000
      [1623,] 0.18181818 0.27272727 1.00000000
      [1624,] 0.27272727 0.27272727 1.00000000
      [1625,] 0.36363636 0.27272727 1.00000000
      [1626,] 0.45454545 0.27272727 1.00000000
      [1627,] 0.54545455 0.27272727 1.00000000
      [1628,] 0.63636364 0.27272727 1.00000000
      [1629,] 0.72727273 0.27272727 1.00000000
      [1630,] 0.81818182 0.27272727 1.00000000
      [1631,] 0.90909091 0.27272727 1.00000000
      [1632,] 1.00000000 0.27272727 1.00000000
      [1633,] 0.00000000 0.36363636 1.00000000
      [1634,] 0.09090909 0.36363636 1.00000000
      [1635,] 0.18181818 0.36363636 1.00000000
      [1636,] 0.27272727 0.36363636 1.00000000
      [1637,] 0.36363636 0.36363636 1.00000000
      [1638,] 0.45454545 0.36363636 1.00000000
      [1639,] 0.54545455 0.36363636 1.00000000
      [1640,] 0.63636364 0.36363636 1.00000000
      [1641,] 0.72727273 0.36363636 1.00000000
      [1642,] 0.81818182 0.36363636 1.00000000
      [1643,] 0.90909091 0.36363636 1.00000000
      [1644,] 1.00000000 0.36363636 1.00000000
      [1645,] 0.00000000 0.45454545 1.00000000
      [1646,] 0.09090909 0.45454545 1.00000000
      [1647,] 0.18181818 0.45454545 1.00000000
      [1648,] 0.27272727 0.45454545 1.00000000
      [1649,] 0.36363636 0.45454545 1.00000000
      [1650,] 0.45454545 0.45454545 1.00000000
      [1651,] 0.54545455 0.45454545 1.00000000
      [1652,] 0.63636364 0.45454545 1.00000000
      [1653,] 0.72727273 0.45454545 1.00000000
      [1654,] 0.81818182 0.45454545 1.00000000
      [1655,] 0.90909091 0.45454545 1.00000000
      [1656,] 1.00000000 0.45454545 1.00000000
      [1657,] 0.00000000 0.54545455 1.00000000
      [1658,] 0.09090909 0.54545455 1.00000000
      [1659,] 0.18181818 0.54545455 1.00000000
      [1660,] 0.27272727 0.54545455 1.00000000
      [1661,] 0.36363636 0.54545455 1.00000000
      [1662,] 0.45454545 0.54545455 1.00000000
      [1663,] 0.54545455 0.54545455 1.00000000
      [1664,] 0.63636364 0.54545455 1.00000000
      [1665,] 0.72727273 0.54545455 1.00000000
      [1666,] 0.81818182 0.54545455 1.00000000
      [1667,] 0.90909091 0.54545455 1.00000000
      [1668,] 1.00000000 0.54545455 1.00000000
      [1669,] 0.00000000 0.63636364 1.00000000
      [1670,] 0.09090909 0.63636364 1.00000000
      [1671,] 0.18181818 0.63636364 1.00000000
      [1672,] 0.27272727 0.63636364 1.00000000
      [1673,] 0.36363636 0.63636364 1.00000000
      [1674,] 0.45454545 0.63636364 1.00000000
      [1675,] 0.54545455 0.63636364 1.00000000
      [1676,] 0.63636364 0.63636364 1.00000000
      [1677,] 0.72727273 0.63636364 1.00000000
      [1678,] 0.81818182 0.63636364 1.00000000
      [1679,] 0.90909091 0.63636364 1.00000000
      [1680,] 1.00000000 0.63636364 1.00000000
      [1681,] 0.00000000 0.72727273 1.00000000
      [1682,] 0.09090909 0.72727273 1.00000000
      [1683,] 0.18181818 0.72727273 1.00000000
      [1684,] 0.27272727 0.72727273 1.00000000
      [1685,] 0.36363636 0.72727273 1.00000000
      [1686,] 0.45454545 0.72727273 1.00000000
      [1687,] 0.54545455 0.72727273 1.00000000
      [1688,] 0.63636364 0.72727273 1.00000000
      [1689,] 0.72727273 0.72727273 1.00000000
      [1690,] 0.81818182 0.72727273 1.00000000
      [1691,] 0.90909091 0.72727273 1.00000000
      [1692,] 1.00000000 0.72727273 1.00000000
      [1693,] 0.00000000 0.81818182 1.00000000
      [1694,] 0.09090909 0.81818182 1.00000000
      [1695,] 0.18181818 0.81818182 1.00000000
      [1696,] 0.27272727 0.81818182 1.00000000
      [1697,] 0.36363636 0.81818182 1.00000000
      [1698,] 0.45454545 0.81818182 1.00000000
      [1699,] 0.54545455 0.81818182 1.00000000
      [1700,] 0.63636364 0.81818182 1.00000000
      [1701,] 0.72727273 0.81818182 1.00000000
      [1702,] 0.81818182 0.81818182 1.00000000
      [1703,] 0.90909091 0.81818182 1.00000000
      [1704,] 1.00000000 0.81818182 1.00000000
      [1705,] 0.00000000 0.90909091 1.00000000
      [1706,] 0.09090909 0.90909091 1.00000000
      [1707,] 0.18181818 0.90909091 1.00000000
      [1708,] 0.27272727 0.90909091 1.00000000
      [1709,] 0.36363636 0.90909091 1.00000000
      [1710,] 0.45454545 0.90909091 1.00000000
      [1711,] 0.54545455 0.90909091 1.00000000
      [1712,] 0.63636364 0.90909091 1.00000000
      [1713,] 0.72727273 0.90909091 1.00000000
      [1714,] 0.81818182 0.90909091 1.00000000
      [1715,] 0.90909091 0.90909091 1.00000000
      [1716,] 1.00000000 0.90909091 1.00000000
      [1717,] 0.00000000 1.00000000 1.00000000
      [1718,] 0.09090909 1.00000000 1.00000000
      [1719,] 0.18181818 1.00000000 1.00000000
      [1720,] 0.27272727 1.00000000 1.00000000
      [1721,] 0.36363636 1.00000000 1.00000000
      [1722,] 0.45454545 1.00000000 1.00000000
      [1723,] 0.54545455 1.00000000 1.00000000
      [1724,] 0.63636364 1.00000000 1.00000000
      [1725,] 0.72727273 1.00000000 1.00000000
      [1726,] 0.81818182 1.00000000 1.00000000
      [1727,] 0.90909091 1.00000000 1.00000000
      [1728,] 1.00000000 1.00000000 1.00000000
      
      $n
      [1] 1728
      

