# plane() works

    Code
      plane(n = 100, coef_x1 = 1, coef_x2 = 1, coef_y1 = -1, coef_y2 = 1,
        intercept_x = -10, intercept_y = 8, u_min = 10, u_max = 30, v_min = 10,
        v_max = 20, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                 [,1]        [,2]         [,3]          [,4]
        [1,] 38.06529  -0.1830627  0.046811273 -0.0397026339
        [2,] 27.34585   2.5625671 -0.012496258  0.0290763175
        [3,] 21.16194   8.7465377 -0.039036306  0.0422360181
        [4,] 22.69912   6.4338428  0.012114244 -0.0214310022
        [5,] 20.57979  14.6530384 -0.007777032 -0.0499433291
        [6,] 32.54503  -1.7862650 -0.043311664 -0.0356851794
        [7,] 30.73466  -7.2881825  0.009618158  0.0015637302
        [8,] 19.44866  -1.1737037  0.040446538 -0.0123396746
        [9,] 31.68997   3.8059987 -0.049745073 -0.0284339315
       [10,] 26.78050   2.4224215 -0.015265306 -0.0350829806
       [11,] 22.55121   3.0012882  0.036571148 -0.0353439124
       [12,] 24.67340   6.3530023  0.015919120  0.0423142502
       [13,] 16.95236  12.4425380 -0.031443569 -0.0051962465
       [14,] 17.24686   8.3570084  0.044940477 -0.0389469245
       [15,] 23.78803  -4.2913413 -0.028938895 -0.0086575911
       [16,] 28.95666   3.0204627  0.013595432  0.0232040592
       [17,] 18.00771   3.1614595  0.002368991 -0.0245691278
       [18,] 22.98414   2.2354769 -0.030572272 -0.0315889175
       [19,] 34.53390  -7.4083066 -0.018436977  0.0227344875
       [20,] 37.13628  -1.8840554  0.045953311 -0.0366494890
       [21,] 28.74126   1.0869808  0.034806118  0.0157848667
       [22,] 29.23264  -8.7350911  0.004200594  0.0070135517
       [23,] 26.88059   5.2281353 -0.030929957  0.0208199039
       [24,] 14.64936  11.4165465 -0.023326323 -0.0189224581
       [25,] 27.74610   1.7388255  0.038856192  0.0338216087
       [26,] 37.18762  -1.2830828  0.036005257 -0.0460992394
       [27,] 23.02161   2.1751909 -0.005547783  0.0447378346
       [28,] 16.30969  11.6633176  0.010797826  0.0272497393
       [29,] 17.14388   2.9375274  0.029635492 -0.0160971409
       [30,] 32.36522   4.0710232  0.009967849  0.0464448324
       [31,] 29.88198   1.9592347 -0.006457079  0.0179349351
       [32,] 14.71168   6.6890438 -0.030954550 -0.0207382537
       [33,] 26.97118   9.8648475 -0.025088984  0.0037443788
       [34,] 13.34293   7.4718654  0.031934072 -0.0118583800
       [35,] 29.82356   2.4865690 -0.035403466  0.0063740385
       [36,] 17.56274  15.0600768 -0.042859625 -0.0297865495
       [37,] 31.07166   2.7377337 -0.034428535 -0.0433482581
       [38,] 15.73687   5.3311466  0.034162961 -0.0163532625
       [39,] 34.18389  -1.2757472 -0.045406635  0.0359919606
       [40,] 13.66898   5.5663674  0.012260502 -0.0370901504
       [41,] 31.28573  -7.0931311  0.002252682 -0.0496382012
       [42,] 21.44132   9.7052804  0.004865140  0.0114451926
       [43,] 16.82610   8.4510034  0.037104514 -0.0157686300
       [44,] 27.50368   4.7326645  0.019189041 -0.0482725061
       [45,] 26.76326   7.1673272  0.016947191  0.0417446218
       [46,] 27.82745   7.8905092  0.023474528  0.0490760001
       [47,] 17.98650  12.3005478 -0.046460505 -0.0143416769
       [48,] 22.77130  -2.6648940 -0.014047195 -0.0389693632
       [49,] 31.50927   4.0713054 -0.002774406 -0.0050521928
       [50,] 25.77285   0.4949728  0.021978159 -0.0338490285
       [51,] 23.92458  -3.8812268  0.001459893  0.0007207744
       [52,] 37.41894  -1.6252462 -0.032680244  0.0358561296
       [53,] 26.95733   3.1994629 -0.006952650 -0.0343432767
       [54,] 16.42082   6.9811431  0.049056897  0.0380912595
       [55,] 26.39955   2.2407739 -0.037429136 -0.0017651984
       [56,] 35.25352  -3.4751869  0.040186682  0.0271230818
       [57,] 22.85841  13.2650500  0.037823953 -0.0153674109
       [58,] 30.49246  -6.8580317 -0.013801423 -0.0435791666
       [59,] 34.69294  -3.1144298  0.014180800 -0.0007038843
       [60,] 30.58163 -10.9610383  0.016110678 -0.0042624283
       [61,] 26.34368   7.4467257  0.045699345  0.0307058573
       [62,] 16.10411   8.2497215 -0.017281139 -0.0172181919
       [63,] 14.49862   5.0879213 -0.022220930  0.0344564827
       [64,] 20.22470  12.0836258  0.048801365 -0.0145525717
       [65,] 28.15990   0.4976967  0.007458667  0.0024064121
       [66,] 26.28815  -1.0116143 -0.033425671  0.0470545179
       [67,] 31.24407  -0.6719509 -0.035560294 -0.0429631366
       [68,] 29.78562  -9.9229317  0.046699327  0.0314480813
       [69,] 27.70097   1.4303849  0.021227714 -0.0469257004
       [70,] 14.16164   9.7023185  0.028738201  0.0067218661
       [71,] 18.77487   3.3523407 -0.048813058 -0.0365070718
       [72,] 28.30731  -2.2965836 -0.025414831  0.0148092618
       [73,] 21.11610   2.5485301 -0.044960774 -0.0288158743
       [74,] 28.78199  -3.3163322 -0.032921567 -0.0393909458
       [75,] 30.44927  -5.2075000  0.004026652 -0.0436995254
       [76,] 35.08717  -3.0559605  0.014284641 -0.0465217978
       [77,] 33.89897   3.5903564 -0.032963758 -0.0291392233
       [78,] 16.58404  10.7266079  0.049464466  0.0114881480
       [79,] 23.31986  13.7065734 -0.036069776 -0.0194828836
       [80,] 14.67288   4.3366145  0.020289299 -0.0485348954
       [81,] 17.27004   4.7070903  0.036633093 -0.0097199444
       [82,] 17.07598  10.6164142 -0.029914531 -0.0044783109
       [83,] 13.97404   7.7474869  0.035608689  0.0366461525
       [84,] 28.54136  -3.3973583  0.030768446 -0.0395055116
       [85,] 37.85737  -3.0101006  0.022653194 -0.0053874930
       [86,] 36.50433   0.2495649  0.014886355  0.0058034629
       [87,] 31.31377  -6.5855703 -0.003475857  0.0060975001
       [88,] 16.37950   7.3071009  0.021506445 -0.0234173421
       [89,] 13.92389   7.8206525  0.031937469  0.0187736356
       [90,] 23.78526  -3.8812011 -0.037160310 -0.0442129100
       [91,] 28.82528  -4.7846283  0.049801787 -0.0419374371
       [92,] 26.34131   3.3073851  0.012772074 -0.0498900986
       [93,] 22.48494   3.3062045  0.005877741  0.0109741065
       [94,] 23.34426   2.9233602  0.025761254 -0.0074751925
       [95,] 28.50014  -8.0604667  0.027342288 -0.0305212979
       [96,] 16.03319   6.6135615 -0.035392174 -0.0172342707
       [97,] 25.55586  -1.6151166  0.018060863 -0.0040695532
       [98,] 25.14713   9.3794330 -0.004448415  0.0392953042
       [99,] 34.18028   1.7857068 -0.047147391  0.0337261188
      [100,] 12.60947   6.0769211 -0.017987990  0.0190098491

---

    Code
      plane(n = 100, coef_x1 = 1, coef_x2 = 1, coef_y1 = -1, coef_y2 = 1,
        intercept_x = -10, intercept_y = 8, u_min = 10, u_max = 30, v_min = 10,
        v_max = 20, num_noise = 0)
    Output
                 [,1]       [,2]
        [1,] 25.78840  9.3636134
        [2,] 22.39959  9.3017729
        [3,] 16.81304  5.7658922
        [4,] 28.91128 -5.3826413
        [5,] 16.40742  4.3913951
        [6,] 18.02165 12.1188274
        [7,] 32.42536 -8.0625336
        [8,] 14.31986  8.0488027
        [9,] 30.18092 -1.4151614
       [10,] 19.34168 16.8468751
       [11,] 20.63491  0.8632219
       [12,] 34.49198 -2.3854661
       [13,] 37.28743 -2.1688173
       [14,] 27.93744 -9.6935692
       [15,] 25.06744 -6.0312750
       [16,] 23.86933 12.9257746
       [17,] 30.32732 -9.5479385
       [18,] 27.45841  4.8044186
       [19,] 19.83353  7.4391072
       [20,] 25.22313 -4.0275102
       [21,] 12.10592  9.7952099
       [22,] 19.25364 10.4504571
       [23,] 22.62221 -1.9675348
       [24,] 30.80505 -8.0893899
       [25,] 17.18856  8.9824890
       [26,] 31.70029 -2.5103732
       [27,] 26.80716 -4.4395431
       [28,] 21.28698  7.0584164
       [29,] 22.39579  0.4645435
       [30,] 26.84256 -8.7766727
       [31,] 20.76963  8.2574219
       [32,] 22.35107  0.1773645
       [33,] 14.19381 11.4878810
       [34,] 23.71080  9.5704806
       [35,] 30.88201  1.0885786
       [36,] 21.79062  6.1606107
       [37,] 29.38237 -2.4443061
       [38,] 11.80213  8.9532780
       [39,] 23.50008  0.6228702
       [40,] 34.26828 -4.4032531
       [41,] 17.88059  5.1450151
       [42,] 24.48451 12.9765461
       [43,] 34.79613 -2.0165809
       [44,] 29.27857 -6.5741100
       [45,] 14.90550  9.3133168
       [46,] 18.18142  2.8235003
       [47,] 35.68227  1.4614386
       [48,] 30.99404 -0.8329754
       [49,] 27.63232 -8.1858842
       [50,] 26.62408  4.4837323
       [51,] 24.65487  1.2925848
       [52,] 22.69335  0.2188524
       [53,] 25.41107 -0.9730640
       [54,] 19.70276  6.1905111
       [55,] 26.38128 -4.3208819
       [56,] 27.51592 -2.1523843
       [57,] 13.94228  9.6356549
       [58,] 27.44062 -3.3397431
       [59,] 38.33725 -3.4752007
       [60,] 19.17528  1.7289027
       [61,] 17.34289  1.5464878
       [62,] 37.46677 -0.5741018
       [63,] 18.94819  3.4879830
       [64,] 32.50590 -6.5100135
       [65,] 17.46119 14.6971137
       [66,] 20.77804 11.1023816
       [67,] 22.23525 -2.6409600
       [68,] 18.18156 12.6931696
       [69,] 34.52086  2.9024679
       [70,] 28.97859 -0.7564741
       [71,] 19.75909 14.7189445
       [72,] 30.03877  0.6396841
       [73,] 33.62499  3.6656055
       [74,] 28.53133  1.8541358
       [75,] 22.47068  9.7616953
       [76,] 30.48569  0.7776023
       [77,] 32.94914 -1.8559350
       [78,] 26.56970  1.2914729
       [79,] 33.93088 -0.6109759
       [80,] 18.46778  6.2387851
       [81,] 32.37526  4.3037232
       [82,] 29.88224 -6.1741185
       [83,] 21.29613  7.8994205
       [84,] 21.13577  0.2271674
       [85,] 16.00766  9.4924676
       [86,] 21.09624  8.2097704
       [87,] 15.86101  3.9106408
       [88,] 31.82020 -8.7771017
       [89,] 25.36253 11.3428426
       [90,] 25.54107 -6.7195285
       [91,] 33.57904 -4.6556367
       [92,] 28.93301  8.0822794
       [93,] 16.70850 12.4795272
       [94,] 34.00339 -7.6410675
       [95,] 30.28491 -8.3769394
       [96,] 31.63143 -4.0480191
       [97,] 23.67836 -1.7739949
       [98,] 27.10267  9.4126448
       [99,] 20.85532  4.8614858
      [100,] 16.16290  7.1622908

# two_long_clust() works

    Code
      two_long_clust(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]        [,2]          [,3]          [,4]
        [1,]   3.9532963  -5.5612581  0.0139380306  3.390966e-02
        [2,]  -0.9264759   4.6853836  0.0222554683 -4.143774e-02
        [3,]  -1.8761690   2.5885781  0.0273821183 -3.741529e-02
        [4,]   6.8544358   2.2695727 -0.0307347960  4.039443e-02
        [5,]   5.1325030  12.4022259  0.0249599343  2.845354e-02
        [6,]   4.5375679   1.6809638  0.0402429315  1.434015e-02
        [7,]   1.4036217   8.6830838 -0.0462197369  1.508975e-02
        [8,]   8.1720491   9.4129084  0.0393223643 -2.946663e-02
        [9,]   6.6065971   7.8217498 -0.0239902109 -2.687273e-02
       [10,]  17.9377182  10.4398605  0.0487629842  2.450101e-02
       [11,]  11.0862648   6.9155396  0.0055707767  3.236095e-02
       [12,]  10.9346576  13.6259543 -0.0371936114 -2.834071e-02
       [13,]  12.7614544   8.3432526 -0.0436406263  1.017609e-02
       [14,]  12.7829400  13.4185407 -0.0390775228 -4.951010e-03
       [15,]  12.4711390  11.5139846 -0.0227467791 -9.329137e-03
       [16,]  16.1403344  15.4877047  0.0276411119  9.235702e-03
       [17,]  15.0650900  18.0318778 -0.0446881498  1.424448e-02
       [18,]  18.0228122  20.1616871 -0.0016349768  2.765936e-02
       [19,]  19.2238781  21.0366824  0.0240139348 -2.357522e-02
       [20,]  21.9404133  24.0568866 -0.0181266045 -9.247106e-04
       [21,]  24.0125220  19.8305108  0.0492232343  2.226533e-02
       [22,]  18.0089388  17.6059636  0.0329920338  1.087636e-02
       [23,]  21.5463198  20.6846337 -0.0064743672 -4.905825e-03
       [24,]  19.0170850  28.4204685 -0.0422361016 -2.455052e-02
       [25,]  25.0429542  24.2088006  0.0344848166 -1.645280e-03
       [26,]  26.1167373  24.8901933 -0.0305266531 -2.338030e-02
       [27,]  26.3311444  26.5255063 -0.0231167459 -4.603940e-02
       [28,]  27.4070889  30.4407412  0.0194286022  3.328674e-02
       [29,]  25.3644757  24.5013061  0.0001718890  4.064574e-02
       [30,]  32.7637388  27.9101129 -0.0340480692 -1.298184e-02
       [31,]  29.4129097  24.8495570  0.0237194850 -1.381245e-03
       [32,]  28.3135833  32.7682518 -0.0004342598 -9.914179e-03
       [33,]  33.0878551  31.4358087  0.0482351774 -2.530526e-03
       [34,]  35.0036939  36.1823120  0.0196492030 -2.729615e-02
       [35,]  34.8126897  32.3198517 -0.0194835741  4.977361e-02
       [36,]  33.7261922  41.7839898  0.0159249835 -3.738483e-02
       [37,]  35.3496554  40.9231865 -0.0245666893 -1.781895e-02
       [38,]  40.0009246  36.6966844  0.0478778662  2.909667e-02
       [39,]  39.6401678  40.8582021 -0.0021930194  3.765714e-02
       [40,]  36.3699826  42.2503787 -0.0416788434 -1.222253e-02
       [41,]  38.1074908  36.6723598  0.0231610519 -2.075209e-02
       [42,]  37.2502308  37.8112928  0.0262300945  4.898746e-02
       [43,]  47.7185437  40.1929271 -0.0370317762 -3.192730e-02
       [44,]  46.8020245  43.2617120 -0.0346316919  2.347345e-02
       [45,]  40.1990572  41.2610461  0.0410195358  3.927989e-02
       [46,]  47.4218434  36.3570225  0.0166052091  4.121712e-02
       [47,]  45.4668159  45.5563893 -0.0305520805 -3.928497e-02
       [48,]  50.2956153  44.7494996 -0.0245675498  3.702536e-02
       [49,]  48.9897966  46.5917958 -0.0345455090  1.453956e-02
       [50,]  51.1175979  54.7087324 -0.0003508595  1.511670e-02
       [51,]  57.5562777  46.2056359 -0.0034057023 -2.085086e-02
       [52,]  51.7245601  55.2633830 -0.0011862537  2.631276e-02
       [53,]  55.2631715  42.2346172 -0.0109603464  3.924439e-02
       [54,]  51.1825996  53.1176209  0.0212193804  3.962608e-02
       [55,]  57.4481140  51.6392024 -0.0217553976  3.601795e-02
       [56,]  54.0648268  51.8461061 -0.0191707506 -2.132409e-02
       [57,]  56.5271759  55.6081368  0.0442334460 -4.799574e-02
       [58,]  52.6778916  56.3437630 -0.0219509164 -3.955065e-02
       [59,]  54.9975620  56.0170240 -0.0495311228 -3.353678e-02
       [60,]  58.6705674  60.8144074  0.0113840646  3.749058e-03
       [61,]  60.6935358  61.2197965  0.0155089854  2.561923e-02
       [62,]  62.6203033  62.6443931 -0.0401021889 -4.328054e-02
       [63,]  62.5615878  64.9614578  0.0163494704 -2.657243e-02
       [64,]  61.9233390  67.8598461 -0.0425397867 -2.482937e-03
       [65,]  60.2239143  62.7546528  0.0480898142  2.067488e-02
       [66,]  66.5051007  66.3976404  0.0308108424 -2.909830e-02
       [67,]  70.7102312  66.2819877 -0.0071905138  5.261940e-03
       [68,]  68.7086295  67.4813781  0.0412790195  1.225310e-03
       [69,]  70.4241580  63.4932764 -0.0240459894 -2.573979e-02
       [70,]  70.9803185  72.2398746 -0.0193376644 -4.920211e-02
       [71,]  68.5093001  61.9426477  0.0423996357  3.828112e-03
       [72,]  69.9554795  69.7815296 -0.0184977262 -4.840133e-02
       [73,]  74.4878673  76.1642905 -0.0198984539  1.622421e-02
       [74,]  73.8720433  71.8971797 -0.0116929745  4.705459e-02
       [75,]  77.5104327  73.6190597  0.0232275496 -5.583441e-03
       [76,]  71.1921070  75.0542044 -0.0192702085 -1.856189e-02
       [77,]  76.8210769  72.9739997 -0.0320126913 -3.931910e-02
       [78,]  77.2410156  76.8672158 -0.0081955564 -2.130964e-02
       [79,]  81.9526535  76.8142231 -0.0313546496  2.342741e-02
       [80,]  80.3940895  78.9470660  0.0244275016  2.933642e-02
       [81,]  82.4142716  82.6013239 -0.0151788390 -2.671146e-02
       [82,]  76.7711580  84.0401924 -0.0351408962 -2.874434e-03
       [83,]  82.2475320  82.1810693  0.0215082376 -4.335716e-02
       [84,]  83.9844920  78.5808469  0.0027284850  3.560783e-02
       [85,]  84.4268197  78.3900471  0.0387120224 -4.759485e-02
       [86,]  82.5426556  81.6898350  0.0227838194 -2.414846e-02
       [87,]  84.2801960  83.5998535  0.0251240733 -3.752585e-02
       [88,]  85.9413552  82.4099121 -0.0464932609 -4.680808e-02
       [89,]  93.8527399  85.5662156  0.0199507820  3.778814e-02
       [90,]  93.9734242  87.4712454 -0.0256514851  4.903727e-02
       [91,]  87.4628620  89.2616856 -0.0405866878  1.696616e-03
       [92,]  88.3226550  94.3294575  0.0028731658  1.757738e-02
       [93,]  95.0126541  91.5936274  0.0444275602 -1.058579e-02
       [94,]  91.7331553  93.4603250 -0.0491111540  3.779881e-02
       [95,]  91.3355200  95.4683324 -0.0416546314  9.174128e-03
       [96,]  93.4443100  90.7973729 -0.0341986140 -4.528655e-02
       [97,]  95.1585787  96.8359327 -0.0086308938 -2.627506e-02
       [98,]  93.5046204  94.4188297  0.0107749348  2.480230e-02
       [99,]  96.4011764  97.6934416  0.0150154262  1.863678e-02
      [100,] 102.8157596 101.9497914  0.0324984893  4.428247e-02
      [101,]  21.1227422 -20.9294867 -0.0357600727  3.309084e-02
      [102,]  18.8716424 -22.3686532 -0.0185067930  6.205570e-04
      [103,]  13.9059678 -23.0633409  0.0271053146  1.274938e-02
      [104,]  24.8212683 -13.5806975  0.0223568213  2.556577e-02
      [105,]  20.7779629 -12.8840504  0.0360059179 -2.704463e-03
      [106,]  24.1699965 -20.8183735 -0.0107024108 -1.715678e-02
      [107,]  23.3778939  -8.8966304  0.0181858625  2.553369e-02
      [108,]  24.6640788 -14.1712181  0.0281567011 -1.342221e-02
      [109,]  27.6510249 -12.1572738 -0.0038288075 -2.135242e-02
      [110,]  30.0442810 -10.1986659 -0.0409427823 -4.435638e-02
      [111,]  30.5304061 -11.5319234  0.0325093341 -3.480150e-02
      [112,]  32.0369899  -9.8457284 -0.0205325620  7.342764e-03
      [113,]  31.9014693  -9.2528761 -0.0355930796 -7.514273e-03
      [114,]  35.5289863  -4.7386588  0.0487806467  1.997895e-02
      [115,]  32.0281749  -8.9420475  0.0448191922  2.137183e-02
      [116,]  40.6639759  -3.4122532 -0.0439755222 -8.705977e-03
      [117,]  38.9468167  -2.5208909  0.0361030853  1.731751e-02
      [118,]  38.4310301  -6.7686992 -0.0213141399 -4.477979e-02
      [119,]  34.0445565  -1.0957223  0.0036367978  4.190433e-02
      [120,]  39.3357599  -5.1368689  0.0340218931  2.007988e-02
      [121,]  40.4986537  -3.2813741  0.0304943694 -3.115944e-02
      [122,]  36.4259868  -0.3820704 -0.0085205035 -2.308626e-02
      [123,]  45.0148875   0.7735584  0.0367266138  3.330740e-02
      [124,]  42.4376003   5.4292061  0.0264216963  4.415502e-02
      [125,]  39.6239518   4.6105650  0.0091447428 -3.834558e-02
      [126,]  40.1864880   2.8783288 -0.0059495745  2.309174e-02
      [127,]  45.0505191   1.0036258  0.0281619394 -8.338904e-03
      [128,]  47.2288892  10.6068802 -0.0017269597  3.812055e-02
      [129,]  47.2902470   9.7779811  0.0256983434  3.733654e-05
      [130,]  48.4605164   9.9630759  0.0496705881 -4.724280e-02
      [131,]  50.2583349   8.1038191 -0.0051352489 -1.894036e-02
      [132,]  49.3059955  11.0928427  0.0273578355  7.934875e-03
      [133,]  49.1916225  12.4521021  0.0115915452  2.471494e-02
      [134,]  53.6833751  18.2916361 -0.0264064001 -9.015889e-03
      [135,]  53.4663906  17.5941203 -0.0198529340 -2.119069e-03
      [136,]  57.0863156  10.3540628  0.0002438598  2.862516e-02
      [137,]  58.1132490  17.4339721  0.0053096824 -4.937218e-02
      [138,]  52.3871104  18.5648457  0.0362229523  1.189991e-03
      [139,]  58.3352683  13.7312096  0.0193852589 -1.052345e-02
      [140,]  64.4622573  17.3251035 -0.0093251564  1.419472e-02
      [141,]  57.8803094  21.5051598  0.0248719533 -3.895420e-02
      [142,]  65.8745204  16.8013214 -0.0473052719  1.607776e-02
      [143,]  61.0724348  26.7770151 -0.0238977435  3.519951e-02
      [144,]  65.9461483  21.2733067  0.0264777167 -4.306235e-02
      [145,]  63.1839135  19.9917226  0.0189059034 -2.677924e-02
      [146,]  70.3441853  20.3578872  0.0349754151  3.370115e-02
      [147,]  67.5987940  21.7423731 -0.0457185472 -7.628256e-03
      [148,]  68.7169472  22.5802521 -0.0108053458  1.474725e-03
      [149,]  68.3890842  30.0340101  0.0427678243  2.119039e-02
      [150,]  64.4069261  28.8127041 -0.0155390420  1.268381e-02
      [151,]  69.2556673  27.5522929  0.0102627469  1.346007e-02
      [152,]  68.1644160  28.4227011  0.0254389687 -1.548746e-02
      [153,]  74.5999382  28.5498483  0.0178099468 -2.307818e-02
      [154,]  74.4361362  35.7519571  0.0105336501  4.217972e-02
      [155,]  73.0217485  36.1930467  0.0296980240  4.829483e-02
      [156,]  75.7294938  38.7832051  0.0131823413  2.072083e-02
      [157,]  80.1776912  33.1851105  0.0221103435  3.700059e-02
      [158,]  75.5286207  41.4805520  0.0194955980 -2.682958e-02
      [159,]  77.4031617  36.2360345 -0.0343102385  5.010260e-03
      [160,]  76.6045570  34.0746628  0.0354791025  2.138814e-02
      [161,]  77.6952372  40.6098573  0.0455530925  3.384213e-02
      [162,]  80.6092074  42.8927501 -0.0444633594 -2.381642e-02
      [163,]  80.4028964  36.6397824  0.0278191108 -3.741723e-02
      [164,]  83.2151198  43.3212244  0.0100205618 -2.485847e-02
      [165,]  85.2690275  39.4447551 -0.0207915091 -1.459736e-03
      [166,]  83.3985470  47.3851627 -0.0194021311 -4.685443e-03
      [167,]  84.6695505  41.9320165  0.0420285729 -4.021027e-02
      [168,]  89.6664172  50.9058909 -0.0143736571  4.312391e-02
      [169,]  90.1179658  46.5005071 -0.0471166582  1.495112e-02
      [170,]  86.2813128  48.4780254 -0.0011105877 -1.122955e-02
      [171,]  88.9000801  46.9081269 -0.0323901738  4.721409e-02
      [172,]  85.3368879  49.8631133 -0.0133922930 -4.704446e-02
      [173,]  95.3255159  54.6501819 -0.0464529631  6.842718e-03
      [174,]  93.5931793  53.9892781 -0.0119273066  1.286648e-02
      [175,]  91.0941384  50.6583837 -0.0211618534 -3.359787e-02
      [176,]  95.1106552  51.5108012 -0.0163164396 -4.484048e-02
      [177,]  92.8647678  55.1894893 -0.0154660322 -4.241089e-02
      [178,]  99.1790424  56.6677338  0.0006941579 -3.371412e-02
      [179,]  94.7654403  57.4982298 -0.0265995397 -1.659019e-02
      [180,]  92.2722114  66.8506194  0.0164671519 -2.000044e-02
      [181,] 100.3691726  59.2530520 -0.0433949099  1.690339e-02
      [182,] 100.3385727  64.8488876  0.0214593931 -9.961860e-03
      [183,] 103.5902814  61.5705600 -0.0059777297 -2.888342e-02
      [184,] 100.4446074  63.6111478  0.0331852962 -2.930204e-02
      [185,] 108.4053038  64.3596720  0.0124993692 -4.338725e-02
      [186,] 104.4963642  61.7101257 -0.0065300648  1.025363e-03
      [187,] 103.4919137  64.1717214  0.0411417381  6.947431e-03
      [188,] 107.8754590  70.2337765  0.0247844953 -3.107307e-02
      [189,] 111.1043592  68.4373486 -0.0435268620 -2.983059e-02
      [190,] 109.8438730  68.2281448  0.0458923144 -3.587464e-03
      [191,] 109.8705405  70.8790928 -0.0046170085  3.662836e-02
      [192,] 111.7190571  71.6265022 -0.0450764619 -2.557130e-02
      [193,] 115.3952068  67.7999658 -0.0059401513 -4.820601e-02
      [194,] 111.9375191  72.5752580  0.0081883668 -4.970583e-02
      [195,] 112.9301514  72.8701575  0.0304601316  1.212139e-02
      [196,] 113.9749847  74.8307040  0.0020829631  3.294325e-02
      [197,] 115.0910873  77.8821985  0.0304781620  1.258265e-02
      [198,] 116.7131579  78.4439615 -0.0425765788 -1.569915e-04
      [199,] 118.2743235  81.0791120  0.0114159942 -1.541384e-02
      [200,] 116.8948203  81.9741286  0.0233740703  3.356151e-02

---

    Code
      two_long_clust(n = 200, num_noise = 0)
    Output
                   [,1]        [,2]
        [1,]   4.614113  -0.8152468
        [2,]   1.016956   4.0900510
        [3,]   6.756617  -1.5781608
        [4,]   5.598659   9.3027720
        [5,]   5.768224   7.0805598
        [6,]   9.765680   6.4702984
        [7,]   8.776972  10.4375477
        [8,]   6.497193   8.8509213
        [9,]   3.905623   9.7130982
       [10,]   6.924691   9.5317722
       [11,]   6.374684   8.3557828
       [12,]   8.895131   9.5943937
       [13,]  13.023348  10.0190425
       [14,]  16.591808  18.0959078
       [15,]  19.440541  10.0744655
       [16,]  17.244169  12.9219306
       [17,]  14.927042  10.9119527
       [18,]  18.692661  15.8135569
       [19,]  21.889035  18.1105362
       [20,]  24.228532  20.1288655
       [21,]  18.713677  18.9621181
       [22,]  24.773081  25.3276732
       [23,]  25.231612  16.0541874
       [24,]  25.568945  27.3417337
       [25,]  20.986264  25.8425796
       [26,]  23.928215  24.3853733
       [27,]  26.030771  27.2121438
       [28,]  33.293475  24.4789509
       [29,]  29.440147  22.2181282
       [30,]  29.069182  24.9211989
       [31,]  30.912809  31.7230192
       [32,]  33.631077  33.8051979
       [33,]  31.859749  28.9755236
       [34,]  31.724063  34.5999964
       [35,]  32.560369  36.1351962
       [36,]  32.788283  33.8355467
       [37,]  33.109826  37.6670981
       [38,]  37.599913  35.9003759
       [39,]  34.772085  32.8017051
       [40,]  40.620687  38.1253516
       [41,]  42.261407  39.8181804
       [42,]  37.538238  38.7574710
       [43,]  40.993413  39.3737393
       [44,]  45.331187  44.6247746
       [45,]  40.829423  50.0368123
       [46,]  46.956960  47.5772235
       [47,]  47.026462  49.7126211
       [48,]  44.077113  48.7198864
       [49,]  46.618638  51.3352077
       [50,]  50.957194  50.2626347
       [51,]  53.923429  53.8154321
       [52,]  49.481930  51.8828641
       [53,]  56.442572  53.9149374
       [54,]  57.170908  52.6711300
       [55,]  50.927177  56.0223693
       [56,]  57.106188  55.8309621
       [57,]  55.053470  48.7927847
       [58,]  56.114913  55.6449743
       [59,]  58.486958  62.3616481
       [60,]  58.731365  60.9322574
       [61,]  57.151756  54.7984721
       [62,]  57.156733  58.5380424
       [63,]  59.372274  57.9936693
       [64,]  58.712189  59.9063332
       [65,]  63.796794  67.2484700
       [66,]  68.136890  68.1308344
       [67,]  68.202040  65.9417723
       [68,]  68.424932  64.7671084
       [69,]  65.725770  65.6297107
       [70,]  69.066821  63.7148032
       [71,]  67.378298  70.9586056
       [72,]  65.549467  72.3147085
       [73,]  73.812601  74.8311678
       [74,]  70.282392  73.7443449
       [75,]  75.180990  73.0580465
       [76,]  76.896524  72.3127351
       [77,]  79.779590  77.9812486
       [78,]  72.169962  74.0027697
       [79,]  77.958135  82.4263301
       [80,]  78.875165  79.3055052
       [81,]  77.251499  82.3445088
       [82,]  82.970496  79.4785608
       [83,]  77.596368  88.7636703
       [84,]  86.689655  82.1712277
       [85,]  88.362058  82.6768020
       [86,]  83.448603  84.0977428
       [87,]  89.203106  84.7158721
       [88,]  85.744226  86.6821797
       [89,]  85.634321  90.5138350
       [90,]  87.176655  89.2462167
       [91,]  91.475808  91.2416082
       [92,]  89.431131  91.3413480
       [93,]  89.103570  92.1423806
       [94,]  90.870253  94.4314269
       [95,]  92.101277  92.3499678
       [96,]  95.561784  96.9974882
       [97,]  97.744257  97.0749954
       [98,] 101.368471  94.4913879
       [99,]  94.385575 103.5475753
      [100,] 100.016136  96.5795823
      [101,]  23.240017 -26.3836808
      [102,]  20.941358 -20.9043471
      [103,]  21.972963 -20.5134288
      [104,]  23.573899  -8.1212254
      [105,]  29.726070 -17.8367927
      [106,]  23.035754 -17.0876132
      [107,]  24.384979 -19.0014947
      [108,]  31.712734 -13.5758047
      [109,]  23.201065 -14.6787018
      [110,]  30.144495 -15.1120944
      [111,]  30.638087 -15.2199331
      [112,]  26.283771 -12.0530238
      [113,]  35.211692  -9.4291734
      [114,]  34.501557  -9.6143908
      [115,]  28.712698 -10.3788785
      [116,]  36.611883   0.5057805
      [117,]  36.356292  -2.1395317
      [118,]  39.702456  -5.2435557
      [119,]  37.486873   0.2480274
      [120,]  37.538307   4.9717005
      [121,]  37.810960   2.0109566
      [122,]  37.008419   5.7386977
      [123,]  42.982139   4.4294679
      [124,]  46.351509  -2.7504175
      [125,]  44.869833   5.2549913
      [126,]  43.213962   4.0285798
      [127,]  47.075541   9.7906894
      [128,]  45.440809   9.0472163
      [129,]  48.329771   5.9989400
      [130,]  53.820579   3.8966199
      [131,]  51.107995  13.8055904
      [132,]  45.773333  12.6827464
      [133,]  50.386505  14.2470298
      [134,]  55.663945  10.4433036
      [135,]  54.514838   9.8390589
      [136,]  59.350255  13.7033786
      [137,]  57.766536  16.8156107
      [138,]  56.490672  20.4814117
      [139,]  60.009669  17.2973528
      [140,]  64.559660  15.7440798
      [141,]  58.162442  16.7868152
      [142,]  57.365145  27.9903681
      [143,]  69.594629  21.5044706
      [144,]  60.839307  25.9980982
      [145,]  66.255593  25.2363406
      [146,]  63.540998  22.6745583
      [147,]  64.193181  25.5146921
      [148,]  70.184694  21.6211095
      [149,]  65.251194  30.2702368
      [150,]  70.177901  34.7728084
      [151,]  68.206304  28.0256655
      [152,]  69.668806  30.2796076
      [153,]  74.650200  32.0705164
      [154,]  73.406696  37.8224403
      [155,]  73.136488  32.9300653
      [156,]  75.496202  34.0355143
      [157,]  75.465707  42.1174197
      [158,]  69.759028  34.4465253
      [159,]  77.393121  40.1959801
      [160,]  71.393413  41.0209042
      [161,]  83.598565  46.3598623
      [162,]  76.223027  42.6867087
      [163,]  88.338336  45.6839345
      [164,]  88.822822  40.5653161
      [165,]  83.027045  41.5952528
      [166,]  80.869828  48.1218404
      [167,]  86.838531  46.8064201
      [168,]  88.135860  47.4105429
      [169,]  87.551376  49.7965771
      [170,]  90.961551  52.4484643
      [171,]  87.341994  45.6410312
      [172,]  91.686661  50.2160369
      [173,]  92.402539  48.7258139
      [174,]  97.507934  52.8753448
      [175,]  92.997458  51.0520032
      [176,]  95.984980  50.3924350
      [177,]  94.899024  54.8087627
      [178,]  95.034702  63.1706573
      [179,]  97.672327  55.6749005
      [180,]  94.711526  61.6518296
      [181,] 100.048857  57.2460618
      [182,] 101.604570  58.5531922
      [183,] 102.321060  64.1947026
      [184,] 102.952729  64.0576217
      [185,]  99.638831  58.9833759
      [186,] 106.013999  61.4030831
      [187,] 102.455856  65.2641944
      [188,] 106.840142  64.3335957
      [189,] 109.695202  69.8556148
      [190,] 109.334358  65.4069152
      [191,] 111.408711  72.2345590
      [192,] 108.916147  67.3033251
      [193,] 111.261394  75.4530026
      [194,] 113.833657  74.6310919
      [195,] 117.620417  71.3778346
      [196,] 118.881520  71.6319629
      [197,] 111.901330  73.6635093
      [198,] 113.579257  78.4381926
      [199,] 122.466324  79.8354817
      [200,] 121.393251  77.1876735

# three_diff_linear() works

    Code
      three_diff_linear(n = 150, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]          [,2]          [,3]          [,4]
        [1,] -248.023352 -16.221861136 -1.458899e-02  0.0014711676
        [2,] -249.963238 -18.637719943  2.865623e-02  0.0134290331
        [3,] -249.938084 -16.368414248  2.609781e-02 -0.0352006401
        [4,] -245.072782 -17.908700225  4.110739e-02  0.0238126035
        [5,] -245.433748 -14.275942978  4.965122e-02  0.0266187110
        [6,] -245.231216 -15.467586592  3.251858e-02 -0.0355576233
        [7,] -246.298189 -13.736412058 -2.281042e-02 -0.0359524742
        [8,] -242.413975 -15.161054223 -4.688578e-02  0.0136410232
        [9,] -242.696701 -13.501219014  3.585914e-02 -0.0487538564
       [10,] -236.531141 -11.164716299 -4.046627e-02 -0.0249387145
       [11,] -239.456868  -9.653232076  1.089824e-02  0.0048969224
       [12,] -239.032671  -8.189848348  3.413554e-02  0.0397005668
       [13,] -237.619273  -7.719206122  3.089505e-02 -0.0087249674
       [14,] -237.108530  -7.538330488 -4.024651e-02 -0.0159715919
       [15,] -236.764430  -7.888042859  2.819042e-02  0.0201976551
       [16,] -234.429833  -4.247449651  3.771454e-02 -0.0091390481
       [17,] -234.467455  -1.644884412  4.630252e-03 -0.0302836767
       [18,] -232.488594  -2.145685244  4.492376e-02 -0.0178858006
       [19,] -231.388061  -0.787920983 -1.361151e-02  0.0429006891
       [20,] -229.529793  -0.009840748  2.761497e-02  0.0220245390
       [21,] -227.993739  -0.745349959 -7.016805e-03 -0.0066660612
       [22,] -230.495531   0.477739744 -7.230506e-03 -0.0439810360
       [23,] -228.226840   3.243933657 -1.352021e-02 -0.0298430641
       [24,] -228.991457   3.436021669  4.457019e-02 -0.0046680911
       [25,] -225.478523   5.755216329  1.310034e-03  0.0114787750
       [26,] -224.441631   3.096053478  9.513795e-03  0.0293110539
       [27,] -223.834428   6.410538450 -3.003845e-02  0.0349615660
       [28,] -222.796456   7.120507820 -6.382821e-03 -0.0005097572
       [29,] -223.317762   9.976326760  2.444980e-02  0.0110756404
       [30,] -219.118131   9.697044768  2.677100e-02 -0.0344400412
       [31,] -220.293545  11.207135784 -4.704865e-02 -0.0017210276
       [32,] -220.343208   8.885578981  2.961780e-02 -0.0051060724
       [33,] -217.456072  12.123766005 -3.370171e-02  0.0094713032
       [34,] -215.998153  13.492246016 -1.654683e-02 -0.0228458265
       [35,] -215.593655  14.213409864 -1.833225e-02  0.0371127199
       [36,] -215.636904  13.771327816  3.866709e-03 -0.0443158027
       [37,] -214.325172  15.140097976  4.063287e-02 -0.0138390628
       [38,] -211.499538  16.470677603 -3.401228e-02  0.0399023135
       [39,] -211.179916  20.926369950 -4.455656e-03 -0.0139310422
       [40,] -212.315009  21.486712087 -2.337754e-02  0.0046689456
       [41,] -210.946255  18.731431006 -6.600727e-03 -0.0133701040
       [42,] -210.874885  19.661327506 -7.430371e-03  0.0308092037
       [43,] -205.140728  23.506327073  4.363294e-02 -0.0119043977
       [44,] -205.098988  22.366577656 -4.190935e-02 -0.0217623521
       [45,] -207.900471  22.667760005 -3.425425e-02 -0.0038086441
       [46,] -203.789078  24.222154987  3.860183e-02  0.0202253440
       [47,] -204.266592  25.579289340  7.435258e-03  0.0036428971
       [48,] -201.352192  25.252310189 -4.040416e-02 -0.0055612393
       [49,] -201.505102  27.200588183  4.276738e-02 -0.0258575147
       [50,] -199.941201  30.907879790 -2.994692e-02  0.0158062011
       [51,]    7.219371 -11.897182053  4.456985e-02 -0.0121654471
       [52,]   12.842692  -6.868308494  1.082111e-02  0.0243803850
       [53,]   12.294289 -12.882691418  1.241861e-02 -0.0369256699
       [54,]   12.634786  -6.941189575  1.631652e-02  0.0122989997
       [55,]   18.201113  -7.180398779 -3.040836e-03 -0.0454273297
       [56,]   13.340482  -6.576946972  4.027878e-02 -0.0106775143
       [57,]   17.341542  -4.195931610  9.351035e-03  0.0372808408
       [58,]   18.206454  -3.328118497  1.717753e-02  0.0463457931
       [59,]   17.910875  -2.991488024  7.135615e-03  0.0350516201
       [60,]   19.719930  -0.092796305  3.335375e-02 -0.0488583200
       [61,]   18.457770   0.609898230 -3.431115e-03 -0.0473777195
       [62,]   22.312977   1.822196552 -1.866506e-02  0.0104406092
       [63,]   20.171626   3.480728894  2.138503e-02  0.0455540076
       [64,]   23.209270   5.429923039 -4.667769e-02  0.0146565949
       [65,]   22.756992   3.377326422  3.253958e-02 -0.0151881842
       [66,]   25.243852   5.698820205 -2.804652e-02 -0.0097940761
       [67,]   27.015939   6.140993837 -9.009592e-03 -0.0020904814
       [68,]   28.580844   7.240689032  2.988130e-02 -0.0167296790
       [69,]   29.518341   5.746638213  7.058739e-03  0.0105308289
       [70,]   31.528443  10.619937289 -1.708714e-02 -0.0256906810
       [71,]   29.915255   5.971323874 -2.566097e-02 -0.0195198813
       [72,]   29.302982  10.390764811 -3.205063e-02 -0.0297583484
       [73,]   31.342317  14.082145237 -2.594132e-02 -0.0110993539
       [74,]   35.710234  12.448589837  3.803132e-02  0.0149155190
       [75,]   34.104400  13.809529828  4.379304e-02 -0.0161889479
       [76,]   34.945097  15.027102200 -1.434154e-02 -0.0473662638
       [77,]   36.262753  14.486999849 -4.449161e-03  0.0274509448
       [78,]   38.720371  16.933607884 -7.503827e-03  0.0041588190
       [79,]   36.250653  17.407111551 -4.656778e-02 -0.0336625336
       [80,]   38.455056  18.973532982 -2.710841e-02  0.0356275376
       [81,]   37.424779  21.300661967  2.600811e-02  0.0201683607
       [82,]   41.884126  22.520096215 -3.284313e-02  0.0039741894
       [83,]   41.717904  22.090534656 -4.479017e-02  0.0189006558
       [84,]   44.591156  20.790423461 -3.177405e-02  0.0339453720
       [85,]   43.159926  21.195023563  1.214109e-02 -0.0395484263
       [86,]   48.391995  23.344917509 -2.545728e-03  0.0351578433
       [87,]   48.461593  24.799926771 -3.369623e-02  0.0118455134
       [88,]   46.848342  24.704956069 -3.942831e-02 -0.0028928479
       [89,]   49.429101  26.783107804  1.072001e-02 -0.0416045885
       [90,]   50.625189  28.235622691 -4.184796e-02  0.0133551081
       [91,]   48.336180  29.630842809 -4.625760e-02 -0.0362976748
       [92,]   49.405646  32.664728770 -2.384936e-02 -0.0314172552
       [93,]   51.096464  31.796813711 -2.029594e-02 -0.0177489534
       [94,]   53.130856  33.230162487 -3.089043e-05  0.0081208988
       [95,]   52.630523  34.734166217 -2.164460e-02 -0.0158661866
       [96,]   50.678511  32.898686452  7.280862e-03 -0.0091859393
       [97,]   55.778195  36.417966337 -5.159603e-03  0.0290953855
       [98,]   55.874750  35.709414849  4.571919e-02 -0.0205360916
       [99,]   57.295898  37.846720824  4.371184e-02  0.0080636337
      [100,]   61.854366  40.474895706 -8.465952e-03 -0.0155338238
      [101,]   -3.778139   1.976648134  9.797570e-03 -0.0260286279
      [102,]   -1.362280   0.036762035 -2.422641e-02  0.0446097311
      [103,]   -3.631586   0.061915504  3.277202e-02 -0.0452089297
      [104,]   -2.091300   4.927217881 -9.997107e-03 -0.0023271855
      [105,]   -5.724057   4.566251513 -3.069320e-02  0.0385375064
      [106,]   -4.532413   4.768783959  1.476614e-02  0.0073803334
      [107,]   -6.263588   3.701810871 -1.839283e-02  0.0223295768
      [108,]   -4.838946   7.586024540  2.645821e-02  0.0060656726
      [109,]   -6.498781   7.303298547  1.278195e-02  0.0125904391
      [110,]   -8.835284  13.468859091 -4.227686e-02 -0.0433271786
      [111,]  -10.346768  10.543132380 -9.606105e-03 -0.0236326260
      [112,]  -11.810152  10.967328814 -2.830282e-02  0.0215880999
      [113,]  -12.280794  12.380727222 -4.181241e-02  0.0012344324
      [114,]  -12.461670  12.891469997  1.311135e-02 -0.0378674791
      [115,]  -12.111957  13.235569506  1.880957e-02  0.0059894086
      [116,]  -15.752550  15.570167189  1.712295e-02 -0.0469727421
      [117,]  -18.355116  15.532544993  7.884755e-03  0.0461123795
      [118,]  -17.854315  17.511406106  4.200629e-02 -0.0005639224
      [119,]  -19.212079  18.611939059  2.877043e-02  0.0384549295
      [120,]  -19.990159  20.470206633  3.228527e-02  0.0081629527
      [121,]  -19.254650  22.006260992  2.788319e-02 -0.0439266545
      [122,]  -20.477740  19.504469394 -1.741983e-02 -0.0270945408
      [123,]  -23.243934  21.773159884  5.182130e-03  0.0183671580
      [124,]  -23.436022  21.008542503 -2.974713e-02 -0.0063818733
      [125,]  -25.755216  24.521477090  2.027644e-02  0.0199030881
      [126,]  -23.096053  25.558368659  6.945097e-03 -0.0273078126
      [127,]  -26.410538  26.165572222 -2.858230e-03 -0.0422621792
      [128,]  -27.120508  27.203544429  4.814338e-02 -0.0466499872
      [129,]  -29.976327  26.682237840 -1.638557e-02 -0.0211679828
      [130,]  -29.697045  30.881869398 -4.239687e-02  0.0430941616
      [131,]  -31.207136  29.706454854  2.032662e-02  0.0192067729
      [132,]  -28.885579  29.656791659  4.524067e-03  0.0224289806
      [133,]  -32.123766  32.543927561  1.712918e-02 -0.0419177369
      [134,]  -33.492246  34.001846937  4.000003e-02 -0.0036740666
      [135,]  -34.213410  34.406344869 -3.129462e-02  0.0444345651
      [136,]  -33.771328  34.363096087 -1.696542e-02  0.0186018101
      [137,]  -35.140098  35.674827719 -2.599024e-02 -0.0217545194
      [138,]  -36.470678  38.500462292  2.685868e-02  0.0218025423
      [139,]  -40.926370  38.820083882  3.175927e-02 -0.0409240471
      [140,]  -41.486712  37.684991285 -2.017552e-02  0.0115609377
      [141,]  -38.731431  39.053745377  1.430562e-02 -0.0439113088
      [142,]  -39.661328  39.125115404 -4.388218e-02 -0.0342168524
      [143,]  -43.506327  44.859271869  4.704672e-02 -0.0422080951
      [144,]  -42.366578  44.901012239 -4.432870e-03  0.0402214550
      [145,]  -42.667760  42.099528579 -3.661782e-02 -0.0429658090
      [146,]  -44.222155  46.210921702  8.528756e-03  0.0452402598
      [147,]  -45.579289  45.733407953 -7.837044e-03  0.0251115222
      [148,]  -45.252310  48.647807633 -3.644674e-02  0.0290669307
      [149,]  -47.200588  48.494898288  3.336327e-02 -0.0024890576
      [150,]  -50.907880  50.058798967 -1.907975e-02 -0.0189063230

---

    Code
      three_diff_linear(n = 150, num_noise = 0)
    Output
                     [,1]        [,2]
        [1,] -252.5657849 -20.5320614
        [2,] -248.6617123 -19.4652512
        [3,] -248.8180835 -17.8455500
        [4,] -244.9261407 -17.0387216
        [5,] -248.5488400 -16.8842125
        [6,] -245.6757998 -16.4447000
        [7,] -246.2172929 -13.8185681
        [8,] -243.7594796 -14.8419465
        [9,] -242.7476386 -13.0544750
       [10,] -239.2053016 -12.5382161
       [11,] -239.8359640 -10.5342390
       [12,] -240.8582913  -6.8761851
       [13,] -238.1658515  -5.7965574
       [14,] -235.8597113  -6.5390136
       [15,] -234.0861793  -4.5466156
       [16,] -236.1166298  -2.8111168
       [17,] -236.6552626  -4.7288042
       [18,] -234.1804805  -2.6551139
       [19,] -232.0317542  -2.0246647
       [20,] -231.5182402  -1.7815163
       [21,] -231.0701682  -0.7595423
       [22,] -230.9368052   1.8840354
       [23,] -227.4393999   0.7457166
       [24,] -228.2348071   2.6774022
       [25,] -223.5126283   4.5294164
       [26,] -223.2491441   6.7652214
       [27,] -221.9195605   7.2165439
       [28,] -221.7574660   6.8290399
       [29,] -223.9639297   9.2507426
       [30,] -221.3672766  10.6291295
       [31,] -222.0564439  10.7169811
       [32,] -218.5400055  14.7564452
       [33,] -216.0378494   9.4154472
       [34,] -219.5306994  13.8757209
       [35,] -216.6191515  14.6751750
       [36,] -213.5300323  15.0988963
       [37,] -208.6475908  18.7296697
       [38,] -214.4073366  18.4344208
       [39,] -209.9064604  18.8938941
       [40,] -212.2146318  19.5346713
       [41,] -208.9778549  20.2653705
       [42,] -207.5424045  21.5292478
       [43,] -209.2907555  20.4559283
       [44,] -208.7565794  22.4738731
       [45,] -206.0000543  25.3080378
       [46,] -204.3040842  24.9350709
       [47,] -203.8439734  24.1213320
       [48,] -200.2256666  25.2146984
       [49,] -201.0409737  29.3031984
       [50,] -201.9446613  28.8611643
       [51,]   11.8328104  -9.0048834
       [52,]   10.5617076  -9.3427681
       [53,]   11.9192761  -8.5334582
       [54,]   14.7240536  -5.9325650
       [55,]   14.9892105  -7.5771742
       [56,]   13.6114005  -5.7486937
       [57,]   14.0317335  -6.6207035
       [58,]   17.0583455  -4.0383477
       [59,]   15.9488709  -3.4395413
       [60,]   21.9623582  -1.4627269
       [61,]   22.9305908   0.2435222
       [62,]   23.8626640   1.8433749
       [63,]   22.1590323   3.9591231
       [64,]   25.2521125   2.4181530
       [65,]   23.4828367   4.9053118
       [66,]   27.4690569   5.0042078
       [67,]   25.4398053   2.5722578
       [68,]   28.6643571   6.4087888
       [69,]   28.2377886   8.8200618
       [70,]   30.6989834  11.2124940
       [71,]   31.1136439  10.0367441
       [72,]   32.4510907  11.3549471
       [73,]   30.6522659  14.7722113
       [74,]   30.2749977  12.6690589
       [75,]   33.3564607  13.7438246
       [76,]   33.5180875  15.1437216
       [77,]   35.0743552  15.9187417
       [78,]   38.9481502  17.9072054
       [79,]   37.3100122  18.3290308
       [80,]   38.8421593  21.4190029
       [81,]   41.4068166  18.3443308
       [82,]   40.1131696  20.9868813
       [83,]   42.9866447  21.6479372
       [84,]   44.0136178  21.9643424
       [85,]   48.9034995  23.8909804
       [86,]   46.0443839  24.6666796
       [87,]   46.0292718  24.1686612
       [88,]   47.4849625  25.0329178
       [89,]   50.1299179  27.3610390
       [90,]   50.1358954  30.1452160
       [91,]   49.0383787  28.7765289
       [92,]   49.6725607  30.3119407
       [93,]   51.3737341  32.0399945
       [94,]   49.0495160  33.2284481
       [95,]   54.2574380  34.2411133
       [96,]   55.3854457  34.5756796
       [97,]   55.3890754  34.9681718
       [98,]   57.5467095  36.6852567
       [99,]   59.3863074  38.7399830
      [100,]   58.0173512  40.8713331
      [101,]    0.5320614  -2.5657849
      [102,]   -0.5347488   1.3382877
      [103,]   -2.1544500   1.1819165
      [104,]   -2.9612784   5.0738593
      [105,]   -3.1157875   1.4511600
      [106,]   -3.5553000   4.3242002
      [107,]   -6.1814319   3.7827071
      [108,]   -5.1580535   6.2405204
      [109,]   -6.9455250   7.2523614
      [110,]   -7.4617839  10.7946984
      [111,]   -9.4657610  10.1640360
      [112,]  -13.1238149   9.1417087
      [113,]  -14.2034426  11.8341485
      [114,]  -13.4609864  14.1402887
      [115,]  -15.4533844  15.9138207
      [116,]  -17.1888832  13.8833702
      [117,]  -15.2711958  13.3447374
      [118,]  -17.3448861  15.8195195
      [119,]  -17.9753353  17.9682458
      [120,]  -18.2184837  18.4817598
      [121,]  -19.2404577  18.9298318
      [122,]  -21.8840354  19.0631948
      [123,]  -20.7457166  22.5606001
      [124,]  -22.6774022  21.7651929
      [125,]  -24.5294164  26.4873717
      [126,]  -26.7652214  26.7508559
      [127,]  -27.2165439  28.0804395
      [128,]  -26.8290399  28.2425340
      [129,]  -29.2507426  26.0360703
      [130,]  -30.6291295  28.6327234
      [131,]  -30.7169811  27.9435561
      [132,]  -34.7564452  31.4599945
      [133,]  -29.4154472  33.9621506
      [134,]  -33.8757209  30.4693006
      [135,]  -34.6751750  33.3808485
      [136,]  -35.0988963  36.4699677
      [137,]  -38.7296697  41.3524092
      [138,]  -38.4344208  35.5926634
      [139,]  -38.8938941  40.0935396
      [140,]  -39.5346713  37.7853682
      [141,]  -40.2653705  41.0221451
      [142,]  -41.5292478  42.4575955
      [143,]  -40.4559283  40.7092445
      [144,]  -42.4738731  41.2434206
      [145,]  -45.3080378  43.9999457
      [146,]  -44.9350709  45.6959158
      [147,]  -44.1213320  46.1560266
      [148,]  -45.2146984  49.7743334
      [149,]  -49.3031984  48.9590263
      [150,]  -48.8611643  48.0553387

# four_long_clust() works

    Code
      four_long_clust(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]          [,2]          [,3]          [,4]
        [1,] -148.023352 -16.221861136 -1.458899e-02 -0.0121654471
        [2,] -149.963238 -18.637719943  2.865623e-02  0.0243803850
        [3,] -149.938084 -16.368414248  2.609781e-02 -0.0369256699
        [4,] -145.072782 -17.908700225  4.110739e-02  0.0122989997
        [5,] -145.433748 -14.275942978  4.965122e-02 -0.0454273297
        [6,] -145.231216 -15.467586592  3.251858e-02 -0.0106775143
        [7,] -146.298189 -13.736412058 -2.281042e-02  0.0372808408
        [8,] -142.413975 -15.161054223 -4.688578e-02  0.0463457931
        [9,] -142.696701 -13.501219014  3.585914e-02  0.0350516201
       [10,] -136.531141 -11.164716299 -4.046627e-02 -0.0488583200
       [11,] -139.456868  -9.653232076  1.089824e-02 -0.0473777195
       [12,] -139.032671  -8.189848348  3.413554e-02  0.0104406092
       [13,] -137.619273  -7.719206122  3.089505e-02  0.0455540076
       [14,] -137.108530  -7.538330488 -4.024651e-02  0.0146565949
       [15,] -136.764430  -7.888042859  2.819042e-02 -0.0151881842
       [16,] -134.429833  -4.247449651  3.771454e-02 -0.0097940761
       [17,] -134.467455  -1.644884412  4.630252e-03 -0.0020904814
       [18,] -132.488594  -2.145685244  4.492376e-02 -0.0167296790
       [19,] -131.388061  -0.787920983 -1.361151e-02  0.0105308289
       [20,] -129.529793  -0.009840748  2.761497e-02 -0.0256906810
       [21,] -127.993739  -0.745349959 -7.016805e-03 -0.0195198813
       [22,] -130.495531   0.477739744 -7.230506e-03 -0.0297583484
       [23,] -128.226840   3.243933657 -1.352021e-02 -0.0110993539
       [24,] -128.991457   3.436021669  4.457019e-02  0.0149155190
       [25,] -125.478523   5.755216329  1.310034e-03 -0.0161889479
       [26,] -124.441631   3.096053478  9.513795e-03 -0.0473662638
       [27,] -123.834428   6.410538450 -3.003845e-02  0.0274509448
       [28,] -122.796456   7.120507820 -6.382821e-03  0.0041588190
       [29,] -123.317762   9.976326760  2.444980e-02 -0.0336625336
       [30,] -119.118131   9.697044768  2.677100e-02  0.0356275376
       [31,] -120.293545  11.207135784 -4.704865e-02  0.0201683607
       [32,] -120.343208   8.885578981  2.961780e-02  0.0039741894
       [33,] -117.456072  12.123766005 -3.370171e-02  0.0189006558
       [34,] -115.998153  13.492246016 -1.654683e-02  0.0339453720
       [35,] -115.593655  14.213409864 -1.833225e-02 -0.0395484263
       [36,] -115.636904  13.771327816  3.866709e-03  0.0351578433
       [37,] -114.325172  15.140097976  4.063287e-02  0.0118455134
       [38,] -111.499538  16.470677603 -3.401228e-02 -0.0028928479
       [39,] -111.179916  20.926369950 -4.455656e-03 -0.0416045885
       [40,] -112.315009  21.486712087 -2.337754e-02  0.0133551081
       [41,] -110.946255  18.731431006 -6.600727e-03 -0.0362976748
       [42,] -110.874885  19.661327506 -7.430371e-03 -0.0314172552
       [43,] -105.140728  23.506327073  4.363294e-02 -0.0177489534
       [44,] -105.098988  22.366577656 -4.190935e-02  0.0081208988
       [45,] -107.900471  22.667760005 -3.425425e-02 -0.0158661866
       [46,] -103.789078  24.222154987  3.860183e-02 -0.0091859393
       [47,] -104.266592  25.579289340  7.435258e-03  0.0290953855
       [48,] -101.352192  25.252310189 -4.040416e-02 -0.0205360916
       [49,] -101.505102  27.200588183  4.276738e-02  0.0080636337
       [50,]  -99.941201  30.907879790 -2.994692e-02 -0.0155338238
       [51,]    7.219371 -11.897182053  4.456985e-02 -0.0260286279
       [52,]   12.842692  -6.868308494  1.082111e-02  0.0446097311
       [53,]   12.294289 -12.882691418  1.241861e-02 -0.0452089297
       [54,]   12.634786  -6.941189575  1.631652e-02 -0.0023271855
       [55,]   18.201113  -7.180398779 -3.040836e-03  0.0385375064
       [56,]   13.340482  -6.576946972  4.027878e-02  0.0073803334
       [57,]   17.341542  -4.195931610  9.351035e-03  0.0223295768
       [58,]   18.206454  -3.328118497  1.717753e-02  0.0060656726
       [59,]   17.910875  -2.991488024  7.135615e-03  0.0125904391
       [60,]   19.719930  -0.092796305  3.335375e-02 -0.0433271786
       [61,]   18.457770   0.609898230 -3.431115e-03 -0.0236326260
       [62,]   22.312977   1.822196552 -1.866506e-02  0.0215880999
       [63,]   20.171626   3.480728894  2.138503e-02  0.0012344324
       [64,]   23.209270   5.429923039 -4.667769e-02 -0.0378674791
       [65,]   22.756992   3.377326422  3.253958e-02  0.0059894086
       [66,]   25.243852   5.698820205 -2.804652e-02 -0.0469727421
       [67,]   27.015939   6.140993837 -9.009592e-03  0.0461123795
       [68,]   28.580844   7.240689032  2.988130e-02 -0.0005639224
       [69,]   29.518341   5.746638213  7.058739e-03  0.0384549295
       [70,]   31.528443  10.619937289 -1.708714e-02  0.0081629527
       [71,]   29.915255   5.971323874 -2.566097e-02 -0.0439266545
       [72,]   29.302982  10.390764811 -3.205063e-02 -0.0270945408
       [73,]   31.342317  14.082145237 -2.594132e-02  0.0183671580
       [74,]   35.710234  12.448589837  3.803132e-02 -0.0063818733
       [75,]   34.104400  13.809529828  4.379304e-02  0.0199030881
       [76,]   34.945097  15.027102200 -1.434154e-02 -0.0273078126
       [77,]   36.262753  14.486999849 -4.449161e-03 -0.0422621792
       [78,]   38.720371  16.933607884 -7.503827e-03 -0.0466499872
       [79,]   36.250653  17.407111551 -4.656778e-02 -0.0211679828
       [80,]   38.455056  18.973532982 -2.710841e-02  0.0430941616
       [81,]   37.424779  21.300661967  2.600811e-02  0.0192067729
       [82,]   41.884126  22.520096215 -3.284313e-02  0.0224289806
       [83,]   41.717904  22.090534656 -4.479017e-02 -0.0419177369
       [84,]   44.591156  20.790423461 -3.177405e-02 -0.0036740666
       [85,]   43.159926  21.195023563  1.214109e-02  0.0444345651
       [86,]   48.391995  23.344917509 -2.545728e-03  0.0186018101
       [87,]   48.461593  24.799926771 -3.369623e-02 -0.0217545194
       [88,]   46.848342  24.704956069 -3.942831e-02  0.0218025423
       [89,]   49.429101  26.783107804  1.072001e-02 -0.0409240471
       [90,]   50.625189  28.235622691 -4.184796e-02  0.0115609377
       [91,]   48.336180  29.630842809 -4.625760e-02 -0.0439113088
       [92,]   49.405646  32.664728770 -2.384936e-02 -0.0342168524
       [93,]   51.096464  31.796813711 -2.029594e-02 -0.0422080951
       [94,]   53.130856  33.230162487 -3.089043e-05  0.0402214550
       [95,]   52.630523  34.734166217 -2.164460e-02 -0.0429658090
       [96,]   50.678511  32.898686452  7.280862e-03  0.0452402598
       [97,]   55.778195  36.417966337 -5.159603e-03  0.0251115222
       [98,]   55.874750  35.709414849  4.571919e-02  0.0290669307
       [99,]   57.295898  37.846720824  4.371184e-02 -0.0024890576
      [100,]   61.854366  40.474895706 -8.465952e-03 -0.0189063230
      [101,]  -66.221861  -1.976648134  9.797570e-03 -0.0292722002
      [102,]  -68.637720  -0.036762035 -2.422641e-02 -0.0409276481
      [103,]  -66.368414  -0.061915504  3.277202e-02 -0.0304857217
      [104,]  -67.908700  -4.927217881 -9.997107e-03 -0.0330706669
      [105,]  -64.275943  -4.566251513 -3.069320e-02 -0.0374938477
      [106,]  -65.467587  -4.768783959  1.476614e-02  0.0341126673
      [107,]  -63.736412  -3.701810871 -1.839283e-02  0.0320512261
      [108,]  -65.161054  -7.586024540  2.645821e-02 -0.0385782004
      [109,]  -63.501219  -7.303298547  1.278195e-02  0.0267615181
      [110,]  -61.164716 -13.468859091 -4.227686e-02 -0.0200580744
      [111,]  -59.653232 -10.543132380 -9.606105e-03  0.0396357887
      [112,]  -58.189848 -10.967328814 -2.830282e-02  0.0446445973
      [113,]  -57.719206 -12.380727222 -4.181241e-02 -0.0325953962
      [114,]  -57.538330 -12.891469997  1.311135e-02 -0.0431575823
      [115,]  -57.888043 -13.235569506  1.880957e-02  0.0432349087
      [116,]  -54.247450 -15.570167189  1.712295e-02  0.0144854801
      [117,]  -51.644884 -15.532544993  7.884755e-03 -0.0221729990
      [118,]  -52.145685 -17.511406106  4.200629e-02  0.0102706363
      [119,]  -50.787921 -18.611939059  2.877043e-02 -0.0449682095
      [120,]  -50.009841 -20.470206633  3.228527e-02 -0.0265591595
      [121,]  -50.745350 -22.006260992  2.788319e-02  0.0080544160
      [122,]  -49.522260 -19.504469394 -1.741983e-02  0.0439237355
      [123,]  -46.756066 -21.773159884  5.182130e-03  0.0235952500
      [124,]  -46.563978 -21.008542503 -2.974713e-02  0.0109238994
      [125,]  -44.244784 -24.521477090  2.027644e-02 -0.0463010175
      [126,]  -46.903947 -25.558368659  6.945097e-03 -0.0266219847
      [127,]  -43.589462 -26.165572222 -2.858230e-03  0.0042635182
      [128,]  -42.879492 -27.203544429  4.814338e-02  0.0261158390
      [129,]  -40.023673 -26.682237840 -1.638557e-02 -0.0435545094
      [130,]  -40.302955 -30.881869398 -4.239687e-02  0.0112480344
      [131,]  -38.792864 -29.706454854  2.032662e-02  0.0286709019
      [132,]  -41.114421 -29.656791659  4.524067e-03 -0.0148543742
      [133,]  -37.876234 -32.543927561  1.712918e-02 -0.0412449545
      [134,]  -36.507754 -34.001846937  4.000003e-02  0.0384964693
      [135,]  -35.786590 -34.406344869 -3.129462e-02  0.0403535591
      [136,]  -36.228672 -34.363096087 -1.696542e-02 -0.0443810073
      [137,]  -34.859902 -35.674827719 -2.599024e-02 -0.0191402950
      [138,]  -33.529322 -38.500462292  2.685868e-02  0.0088271511
      [139,]  -29.073630 -38.820083882  3.175927e-02 -0.0069063945
      [140,]  -28.513288 -37.684991285 -2.017552e-02  0.0250049557
      [141,]  -31.268569 -39.053745377  1.430562e-02 -0.0348641495
      [142,]  -30.338672 -39.125115404 -4.388218e-02 -0.0320736578
      [143,]  -26.493673 -44.859271869  4.704672e-02 -0.0147642042
      [144,]  -27.633422 -44.901012239 -4.432870e-03  0.0014871315
      [145,]  -27.332240 -42.099528579 -3.661782e-02  0.0311488281
      [146,]  -25.777845 -46.210921702  8.528756e-03 -0.0393062410
      [147,]  -24.420711 -45.733407953 -7.837044e-03  0.0129209106
      [148,]  -24.747690 -48.647807633 -3.644674e-02  0.0343811021
      [149,]  -22.799412 -48.494898288  3.336327e-02 -0.0367332967
      [150,]  -19.092120 -50.058798967 -1.907975e-02  0.0077857896
      [151,]  -66.221861 148.023351866 -1.471168e-03 -0.0377598689
      [152,]  -68.637720 149.963237965 -1.342903e-02  0.0281777969
      [153,]  -66.368414 149.938084496  3.520064e-02 -0.0106485355
      [154,]  -67.908700 145.072782119 -2.381260e-02 -0.0442246798
      [155,]  -64.275943 145.433748487 -2.661871e-02 -0.0044094845
      [156,]  -65.467587 145.231216041  3.555762e-02 -0.0276584150
      [157,]  -63.736412 146.298189129  3.595247e-02 -0.0066415980
      [158,]  -65.161054 142.413975460 -1.364102e-02  0.0251244939
      [159,]  -63.501219 142.696701453  4.875386e-02  0.0495563033
      [160,]  -61.164716 136.531140909  2.493871e-02  0.0031468394
      [161,]  -59.653232 139.456867620 -4.896922e-03 -0.0098312909
      [162,]  -58.189848 139.032671186 -3.970057e-02  0.0271438907
      [163,]  -57.719206 137.619272778  8.724967e-03  0.0400247400
      [164,]  -57.538330 137.108530003  1.597159e-02 -0.0341779724
      [165,]  -57.888043 136.764430494 -2.019766e-02 -0.0056912830
      [166,]  -54.247450 134.429832811  9.139048e-03 -0.0215980678
      [167,]  -51.644884 134.467455007  3.028368e-02  0.0080712251
      [168,]  -52.145685 132.488593894  1.788580e-02 -0.0043913169
      [169,]  -50.787921 131.388060941 -4.290069e-02  0.0047715123
      [170,]  -50.009841 129.529793367 -2.202454e-02 -0.0158707107
      [171,]  -50.745350 127.993739008  6.666061e-03 -0.0363597272
      [172,]  -49.522260 130.495530606  4.398104e-02  0.0113337014
      [173,]  -46.756066 128.226840116  2.984306e-02 -0.0228879017
      [174,]  -46.563978 128.991457497  4.668091e-03  0.0066610883
      [175,]  -44.244784 125.478522910 -1.147877e-02  0.0359466498
      [176,]  -46.903947 124.441631341 -2.931105e-02  0.0345976077
      [177,]  -43.589462 123.834427778 -3.496157e-02  0.0057953600
      [178,]  -42.879492 122.796455571  5.097572e-04 -0.0165653628
      [179,]  -40.023673 123.317762160 -1.107564e-02 -0.0101520649
      [180,]  -40.302955 119.118130602  3.444004e-02  0.0487028622
      [181,]  -38.792864 120.293545146  1.721028e-03  0.0115250749
      [182,]  -41.114421 120.343208341  5.106072e-03  0.0444430579
      [183,]  -37.876234 117.456072439 -9.471303e-03  0.0082711114
      [184,]  -36.507754 115.998153063  2.284583e-02 -0.0360433521
      [185,]  -35.786590 115.593655131 -3.711272e-02 -0.0419245044
      [186,]  -36.228672 115.636903913  4.431580e-02 -0.0346357887
      [187,]  -34.859902 114.325172281  1.383906e-02 -0.0056294389
      [188,]  -33.529322 111.499537708 -3.990231e-02 -0.0037365437
      [189,]  -29.073630 111.179916118  1.393104e-02 -0.0146769820
      [190,]  -28.513288 112.315008715 -4.668946e-03 -0.0021888600
      [191,]  -31.268569 110.946254623  1.337010e-02 -0.0022501174
      [192,]  -30.338672 110.874884596 -3.080920e-02  0.0083656044
      [193,]  -26.493673 105.140728131  1.190440e-02  0.0234801304
      [194,]  -27.633422 105.098987761  2.176235e-02  0.0150542545
      [195,]  -27.332240 107.900471421  3.808644e-03  0.0184855636
      [196,]  -25.777845 103.789078298 -2.022534e-02 -0.0395605636
      [197,]  -24.420711 104.266592047 -3.642897e-03  0.0347641557
      [198,]  -24.747690 101.352192367  5.561239e-03 -0.0401655558
      [199,]  -22.799412 101.505101712  2.585751e-02  0.0339249040
      [200,]  -19.092120  99.941201033 -1.580620e-02 -0.0093930904

---

    Code
      four_long_clust(n = 200, num_noise = 0)
    Output
                   [,1]        [,2]
        [1,] -150.53206 -18.1671896
        [2,] -149.46525 -19.4382924
        [3,] -147.84555 -18.0807239
        [4,] -147.03872 -15.2759464
        [5,] -146.88421 -15.0107895
        [6,] -146.44470 -16.3885995
        [7,] -143.81857 -15.9682665
        [8,] -144.84195 -12.9416545
        [9,] -143.05447 -14.0511291
       [10,] -142.53822  -8.0376418
       [11,] -140.53424  -7.0694092
       [12,] -136.87619  -6.1373360
       [13,] -135.79656  -7.8409677
       [14,] -136.53901  -4.7478875
       [15,] -134.54662  -6.5171633
       [16,] -132.81112  -2.5309431
       [17,] -134.72880  -4.5601947
       [18,] -132.65511  -1.3356429
       [19,] -132.02466  -1.7622114
       [20,] -131.78152   0.6989834
       [21,] -130.75954   1.1136439
       [22,] -128.11596   2.4510907
       [23,] -129.25428   0.6522659
       [24,] -127.32260   0.2749977
       [25,] -125.47058   3.3564607
       [26,] -123.23478   3.5180875
       [27,] -122.78346   5.0743552
       [28,] -123.17096   8.9481502
       [29,] -120.74926   7.3100122
       [30,] -119.37087   8.8421593
       [31,] -119.28302  11.4068166
       [32,] -115.24355  10.1131696
       [33,] -120.58455  12.9866447
       [34,] -116.12428  14.0136178
       [35,] -115.32482  18.9034995
       [36,] -114.90110  16.0443839
       [37,] -111.27033  16.0292718
       [38,] -111.56558  17.4849625
       [39,] -111.10611  20.1299179
       [40,] -110.46533  20.1358954
       [41,] -109.73463  19.0383787
       [42,] -108.47075  19.6725607
       [43,] -109.54407  21.3737341
       [44,] -107.52613  19.0495160
       [45,] -104.69196  24.2574380
       [46,] -105.06493  25.3854457
       [47,] -105.87867  25.3890754
       [48,] -104.78530  27.5467095
       [49,] -100.69680  29.3863074
       [50,] -101.13884  28.0173512
       [51,]   10.99512  -8.0746237
       [52,]   10.65723 -10.3344661
       [53,]   11.46654  -7.8549912
       [54,]   14.06744  -7.3031037
       [55,]   12.42283  -6.8931937
       [56,]   14.25131  -4.1691051
       [57,]   13.37930  -4.2392139
       [58,]   15.96165  -2.8454204
       [59,]   16.56046  -1.0514758
       [60,]   18.53727  -1.6320810
       [61,]   20.24352  -1.5307041
       [62,]   21.84337   1.1056059
       [63,]   23.95912   2.3623309
       [64,]   22.41815   2.6415743
       [65,]   24.90531   1.4431373
       [66,]   25.00421   4.2780277
       [67,]   22.57226   8.9592063
       [68,]   26.40879   5.0405912
       [69,]   28.82006   6.1831843
       [70,]   31.21249  10.5470016
       [71,]   30.03674   8.2070094
       [72,]   31.35495   8.9976934
       [73,]   34.77221  16.0173099
       [74,]   32.66906  14.3782807
       [75,]   33.74382  12.2914433
       [76,]   35.14372  14.8136313
       [77,]   35.91874  14.9604193
       [78,]   37.90721  18.1389314
       [79,]   38.32903  19.5199587
       [80,]   41.41900  17.8354234
       [81,]   38.34433  18.8424569
       [82,]   40.98688  18.6070876
       [83,]   41.64794  22.3349567
       [84,]   41.96434  23.2966708
       [85,]   43.89098  23.1139359
       [86,]   44.66668  22.1924257
       [87,]   44.16866  26.6888002
       [88,]   45.03292  25.4652346
       [89,]   47.36104  28.5706200
       [90,]   50.14522  30.9632626
       [91,]   48.77653  28.4921650
       [92,]   50.31194  30.1073657
       [93,]   52.03999  31.2231037
       [94,]   53.22845  32.6783414
       [95,]   54.24111  34.7719989
       [96,]   54.57568  35.3020300
       [97,]   54.96817  33.8632474
       [98,]   56.68526  36.5526806
       [99,]   58.73998  37.8023212
      [100,]   60.87133  39.5591411
      [101,]  -68.16719   0.5320614
      [102,]  -69.43829  -0.5347488
      [103,]  -68.08072  -2.1544500
      [104,]  -65.27595  -2.9612784
      [105,]  -65.01079  -3.1157875
      [106,]  -66.38860  -3.5553000
      [107,]  -65.96827  -6.1814319
      [108,]  -62.94165  -5.1580535
      [109,]  -64.05113  -6.9455250
      [110,]  -58.03764  -7.4617839
      [111,]  -57.06941  -9.4657610
      [112,]  -56.13734 -13.1238149
      [113,]  -57.84097 -14.2034426
      [114,]  -54.74789 -13.4609864
      [115,]  -56.51716 -15.4533844
      [116,]  -52.53094 -17.1888832
      [117,]  -54.56019 -15.2711958
      [118,]  -51.33564 -17.3448861
      [119,]  -51.76221 -17.9753353
      [120,]  -49.30102 -18.2184837
      [121,]  -48.88636 -19.2404577
      [122,]  -47.54891 -21.8840354
      [123,]  -49.34773 -20.7457166
      [124,]  -49.72500 -22.6774022
      [125,]  -46.64354 -24.5294164
      [126,]  -46.48191 -26.7652214
      [127,]  -44.92564 -27.2165439
      [128,]  -41.05185 -26.8290399
      [129,]  -42.68999 -29.2507426
      [130,]  -41.15784 -30.6291295
      [131,]  -38.59318 -30.7169811
      [132,]  -39.88683 -34.7564452
      [133,]  -37.01336 -29.4154472
      [134,]  -35.98638 -33.8757209
      [135,]  -31.09650 -34.6751750
      [136,]  -33.95562 -35.0988963
      [137,]  -33.97073 -38.7296697
      [138,]  -32.51504 -38.4344208
      [139,]  -29.87008 -38.8938941
      [140,]  -29.86410 -39.5346713
      [141,]  -30.96162 -40.2653705
      [142,]  -30.32744 -41.5292478
      [143,]  -28.62627 -40.4559283
      [144,]  -30.95048 -42.4738731
      [145,]  -25.74256 -45.3080378
      [146,]  -24.61455 -44.9350709
      [147,]  -24.61092 -44.1213320
      [148,]  -22.45329 -45.2146984
      [149,]  -20.61369 -49.3031984
      [150,]  -21.98265 -48.8611643
      [151,]  -68.16719 150.5320614
      [152,]  -69.43829 149.4652512
      [153,]  -68.08072 147.8455500
      [154,]  -65.27595 147.0387216
      [155,]  -65.01079 146.8842125
      [156,]  -66.38860 146.4447000
      [157,]  -65.96827 143.8185681
      [158,]  -62.94165 144.8419465
      [159,]  -64.05113 143.0544750
      [160,]  -58.03764 142.5382161
      [161,]  -57.06941 140.5342390
      [162,]  -56.13734 136.8761851
      [163,]  -57.84097 135.7965574
      [164,]  -54.74789 136.5390136
      [165,]  -56.51716 134.5466156
      [166,]  -52.53094 132.8111168
      [167,]  -54.56019 134.7288042
      [168,]  -51.33564 132.6551139
      [169,]  -51.76221 132.0246647
      [170,]  -49.30102 131.7815163
      [171,]  -48.88636 130.7595423
      [172,]  -47.54891 128.1159646
      [173,]  -49.34773 129.2542834
      [174,]  -49.72500 127.3225978
      [175,]  -46.64354 125.4705836
      [176,]  -46.48191 123.2347786
      [177,]  -44.92564 122.7834561
      [178,]  -41.05185 123.1709601
      [179,]  -42.68999 120.7492574
      [180,]  -41.15784 119.3708705
      [181,]  -38.59318 119.2830189
      [182,]  -39.88683 115.2435548
      [183,]  -37.01336 120.5845528
      [184,]  -35.98638 116.1242791
      [185,]  -31.09650 115.3248250
      [186,]  -33.95562 114.9011037
      [187,]  -33.97073 111.2703303
      [188,]  -32.51504 111.5655792
      [189,]  -29.87008 111.1061059
      [190,]  -29.86410 110.4653287
      [191,]  -30.96162 109.7346295
      [192,]  -30.32744 108.4707522
      [193,]  -28.62627 109.5440717
      [194,]  -30.95048 107.5261269
      [195,]  -25.74256 104.6919622
      [196,]  -24.61455 105.0649291
      [197,]  -24.61092 105.8786680
      [198,]  -22.45329 104.7853016
      [199,]  -20.61369 100.6968016
      [200,]  -21.98265 101.1388357

# plane_2d_hole() works

    Code
      plane_2d_hole(n = 100, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
      $df
                 [,1]        [,2]         [,3]          [,4]
       [1,] 27.241853 -11.0065027 -0.014514506  0.0205436346
       [2,] 16.103247  -8.6800396 -0.042610457 -0.0096704798
       [3,] 10.184226  -6.0810512 -0.004394658  0.0074246488
       [4,]  8.536926   2.6101732  0.031400799  0.0395226781
       [5,] 22.646336 -11.6849626 -0.005396931 -0.0140160184
       [6,] 13.087763  -7.5345965 -0.041821771 -0.0001349537
       [7,] 17.513284  -6.8447910  0.031016598 -0.0395929786
       [8,] 14.743681  -3.5767158 -0.038376223  0.0421812224
       [9,]  3.356345  -1.1534816 -0.039518429  0.0192060802
      [10,] 11.809833   2.9199860 -0.048856669 -0.0329963851
      [11,] 21.062812  -4.8733826  0.007757624  0.0441801412
      [12,]  8.857137  -5.9891176  0.035364025 -0.0359260298
      [13,] 25.163856 -16.7783504  0.031473265  0.0215506210
      [14,] 22.909152 -16.1111833  0.034647305  0.0231140854
      [15,] 17.311374 -10.3429044 -0.014155501  0.0290469873
      [16,] 15.685277  -5.9671796 -0.013249423 -0.0346599014
      [17,]  6.975895   3.7430845 -0.024790063  0.0245407152
      [18,] 17.823110  -8.1841690 -0.044271391 -0.0438232428
      [19,] 47.241853   8.9934973 -0.010676471 -0.0190370204
      [20,] 36.103247  11.3199604  0.043851697  0.0157330000
      [21,] 30.184226  13.9189488  0.016443681 -0.0136145061
      [22,] 28.536926  22.6101732 -0.021509732  0.0211817049
      [23,] 42.646336   8.3150374  0.008581070  0.0296529576
      [24,] 33.087763  12.4654035 -0.025245797  0.0385897858
      [25,] 37.513284  13.1552090 -0.034141930  0.0114352393
      [26,] 34.743681  16.4232842 -0.040357834 -0.0394679684
      [27,] 23.356345  18.8465184 -0.020771534  0.0379028531
      [28,] 31.809833  22.9199860  0.040356428 -0.0086608654
      [29,] 41.062812  15.1266174  0.030966772 -0.0397832549
      [30,] 28.857137  14.0108824  0.029159332  0.0389684510
      [31,] 45.163856   3.2216496  0.023592625  0.0107839450
      [32,] 42.909152   3.8888167  0.038851087 -0.0229901668
      [33,] 37.311374   9.6570956  0.039433618  0.0032016000
      [34,] 35.685277  14.0328204 -0.024846803  0.0188916723
      [35,] 26.975895  23.7430845 -0.047168665  0.0406173033
      [36,] 37.823110  11.8158310 -0.035636917 -0.0218278701
      [37,] 27.006503  22.2418534 -0.039748340  0.0178925602
      [38,] 24.680040  11.1032469  0.032319008 -0.0418970450
      [39,] 22.081051   5.1842259  0.039741895  0.0289520095
      [40,] 13.389827   3.5369259 -0.014166147 -0.0182308341
      [41,] 27.684963  17.6463359 -0.029024773 -0.0420673159
      [42,] 23.534596   8.0877631 -0.002584811  0.0215416480
      [43,] 22.844791  12.5132841  0.007053171  0.0032879685
      [44,] 19.576716   9.7436809  0.003947746 -0.0136172979
      [45,] 17.153482  -1.6436551 -0.036401528  0.0128606171
      [46,] 13.080014   6.8098328  0.031450933 -0.0406865353
      [47,] 20.873383  16.0628117 -0.012927440  0.0056567913
      [48,] 21.989118   3.8571372  0.015580769 -0.0206802091
      [49,] 32.778350  20.1638564 -0.025986426 -0.0293639539
      [50,] 32.111183  17.9091519  0.038668635 -0.0099463716
      [51,] 26.342904  12.3113738 -0.049411154 -0.0216768384
      [52,] 21.967180  10.6852768 -0.009542103 -0.0126717287
      [53,] 12.256916   1.9758955 -0.009542396 -0.0137911398
      [54,] 24.184169  12.8231097 -0.005664813  0.0201560635
      [55,] 28.993497 -12.2418534 -0.036164148  0.0474466317
      [56,] 31.319960  -1.1032469 -0.013793843 -0.0034467781
      [57,] 33.918949   4.8157741  0.022767626  0.0451321898
      [58,] 42.610173   6.4630741  0.048625240 -0.0449525188
      [59,] 28.315037  -7.6463359 -0.037479856 -0.0301143471
      [60,] 32.465404   1.9122369 -0.006014590 -0.0015380326
      [61,] 33.155209  -2.5132841  0.012237501 -0.0313923658
      [62,] 36.423284   0.2563191 -0.015132007 -0.0142799772
      [63,] 38.846518  11.6436551 -0.006974512  0.0342363236
      [64,] 42.919986   3.1901672  0.011980682  0.0437694831
      [65,] 35.126617  -6.0628117  0.042516567 -0.0163590239
      [66,] 34.010882   6.1428628 -0.019885599 -0.0215670073
      [67,] 23.221650 -10.1638564  0.034154131 -0.0312772650
      [68,] 23.888817  -7.9091519  0.013901909 -0.0404797181
      [69,] 29.657096  -2.3113738  0.004372032 -0.0197967365
      [70,] 34.032820  -0.6852768 -0.036261122  0.0082434738
      [71,] 43.743084   8.0241045 -0.009141198 -0.0110442976
      [72,] 31.815831  -2.8231097  0.037512238 -0.0086618911
      
      $n
      [1] 72
      

---

    Code
      plane_2d_hole(n = 100, num_noise = 0)
    Output
      $df
                 [,1]         [,2]
       [1,] 23.656921 -12.49994803
       [2,] 12.089183  -2.68647227
       [3,] 17.971673  -5.80769251
       [4,] 22.537232 -18.32172397
       [5,] 21.979759  -7.21543714
       [6,] 25.289047  -8.34148004
       [7,] 26.172178 -12.72222969
       [8,]  9.104085  -4.32351365
       [9,]  9.655817   7.63314906
      [10,]  9.656458   1.93052939
      [11,] 13.238921  -9.38657141
      [12,] 12.906503  -4.15762720
      [13,]  8.127376  -2.49905171
      [14,]  8.620808   0.65399997
      [15,]  4.952563  -2.90987247
      [16,] 12.325424  -7.59607696
      [17,] 10.809811   4.38858095
      [18,] 11.230694  -0.94165518
      [19,]  7.105354  -2.25907951
      [20,] 43.656921   7.50005197
      [21,] 32.089183  17.31352773
      [22,] 37.971673  14.19230749
      [23,] 42.537232   1.67827603
      [24,] 41.979759  12.78456286
      [25,] 45.289047  11.65851996
      [26,] 46.172178   7.27777031
      [27,] 29.104085  15.67648635
      [28,] 29.655817  27.63314906
      [29,] 29.656458  21.93052939
      [30,] 33.238921  10.61342859
      [31,] 32.906503  15.84237280
      [32,] 28.127376  17.50094829
      [33,] 28.620808  20.65399997
      [34,] 24.952563  17.09012753
      [35,] 32.325424  12.40392304
      [36,] 30.809811  24.38858095
      [37,] 31.230694  19.05834482
      [38,] 27.105354  17.74092049
      [39,] 28.499948  18.65692137
      [40,] 18.686472   7.08918262
      [41,] 21.807693  12.97167329
      [42,] 34.321724  17.53723235
      [43,] 23.215437  16.97975889
      [44,] 24.341480  20.28904697
      [45,] 28.722230  21.17217756
      [46,] 20.323514   4.10408546
      [47,]  8.366851   4.65581743
      [48,] 14.069471   4.65645762
      [49,] 25.386571   8.23892067
      [50,] 20.157627   7.90650296
      [51,] 18.499052   3.12737571
      [52,] 15.346000   3.62080773
      [53,] 18.909872  -0.04743743
      [54,] 23.596077   7.32542445
      [55,] 11.611419   5.80981117
      [56,] 16.941655   6.23069370
      [57,] 18.259080   2.10535350
      [58,] 27.500052  -8.65692137
      [59,] 37.313528   2.91081738
      [60,] 34.192307  -2.97167329
      [61,] 21.678276  -7.53723235
      [62,] 32.784563  -6.97975889
      [63,] 31.658520 -10.28904697
      [64,] 27.277770 -11.17217756
      [65,] 35.676486   5.89591454
      [66,] 47.633149   5.34418257
      [67,] 41.930529   5.34354238
      [68,] 30.613429   1.76107933
      [69,] 35.842373   2.09349704
      [70,] 37.500948   6.87262429
      [71,] 40.654000   6.37919227
      [72,] 37.090128  10.04743743
      [73,] 32.403923   2.67457555
      [74,] 44.388581   4.19018883
      [75,] 39.058345   3.76930630
      [76,] 37.740920   7.89464650
      
      $n
      [1] 76
      

# four_long_clust_bkg() works

    Code
      four_long_clust_bkg(n = 400, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]          [,2]          [,3]          [,4]
        [1,] -16.8373630 -1.806858e+01  3.629767e-02 -4.555309e-02
        [2,] -20.5411807 -2.238307e+01  3.141726e-02  4.446336e-02
        [3,] -21.1009352 -1.780197e+01  1.774895e-02 -2.781911e-02
        [4,] -13.9164514 -1.621241e+01 -8.120899e-03 -1.002056e-02
        [5,] -15.0939976 -1.565854e+01  1.586619e-02  2.079151e-02
        [6,] -15.3699457 -1.696588e+01  9.185939e-03  1.940213e-02
        [7,] -17.6771026 -1.537584e+01 -2.909539e-02 -4.202857e-02
        [8,] -12.0623607 -1.384692e+01  2.053609e-02  1.437366e-02
        [9,] -13.1147223 -7.317808e+00 -8.063634e-03  4.711666e-02
       [10,]  -3.8498255 -7.021261e+00  1.553382e-02  1.110588e-03
       [11,]  -9.1309882 -1.202971e+01  2.602863e-02  3.239017e-02
       [12,]  -9.0522739 -1.114188e+01 -4.460973e-02  1.339229e-02
       [13,]  -7.3908364 -5.589877e+00  4.520893e-02  4.645296e-02
       [14,]  -7.1736480 -8.013476e+00  2.327186e-03  1.192731e-02
       [15,]  -7.2230888 -8.131584e+00 -3.853751e-02  2.116185e-02
       [16,]  -4.0877325 -6.244552e+00 -7.380333e-03  1.631644e-02
       [17,]  -4.7479280 -4.673137e+00 -2.232958e-02  1.546603e-02
       [18,]  -2.1817502 -5.796304e+00 -6.065673e-03 -6.941579e-04
       [19,]  -1.0208975 -3.279059e+00 -1.259044e-02  2.659954e-02
       [20,]   1.3523306  2.052608e+00  4.332718e-02 -1.646715e-02
       [21,]   3.2100176 -4.449006e+00  2.363263e-02  4.339491e-02
       [22,]  -1.3928490  3.948307e+00 -2.158810e-02 -2.145939e-02
       [23,]   1.6370558  2.470862e+00 -1.234432e-03  5.977730e-03
       [24,]  -0.1863320  2.415658e+00  3.786748e-02 -3.318530e-02
       [25,]   4.8343633  1.072178e+01 -5.989409e-03 -1.249937e-02
       [26,]   5.8933899  2.344771e+00  4.697274e-02  6.530065e-03
       [27,]   6.2649156  8.146467e+00 -4.611238e-02 -4.114174e-02
       [28,]   7.3256711  8.930327e+00  5.639224e-04 -2.478450e-02
       [29,]   5.8915805  7.857400e+00 -3.845493e-02  4.352686e-02
       [30,]  12.0109910  1.015189e+01 -8.162953e-03 -4.589231e-02
       [31,]   9.5303278  7.532432e+00  4.392665e-02  4.617009e-03
       [32,]   8.8508667  1.310076e+01  2.709454e-02  4.507646e-02
       [33,]  12.8702841  9.074602e+00 -1.836716e-02  5.940151e-03
       [34,]  14.6029551  1.333483e+01  6.381873e-03 -8.188367e-03
       [35,]  14.6501518  1.201119e+01 -1.990309e-02 -3.046013e-02
       [36,]  13.9809537  1.539016e+01  2.730781e-02 -2.082963e-03
       [37,]  15.4797244  1.762550e+01  4.226218e-02 -3.047816e-02
       [38,]  19.4007397  1.952935e+01  4.664999e-02  4.257658e-02
       [39,]  19.3121342  2.042935e+01  2.116798e-02 -1.141599e-02
       [40,]  16.8959861  2.304551e+01 -4.309416e-02 -2.337407e-02
       [41,]  18.4859926  1.986441e+01 -1.920677e-02  3.390966e-02
       [42,]  18.0001846  1.828477e+01 -2.242898e-02 -4.143774e-02
       [43,]  26.5748350  2.094771e+01  4.191774e-02 -3.741529e-02
       [44,]  26.0416196  2.733637e+01  3.674067e-03  4.039443e-02
       [45,]  20.9592457  2.416704e+01 -4.443457e-02  2.845354e-02
       [46,]  26.9374747  2.491215e+01 -1.860181e-02  1.434015e-02
       [47,]  25.5734527  2.642041e+01  2.175452e-02  1.508975e-02
       [48,]  29.6364922  2.975259e+01 -2.180254e-02 -2.946663e-02
       [49,]  28.7918373  2.520104e+01  4.092405e-02 -2.687273e-02
       [50,]  30.6940783  2.812809e+01 -1.156094e-02  2.450101e-02
       [51,]  36.0450222  2.587965e+01  4.391131e-02  3.236095e-02
       [52,]  31.5796481  3.241460e+01  3.421685e-02 -2.834071e-02
       [53,]  34.6105372  3.154865e+01  4.220810e-02  1.017609e-02
       [54,]  31.5460796  3.554585e+01 -4.022145e-02 -4.951010e-03
       [55,]  36.7584912  3.265588e+01  4.296581e-02 -9.329137e-03
       [56,]  34.2518615  4.042719e+01 -4.524026e-02  9.235702e-03
       [57,]  36.4217407  3.993855e+01 -2.511152e-02  1.424448e-02
       [58,]  33.5423132  3.675735e+01 -2.906693e-02  2.765936e-02
       [59,]  35.5980496  4.028656e+01  2.489058e-03 -2.357522e-02
       [60,]  38.7364539  4.160030e+01  1.890632e-02 -9.247106e-04
       [61,]  40.5548287  3.733789e+01  2.927220e-02  2.226533e-02
       [62,]  42.2962426  3.844903e+01  4.092765e-02  1.087636e-02
       [63,]  42.4492702  4.055434e+01  3.048572e-02 -4.905825e-03
       [64,]  42.1386712  4.320937e+01  3.307067e-02 -2.455052e-02
       [65,]  40.9791314  4.180884e+01  3.749385e-02 -1.645280e-03
       [66,]  46.2040806  3.808562e+01 -3.411267e-02 -2.338030e-02
       [67,]  49.7681849  4.564511e+01 -3.205123e-02 -4.603940e-02
       [68,]  48.3669036  4.519960e+01  3.857820e-02  3.328674e-02
       [69,]  49.9393264  4.687344e+01 -2.676152e-02  4.064574e-02
       [70,]  50.5842548  5.356699e+01  2.005807e-02 -1.298184e-02
       [71,]  48.8074401  4.696451e+01 -3.963579e-02 -1.381245e-03
       [72,]  50.1643836  5.441071e+01 -4.464460e-02 -9.914179e-03
       [73,]  53.9902939  4.418769e+01  3.259540e-02 -2.530526e-03
       [74,]  53.6976347  5.309410e+01  4.315758e-02 -2.729615e-02
       [75,]  56.8083461  5.211136e+01 -4.323491e-02  4.977361e-02
       [76,]  51.9536856  5.247688e+01 -1.448548e-02 -3.738483e-02
       [77,]  56.6568615  5.568651e+01  2.217300e-02 -1.781895e-02
       [78,]  57.1928125  5.647501e+01 -1.027064e-02  2.909667e-02
       [79,]  61.1621228  5.641362e+01  4.496821e-02  3.765714e-02
       [80,]  60.1152716  6.045153e+01  2.655916e-02 -1.222253e-02
       [81,]  16.9758372 -1.769575e+01 -8.054416e-03 -2.075209e-02
       [82,]  18.3155145 -1.110038e+01 -4.392374e-02  4.898746e-02
       [83,]  20.3691662 -1.474205e+01 -2.359525e-02 -3.192730e-02
       [84,]  22.8878769 -1.064308e+01 -1.092390e-02  2.347345e-02
       [85,]  19.0037223 -1.265287e+01  4.630102e-02  3.927989e-02
       [86,]  22.1181123 -6.724652e+00  2.662198e-02  4.121712e-02
       [87,]  22.2255901 -8.720965e+00 -4.263518e-03 -3.928497e-02
       [88,]  23.3851025 -7.626442e+00 -2.611584e-02  3.702536e-02
       [89,]  20.3946211 -7.688733e+00  4.355451e-02  1.453956e-02
       [90,]  27.5918997 -1.067446e+01 -1.124803e-02  1.511670e-02
       [91,]  19.5541182 -6.595466e+00 -2.867090e-02 -2.085086e-02
       [92,]  26.0252237 -7.268467e+00  1.485437e-02  2.631276e-02
       [93,]  31.3314324 -1.920049e+00  4.124495e-02  3.924439e-02
       [94,]  28.1177437 -1.851091e+00 -3.849647e-02  3.962608e-02
       [95,]  29.6952477 -2.782601e+00 -4.035356e-02  3.601795e-02
       [96,]  31.0433635 -4.164050e-01  4.438101e-02 -2.132409e-02
       [97,]  29.5791998  3.342153e+00  1.914029e-02 -4.799574e-02
       [98,]  32.8937726 -1.771034e-01 -8.827151e-03 -3.955065e-02
       [99,]  33.0513785  1.522529e+00  6.906394e-03 -3.353678e-02
      [100,]  34.9576528  1.083646e+00 -2.500496e-02  3.749058e-03
      [101,]  38.0810591  2.156190e+00  3.486415e-02  2.561923e-02
      [102,]  39.4321539  4.687366e+00  3.207366e-02 -4.328054e-02
      [103,]  38.1448555  4.722317e+00  1.476420e-02 -2.657243e-02
      [104,]  35.4646775  7.172096e+00 -1.487132e-03 -2.482937e-03
      [105,]  35.5120377  9.015222e+00 -3.114883e-02  2.067488e-02
      [106,]  38.3518680  7.718838e+00  3.930624e-02 -2.909830e-02
      [107,]  40.0798828  8.935640e+00 -1.292091e-02  5.261940e-03
      [108,]  39.3279297  1.313313e+01 -3.438110e-02  1.225310e-03
      [109,]  42.0529725  1.369437e+01  3.673330e-02 -2.573979e-02
      [110,]  43.7769963  1.082505e+01 -7.785790e-03 -4.920211e-02
      [111,]  45.4093485  1.312006e+01  3.775987e-02  3.828112e-03
      [112,]  49.6635660  1.046951e+01 -2.817780e-02 -4.840133e-02
      [113,]  47.6749019  1.866041e+01  1.064854e-02  1.622421e-02
      [114,]  49.3682600  1.747454e+01  4.422468e-02  4.705459e-02
      [115,]  51.1746659  1.567531e+01  4.409485e-03 -5.583441e-03
      [116,]  47.6378983  1.908852e+01  2.765841e-02 -1.856189e-02
      [117,]  52.6687461  1.749181e+01  6.641598e-03 -3.931910e-02
      [118,]  50.9350638  2.274323e+01 -2.512449e-02 -2.130964e-02
      [119,]  53.7547533  1.941235e+01 -4.955630e-02  2.342741e-02
      [120,]  57.3598331  1.761777e+01 -3.146839e-03  2.933642e-02
      [121,]  56.8981938  2.429534e+01  9.831291e-03 -2.671146e-02
      [122,]  55.2973139  2.447086e+01 -2.714389e-02 -2.874434e-03
      [123,]  51.5247743  2.727223e+01 -4.002474e-02 -4.335716e-02
      [124,]  60.4570146  2.495569e+01  3.417797e-02  3.560783e-02
      [125,]  57.4223703  3.152424e+01  5.691283e-03 -4.759485e-02
      [126,]  60.3359972  2.859709e+01  2.159807e-02 -2.414846e-02
      [127,]  59.9023151  2.799353e+01 -8.071225e-03 -3.752585e-02
      [128,]  61.1312630  3.170037e+01  4.391317e-03 -4.680808e-02
      [129,]  63.7208199  3.448349e+01 -4.771512e-03  3.778814e-02
      [130,]  65.8354248  3.367510e+01  1.587071e-02  4.903727e-02
      [131,]  66.4243249  3.389643e+01  3.635973e-02  1.696616e-03
      [132,]  67.8295919  3.557525e+01 -1.133370e-02  1.757738e-02
      [133,]  67.9211754  3.871617e+01  2.288790e-02 -1.058579e-02
      [134,]  71.0231891  3.615002e+01 -6.661088e-03  3.779881e-02
      [135,]  68.4225399  3.714412e+01 -3.594665e-02  9.174128e-03
      [136,]  75.5311807  3.817999e+01 -3.459761e-02 -4.528655e-02
      [137,]  74.3574533  3.927287e+01 -5.795360e-03 -2.627506e-02
      [138,]  74.1448241  4.077053e+01  1.656536e-02  2.480230e-02
      [139,]  70.8356452  4.221946e+01  1.015206e-02  1.863678e-02
      [140,]  75.2686079  4.131586e+01 -4.870286e-02  4.428247e-02
      [141,]  76.3989230  4.325641e+01 -1.152507e-02  3.309084e-02
      [142,]  73.3407895  4.230508e+01 -4.444306e-02  6.205570e-04
      [143,]  80.4119100  4.194933e+01 -8.271111e-03  1.274938e-02
      [144,]  78.5500803  4.973544e+01  3.604335e-02  2.556577e-02
      [145,]  76.4991615  5.049276e+01  4.192450e-02 -2.704463e-03
      [146,]  77.1491904  4.434530e+01  3.463579e-02 -1.715678e-02
      [147,]  81.2404153  5.408270e+01  5.629439e-03  2.553369e-02
      [148,]  83.1831113  5.006303e+01  3.736544e-03 -1.342221e-02
      [149,]  83.4321976  5.187418e+01  1.467698e-02 -2.135242e-02
      [150,]  84.5684131  5.364107e+01  2.188860e-03 -4.435638e-02
      [151,]  86.2066679  5.277446e+01  2.250117e-03 -3.480150e-02
      [152,]  85.6447964  5.432342e+01 -8.365604e-03  7.342764e-03
      [153,]  85.7532980  5.499770e+01 -2.348013e-02 -7.514273e-03
      [154,]  89.5467001  5.880907e+01 -1.505425e-02  1.997895e-02
      [155,]  89.5731125  5.564636e+01 -1.848556e-02  2.137183e-02
      [156,]  92.6690525  6.027020e+01  3.956056e-02 -8.705977e-03
      [157,]  93.6905992  6.118329e+01 -3.476416e-02  1.731751e-02
      [158,]  89.3096883  5.798504e+01  4.016556e-02 -4.477979e-02
      [159,]  94.2682147  6.272342e+01 -3.392490e-02  4.190433e-02
      [160,]  99.3698058  5.969050e+01  9.393090e-03  2.007988e-02
      [161,]  -6.8373630  1.193142e+01  1.393803e-02 -3.115944e-02
      [162,] -10.5411807  7.616926e+00  2.225547e-02 -2.308626e-02
      [163,] -11.1009352  1.219803e+01  2.738212e-02  3.330740e-02
      [164,]  -3.9164514  1.378759e+01 -3.073480e-02  4.415502e-02
      [165,]  -5.0939976  1.434146e+01  2.495993e-02 -3.834558e-02
      [166,]  -5.3699457  1.303412e+01  4.024293e-02  2.309174e-02
      [167,]  -7.6771026  1.462416e+01 -4.621974e-02 -8.338904e-03
      [168,]  -2.0623607  1.615308e+01  3.932236e-02  3.812055e-02
      [169,]  -3.1147223  2.268219e+01 -2.399021e-02  3.733654e-05
      [170,]   6.1501745  2.297874e+01  4.876298e-02 -4.724280e-02
      [171,]   0.8690118  1.797029e+01  5.570777e-03 -1.894036e-02
      [172,]   0.9477261  1.885812e+01 -3.719361e-02  7.934875e-03
      [173,]   2.6091636  2.441012e+01 -4.364063e-02  2.471494e-02
      [174,]   2.8263520  2.198652e+01 -3.907752e-02 -9.015889e-03
      [175,]   2.7769112  2.186842e+01 -2.274678e-02 -2.119069e-03
      [176,]   5.9122675  2.375545e+01  2.764111e-02  2.862516e-02
      [177,]   5.2520720  2.532686e+01 -4.468815e-02 -4.937218e-02
      [178,]   7.8182498  2.420370e+01 -1.634977e-03  1.189991e-03
      [179,]   8.9791025  2.672094e+01  2.401393e-02 -1.052345e-02
      [180,]  11.3523306  3.205261e+01 -1.812660e-02  1.419472e-02
      [181,]  13.2100176  2.555099e+01  4.922323e-02 -3.895420e-02
      [182,]   8.6071510  3.394831e+01  3.299203e-02  1.607776e-02
      [183,]  11.6370558  3.247086e+01 -6.474367e-03  3.519951e-02
      [184,]   9.8136680  3.241566e+01 -4.223610e-02 -4.306235e-02
      [185,]  14.8343633  4.072178e+01  3.448482e-02 -2.677924e-02
      [186,]  15.8933899  3.234477e+01 -3.052665e-02  3.370115e-02
      [187,]  16.2649156  3.814647e+01 -2.311675e-02 -7.628256e-03
      [188,]  17.3256711  3.893033e+01  1.942860e-02  1.474725e-03
      [189,]  15.8915805  3.785740e+01  1.718890e-04  2.119039e-02
      [190,]  22.0109910  4.015189e+01 -3.404807e-02  1.268381e-02
      [191,]  19.5303278  3.753243e+01  2.371948e-02  1.346007e-02
      [192,]  18.8508667  4.310076e+01 -4.342598e-04 -1.548746e-02
      [193,]  22.8702841  3.907460e+01  4.823518e-02 -2.307818e-02
      [194,]  24.6029551  4.333483e+01  1.964920e-02  4.217972e-02
      [195,]  24.6501518  4.201119e+01 -1.948357e-02  4.829483e-02
      [196,]  23.9809537  4.539016e+01  1.592498e-02  2.072083e-02
      [197,]  25.4797244  4.762550e+01 -2.456669e-02  3.700059e-02
      [198,]  29.4007397  4.952935e+01  4.787787e-02 -2.682958e-02
      [199,]  29.3121342  5.042935e+01 -2.193019e-03  5.010260e-03
      [200,]  26.8959861  5.304551e+01 -4.167884e-02  2.138814e-02
      [201,]  28.4859926  4.986441e+01  2.316105e-02  3.384213e-02
      [202,]  28.0001846  4.828477e+01  2.623009e-02 -2.381642e-02
      [203,]  36.5748350  5.094771e+01 -3.703178e-02 -3.741723e-02
      [204,]  36.0416196  5.733637e+01 -3.463169e-02 -2.485847e-02
      [205,]  30.9592457  5.416704e+01  4.101954e-02 -1.459736e-03
      [206,]  36.9374747  5.491215e+01  1.660521e-02 -4.685443e-03
      [207,]  35.5734527  5.642041e+01 -3.055208e-02 -4.021027e-02
      [208,]  39.6364922  5.975259e+01 -2.456755e-02  4.312391e-02
      [209,]  38.7918373  5.520104e+01 -3.454551e-02  1.495112e-02
      [210,]  40.6940783  5.812809e+01 -3.508595e-04 -1.122955e-02
      [211,]  46.0450222  5.587965e+01 -3.405702e-03  4.721409e-02
      [212,]  41.5796481  6.241460e+01 -1.186254e-03 -4.704446e-02
      [213,]  44.6105372  6.154865e+01 -1.096035e-02  6.842718e-03
      [214,]  41.5460796  6.554585e+01  2.121938e-02  1.286648e-02
      [215,]  46.7584912  6.265588e+01 -2.175540e-02 -3.359787e-02
      [216,]  44.2518615  7.042719e+01 -1.917075e-02 -4.484048e-02
      [217,]  46.4217407  6.993855e+01  4.423345e-02 -4.241089e-02
      [218,]  43.5423132  6.675735e+01 -2.195092e-02 -3.371412e-02
      [219,]  45.5980496  7.028656e+01 -4.953112e-02 -1.659019e-02
      [220,]  48.7364539  7.160030e+01  1.138406e-02 -2.000044e-02
      [221,]  50.5548287  6.733789e+01  1.550899e-02  1.690339e-02
      [222,]  52.2962426  6.844903e+01 -4.010219e-02 -9.961860e-03
      [223,]  52.4492702  7.055434e+01  1.634947e-02 -2.888342e-02
      [224,]  52.1386712  7.320937e+01 -4.253979e-02 -2.930204e-02
      [225,]  50.9791314  7.180884e+01  4.808981e-02 -4.338725e-02
      [226,]  56.2040806  6.808562e+01  3.081084e-02  1.025363e-03
      [227,]  59.7681849  7.564511e+01 -7.190514e-03  6.947431e-03
      [228,]  58.3669036  7.519960e+01  4.127902e-02 -3.107307e-02
      [229,]  59.9393264  7.687344e+01 -2.404599e-02 -2.983059e-02
      [230,]  60.5842548  8.356699e+01 -1.933766e-02 -3.587464e-03
      [231,]  58.8074401  7.696451e+01  4.239964e-02  3.662836e-02
      [232,]  60.1643836  8.441071e+01 -1.849773e-02 -2.557130e-02
      [233,]  63.9902939  7.418769e+01 -1.989845e-02 -4.820601e-02
      [234,]  63.6976347  8.309410e+01 -1.169297e-02 -4.970583e-02
      [235,]  66.8083461  8.211136e+01  2.322755e-02  1.212139e-02
      [236,]  61.9536856  8.247688e+01 -1.927021e-02  3.294325e-02
      [237,]  66.6568615  8.568651e+01 -3.201269e-02  1.258265e-02
      [238,]  67.1928125  8.647501e+01 -8.195556e-03 -1.569915e-04
      [239,]  71.1621228  8.641362e+01 -3.135465e-02 -1.541384e-02
      [240,]  70.1152716  9.045153e+01  2.442750e-02  3.356151e-02
      [241,]  23.1626370  3.193142e+01 -1.517884e-02 -6.868312e-03
      [242,]  19.4588193  2.761693e+01 -3.514090e-02  2.614086e-02
      [243,]  18.8990648  3.219803e+01  2.150824e-02  2.321119e-02
      [244,]  26.0835486  3.378759e+01  2.728485e-03 -4.151565e-02
      [245,]  24.9060024  3.434146e+01  3.871202e-02  6.862480e-03
      [246,]  24.6300543  3.303412e+01  2.278382e-02  3.822739e-02
      [247,]  22.3228974  3.462416e+01  2.512407e-02  2.681517e-02
      [248,]  27.9376393  3.615308e+01 -4.649326e-02 -3.516757e-02
      [249,]  26.8852777  4.268219e+01  1.995078e-02  4.175256e-03
      [250,]  36.1501745  4.297874e+01 -2.565149e-02 -4.622971e-02
      [251,]  30.8690118  3.797029e+01 -4.058669e-02  3.193288e-02
      [252,]  30.9477261  3.885812e+01  2.873166e-03 -1.676492e-02
      [253,]  32.6091636  4.441012e+01  4.442756e-02  3.526906e-02
      [254,]  32.8263520  4.198652e+01 -4.911115e-02  3.087604e-02
      [255,]  32.7769112  4.186842e+01 -4.165463e-02  1.070080e-02
      [256,]  35.9122675  4.375545e+01 -3.419861e-02  3.229748e-02
      [257,]  35.2520720  4.532686e+01 -8.630894e-03  4.542123e-02
      [258,]  37.8182498  4.420370e+01  1.077493e-02  1.655894e-02
      [259,]  38.9791025  4.672094e+01  1.501543e-02  1.747713e-03
      [260,]  41.3523306  5.205261e+01  3.249849e-02 -3.294439e-02
      [261,]  43.2100176  4.555099e+01 -3.576007e-02  4.563259e-02
      [262,]  38.6071510  5.394831e+01 -1.850679e-02  3.535140e-03
      [263,]  41.6370558  5.247086e+01  2.710531e-02  1.578933e-02
      [264,]  39.8136680  5.241566e+01  2.235682e-02  4.282951e-02
      [265,]  44.8343633  6.072178e+01  3.600592e-02 -4.877184e-02
      [266,]  45.8933899  5.234477e+01 -1.070241e-02 -1.200973e-02
      [267,]  46.2649156  5.814647e+01  1.818586e-02  2.913777e-02
      [268,]  47.3256711  5.893033e+01  2.815670e-02 -1.224266e-02
      [269,]  45.8915805  5.785740e+01 -3.828808e-03  1.746640e-02
      [270,]  52.0109910  6.015189e+01 -4.094278e-02 -1.495863e-02
      [271,]  49.5303278  5.753243e+01  3.250933e-02  3.182903e-02
      [272,]  48.8508667  6.310076e+01 -2.053256e-02  1.085481e-04
      [273,]  52.8702841  5.907460e+01 -3.559308e-02  3.300351e-02
      [274,]  54.6029551  6.333483e+01  4.878065e-02 -3.553239e-02
      [275,]  54.6501518  6.201119e+01  4.481919e-02  2.355607e-03
      [276,]  53.9809537  6.539016e+01 -4.397552e-02 -2.481383e-02
      [277,]  55.4797244  6.762550e+01  3.610309e-02  4.444729e-02
      [278,]  59.4007397  6.952935e+01 -2.131414e-02  3.384768e-02
      [279,]  59.3121342  7.042935e+01  3.636798e-03  3.985037e-02
      [280,]  56.8959861  7.304551e+01  3.402189e-02  2.217006e-02
      [281,]  58.4859926  6.986441e+01  3.049437e-02  2.400772e-02
      [282,]  58.0001846  6.828477e+01 -8.520503e-03  3.606880e-03
      [283,]  66.5748350  7.094771e+01  3.672661e-02 -3.080228e-02
      [284,]  66.0416196  7.733637e+01  2.642170e-02 -2.536742e-02
      [285,]  60.9592457  7.416704e+01  9.144743e-03 -1.347111e-02
      [286,]  66.9374747  7.491215e+01 -5.949574e-03 -4.044331e-02
      [287,]  65.5734527  7.642041e+01  2.816194e-02 -5.961939e-03
      [288,]  69.6364922  7.975259e+01 -1.726960e-03  4.369684e-02
      [289,]  68.7918373  7.520104e+01  2.569834e-02  3.528876e-02
      [290,]  70.6940783  7.812809e+01  4.967059e-02 -3.967089e-02
      [291,]  76.0450222  7.587965e+01 -5.135249e-03 -1.281080e-02
      [292,]  71.5796481  8.241460e+01  2.735784e-02 -6.340092e-03
      [293,]  74.6105372  8.154865e+01  1.159155e-02 -2.135797e-02
      [294,]  71.5460796  8.554585e+01 -2.640640e-02  1.863120e-02
      [295,]  76.7584912  8.265588e+01 -1.985293e-02  2.447875e-02
      [296,]  74.2518615  9.042719e+01  2.438598e-04 -3.734830e-02
      [297,]  76.4217407  8.993855e+01  5.309682e-03  4.338618e-03
      [298,]  73.5423132  8.675735e+01  3.622295e-02  4.281553e-02
      [299,]  75.5980496  9.028656e+01  1.938526e-02 -5.244724e-04
      [300,]  78.7364539  9.160030e+01 -9.325156e-03  1.928101e-02
      [301,]  80.5548287  8.733789e+01  2.487195e-02 -3.568117e-02
      [302,]  82.2962426  8.844903e+01 -4.730527e-02 -2.225809e-02
      [303,]  82.4492702  9.055434e+01 -2.389774e-02  3.982380e-02
      [304,]  82.1386712  9.320937e+01  2.647772e-02  4.170410e-02
      [305,]  80.9791314  9.180884e+01  1.890590e-02  3.715181e-02
      [306,]  86.2040806  8.808562e+01  3.497542e-02 -4.220070e-02
      [307,]  89.7681849  9.564511e+01 -4.571855e-02  2.518827e-03
      [308,]  88.3669036  9.519960e+01 -1.080535e-02 -3.659039e-02
      [309,]  89.9393264  9.687344e+01  4.276782e-02  3.716604e-02
      [310,]  90.5842548  1.035670e+02 -1.553904e-02 -3.218129e-02
      [311,]  88.8074401  9.696451e+01  1.026275e-02  2.750799e-02
      [312,]  90.1643836  1.044107e+02  2.543897e-02 -1.701060e-02
      [313,]  93.9902939  9.418769e+01  1.780995e-02  3.058774e-02
      [314,]  93.6976347  1.030941e+02  1.053365e-02  2.541549e-02
      [315,]  96.8083461  1.021114e+02  2.969802e-02 -2.644579e-02
      [316,]  91.9536856  1.024769e+02  1.318234e-02  3.796711e-03
      [317,]  96.6568615  1.056865e+02  2.211034e-02 -2.241050e-02
      [318,]  97.1928125  1.064750e+02  1.949560e-02 -3.275914e-02
      [319,] 101.1621228  1.064136e+02 -3.431024e-02 -1.030154e-02
      [320,] 100.1152716  1.104515e+02  3.547910e-02 -2.848918e-02
      [321,]  20.7222632 -5.000893e+00 -3.547076e+00  9.378777e+00
      [322,]  -7.6525701 -7.563056e+00 -3.101675e+00 -5.912202e+00
      [323,]   0.1114251  1.411212e+01  1.029667e+00  6.577632e+00
      [324,]  -8.9582246  1.064097e+01 -2.581438e-01  6.757452e+00
      [325,]   0.3035147 -1.247794e+01 -5.894750e+00  3.269000e+01
      [326,]  10.9872829  4.090102e+00 -9.631333e+00  6.962559e+00
      [327,]  -1.5652624  1.303039e+00  1.209546e+00  1.951456e-01
      [328,]  -1.6403877  5.359667e+00 -1.227964e+01  3.233083e+00
      [329,] -10.8568295  6.824598e+00 -7.029833e+00  1.419945e+01
      [330,] -11.2031728 -4.460549e+00 -1.025477e+01  7.572636e+00
      [331,] -21.4929757 -9.357315e+00 -3.561593e+00 -6.410809e+00
      [332,]  -1.9589130  1.007764e+01  1.415877e+01 -8.849595e+00
      [333,] -15.2791952  1.207989e+01  1.468962e+01 -4.175106e+00
      [334,]  -5.4676523  9.838880e+00  3.073243e+00 -2.633656e+01
      [335,]   6.9941295 -2.735339e+00  9.689229e+00  1.716253e+00
      [336,]   9.3048533 -1.500951e+01  1.459255e+01  2.569638e+00
      [337,]   7.7386190  1.786042e+00 -4.858695e+00 -4.072831e+00
      [338,]   3.7427760 -4.376574e+00  2.299240e+00  3.644730e+00
      [339,]   2.0335543 -1.336529e+01 -1.644311e-01  9.242049e+00
      [340,]   2.3751650  6.336118e+00 -5.210109e+00 -6.550992e+00
      [341,]  13.1014093  5.868386e+00 -5.063615e+00  6.634111e+00
      [342,]  -6.1399954 -1.107020e+01  5.893569e+00 -2.285120e+00
      [343,]   6.5551040 -4.628775e+00 -8.361889e+00 -3.556388e+00
      [344,]   3.8450699 -1.475914e+01 -2.150652e+00  7.116233e+00
      [345,]  -7.8463574  1.126571e+00  3.529443e+00 -1.051449e+01
      [346,]  24.8505184  9.002229e+00  1.176814e+01 -4.991291e+00
      [347,]   1.8069110 -1.693914e+01  8.110293e+00 -1.747136e+01
      [348,]  -9.1588076  4.932778e+00 -1.139734e+00 -6.922318e+00
      [349,]  12.8795811  3.680191e+00  8.338284e+00 -9.596942e+00
      [350,]  -3.8266635 -2.235629e+00  1.086086e+01 -3.084846e+00
      [351,]   8.3304240 -1.710523e+01  4.779874e+00  1.623482e+00
      [352,]  -4.8425068  2.255251e+00  2.504297e+01  5.622499e+00
      [353,]   0.3357698 -5.453890e+00 -1.723035e+01  1.306082e+01
      [354,]   0.6778413  1.382573e+01  5.838139e+00 -3.878980e+00
      [355,]  -1.6074643 -1.699227e+01  4.501167e+00  6.035412e+00
      [356,]  10.3776903 -4.505332e+00  6.593084e-01  2.805176e-02
      [357,]  14.8957622 -1.478195e+01  1.819780e+01 -2.285161e+01
      [358,]  10.5613190 -5.063198e+00  9.562806e+00 -3.941408e+00
      [359,]  -9.8509188 -4.984257e+00  5.959294e+00  5.467079e+00
      [360,]  -6.7577345  1.196466e+01  3.564475e+00  1.474996e+01
      [361,]   6.9866675  1.093573e+00  1.769136e+00  2.449608e-01
      [362,]  22.7980146 -1.238861e+01  3.528319e+00  2.366314e+00
      [363,]   6.6798234 -1.105677e+00 -1.029381e+01  1.848141e+01
      [364,] -16.2023226  7.601924e+00 -3.507513e+00 -2.206274e+00
      [365,] -11.7457198  1.275880e+01  8.720252e+00 -1.707836e+00
      [366,]  -2.1182952 -7.444199e+00 -4.328609e-01  9.581442e-01
      [367,]   4.6604515 -1.770175e+01 -1.252445e+01 -5.417217e-01
      [368,] -15.3393627 -7.869870e+00 -1.190201e+01  6.048036e+00
      [369,] -11.4221970 -2.116944e-01  8.687989e+00  2.193539e+00
      [370,] -11.6936189 -3.454935e+00 -9.255716e-01  1.612669e+01
      [371,]  18.7810385 -7.134455e+00  1.221874e+01 -1.103779e+01
      [372,]  -2.2131547 -1.291203e+01 -2.921949e+00 -8.745808e-02
      [373,]   7.8609681  3.737334e+00 -5.381596e-01 -2.347085e+00
      [374,]  -9.2573816 -8.232048e+00  1.149369e+01 -6.904384e+00
      [375,]  -0.8883126  1.658248e+01  6.594737e+00 -7.267975e-01
      [376,] -10.8396948  1.167237e+01 -9.257330e+00 -2.222136e+00
      [377,]  23.1045630  1.386960e+01 -1.312178e+01 -1.220893e+01
      [378,]   7.3286992  8.283560e+00  3.889702e-01 -1.311388e+01
      [379,]  -1.9414794 -1.309286e+01 -1.367419e+01 -4.259740e+00
      [380,] -14.7604195 -2.448510e+00  1.974905e+01  7.634774e+00
      [381,]   6.9663813 -1.370963e+01  1.953727e+01 -8.156474e+00
      [382,]  15.8753482  3.066630e+00  1.908443e+01 -4.587062e+00
      [383,]   7.9599173  1.308100e+01  1.060216e+00  2.666298e-01
      [384,]   2.0641936 -1.687133e+01  1.501408e+01  1.522988e+00
      [385,]   0.2519359 -4.127677e+00 -3.447755e+00  1.607422e+00
      [386,]  -3.0002471  9.799784e+00  1.646038e+01 -2.828803e+00
      [387,] -26.1907702  3.568273e+01 -3.734631e+00 -6.878855e+00
      [388,]  -2.7288956 -9.382244e+00  1.109571e+01 -2.098288e+00
      [389,]  10.7692394  1.395693e+01  1.585258e+00  4.933220e+00
      [390,] -19.0732156 -8.097545e+00  1.132656e+01  1.247555e+01
      [391,] -21.6019288  6.814301e+00  7.424293e+00  1.283584e+01
      [392,]   3.1743120  9.717303e+00  9.673938e+00 -8.896441e+00
      [393,]   4.7233500 -8.605036e+00 -8.984894e+00  9.667252e-01
      [394,]   7.0973536 -1.171053e+01 -1.816668e+01 -2.020691e+00
      [395,]   5.3170236 -3.623071e-04 -4.290262e+00 -5.954625e+00
      [396,]   2.4789689  4.639439e+00 -9.879417e+00  5.539300e+00
      [397,]  14.1507790  1.040177e+00 -6.170966e+00 -1.594759e+00
      [398,]   2.3895792  1.849556e+01  1.298767e+01  1.030531e+00
      [399,]  16.8941547  6.393509e+00 -4.599919e+00  6.323494e+00
      [400,]  11.0747957 -6.297742e+00 -1.052272e+00 -4.213873e+00

---

    Code
      four_long_clust_bkg(n = 400, num_noise = 0)
    Output
                     [,1]         [,2]
        [1,] -17.40798624 -19.96091436
        [2,] -19.04691355 -18.51634384
        [3,] -18.02162950 -17.74315185
        [4,] -16.54088079 -17.03781711
        [5,] -11.41914383 -19.48893501
        [6,] -16.57139710 -14.18880089
        [7,] -15.29201686 -16.83531541
        [8,]  -9.22981241 -13.12788627
        [9,] -15.83914835 -10.64383868
       [10,] -10.08440415 -10.73251372
       [11,]  -9.48953054  -8.87303119
       [12,] -12.77298296 -10.66708206
       [13,]  -5.43064672  -8.59088446
       [14,]  -5.79875409  -6.33307465
       [15,] -10.22984168  -3.10366641
       [16,]  -3.71049323  -1.89478434
       [17,]  -3.71496674  -7.27893568
       [18,]  -0.83803502  -5.73659419
       [19,]  -2.41050144   1.57305950
       [20,]  -2.16935412   0.91460089
       [21,]  -1.75123169  -5.10694466
       [22,]  -2.19326503  -0.52347769
       [23,]   2.78571155  -0.01074308
       [24,]   5.68120705  10.10301965
       [25,]   4.69586620   2.53056584
       [26,]   3.57116986   3.32990944
       [27,]   6.86043266   1.99880421
       [28,]   5.75264728   6.53935621
       [29,]   8.26381702   5.85703855
       [30,]  12.85646299   5.71032447
       [31,]  10.88639631   5.82405348
       [32,]   6.81866604   8.55758099
       [33,]  10.70920364  10.85666124
       [34,]  15.13115613  10.90848734
       [35,]  14.41187039  10.49689721
       [36,]  18.48020426  19.40462440
       [37,]  17.41322894  17.48837464
       [38,]  16.59253749  15.20515548
       [39,]  19.60773508  19.79842191
       [40,]  23.44772835  23.77736043
       [41,]  18.52995382  21.60876531
       [42,]  18.09211623  24.79095817
       [43,]  28.07570285  23.94357432
       [44,]  21.27144580  18.39966599
       [45,]  25.80447407  25.00399303
       [46,]  23.83279843  24.22286387
       [47,]  24.55454481  29.03255152
       [48,]  29.54775521  28.63777306
       [49,]  25.80095547  26.39915201
       [50,]  29.94232113  24.91729593
       [51,]  28.56504338  33.04447234
       [52,]  29.93504509  32.34619715
       [53,]  34.12015998  33.79762387
       [54,]  33.32535710  30.95464292
       [55,]  33.30919074  30.67124709
       [56,]  35.39696167  33.96270287
       [57,]  35.57256540  36.65248859
       [58,]  31.20722239  39.78512934
       [59,]  37.51449712  37.43788224
       [60,]  32.91473044  36.39526387
       [61,]  42.87885187  37.42945213
       [62,]  37.17842198  46.59229451
       [63,]  47.07066865  41.60357647
       [64,]  47.65825784  45.39847857
       [65,]  43.22163588  44.98907244
       [66,]  41.69586233  43.13964666
       [67,]  46.67082491  45.61175366
       [68,]  47.90868812  42.69688757
       [69,]  47.64110078  49.81618947
       [70,]  50.56924040  53.61824670
       [71,]  47.87359488  48.42053237
       [72,]  51.54932862  50.42368611
       [73,]  52.32203130  52.05641316
       [74,]  56.60634716  56.85795221
       [75,]  53.19796616  53.14405222
       [76,]  55.78798425  54.22841141
       [77,]  55.11921884  60.89393578
       [78,]  55.42776128  54.95722025
       [79,]  57.73786154  59.75678412
       [80,]  55.56922116  60.61672338
       [81,]  21.08788984 -15.67266418
       [82,]  18.34936694 -13.37707365
       [83,]  20.94714763 -16.57657681
       [84,]  17.05225288 -11.95871065
       [85,]  18.07620226 -11.78547320
       [86,]  23.49747231  -9.64639284
       [87,]  22.64513610 -15.70055722
       [88,]  23.32843434 -11.23049231
       [89,]  25.43726166  -3.48324063
       [90,]  27.75877143  -5.53582656
       [91,]  22.51282499  -8.88832583
       [92,]  26.37282950  -4.53930712
       [93,]  25.38065109  -6.29848510
       [94,]  28.90027581  -6.00783651
       [95,]  27.64160260  -2.63955373
       [96,]  27.31394801   3.66488488
       [97,]  31.04701014  -1.97731022
       [98,]  37.93652585   3.30586344
       [99,]  32.13992043  -1.80023988
      [100,]  37.12146366   4.95968661
      [101,]  33.79684947   0.66124926
      [102,]  35.04255377   2.35911200
      [103,]  39.75576212   6.59894655
      [104,]  39.84609733   5.85702407
      [105,]  35.98670072  10.00702821
      [106,]  38.12246647  11.18881961
      [107,]  41.41135553  12.77847249
      [108,]  40.86687653   8.22979628
      [109,]  45.48449181   8.11341784
      [110,]  42.12553215  14.84289036
      [111,]  47.78764723  12.11884905
      [112,]  44.04266008  16.51141311
      [113,]  50.76240206  11.17818244
      [114,]  50.30487353  18.04007439
      [115,]  47.90226767  19.91886899
      [116,]  48.30557030  17.81072682
      [117,]  50.13080742  15.12286670
      [118,]  54.15055411  22.63902163
      [119,]  55.46838534  18.84725074
      [120,]  53.55013876  25.11512479
      [121,]  51.93862835  24.19231147
      [122,]  58.14029822  27.50207627
      [123,]  54.63427273  25.09906096
      [124,]  62.62870878  29.70597269
      [125,]  61.42353794  25.77823924
      [126,]  59.83696502  26.44065747
      [127,]  60.09330644  29.79252809
      [128,]  67.60877017  32.15461302
      [129,]  63.27318502  32.23739051
      [130,]  64.93037811  32.72375585
      [131,]  65.32671864  34.43408586
      [132,]  65.30926890  36.57073783
      [133,]  65.40045833  33.94086361
      [134,]  68.40751678  33.84660820
      [135,]  64.56236326  40.67838009
      [136,]  71.52174715  39.98361930
      [137,]  74.06623347  39.47332950
      [138,]  72.31783334  43.50154966
      [139,]  75.10682718  41.08585582
      [140,]  73.28145034  45.01655144
      [141,]  77.90389602  44.14168260
      [142,]  78.99654601  43.53414163
      [143,]  73.65300772  45.33124588
      [144,]  80.87889570  49.80573882
      [145,]  80.82123524  47.86916381
      [146,]  81.63006916  49.38601789
      [147,]  84.19017475  51.02295144
      [148,]  86.12895160  53.79450354
      [149,]  87.44124448  50.07875728
      [150,]  87.95874038  56.03114371
      [151,]  85.31045371  59.46153249
      [152,]  84.16570283  57.31185745
      [153,]  87.25033633  55.61719216
      [154,]  87.15673386  59.19307833
      [155,]  90.30767667  58.28260387
      [156,]  89.68774620  57.14420873
      [157,]  91.45061585  61.89867692
      [158,]  94.48436334  62.73958816
      [159,]  93.37258359  63.54929826
      [160,]  95.24000389  64.79412589
      [161,]  -7.40798624  10.03908564
      [162,]  -9.04691355  11.48365616
      [163,]  -8.02162950  12.25684815
      [164,]  -6.54088079  12.96218289
      [165,]  -1.41914383  10.51106499
      [166,]  -6.57139710  15.81119911
      [167,]  -5.29201686  13.16468459
      [168,]   0.77018759  16.87211373
      [169,]  -5.83914835  19.35616132
      [170,]  -0.08440415  19.26748628
      [171,]   0.51046946  21.12696881
      [172,]  -2.77298296  19.33291794
      [173,]   4.56935328  21.40911554
      [174,]   4.20124591  23.66692535
      [175,]  -0.22984168  26.89633359
      [176,]   6.28950677  28.10521566
      [177,]   6.28503326  22.72106432
      [178,]   9.16196498  24.26340581
      [179,]   7.58949856  31.57305950
      [180,]   7.83064588  30.91460089
      [181,]   8.24876831  24.89305534
      [182,]   7.80673497  29.47652231
      [183,]  12.78571155  29.98925692
      [184,]  15.68120705  40.10301965
      [185,]  14.69586620  32.53056584
      [186,]  13.57116986  33.32990944
      [187,]  16.86043266  31.99880421
      [188,]  15.75264728  36.53935621
      [189,]  18.26381702  35.85703855
      [190,]  22.85646299  35.71032447
      [191,]  20.88639631  35.82405348
      [192,]  16.81866604  38.55758099
      [193,]  20.70920364  40.85666124
      [194,]  25.13115613  40.90848734
      [195,]  24.41187039  40.49689721
      [196,]  28.48020426  49.40462440
      [197,]  27.41322894  47.48837464
      [198,]  26.59253749  45.20515548
      [199,]  29.60773508  49.79842191
      [200,]  33.44772835  53.77736043
      [201,]  28.52995382  51.60876531
      [202,]  28.09211623  54.79095817
      [203,]  38.07570285  53.94357432
      [204,]  31.27144580  48.39966599
      [205,]  35.80447407  55.00399303
      [206,]  33.83279843  54.22286387
      [207,]  34.55454481  59.03255152
      [208,]  39.54775521  58.63777306
      [209,]  35.80095547  56.39915201
      [210,]  39.94232113  54.91729593
      [211,]  38.56504338  63.04447234
      [212,]  39.93504509  62.34619715
      [213,]  44.12015998  63.79762387
      [214,]  43.32535710  60.95464292
      [215,]  43.30919074  60.67124709
      [216,]  45.39696167  63.96270287
      [217,]  45.57256540  66.65248859
      [218,]  41.20722239  69.78512934
      [219,]  47.51449712  67.43788224
      [220,]  42.91473044  66.39526387
      [221,]  52.87885187  67.42945213
      [222,]  47.17842198  76.59229451
      [223,]  57.07066865  71.60357647
      [224,]  57.65825784  75.39847857
      [225,]  53.22163588  74.98907244
      [226,]  51.69586233  73.13964666
      [227,]  56.67082491  75.61175366
      [228,]  57.90868812  72.69688757
      [229,]  57.64110078  79.81618947
      [230,]  60.56924040  83.61824670
      [231,]  57.87359488  78.42053237
      [232,]  61.54932862  80.42368611
      [233,]  62.32203130  82.05641316
      [234,]  66.60634716  86.85795221
      [235,]  63.19796616  83.14405222
      [236,]  65.78798425  84.22841141
      [237,]  65.11921884  90.89393578
      [238,]  65.42776128  84.95722025
      [239,]  67.73786154  89.75678412
      [240,]  65.56922116  90.61672338
      [241,]  22.59201376  30.03908564
      [242,]  20.95308645  31.48365616
      [243,]  21.97837050  32.25684815
      [244,]  23.45911921  32.96218289
      [245,]  28.58085617  30.51106499
      [246,]  23.42860290  35.81119911
      [247,]  24.70798314  33.16468459
      [248,]  30.77018759  36.87211373
      [249,]  24.16085165  39.35616132
      [250,]  29.91559585  39.26748628
      [251,]  30.51046946  41.12696881
      [252,]  27.22701704  39.33291794
      [253,]  34.56935328  41.40911554
      [254,]  34.20124591  43.66692535
      [255,]  29.77015832  46.89633359
      [256,]  36.28950677  48.10521566
      [257,]  36.28503326  42.72106432
      [258,]  39.16196498  44.26340581
      [259,]  37.58949856  51.57305950
      [260,]  37.83064588  50.91460089
      [261,]  38.24876831  44.89305534
      [262,]  37.80673497  49.47652231
      [263,]  42.78571155  49.98925692
      [264,]  45.68120705  60.10301965
      [265,]  44.69586620  52.53056584
      [266,]  43.57116986  53.32990944
      [267,]  46.86043266  51.99880421
      [268,]  45.75264728  56.53935621
      [269,]  48.26381702  55.85703855
      [270,]  52.85646299  55.71032447
      [271,]  50.88639631  55.82405348
      [272,]  46.81866604  58.55758099
      [273,]  50.70920364  60.85666124
      [274,]  55.13115613  60.90848734
      [275,]  54.41187039  60.49689721
      [276,]  58.48020426  69.40462440
      [277,]  57.41322894  67.48837464
      [278,]  56.59253749  65.20515548
      [279,]  59.60773508  69.79842191
      [280,]  63.44772835  73.77736043
      [281,]  58.52995382  71.60876531
      [282,]  58.09211623  74.79095817
      [283,]  68.07570285  73.94357432
      [284,]  61.27144580  68.39966599
      [285,]  65.80447407  75.00399303
      [286,]  63.83279843  74.22286387
      [287,]  64.55454481  79.03255152
      [288,]  69.54775521  78.63777306
      [289,]  65.80095547  76.39915201
      [290,]  69.94232113  74.91729593
      [291,]  68.56504338  83.04447234
      [292,]  69.93504509  82.34619715
      [293,]  74.12015998  83.79762387
      [294,]  73.32535710  80.95464292
      [295,]  73.30919074  80.67124709
      [296,]  75.39696167  83.96270287
      [297,]  75.57256540  86.65248859
      [298,]  71.20722239  89.78512934
      [299,]  77.51449712  87.43788224
      [300,]  72.91473044  86.39526387
      [301,]  82.87885187  87.42945213
      [302,]  77.17842198  96.59229451
      [303,]  87.07066865  91.60357647
      [304,]  87.65825784  95.39847857
      [305,]  83.22163588  94.98907244
      [306,]  81.69586233  93.13964666
      [307,]  86.67082491  95.61175366
      [308,]  87.90868812  92.69688757
      [309,]  87.64110078  99.81618947
      [310,]  90.56924040 103.61824670
      [311,]  87.87359488  98.42053237
      [312,]  91.54932862 100.42368611
      [313,]  92.32203130 102.05641316
      [314,]  96.60634716 106.85795221
      [315,]  93.19796616 103.14405222
      [316,]  95.78798425 104.22841141
      [317,]  95.11921884 110.89393578
      [318,]  95.42776128 104.95722025
      [319,]  97.73786154 109.75678412
      [320,]  95.56922116 110.61672338
      [321,]  -9.67514002  11.73788083
      [322,]   9.06166344  -2.35548618
      [323,] -25.88792068  -3.74395197
      [324,]  25.82119392  -6.24908339
      [325,]  16.93524789   5.04823362
      [326,]   6.25941407  -1.07442780
      [327,]  -6.39509148  -1.26286332
      [328,]   4.05695459  -5.67225834
      [329,] -11.34420922  -7.49354217
      [330,]   1.43754969  -7.21137035
      [331,]   0.20732853 -16.86463646
      [332,]   2.26767652 -12.47505441
      [333,]  -1.11823447  -0.66677693
      [334,]   2.05549548  19.19351369
      [335,]  -4.94592751  17.17747825
      [336,] -20.63375328   3.44807735
      [337,]  -5.22017848   0.57883762
      [338,] -19.43019661   2.90233903
      [339,] -11.46390182  13.65608295
      [340,]   8.48219034   9.79043799
      [341,] -13.09883978   2.98372162
      [342,]   5.63880080   6.04415255
      [343,]  18.37894671  -8.28033884
      [344,]   1.19659601  15.50528652
      [345,]   1.43994231  -7.20877953
      [346,]  21.78575281   4.15155481
      [347,]   6.95886465   7.19309213
      [348,]  -0.37588272  -6.89856125
      [349,]  -2.93775574  -1.17204082
      [350,]  -8.71904123  -5.62916041
      [351,]  16.21164547  -8.26751739
      [352,]  10.65080553 -12.84227310
      [353,]  -9.41529483  -3.10078414
      [354,]  11.49203830  -8.14354973
      [355,]  -3.09004797  -7.72543595
      [356,]  -1.03534875  -3.44462522
      [357,]   3.28116447  -5.52296612
      [358,]  -4.69394847   2.63290980
      [359,]  -8.89402511  -4.94441644
      [360,]   9.95926896  -3.58159322
      [361,]   8.03713588   1.05897750
      [362,]   9.99099661  -1.41523983
      [363,]  11.83869523  14.25938805
      [364,]  22.17082758  -7.94861059
      [365,]  15.11065004  15.81000338
      [366,]  -9.29787746  -2.60832258
      [367,] -10.69143762  -4.50655213
      [368,] -13.51552435   5.09923414
      [369,]   5.41747317 -20.60825384
      [370,]  10.11740808  22.76513079
      [371,]  15.49216253   5.79486554
      [372,] -15.80965760   2.33380345
      [373,] -16.60617382  -3.52249941
      [374,] -10.88296819  17.15718966
      [375,]  -2.98889173   9.80376600
      [376,]  -1.26766203   2.83318194
      [377,] -17.53998081  -6.82424563
      [378,] -13.60952256 -11.43246523
      [379,]  17.19019570  16.76441620
      [380,]  14.93271449  -5.11488556
      [381,]  -4.84194469   4.87483354
      [382,] -10.13879801   3.60349309
      [383,]  -3.24122464  -5.89972352
      [384,] -27.36816803   2.10092431
      [385,]   4.65919654  -3.87850449
      [386,]  -2.54104587 -14.82230630
      [387,]   6.19268358  -2.32659909
      [388,]   4.61339462  11.38283313
      [389,]   0.47275051  -8.06638772
      [390,]   5.79949415  -0.89254212
      [391,]   0.49213360  -6.77037196
      [392,]   4.15307991  10.63459365
      [393,]  11.99100426   3.57711895
      [394,]  13.12213806  -3.57979495
      [395,]   9.10895959  16.60701782
      [396,]  13.59021124  -7.85062001
      [397,]  -8.27591418  -8.19620083
      [398,]  -8.37810035 -10.32041377
      [399,]  22.81103452  -4.05183379
      [400,]  -6.36374315  -3.44687829

# three_long_clust() works

    Code
      three_long_clust(n = 300, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]        [,2]          [,3]          [,4]
        [1,] -16.0467037 -25.5612581  0.0139380306  3.309084e-02
        [2,] -20.9264759 -15.3146164  0.0222554683  6.205570e-04
        [3,] -21.8761690 -17.4114219  0.0273821183  1.274938e-02
        [4,] -13.1455642 -17.7304273 -0.0307347960  2.556577e-02
        [5,] -14.8674970  -7.5977741  0.0249599343 -2.704463e-03
        [6,] -15.4624321 -18.3190362  0.0402429315 -1.715678e-02
        [7,] -18.5963783 -11.3169162 -0.0462197369  2.553369e-02
        [8,] -11.8279509 -10.5870916  0.0393223643 -1.342221e-02
        [9,] -13.3934029 -12.1782502 -0.0239902109 -2.135242e-02
       [10,]  -2.0622818  -9.5601395  0.0487629842 -4.435638e-02
       [11,]  -8.9137352 -13.0844604  0.0055707767 -3.480150e-02
       [12,]  -9.0653424  -6.3740457 -0.0371936114  7.342764e-03
       [13,]  -7.2385456 -11.6567474 -0.0436406263 -7.514273e-03
       [14,]  -7.2170600  -6.5814593 -0.0390775228  1.997895e-02
       [15,]  -7.5288610  -8.4860154 -0.0227467791  2.137183e-02
       [16,]  -3.8596656  -4.5122953  0.0276411119 -8.705977e-03
       [17,]  -4.9349100  -1.9681222 -0.0446881498  1.731751e-02
       [18,]  -1.9771878   0.1616871 -0.0016349768 -4.477979e-02
       [19,]  -0.7761219   1.0366824  0.0240139348  4.190433e-02
       [20,]   1.9404133   4.0568866 -0.0181266045  2.007988e-02
       [21,]   4.0125220  -0.1694892  0.0492232343 -3.115944e-02
       [22,]  -1.9910612  -2.3940364  0.0329920338 -2.308626e-02
       [23,]   1.5463198   0.6846337 -0.0064743672  3.330740e-02
       [24,]  -0.9829150   8.4204685 -0.0422361016  4.415502e-02
       [25,]   5.0429542   4.2088006  0.0344848166 -3.834558e-02
       [26,]   6.1167373   4.8901933 -0.0305266531  2.309174e-02
       [27,]   6.3311444   6.5255063 -0.0231167459 -8.338904e-03
       [28,]   7.4070889  10.4407412  0.0194286022  3.812055e-02
       [29,]   5.3644757   4.5013061  0.0001718890  3.733654e-05
       [30,]  12.7637388   7.9101129 -0.0340480692 -4.724280e-02
       [31,]   9.4129097   4.8495570  0.0237194850 -1.894036e-02
       [32,]   8.3135833  12.7682518 -0.0004342598  7.934875e-03
       [33,]  13.0878551  11.4358087  0.0482351774  2.471494e-02
       [34,]  15.0036939  16.1823120  0.0196492030 -9.015889e-03
       [35,]  14.8126897  12.3198517 -0.0194835741 -2.119069e-03
       [36,]  13.7261922  21.7839898  0.0159249835  2.862516e-02
       [37,]  15.3496554  20.9231865 -0.0245666893 -4.937218e-02
       [38,]  20.0009246  16.6966844  0.0478778662  1.189991e-03
       [39,]  19.6401678  20.8582021 -0.0021930194 -1.052345e-02
       [40,]  16.3699826  22.2503787 -0.0416788434  1.419472e-02
       [41,]  18.1074908  16.6723598  0.0231610519 -3.895420e-02
       [42,]  17.2502308  17.8112928  0.0262300945  1.607776e-02
       [43,]  27.7185437  20.1929271 -0.0370317762  3.519951e-02
       [44,]  26.8020245  23.2617120 -0.0346316919 -4.306235e-02
       [45,]  20.1990572  21.2610461  0.0410195358 -2.677924e-02
       [46,]  27.4218434  16.3570225  0.0166052091  3.370115e-02
       [47,]  25.4668159  25.5563893 -0.0305520805 -7.628256e-03
       [48,]  30.2956153  24.7494996 -0.0245675498  1.474725e-03
       [49,]  28.9897966  26.5917958 -0.0345455090  2.119039e-02
       [50,]  31.1175979  34.7087324 -0.0003508595  1.268381e-02
       [51,]  37.5562777  26.2056359 -0.0034057023  1.346007e-02
       [52,]  31.7245601  35.2633830 -0.0011862537 -1.548746e-02
       [53,]  35.2631715  22.2346172 -0.0109603464 -2.307818e-02
       [54,]  31.1825996  33.1176209  0.0212193804  4.217972e-02
       [55,]  37.4481140  31.6392024 -0.0217553976  4.829483e-02
       [56,]  34.0648268  31.8461061 -0.0191707506  2.072083e-02
       [57,]  36.5271759  35.6081368  0.0442334460  3.700059e-02
       [58,]  32.6778916  36.3437630 -0.0219509164 -2.682958e-02
       [59,]  34.9975620  36.0170240 -0.0495311228  5.010260e-03
       [60,]  38.6705674  40.8144074  0.0113840646  2.138814e-02
       [61,]  40.6935358  41.2197965  0.0155089854  3.384213e-02
       [62,]  42.6203033  42.6443931 -0.0401021889 -2.381642e-02
       [63,]  42.5615878  44.9614578  0.0163494704 -3.741723e-02
       [64,]  41.9233390  47.8598461 -0.0425397867 -2.485847e-02
       [65,]  40.2239143  42.7546528  0.0480898142 -1.459736e-03
       [66,]  46.5051007  46.3976404  0.0308108424 -4.685443e-03
       [67,]  50.7102312  46.2819877 -0.0071905138 -4.021027e-02
       [68,]  48.7086295  47.4813781  0.0412790195  4.312391e-02
       [69,]  50.4241580  43.4932764 -0.0240459894  1.495112e-02
       [70,]  50.9803185  52.2398746 -0.0193376644 -1.122955e-02
       [71,]  48.5093001  41.9426477  0.0423996357  4.721409e-02
       [72,]  49.9554795  49.7815296 -0.0184977262 -4.704446e-02
       [73,]  54.4878673  56.1642905 -0.0198984539  6.842718e-03
       [74,]  53.8720433  51.8971797 -0.0116929745  1.286648e-02
       [75,]  57.5104327  53.6190597  0.0232275496 -3.359787e-02
       [76,]  51.1921070  55.0542044 -0.0192702085 -4.484048e-02
       [77,]  56.8210769  52.9739997 -0.0320126913 -4.241089e-02
       [78,]  57.2410156  56.8672158 -0.0081955564 -3.371412e-02
       [79,]  61.9526535  56.8142231 -0.0313546496 -1.659019e-02
       [80,]  60.3940895  58.9470660  0.0244275016 -2.000044e-02
       [81,]  62.4142716  62.6013239 -0.0151788390  1.690339e-02
       [82,]  56.7711580  64.0401924 -0.0351408962 -9.961860e-03
       [83,]  62.2475320  62.1810693  0.0215082376 -2.888342e-02
       [84,]  63.9844920  58.5808469  0.0027284850 -2.930204e-02
       [85,]  64.4268197  58.3900471  0.0387120224 -4.338725e-02
       [86,]  62.5426556  61.6898350  0.0227838194  1.025363e-03
       [87,]  64.2801960  63.5998535  0.0251240733  6.947431e-03
       [88,]  65.9413552  62.4099121 -0.0464932609 -3.107307e-02
       [89,]  73.8527399  65.5662156  0.0199507820 -2.983059e-02
       [90,]  73.9734242  67.4712454 -0.0256514851 -3.587464e-03
       [91,]  67.4628620  69.2616856 -0.0405866878  3.662836e-02
       [92,]  68.3226550  74.3294575  0.0028731658 -2.557130e-02
       [93,]  75.0126541  71.5936274  0.0444275602 -4.820601e-02
       [94,]  71.7331553  73.4603250 -0.0491111540 -4.970583e-02
       [95,]  71.3355200  75.4683324 -0.0416546314  1.212139e-02
       [96,]  73.4443100  70.7973729 -0.0341986140  3.294325e-02
       [97,]  75.1585787  76.8359327 -0.0086308938  1.258265e-02
       [98,]  73.5046204  74.4188297  0.0107749348 -1.569915e-04
       [99,]  76.4011764  77.6934416  0.0150154262 -1.541384e-02
      [100,]  82.8157596  81.9497914  0.0324984893  3.356151e-02
      [101,]  21.1227422 -20.9294867 -0.0357600727 -6.868312e-03
      [102,]  18.8716424 -22.3686532 -0.0185067930  2.614086e-02
      [103,]  13.9059678 -23.0633409  0.0271053146  2.321119e-02
      [104,]  24.8212683 -13.5806975  0.0223568213 -4.151565e-02
      [105,]  20.7779629 -12.8840504  0.0360059179  6.862480e-03
      [106,]  24.1699965 -20.8183735 -0.0107024108  3.822739e-02
      [107,]  23.3778939  -8.8966304  0.0181858625  2.681517e-02
      [108,]  24.6640788 -14.1712181  0.0281567011 -3.516757e-02
      [109,]  27.6510249 -12.1572738 -0.0038288075  4.175256e-03
      [110,]  30.0442810 -10.1986659 -0.0409427823 -4.622971e-02
      [111,]  30.5304061 -11.5319234  0.0325093341  3.193288e-02
      [112,]  32.0369899  -9.8457284 -0.0205325620 -1.676492e-02
      [113,]  31.9014693  -9.2528761 -0.0355930796  3.526906e-02
      [114,]  35.5289863  -4.7386588  0.0487806467  3.087604e-02
      [115,]  32.0281749  -8.9420475  0.0448191922  1.070080e-02
      [116,]  40.6639759  -3.4122532 -0.0439755222  3.229748e-02
      [117,]  38.9468167  -2.5208909  0.0361030853  4.542123e-02
      [118,]  38.4310301  -6.7686992 -0.0213141399  1.655894e-02
      [119,]  34.0445565  -1.0957223  0.0036367978  1.747713e-03
      [120,]  39.3357599  -5.1368689  0.0340218931 -3.294439e-02
      [121,]  40.4986537  -3.2813741  0.0304943694  4.563259e-02
      [122,]  36.4259868  -0.3820704 -0.0085205035  3.535140e-03
      [123,]  45.0148875   0.7735584  0.0367266138  1.578933e-02
      [124,]  42.4376003   5.4292061  0.0264216963  4.282951e-02
      [125,]  39.6239518   4.6105650  0.0091447428 -4.877184e-02
      [126,]  40.1864880   2.8783288 -0.0059495745 -1.200973e-02
      [127,]  45.0505191   1.0036258  0.0281619394  2.913777e-02
      [128,]  47.2288892  10.6068802 -0.0017269597 -1.224266e-02
      [129,]  47.2902470   9.7779811  0.0256983434  1.746640e-02
      [130,]  48.4605164   9.9630759  0.0496705881 -1.495863e-02
      [131,]  50.2583349   8.1038191 -0.0051352489  3.182903e-02
      [132,]  49.3059955  11.0928427  0.0273578355  1.085481e-04
      [133,]  49.1916225  12.4521021  0.0115915452  3.300351e-02
      [134,]  53.6833751  18.2916361 -0.0264064001 -3.553239e-02
      [135,]  53.4663906  17.5941203 -0.0198529340  2.355607e-03
      [136,]  57.0863156  10.3540628  0.0002438598 -2.481383e-02
      [137,]  58.1132490  17.4339721  0.0053096824  4.444729e-02
      [138,]  52.3871104  18.5648457  0.0362229523  3.384768e-02
      [139,]  58.3352683  13.7312096  0.0193852589  3.985037e-02
      [140,]  64.4622573  17.3251035 -0.0093251564  2.217006e-02
      [141,]  57.8803094  21.5051598  0.0248719533  2.400772e-02
      [142,]  65.8745204  16.8013214 -0.0473052719  3.606880e-03
      [143,]  61.0724348  26.7770151 -0.0238977435 -3.080228e-02
      [144,]  65.9461483  21.2733067  0.0264777167 -2.536742e-02
      [145,]  63.1839135  19.9917226  0.0189059034 -1.347111e-02
      [146,]  70.3441853  20.3578872  0.0349754151 -4.044331e-02
      [147,]  67.5987940  21.7423731 -0.0457185472 -5.961939e-03
      [148,]  68.7169472  22.5802521 -0.0108053458  4.369684e-02
      [149,]  68.3890842  30.0340101  0.0427678243  3.528876e-02
      [150,]  64.4069261  28.8127041 -0.0155390420 -3.967089e-02
      [151,]  69.2556673  27.5522929  0.0102627469 -1.281080e-02
      [152,]  68.1644160  28.4227011  0.0254389687 -6.340092e-03
      [153,]  74.5999382  28.5498483  0.0178099468 -2.135797e-02
      [154,]  74.4361362  35.7519571  0.0105336501  1.863120e-02
      [155,]  73.0217485  36.1930467  0.0296980240  2.447875e-02
      [156,]  75.7294938  38.7832051  0.0131823413 -3.734830e-02
      [157,]  80.1776912  33.1851105  0.0221103435  4.338618e-03
      [158,]  75.5286207  41.4805520  0.0194955980  4.281553e-02
      [159,]  77.4031617  36.2360345 -0.0343102385 -5.244724e-04
      [160,]  76.6045570  34.0746628  0.0354791025  1.928101e-02
      [161,]  77.6952372  40.6098573  0.0455530925 -3.568117e-02
      [162,]  80.6092074  42.8927501 -0.0444633594 -2.225809e-02
      [163,]  80.4028964  36.6397824  0.0278191108  3.982380e-02
      [164,]  83.2151198  43.3212244  0.0100205618  4.170410e-02
      [165,]  85.2690275  39.4447551 -0.0207915091  3.715181e-02
      [166,]  83.3985470  47.3851627 -0.0194021311 -4.220070e-02
      [167,]  84.6695505  41.9320165  0.0420285729  2.518827e-03
      [168,]  89.6664172  50.9058909 -0.0143736571 -3.659039e-02
      [169,]  90.1179658  46.5005071 -0.0471166582  3.716604e-02
      [170,]  86.2813128  48.4780254 -0.0011105877 -3.218129e-02
      [171,]  88.9000801  46.9081269 -0.0323901738  2.750799e-02
      [172,]  85.3368879  49.8631133 -0.0133922930 -1.701060e-02
      [173,]  95.3255159  54.6501819 -0.0464529631  3.058774e-02
      [174,]  93.5931793  53.9892781 -0.0119273066  2.541549e-02
      [175,]  91.0941384  50.6583837 -0.0211618534 -2.644579e-02
      [176,]  95.1106552  51.5108012 -0.0163164396  3.796711e-03
      [177,]  92.8647678  55.1894893 -0.0154660322 -2.241050e-02
      [178,]  99.1790424  56.6677338  0.0006941579 -3.275914e-02
      [179,]  94.7654403  57.4982298 -0.0265995397 -1.030154e-02
      [180,]  92.2722114  66.8506194  0.0164671519 -2.848918e-02
      [181,] 100.3691726  59.2530520 -0.0433949099  4.808778e-02
      [182,] 100.3385727  64.8488876  0.0214593931  3.091673e-02
      [183,] 103.5902814  61.5705600 -0.0059777297 -2.779407e-02
      [184,] 100.4446074  63.6111478  0.0331852962 -1.607059e-02
      [185,] 108.4053038  64.3596720  0.0124993692  4.445126e-04
      [186,] 104.4963642  61.7101257 -0.0065300648  5.350461e-03
      [187,] 103.4919137  64.1717214  0.0411417381 -3.148262e-02
      [188,] 107.8754590  70.2337765  0.0247844953 -1.685814e-02
      [189,] 111.1043592  68.4373486 -0.0435268620  1.210662e-03
      [190,] 109.8438730  68.2281448  0.0458923144  4.850406e-02
      [191,] 109.8705405  70.8790928 -0.0046170085  3.640567e-02
      [192,] 111.7190571  71.6265022 -0.0450764619 -4.455620e-02
      [193,] 115.3952068  67.7999658 -0.0059401513 -6.219088e-03
      [194,] 111.9375191  72.5752580  0.0081883668 -4.095101e-03
      [195,] 112.9301514  72.8701575  0.0304601316 -6.514969e-03
      [196,] 113.9749847  74.8307040  0.0020829631  3.607097e-02
      [197,] 115.0910873  77.8821985  0.0304781620 -3.611904e-02
      [198,] 116.7131579  78.4439615 -0.0425765788  4.177381e-02
      [199,] 118.2743235  81.0791120  0.0114159942 -3.687107e-02
      [200,] 116.8948203  81.9741286  0.0233740703 -3.089587e-02
      [201,]  -6.0467037   4.4387419 -0.0339096562 -4.841946e-02
      [202,] -10.9264759  14.6853836  0.0414377427 -3.479588e-02
      [203,] -11.8761690  12.5885781  0.0374152880 -7.765238e-03
      [204,]  -3.1455642  12.2695727 -0.0403944338  8.493012e-03
      [205,]  -4.8674970  22.4022259 -0.0284535438 -4.367337e-02
      [206,]  -5.4624321  11.6809638 -0.0143401542  1.733485e-02
      [207,]  -8.5963783  18.6830838 -0.0150897518 -2.077300e-02
      [208,]  -1.8279509  19.4129084  0.0294666313 -1.581126e-03
      [209,]  -3.3934029  17.8217498  0.0268727275  2.578530e-02
      [210,]   7.9377182  20.4398605 -0.0245010051 -4.158560e-02
      [211,]   1.0862648  16.9155396 -0.0323609477  3.239401e-02
      [212,]   0.9346576  23.6259543  0.0283407058 -3.571340e-03
      [213,]   2.7614544  18.3432526 -0.0101760890  2.804938e-02
      [214,]   2.7829400  23.4185407  0.0049510104 -1.635639e-02
      [215,]   2.4711390  21.5139846  0.0093291366  1.459011e-02
      [216,]   6.1403344  25.4877047 -0.0092357021 -1.896442e-02
      [217,]   5.0650900  28.0318778 -0.0142444834  8.057138e-03
      [218,]   8.0228122  30.1616871 -0.0276593626  4.193794e-02
      [219,]   9.2238781  31.0366824  0.0235752249  9.387194e-03
      [220,]  11.9404133  34.0568866  0.0009247106  7.353027e-03
      [221,]  14.0125220  29.8305108 -0.0222653301  4.049259e-02
      [222,]   8.0089388  27.6059636 -0.0108763634  1.485700e-02
      [223,]  11.5463198  30.6846337  0.0049058254 -2.303922e-02
      [224,]   9.0170850  38.4204685  0.0245505164 -1.958080e-02
      [225,]  15.0429542  34.2088006  0.0016452796  2.439304e-02
      [226,]  16.1167373  34.8901933  0.0233802950 -1.207646e-02
      [227,]  16.3311444  36.5255063  0.0460393964  1.496986e-02
      [228,]  17.4070889  40.4407412 -0.0332867402  2.234558e-03
      [229,]  15.3644757  34.5013061 -0.0406457410 -2.836664e-02
      [230,]  22.7637388  37.9101129  0.0129818394 -4.881061e-02
      [231,]  19.4129097  34.8495570  0.0013812454  4.935234e-02
      [232,]  18.3135833  42.7682518  0.0099141791  1.414081e-02
      [233,]  23.0878551  41.4358087  0.0025305262  7.169498e-03
      [234,]  25.0036939  46.1823120  0.0272961495 -3.040587e-02
      [235,]  24.8126897  42.3198517 -0.0497736051 -3.201353e-02
      [236,]  23.7261922  51.7839898  0.0373848314 -4.102860e-02
      [237,]  25.3496554  50.9231865  0.0178189527  4.011197e-02
      [238,]  30.0009246  46.6966844 -0.0290966723  3.823476e-03
      [239,]  29.6401678  50.8582021 -0.0376571369 -1.490164e-02
      [240,]  26.3699826  52.2503787  0.0122225274 -4.937804e-02
      [241,]  28.1074908  46.6723598  0.0207520892  2.975896e-02
      [242,]  27.2502308  47.8112928 -0.0489874637 -4.884075e-02
      [243,]  37.7185437  50.1929271  0.0319272961 -1.858960e-02
      [244,]  36.8020245  53.2617120 -0.0234734462  8.801401e-03
      [245,]  30.1990572  51.2610461 -0.0392798880  1.339276e-03
      [246,]  37.4218434  46.3570225 -0.0412171215  1.764744e-02
      [247,]  35.4668159  55.5563893  0.0392849744  2.702126e-03
      [248,]  40.2956153  54.7494996 -0.0370253569 -4.090619e-02
      [249,]  38.9897966  56.5917958 -0.0145395615 -6.385344e-03
      [250,]  41.1175979  64.7087324 -0.0151166953 -3.685905e-02
      [251,]  47.5562777  56.2056359  0.0208508563  3.503112e-02
      [252,]  41.7245601  65.2633830 -0.0263127579 -8.227978e-03
      [253,]  45.2631715  52.2346172 -0.0392443858  4.318322e-02
      [254,]  41.1825996  63.1176209 -0.0396260771 -4.268886e-02
      [255,]  47.4481140  61.6392024 -0.0360179453  3.545460e-02
      [256,]  44.0648268  61.8461061  0.0213240878 -2.309860e-02
      [257,]  46.5271759  65.6081368  0.0479957431 -3.377105e-02
      [258,]  42.6778916  66.3437630  0.0395506542 -3.713369e-02
      [259,]  44.9975620  66.0170240  0.0335367842 -2.504078e-02
      [260,]  48.6705674  70.8144074 -0.0037490580 -2.202144e-02
      [261,]  50.6935358  71.2197965 -0.0256192339  2.576198e-02
      [262,]  52.6203033  72.6443931  0.0432805400  4.108143e-02
      [263,]  52.5615878  74.9614578  0.0265724259  4.886903e-02
      [264,]  51.9233390  77.8598461  0.0024829366 -2.070392e-02
      [265,]  50.2239143  72.7546528 -0.0206748786  2.479276e-02
      [266,]  56.5051007  76.3976404  0.0290983000  3.753685e-02
      [267,]  60.7102312  76.2819877 -0.0052619396 -4.474088e-02
      [268,]  58.7086295  77.4813781 -0.0012253103 -4.821559e-02
      [269,]  60.4241580  73.4932764  0.0257397868 -3.799170e-02
      [270,]  60.9803185  82.2398746  0.0492021148 -2.464728e-02
      [271,]  58.5093001  71.9426477 -0.0038281123 -8.387998e-03
      [272,]  59.9554795  79.7815296  0.0484013313 -2.661362e-02
      [273,]  64.4878673  86.1642905 -0.0162242120  1.794084e-02
      [274,]  63.8720433  81.8971797 -0.0470545943  3.887252e-02
      [275,]  67.5104327  83.6190597  0.0055834409 -4.374773e-02
      [276,]  61.1921070  85.0542044  0.0185618917 -2.679644e-02
      [277,]  66.8210769  82.9739997  0.0393190964 -3.733186e-02
      [278,]  67.2410156  86.8672158  0.0213096378  1.296832e-02
      [279,]  71.9526535  86.8142231 -0.0234274061 -3.788711e-02
      [280,]  70.3940895  88.9470660 -0.0293364196  1.547613e-02
      [281,]  72.4142716  92.6013239  0.0267114585  4.698165e-02
      [282,]  66.7711580  94.0401924  0.0028744341  3.856291e-02
      [283,]  72.2475320  92.1810693  0.0433571625 -8.757659e-03
      [284,]  73.9844920  88.5808469 -0.0356078255 -2.861032e-02
      [285,]  74.4268197  88.3900471  0.0475948478  2.840946e-02
      [286,]  72.5426556  91.6898350  0.0241484647  5.369577e-03
      [287,]  74.2801960  93.5998535  0.0375258525 -3.227090e-02
      [288,]  75.9413552  92.4099121  0.0468080780 -3.542723e-02
      [289,]  83.8527399  95.5662156 -0.0377881441 -3.539199e-03
      [290,]  83.9734242  97.4712454 -0.0490372739 -1.398847e-02
      [291,]  77.4628620  99.2616856 -0.0016966163 -3.608108e-02
      [292,]  78.3226550 104.3294575 -0.0175773777  4.937051e-03
      [293,]  85.0126541 101.5936274  0.0105857869  4.895686e-02
      [294,]  81.7331553 103.4603250 -0.0377988065 -3.697397e-02
      [295,]  81.3355200 105.4683324 -0.0091741279  2.681811e-02
      [296,]  83.4443100 100.7973729  0.0452865537  3.807928e-02
      [297,]  85.1585787 106.8359327  0.0262750590 -7.696998e-03
      [298,]  83.5046204 104.4188297 -0.0248023016 -2.305322e-02
      [299,]  86.4011764 107.6934416 -0.0186367779 -4.300337e-02
      [300,]  92.8157596 111.9497914 -0.0442824661  4.845613e-02

---

    Code
      three_long_clust(n = 300, num_noise = 0)
    Output
                     [,1]        [,2]
        [1,] -20.81524680 -16.7599828
        [2,] -15.90994897 -19.0586419
        [3,] -21.57816080 -18.0270369
        [4,] -10.69722800 -16.4261010
        [5,] -12.91944022 -10.2739298
        [6,] -13.52970162 -16.9642464
        [7,]  -9.56245229 -15.6150211
        [8,] -11.14907869  -8.2872655
        [9,] -10.28690177 -16.7989354
       [10,] -10.46822779  -9.8555052
       [11,] -11.64421719  -9.3619132
       [12,] -10.40560630 -13.7162287
       [13,]  -9.98095746  -4.7883084
       [14,]  -1.90409219  -5.4984426
       [15,]  -9.92553449 -11.2873021
       [16,]  -7.07806941  -3.3881165
       [17,]  -9.08804725  -3.6437084
       [18,]  -4.18644313  -0.2975438
       [19,]  -1.88946377  -2.5131268
       [20,]   0.12886552  -2.4616926
       [21,]  -1.03788187  -2.1890396
       [22,]   5.32767320  -2.9915813
       [23,]  -3.94581258   2.9821394
       [24,]   7.34173366   6.3515088
       [25,]   5.84257961   4.8698328
       [26,]   4.38537328   3.2139623
       [27,]   7.21214384   7.0755408
       [28,]   4.47895086   5.4408091
       [29,]   2.21812821   8.3297713
       [30,]   4.92119887  13.8205787
       [31,]  11.72301917  11.1079954
       [32,]  13.80519788   5.7733325
       [33,]   8.97552361  10.3865045
       [34,]  14.59999635  15.6639452
       [35,]  16.13519624  14.5148380
       [36,]  13.83554671  19.3502553
       [37,]  17.66709811  17.7665362
       [38,]  15.90037585  16.4906719
       [39,]  12.80170512  20.0096688
       [40,]  18.12535158  24.5596604
       [41,]  19.81818035  18.1624423
       [42,]  18.75747104  17.3651453
       [43,]  19.37373932  29.5946286
       [44,]  24.62477459  20.8393073
       [45,]  30.03681226  26.2555926
       [46,]  27.57722348  23.5409980
       [47,]  29.71262107  24.1931810
       [48,]  28.71988642  30.1846940
       [49,]  31.33520771  25.2511943
       [50,]  30.26263472  30.1779014
       [51,]  33.81543213  28.2063042
       [52,]  31.88286414  29.6688064
       [53,]  33.91493739  34.6502000
       [54,]  32.67113002  33.4066964
       [55,]  36.02236927  33.1364884
       [56,]  35.83096212  35.4962021
       [57,]  28.79278474  35.4657067
       [58,]  35.64497432  29.7590280
       [59,]  42.36164811  37.3931214
       [60,]  40.93225738  31.3934131
       [61,]  34.79847208  43.5985648
       [62,]  38.53804241  36.2230275
       [63,]  37.99366932  48.3383358
       [64,]  39.90633323  48.8228223
       [65,]  47.24847001  43.0270449
       [66,]  48.13083442  40.8698279
       [67,]  45.94177234  46.8385311
       [68,]  44.76710839  48.1358601
       [69,]  45.62971067  47.5513760
       [70,]  43.71480315  50.9615505
       [71,]  50.95860560  47.3419936
       [72,]  52.31470855  51.6866608
       [73,]  54.83116777  52.4025391
       [74,]  53.74434488  57.5079339
       [75,]  53.05804646  52.9974577
       [76,]  52.31273508  55.9849803
       [77,]  57.98124858  54.8990235
       [78,]  54.00276970  55.0347016
       [79,]  62.42633011  57.6723269
       [80,]  59.30550523  54.7115265
       [81,]  62.34450881  60.0488571
       [82,]  59.47856075  61.6045702
       [83,]  68.76367034  62.3210602
       [84,]  62.17122767  62.9527286
       [85,]  62.67680201  59.6388312
       [86,]  64.09774284  66.0139989
       [87,]  64.71587213  62.4558557
       [88,]  66.68217975  66.8401422
       [89,]  70.51383502  69.6952017
       [90,]  69.24621674  69.3343579
       [91,]  71.24160822  71.4087110
       [92,]  71.34134796  68.9161474
       [93,]  72.14238061  71.2613944
       [94,]  74.43142688  73.8336567
       [95,]  72.34996780  77.6204170
       [96,]  76.99748822  78.8815196
       [97,]  77.07499544  71.9013304
       [98,]  74.49138788  73.5792573
       [99,]  83.54757527  82.4663244
      [100,]  76.57958234  81.3932511
      [101,]  13.61631918 -25.0767146
      [102,]  19.09565289 -17.5746272
      [103,]  19.48657115 -22.2071591
      [104,]  31.87877456 -12.4641140
      [105,]  22.16320731 -14.2205776
      [106,]  22.91238680 -16.4537937
      [107,]  20.99850526 -16.3833670
      [108,]  26.42419526  -7.2390373
      [109,]  25.32129819 -12.9085187
      [110,]  24.88790559 -11.0870274
      [111,]  24.78006686 -10.8416017
      [112,]  27.94697624 -11.1134139
      [113,]  30.57082655 -11.2494271
      [114,]  30.38560917  -7.7406040
      [115,]  29.62112151 -12.7970459
      [116,]  40.50578050  -4.3478161
      [117,]  37.86046830  -1.4172082
      [118,]  34.75644435  -3.8527083
      [119,]  40.24802739  -0.6164660
      [120,]  44.97170054  -3.1481871
      [121,]  42.01095664   2.3798700
      [122,]  45.73869771   3.4956825
      [123,]  44.42946789  -3.4337404
      [124,]  37.24958249   5.3486196
      [125,]  45.25499129   5.0265441
      [126,]  44.02857983   5.7875864
      [127,]  49.79068940   8.7377184
      [128,]  49.04721632  10.9111895
      [129,]  45.99894001  12.3015556
      [130,]  43.89661991  12.6984255
      [131,]  53.80559042   9.1380671
      [132,]  52.68274644   7.4571285
      [133,]  54.24702983  11.0629204
      [134,]  50.44330365  10.6959173
      [135,]  49.83905886  14.3845958
      [136,]  53.70337859  13.3596828
      [137,]  56.81561073  15.3132698
      [138,]  60.48141168  18.8554542
      [139,]  57.29735280  17.2157295
      [140,]  55.74407984  19.3000049
      [141,]  56.78681516  20.4091698
      [142,]  67.99036813  23.0286579
      [143,]  61.50447059  18.7792790
      [144,]  65.99809821  24.3016117
      [145,]  65.23634055  24.2681585
      [146,]  62.67455832  26.6920089
      [147,]  65.51469207  18.8743035
      [148,]  61.62110946  24.2118846
      [149,]  70.27023683  33.6459492
      [150,]  74.77280838  30.8302168
      [151,]  68.02566547  26.3895927
      [152,]  70.27960764  31.5758661
      [153,]  72.07051645  29.1268936
      [154,]  77.82244027  29.2402044
      [155,]  72.93006528  33.2005578
      [156,]  74.03551426  40.8311061
      [157,]  82.11741972  33.5283622
      [158,]  74.44652531  39.8823293
      [159,]  80.19598015  33.2497001
      [160,]  81.02090423  41.4496083
      [161,]  86.35986230  35.8265616
      [162,]  82.68670867  37.6988900
      [163,]  85.68393454  42.7486832
      [164,]  80.56531610  41.5712801
      [165,]  81.59525282  46.5087853
      [166,]  88.12184039  47.7360245
      [167,]  86.80642012  49.4730906
      [168,]  87.41054292  43.5372454
      [169,]  89.79657707  43.1417723
      [170,]  92.44846429  51.3036130
      [171,]  85.64103124  47.6485613
      [172,]  90.21603687  52.8892664
      [173,]  88.72581386  45.9727281
      [174,]  92.87534476  54.3000930
      [175,]  91.05200325  56.3985862
      [176,]  90.39243501  53.5134085
      [177,]  94.80876267  49.9035834
      [178,] 103.17065732  59.0487770
      [179,]  95.67490054  54.0590634
      [180,] 101.65182958  61.6439060
      [181,]  97.24606184  60.2403893
      [182,]  98.55319221  64.1275953
      [183,] 104.19470265  60.8738262
      [184,] 104.05762167  66.3824659
      [185,]  98.98337590  61.2227990
      [186,] 101.40308308  61.8008218
      [187,] 105.26419441  65.7406601
      [188,] 104.33359566  68.4432663
      [189,] 109.85561476  68.2967381
      [190,] 105.40691519  68.6546948
      [191,] 112.23455904  70.5426073
      [192,] 107.30332510  72.9634223
      [193,] 115.45300258  69.4260795
      [194,] 114.63109191  69.0582602
      [195,] 111.37783458  77.3479751
      [196,] 111.63196288  76.2295241
      [197,] 113.66350928  75.3416619
      [198,] 118.43819264  80.1269371
      [199,] 119.83548168  76.8573198
      [200,] 117.18767345  81.5206893
      [201,] -10.81524680  13.2400172
      [202,]  -5.90994897  10.9413581
      [203,] -11.57816080  11.9729631
      [204,]  -0.69722800  13.5738990
      [205,]  -2.91944022  19.7260702
      [206,]  -3.52970162  13.0357536
      [207,]   0.43754771  14.3849789
      [208,]  -1.14907869  21.7127345
      [209,]  -0.28690177  13.2010646
      [210,]  -0.46822779  20.1444948
      [211,]  -1.64421719  20.6380868
      [212,]  -0.40560630  16.2837713
      [213,]   0.01904254  25.2116916
      [214,]   8.09590781  24.5015574
      [215,]   0.07446551  18.7126979
      [216,]   2.92193059  26.6118835
      [217,]   0.91195275  26.3562916
      [218,]   5.81355687  29.7024562
      [219,]   8.11053623  27.4868732
      [220,]  10.12886552  27.5383074
      [221,]   8.96211813  27.8109604
      [222,]  15.32767320  27.0084187
      [223,]   6.05418742  32.9821394
      [224,]  17.34173366  36.3515088
      [225,]  15.84257961  34.8698328
      [226,]  14.38537328  33.2139623
      [227,]  17.21214384  37.0755408
      [228,]  14.47895086  35.4408091
      [229,]  12.21812821  38.3297713
      [230,]  14.92119887  43.8205787
      [231,]  21.72301917  41.1079954
      [232,]  23.80519788  35.7733325
      [233,]  18.97552361  40.3865045
      [234,]  24.59999635  45.6639452
      [235,]  26.13519624  44.5148380
      [236,]  23.83554671  49.3502553
      [237,]  27.66709811  47.7665362
      [238,]  25.90037585  46.4906719
      [239,]  22.80170512  50.0096688
      [240,]  28.12535158  54.5596604
      [241,]  29.81818035  48.1624423
      [242,]  28.75747104  47.3651453
      [243,]  29.37373932  59.5946286
      [244,]  34.62477459  50.8393073
      [245,]  40.03681226  56.2555926
      [246,]  37.57722348  53.5409980
      [247,]  39.71262107  54.1931810
      [248,]  38.71988642  60.1846940
      [249,]  41.33520771  55.2511943
      [250,]  40.26263472  60.1779014
      [251,]  43.81543213  58.2063042
      [252,]  41.88286414  59.6688064
      [253,]  43.91493739  64.6502000
      [254,]  42.67113002  63.4066964
      [255,]  46.02236927  63.1364884
      [256,]  45.83096212  65.4962021
      [257,]  38.79278474  65.4657067
      [258,]  45.64497432  59.7590280
      [259,]  52.36164811  67.3931214
      [260,]  50.93225738  61.3934131
      [261,]  44.79847208  73.5985648
      [262,]  48.53804241  66.2230275
      [263,]  47.99366932  78.3383358
      [264,]  49.90633323  78.8228223
      [265,]  57.24847001  73.0270449
      [266,]  58.13083442  70.8698279
      [267,]  55.94177234  76.8385311
      [268,]  54.76710839  78.1358601
      [269,]  55.62971067  77.5513760
      [270,]  53.71480315  80.9615505
      [271,]  60.95860560  77.3419936
      [272,]  62.31470855  81.6866608
      [273,]  64.83116777  82.4025391
      [274,]  63.74434488  87.5079339
      [275,]  63.05804646  82.9974577
      [276,]  62.31273508  85.9849803
      [277,]  67.98124858  84.8990235
      [278,]  64.00276970  85.0347016
      [279,]  72.42633011  87.6723269
      [280,]  69.30550523  84.7115265
      [281,]  72.34450881  90.0488571
      [282,]  69.47856075  91.6045702
      [283,]  78.76367034  92.3210602
      [284,]  72.17122767  92.9527286
      [285,]  72.67680201  89.6388312
      [286,]  74.09774284  96.0139989
      [287,]  74.71587213  92.4558557
      [288,]  76.68217975  96.8401422
      [289,]  80.51383502  99.6952017
      [290,]  79.24621674  99.3343579
      [291,]  81.24160822 101.4087110
      [292,]  81.34134796  98.9161474
      [293,]  82.14238061 101.2613944
      [294,]  84.43142688 103.8336567
      [295,]  82.34996780 107.6204170
      [296,]  86.99748822 108.8815196
      [297,]  87.07499544 101.9013304
      [298,]  84.49138788 103.5792573
      [299,]  93.54757527 112.4663244
      [300,]  86.57958234 111.3932511

# two_long_clust_diff() works

    Code
      two_long_clust_diff(n = 300, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]        [,2]          [,3]          [,4]
        [1,] -16.0467037 -25.5612581  0.0139380306  3.309084e-02
        [2,] -20.9264759 -15.3146164  0.0222554683  6.205570e-04
        [3,] -21.8761690 -17.4114219  0.0273821183  1.274938e-02
        [4,] -13.1455642 -17.7304273 -0.0307347960  2.556577e-02
        [5,] -14.8674970  -7.5977741  0.0249599343 -2.704463e-03
        [6,] -15.4624321 -18.3190362  0.0402429315 -1.715678e-02
        [7,] -18.5963783 -11.3169162 -0.0462197369  2.553369e-02
        [8,] -11.8279509 -10.5870916  0.0393223643 -1.342221e-02
        [9,] -13.3934029 -12.1782502 -0.0239902109 -2.135242e-02
       [10,]  -2.0622818  -9.5601395  0.0487629842 -4.435638e-02
       [11,]  -8.9137352 -13.0844604  0.0055707767 -3.480150e-02
       [12,]  -9.0653424  -6.3740457 -0.0371936114  7.342764e-03
       [13,]  -7.2385456 -11.6567474 -0.0436406263 -7.514273e-03
       [14,]  -7.2170600  -6.5814593 -0.0390775228  1.997895e-02
       [15,]  -7.5288610  -8.4860154 -0.0227467791  2.137183e-02
       [16,]  -3.8596656  -4.5122953  0.0276411119 -8.705977e-03
       [17,]  -4.9349100  -1.9681222 -0.0446881498  1.731751e-02
       [18,]  -1.9771878   0.1616871 -0.0016349768 -4.477979e-02
       [19,]  -0.7761219   1.0366824  0.0240139348  4.190433e-02
       [20,]   1.9404133   4.0568866 -0.0181266045  2.007988e-02
       [21,]   4.0125220  -0.1694892  0.0492232343 -3.115944e-02
       [22,]  -1.9910612  -2.3940364  0.0329920338 -2.308626e-02
       [23,]   1.5463198   0.6846337 -0.0064743672  3.330740e-02
       [24,]  -0.9829150   8.4204685 -0.0422361016  4.415502e-02
       [25,]   5.0429542   4.2088006  0.0344848166 -3.834558e-02
       [26,]   6.1167373   4.8901933 -0.0305266531  2.309174e-02
       [27,]   6.3311444   6.5255063 -0.0231167459 -8.338904e-03
       [28,]   7.4070889  10.4407412  0.0194286022  3.812055e-02
       [29,]   5.3644757   4.5013061  0.0001718890  3.733654e-05
       [30,]  12.7637388   7.9101129 -0.0340480692 -4.724280e-02
       [31,]   9.4129097   4.8495570  0.0237194850 -1.894036e-02
       [32,]   8.3135833  12.7682518 -0.0004342598  7.934875e-03
       [33,]  13.0878551  11.4358087  0.0482351774  2.471494e-02
       [34,]  15.0036939  16.1823120  0.0196492030 -9.015889e-03
       [35,]  14.8126897  12.3198517 -0.0194835741 -2.119069e-03
       [36,]  13.7261922  21.7839898  0.0159249835  2.862516e-02
       [37,]  15.3496554  20.9231865 -0.0245666893 -4.937218e-02
       [38,]  20.0009246  16.6966844  0.0478778662  1.189991e-03
       [39,]  19.6401678  20.8582021 -0.0021930194 -1.052345e-02
       [40,]  16.3699826  22.2503787 -0.0416788434  1.419472e-02
       [41,]  18.1074908  16.6723598  0.0231610519 -3.895420e-02
       [42,]  17.2502308  17.8112928  0.0262300945  1.607776e-02
       [43,]  27.7185437  20.1929271 -0.0370317762  3.519951e-02
       [44,]  26.8020245  23.2617120 -0.0346316919 -4.306235e-02
       [45,]  20.1990572  21.2610461  0.0410195358 -2.677924e-02
       [46,]  27.4218434  16.3570225  0.0166052091  3.370115e-02
       [47,]  25.4668159  25.5563893 -0.0305520805 -7.628256e-03
       [48,]  30.2956153  24.7494996 -0.0245675498  1.474725e-03
       [49,]  28.9897966  26.5917958 -0.0345455090  2.119039e-02
       [50,]  31.1175979  34.7087324 -0.0003508595  1.268381e-02
       [51,]  37.5562777  26.2056359 -0.0034057023  1.346007e-02
       [52,]  31.7245601  35.2633830 -0.0011862537 -1.548746e-02
       [53,]  35.2631715  22.2346172 -0.0109603464 -2.307818e-02
       [54,]  31.1825996  33.1176209  0.0212193804  4.217972e-02
       [55,]  37.4481140  31.6392024 -0.0217553976  4.829483e-02
       [56,]  34.0648268  31.8461061 -0.0191707506  2.072083e-02
       [57,]  36.5271759  35.6081368  0.0442334460  3.700059e-02
       [58,]  32.6778916  36.3437630 -0.0219509164 -2.682958e-02
       [59,]  34.9975620  36.0170240 -0.0495311228  5.010260e-03
       [60,]  38.6705674  40.8144074  0.0113840646  2.138814e-02
       [61,]  40.6935358  41.2197965  0.0155089854  3.384213e-02
       [62,]  42.6203033  42.6443931 -0.0401021889 -2.381642e-02
       [63,]  42.5615878  44.9614578  0.0163494704 -3.741723e-02
       [64,]  41.9233390  47.8598461 -0.0425397867 -2.485847e-02
       [65,]  40.2239143  42.7546528  0.0480898142 -1.459736e-03
       [66,]  46.5051007  46.3976404  0.0308108424 -4.685443e-03
       [67,]  50.7102312  46.2819877 -0.0071905138 -4.021027e-02
       [68,]  48.7086295  47.4813781  0.0412790195  4.312391e-02
       [69,]  50.4241580  43.4932764 -0.0240459894  1.495112e-02
       [70,]  50.9803185  52.2398746 -0.0193376644 -1.122955e-02
       [71,]  48.5093001  41.9426477  0.0423996357  4.721409e-02
       [72,]  49.9554795  49.7815296 -0.0184977262 -4.704446e-02
       [73,]  54.4878673  56.1642905 -0.0198984539  6.842718e-03
       [74,]  53.8720433  51.8971797 -0.0116929745  1.286648e-02
       [75,]  57.5104327  53.6190597  0.0232275496 -3.359787e-02
       [76,]  51.1921070  55.0542044 -0.0192702085 -4.484048e-02
       [77,]  56.8210769  52.9739997 -0.0320126913 -4.241089e-02
       [78,]  57.2410156  56.8672158 -0.0081955564 -3.371412e-02
       [79,]  61.9526535  56.8142231 -0.0313546496 -1.659019e-02
       [80,]  60.3940895  58.9470660  0.0244275016 -2.000044e-02
       [81,]  62.4142716  62.6013239 -0.0151788390  1.690339e-02
       [82,]  56.7711580  64.0401924 -0.0351408962 -9.961860e-03
       [83,]  62.2475320  62.1810693  0.0215082376 -2.888342e-02
       [84,]  63.9844920  58.5808469  0.0027284850 -2.930204e-02
       [85,]  64.4268197  58.3900471  0.0387120224 -4.338725e-02
       [86,]  62.5426556  61.6898350  0.0227838194  1.025363e-03
       [87,]  64.2801960  63.5998535  0.0251240733  6.947431e-03
       [88,]  65.9413552  62.4099121 -0.0464932609 -3.107307e-02
       [89,]  73.8527399  65.5662156  0.0199507820 -2.983059e-02
       [90,]  73.9734242  67.4712454 -0.0256514851 -3.587464e-03
       [91,]  67.4628620  69.2616856 -0.0405866878  3.662836e-02
       [92,]  68.3226550  74.3294575  0.0028731658 -2.557130e-02
       [93,]  75.0126541  71.5936274  0.0444275602 -4.820601e-02
       [94,]  71.7331553  73.4603250 -0.0491111540 -4.970583e-02
       [95,]  71.3355200  75.4683324 -0.0416546314  1.212139e-02
       [96,]  73.4443100  70.7973729 -0.0341986140  3.294325e-02
       [97,]  75.1585787  76.8359327 -0.0086308938  1.258265e-02
       [98,]  73.5046204  74.4188297  0.0107749348 -1.569915e-04
       [99,]  76.4011764  77.6934416  0.0150154262 -1.541384e-02
      [100,]  82.8157596  81.9497914  0.0324984893  3.356151e-02
      [101,]  21.1227422 -20.9294867 -0.0357600727 -6.868312e-03
      [102,]  18.8716424 -22.3686532 -0.0185067930  2.614086e-02
      [103,]  13.9059678 -23.0633409  0.0271053146  2.321119e-02
      [104,]  24.8212683 -13.5806975  0.0223568213 -4.151565e-02
      [105,]  20.7779629 -12.8840504  0.0360059179  6.862480e-03
      [106,]  24.1699965 -20.8183735 -0.0107024108  3.822739e-02
      [107,]  23.3778939  -8.8966304  0.0181858625  2.681517e-02
      [108,]  24.6640788 -14.1712181  0.0281567011 -3.516757e-02
      [109,]  27.6510249 -12.1572738 -0.0038288075  4.175256e-03
      [110,]  30.0442810 -10.1986659 -0.0409427823 -4.622971e-02
      [111,]  30.5304061 -11.5319234  0.0325093341  3.193288e-02
      [112,]  32.0369899  -9.8457284 -0.0205325620 -1.676492e-02
      [113,]  31.9014693  -9.2528761 -0.0355930796  3.526906e-02
      [114,]  35.5289863  -4.7386588  0.0487806467  3.087604e-02
      [115,]  32.0281749  -8.9420475  0.0448191922  1.070080e-02
      [116,]  40.6639759  -3.4122532 -0.0439755222  3.229748e-02
      [117,]  38.9468167  -2.5208909  0.0361030853  4.542123e-02
      [118,]  38.4310301  -6.7686992 -0.0213141399  1.655894e-02
      [119,]  34.0445565  -1.0957223  0.0036367978  1.747713e-03
      [120,]  39.3357599  -5.1368689  0.0340218931 -3.294439e-02
      [121,]  40.4986537  -3.2813741  0.0304943694  4.563259e-02
      [122,]  36.4259868  -0.3820704 -0.0085205035  3.535140e-03
      [123,]  45.0148875   0.7735584  0.0367266138  1.578933e-02
      [124,]  42.4376003   5.4292061  0.0264216963  4.282951e-02
      [125,]  39.6239518   4.6105650  0.0091447428 -4.877184e-02
      [126,]  40.1864880   2.8783288 -0.0059495745 -1.200973e-02
      [127,]  45.0505191   1.0036258  0.0281619394  2.913777e-02
      [128,]  47.2288892  10.6068802 -0.0017269597 -1.224266e-02
      [129,]  47.2902470   9.7779811  0.0256983434  1.746640e-02
      [130,]  48.4605164   9.9630759  0.0496705881 -1.495863e-02
      [131,]  50.2583349   8.1038191 -0.0051352489  3.182903e-02
      [132,]  49.3059955  11.0928427  0.0273578355  1.085481e-04
      [133,]  49.1916225  12.4521021  0.0115915452  3.300351e-02
      [134,]  53.6833751  18.2916361 -0.0264064001 -3.553239e-02
      [135,]  53.4663906  17.5941203 -0.0198529340  2.355607e-03
      [136,]  57.0863156  10.3540628  0.0002438598 -2.481383e-02
      [137,]  58.1132490  17.4339721  0.0053096824  4.444729e-02
      [138,]  52.3871104  18.5648457  0.0362229523  3.384768e-02
      [139,]  58.3352683  13.7312096  0.0193852589  3.985037e-02
      [140,]  64.4622573  17.3251035 -0.0093251564  2.217006e-02
      [141,]  57.8803094  21.5051598  0.0248719533  2.400772e-02
      [142,]  65.8745204  16.8013214 -0.0473052719  3.606880e-03
      [143,]  61.0724348  26.7770151 -0.0238977435 -3.080228e-02
      [144,]  65.9461483  21.2733067  0.0264777167 -2.536742e-02
      [145,]  63.1839135  19.9917226  0.0189059034 -1.347111e-02
      [146,]  70.3441853  20.3578872  0.0349754151 -4.044331e-02
      [147,]  67.5987940  21.7423731 -0.0457185472 -5.961939e-03
      [148,]  68.7169472  22.5802521 -0.0108053458  4.369684e-02
      [149,]  68.3890842  30.0340101  0.0427678243  3.528876e-02
      [150,]  64.4069261  28.8127041 -0.0155390420 -3.967089e-02
      [151,]  69.2556673  27.5522929  0.0102627469 -1.281080e-02
      [152,]  68.1644160  28.4227011  0.0254389687 -6.340092e-03
      [153,]  74.5999382  28.5498483  0.0178099468 -2.135797e-02
      [154,]  74.4361362  35.7519571  0.0105336501  1.863120e-02
      [155,]  73.0217485  36.1930467  0.0296980240  2.447875e-02
      [156,]  75.7294938  38.7832051  0.0131823413 -3.734830e-02
      [157,]  80.1776912  33.1851105  0.0221103435  4.338618e-03
      [158,]  75.5286207  41.4805520  0.0194955980  4.281553e-02
      [159,]  77.4031617  36.2360345 -0.0343102385 -5.244724e-04
      [160,]  76.6045570  34.0746628  0.0354791025  1.928101e-02
      [161,]  77.6952372  40.6098573  0.0455530925 -3.568117e-02
      [162,]  80.6092074  42.8927501 -0.0444633594 -2.225809e-02
      [163,]  80.4028964  36.6397824  0.0278191108  3.982380e-02
      [164,]  83.2151198  43.3212244  0.0100205618  4.170410e-02
      [165,]  85.2690275  39.4447551 -0.0207915091  3.715181e-02
      [166,]  83.3985470  47.3851627 -0.0194021311 -4.220070e-02
      [167,]  84.6695505  41.9320165  0.0420285729  2.518827e-03
      [168,]  89.6664172  50.9058909 -0.0143736571 -3.659039e-02
      [169,]  90.1179658  46.5005071 -0.0471166582  3.716604e-02
      [170,]  86.2813128  48.4780254 -0.0011105877 -3.218129e-02
      [171,]  88.9000801  46.9081269 -0.0323901738  2.750799e-02
      [172,]  85.3368879  49.8631133 -0.0133922930 -1.701060e-02
      [173,]  95.3255159  54.6501819 -0.0464529631  3.058774e-02
      [174,]  93.5931793  53.9892781 -0.0119273066  2.541549e-02
      [175,]  91.0941384  50.6583837 -0.0211618534 -2.644579e-02
      [176,]  95.1106552  51.5108012 -0.0163164396  3.796711e-03
      [177,]  92.8647678  55.1894893 -0.0154660322 -2.241050e-02
      [178,]  99.1790424  56.6677338  0.0006941579 -3.275914e-02
      [179,]  94.7654403  57.4982298 -0.0265995397 -1.030154e-02
      [180,]  92.2722114  66.8506194  0.0164671519 -2.848918e-02
      [181,] 100.3691726  59.2530520 -0.0433949099  4.808778e-02
      [182,] 100.3385727  64.8488876  0.0214593931  3.091673e-02
      [183,] 103.5902814  61.5705600 -0.0059777297 -2.779407e-02
      [184,] 100.4446074  63.6111478  0.0331852962 -1.607059e-02
      [185,] 108.4053038  64.3596720  0.0124993692  4.445126e-04
      [186,] 104.4963642  61.7101257 -0.0065300648  5.350461e-03
      [187,] 103.4919137  64.1717214  0.0411417381 -3.148262e-02
      [188,] 107.8754590  70.2337765  0.0247844953 -1.685814e-02
      [189,] 111.1043592  68.4373486 -0.0435268620  1.210662e-03
      [190,] 109.8438730  68.2281448  0.0458923144  4.850406e-02
      [191,] 109.8705405  70.8790928 -0.0046170085  3.640567e-02
      [192,] 111.7190571  71.6265022 -0.0450764619 -4.455620e-02
      [193,] 115.3952068  67.7999658 -0.0059401513 -6.219088e-03
      [194,] 111.9375191  72.5752580  0.0081883668 -4.095101e-03
      [195,] 112.9301514  72.8701575  0.0304601316 -6.514969e-03
      [196,] 113.9749847  74.8307040  0.0020829631  3.607097e-02
      [197,] 115.0910873  77.8821985  0.0304781620 -3.611904e-02
      [198,] 116.7131579  78.4439615 -0.0425765788  4.177381e-02
      [199,] 118.2743235  81.0791120  0.0114159942 -3.687107e-02
      [200,] 116.8948203  81.9741286  0.0233740703 -3.089587e-02
      [201,]  13.9532963   4.4387419 -0.0339096562 -4.841946e-02
      [202,]   9.0735241  14.6853836  0.0414377427 -3.479588e-02
      [203,]   8.1238310  12.5885781  0.0374152880 -7.765238e-03
      [204,]  16.8544358  12.2695727 -0.0403944338  8.493012e-03
      [205,]  15.1325030  22.4022259 -0.0284535438 -4.367337e-02
      [206,]  14.5375679  11.6809638 -0.0143401542  1.733485e-02
      [207,]  11.4036217  18.6830838 -0.0150897518 -2.077300e-02
      [208,]  18.1720491  19.4129084  0.0294666313 -1.581126e-03
      [209,]  16.6065971  17.8217498  0.0268727275  2.578530e-02
      [210,]  27.9377182  20.4398605 -0.0245010051 -4.158560e-02
      [211,]  21.0862648  16.9155396 -0.0323609477  3.239401e-02
      [212,]  20.9346576  23.6259543  0.0283407058 -3.571340e-03
      [213,]  22.7614544  18.3432526 -0.0101760890  2.804938e-02
      [214,]  22.7829400  23.4185407  0.0049510104 -1.635639e-02
      [215,]  22.4711390  21.5139846  0.0093291366  1.459011e-02
      [216,]  26.1403344  25.4877047 -0.0092357021 -1.896442e-02
      [217,]  25.0650900  28.0318778 -0.0142444834  8.057138e-03
      [218,]  28.0228122  30.1616871 -0.0276593626  4.193794e-02
      [219,]  29.2238781  31.0366824  0.0235752249  9.387194e-03
      [220,]  31.9404133  34.0568866  0.0009247106  7.353027e-03
      [221,]  34.0125220  29.8305108 -0.0222653301  4.049259e-02
      [222,]  28.0089388  27.6059636 -0.0108763634  1.485700e-02
      [223,]  31.5463198  30.6846337  0.0049058254 -2.303922e-02
      [224,]  29.0170850  38.4204685  0.0245505164 -1.958080e-02
      [225,]  35.0429542  34.2088006  0.0016452796  2.439304e-02
      [226,]  36.1167373  34.8901933  0.0233802950 -1.207646e-02
      [227,]  36.3311444  36.5255063  0.0460393964  1.496986e-02
      [228,]  37.4070889  40.4407412 -0.0332867402  2.234558e-03
      [229,]  35.3644757  34.5013061 -0.0406457410 -2.836664e-02
      [230,]  42.7637388  37.9101129  0.0129818394 -4.881061e-02
      [231,]  39.4129097  34.8495570  0.0013812454  4.935234e-02
      [232,]  38.3135833  42.7682518  0.0099141791  1.414081e-02
      [233,]  43.0878551  41.4358087  0.0025305262  7.169498e-03
      [234,]  45.0036939  46.1823120  0.0272961495 -3.040587e-02
      [235,]  44.8126897  42.3198517 -0.0497736051 -3.201353e-02
      [236,]  43.7261922  51.7839898  0.0373848314 -4.102860e-02
      [237,]  45.3496554  50.9231865  0.0178189527  4.011197e-02
      [238,]  50.0009246  46.6966844 -0.0290966723  3.823476e-03
      [239,]  49.6401678  50.8582021 -0.0376571369 -1.490164e-02
      [240,]  46.3699826  52.2503787  0.0122225274 -4.937804e-02
      [241,]  48.1074908  46.6723598  0.0207520892  2.975896e-02
      [242,]  47.2502308  47.8112928 -0.0489874637 -4.884075e-02
      [243,]  57.7185437  50.1929271  0.0319272961 -1.858960e-02
      [244,]  56.8020245  53.2617120 -0.0234734462  8.801401e-03
      [245,]  50.1990572  51.2610461 -0.0392798880  1.339276e-03
      [246,]  57.4218434  46.3570225 -0.0412171215  1.764744e-02
      [247,]  55.4668159  55.5563893  0.0392849744  2.702126e-03
      [248,]  60.2956153  54.7494996 -0.0370253569 -4.090619e-02
      [249,]  58.9897966  56.5917958 -0.0145395615 -6.385344e-03
      [250,]  61.1175979  64.7087324 -0.0151166953 -3.685905e-02
      [251,]  67.5562777  56.2056359  0.0208508563  3.503112e-02
      [252,]  61.7245601  65.2633830 -0.0263127579 -8.227978e-03
      [253,]  65.2631715  52.2346172 -0.0392443858  4.318322e-02
      [254,]  61.1825996  63.1176209 -0.0396260771 -4.268886e-02
      [255,]  67.4481140  61.6392024 -0.0360179453  3.545460e-02
      [256,]  64.0648268  61.8461061  0.0213240878 -2.309860e-02
      [257,]  66.5271759  65.6081368  0.0479957431 -3.377105e-02
      [258,]  62.6778916  66.3437630  0.0395506542 -3.713369e-02
      [259,]  64.9975620  66.0170240  0.0335367842 -2.504078e-02
      [260,]  68.6705674  70.8144074 -0.0037490580 -2.202144e-02
      [261,]  70.6935358  71.2197965 -0.0256192339  2.576198e-02
      [262,]  72.6203033  72.6443931  0.0432805400  4.108143e-02
      [263,]  72.5615878  74.9614578  0.0265724259  4.886903e-02
      [264,]  71.9233390  77.8598461  0.0024829366 -2.070392e-02
      [265,]  70.2239143  72.7546528 -0.0206748786  2.479276e-02
      [266,]  76.5051007  76.3976404  0.0290983000  3.753685e-02
      [267,]  80.7102312  76.2819877 -0.0052619396 -4.474088e-02
      [268,]  78.7086295  77.4813781 -0.0012253103 -4.821559e-02
      [269,]  80.4241580  73.4932764  0.0257397868 -3.799170e-02
      [270,]  80.9803185  82.2398746  0.0492021148 -2.464728e-02
      [271,]  78.5093001  71.9426477 -0.0038281123 -8.387998e-03
      [272,]  79.9554795  79.7815296  0.0484013313 -2.661362e-02
      [273,]  84.4878673  86.1642905 -0.0162242120  1.794084e-02
      [274,]  83.8720433  81.8971797 -0.0470545943  3.887252e-02
      [275,]  87.5104327  83.6190597  0.0055834409 -4.374773e-02
      [276,]  81.1921070  85.0542044  0.0185618917 -2.679644e-02
      [277,]  86.8210769  82.9739997  0.0393190964 -3.733186e-02
      [278,]  87.2410156  86.8672158  0.0213096378  1.296832e-02
      [279,]  91.9526535  86.8142231 -0.0234274061 -3.788711e-02
      [280,]  90.3940895  88.9470660 -0.0293364196  1.547613e-02
      [281,]  92.4142716  92.6013239  0.0267114585  4.698165e-02
      [282,]  86.7711580  94.0401924  0.0028744341  3.856291e-02
      [283,]  92.2475320  92.1810693  0.0433571625 -8.757659e-03
      [284,]  93.9844920  88.5808469 -0.0356078255 -2.861032e-02
      [285,]  94.4268197  88.3900471  0.0475948478  2.840946e-02
      [286,]  92.5426556  91.6898350  0.0241484647  5.369577e-03
      [287,]  94.2801960  93.5998535  0.0375258525 -3.227090e-02
      [288,]  95.9413552  92.4099121  0.0468080780 -3.542723e-02
      [289,] 103.8527399  95.5662156 -0.0377881441 -3.539199e-03
      [290,] 103.9734242  97.4712454 -0.0490372739 -1.398847e-02
      [291,]  97.4628620  99.2616856 -0.0016966163 -3.608108e-02
      [292,]  98.3226550 104.3294575 -0.0175773777  4.937051e-03
      [293,] 105.0126541 101.5936274  0.0105857869  4.895686e-02
      [294,] 101.7331553 103.4603250 -0.0377988065 -3.697397e-02
      [295,] 101.3355200 105.4683324 -0.0091741279  2.681811e-02
      [296,] 103.4443100 100.7973729  0.0452865537  3.807928e-02
      [297,] 105.1585787 106.8359327  0.0262750590 -7.696998e-03
      [298,] 103.5046204 104.4188297 -0.0248023016 -2.305322e-02
      [299,] 106.4011764 107.6934416 -0.0186367779 -4.300337e-02
      [300,] 112.8157596 111.9497914 -0.0442824661  4.845613e-02

---

    Code
      two_long_clust_diff(n = 300, num_noise = 0)
    Output
                    [,1]        [,2]
        [1,] -20.8152468 -16.7599828
        [2,] -15.9099490 -19.0586419
        [3,] -21.5781608 -18.0270369
        [4,] -10.6972280 -16.4261010
        [5,] -12.9194402 -10.2739298
        [6,] -13.5297016 -16.9642464
        [7,]  -9.5624523 -15.6150211
        [8,] -11.1490787  -8.2872655
        [9,] -10.2869018 -16.7989354
       [10,] -10.4682278  -9.8555052
       [11,] -11.6442172  -9.3619132
       [12,] -10.4056063 -13.7162287
       [13,]  -9.9809575  -4.7883084
       [14,]  -1.9040922  -5.4984426
       [15,]  -9.9255345 -11.2873021
       [16,]  -7.0780694  -3.3881165
       [17,]  -9.0880473  -3.6437084
       [18,]  -4.1864431  -0.2975438
       [19,]  -1.8894638  -2.5131268
       [20,]   0.1288655  -2.4616926
       [21,]  -1.0378819  -2.1890396
       [22,]   5.3276732  -2.9915813
       [23,]  -3.9458126   2.9821394
       [24,]   7.3417337   6.3515088
       [25,]   5.8425796   4.8698328
       [26,]   4.3853733   3.2139623
       [27,]   7.2121438   7.0755408
       [28,]   4.4789509   5.4408091
       [29,]   2.2181282   8.3297713
       [30,]   4.9211989  13.8205787
       [31,]  11.7230192  11.1079954
       [32,]  13.8051979   5.7733325
       [33,]   8.9755236  10.3865045
       [34,]  14.5999964  15.6639452
       [35,]  16.1351962  14.5148380
       [36,]  13.8355467  19.3502553
       [37,]  17.6670981  17.7665362
       [38,]  15.9003759  16.4906719
       [39,]  12.8017051  20.0096688
       [40,]  18.1253516  24.5596604
       [41,]  19.8181804  18.1624423
       [42,]  18.7574710  17.3651453
       [43,]  19.3737393  29.5946286
       [44,]  24.6247746  20.8393073
       [45,]  30.0368123  26.2555926
       [46,]  27.5772235  23.5409980
       [47,]  29.7126211  24.1931810
       [48,]  28.7198864  30.1846940
       [49,]  31.3352077  25.2511943
       [50,]  30.2626347  30.1779014
       [51,]  33.8154321  28.2063042
       [52,]  31.8828641  29.6688064
       [53,]  33.9149374  34.6502000
       [54,]  32.6711300  33.4066964
       [55,]  36.0223693  33.1364884
       [56,]  35.8309621  35.4962021
       [57,]  28.7927847  35.4657067
       [58,]  35.6449743  29.7590280
       [59,]  42.3616481  37.3931214
       [60,]  40.9322574  31.3934131
       [61,]  34.7984721  43.5985648
       [62,]  38.5380424  36.2230275
       [63,]  37.9936693  48.3383358
       [64,]  39.9063332  48.8228223
       [65,]  47.2484700  43.0270449
       [66,]  48.1308344  40.8698279
       [67,]  45.9417723  46.8385311
       [68,]  44.7671084  48.1358601
       [69,]  45.6297107  47.5513760
       [70,]  43.7148032  50.9615505
       [71,]  50.9586056  47.3419936
       [72,]  52.3147085  51.6866608
       [73,]  54.8311678  52.4025391
       [74,]  53.7443449  57.5079339
       [75,]  53.0580465  52.9974577
       [76,]  52.3127351  55.9849803
       [77,]  57.9812486  54.8990235
       [78,]  54.0027697  55.0347016
       [79,]  62.4263301  57.6723269
       [80,]  59.3055052  54.7115265
       [81,]  62.3445088  60.0488571
       [82,]  59.4785608  61.6045702
       [83,]  68.7636703  62.3210602
       [84,]  62.1712277  62.9527286
       [85,]  62.6768020  59.6388312
       [86,]  64.0977428  66.0139989
       [87,]  64.7158721  62.4558557
       [88,]  66.6821797  66.8401422
       [89,]  70.5138350  69.6952017
       [90,]  69.2462167  69.3343579
       [91,]  71.2416082  71.4087110
       [92,]  71.3413480  68.9161474
       [93,]  72.1423806  71.2613944
       [94,]  74.4314269  73.8336567
       [95,]  72.3499678  77.6204170
       [96,]  76.9974882  78.8815196
       [97,]  77.0749954  71.9013304
       [98,]  74.4913879  73.5792573
       [99,]  83.5475753  82.4663244
      [100,]  76.5795823  81.3932511
      [101,]  13.6163192 -25.0767146
      [102,]  19.0956529 -17.5746272
      [103,]  19.4865712 -22.2071591
      [104,]  31.8787746 -12.4641140
      [105,]  22.1632073 -14.2205776
      [106,]  22.9123868 -16.4537937
      [107,]  20.9985053 -16.3833670
      [108,]  26.4241953  -7.2390373
      [109,]  25.3212982 -12.9085187
      [110,]  24.8879056 -11.0870274
      [111,]  24.7800669 -10.8416017
      [112,]  27.9469762 -11.1134139
      [113,]  30.5708266 -11.2494271
      [114,]  30.3856092  -7.7406040
      [115,]  29.6211215 -12.7970459
      [116,]  40.5057805  -4.3478161
      [117,]  37.8604683  -1.4172082
      [118,]  34.7564443  -3.8527083
      [119,]  40.2480274  -0.6164660
      [120,]  44.9717005  -3.1481871
      [121,]  42.0109566   2.3798700
      [122,]  45.7386977   3.4956825
      [123,]  44.4294679  -3.4337404
      [124,]  37.2495825   5.3486196
      [125,]  45.2549913   5.0265441
      [126,]  44.0285798   5.7875864
      [127,]  49.7906894   8.7377184
      [128,]  49.0472163  10.9111895
      [129,]  45.9989400  12.3015556
      [130,]  43.8966199  12.6984255
      [131,]  53.8055904   9.1380671
      [132,]  52.6827464   7.4571285
      [133,]  54.2470298  11.0629204
      [134,]  50.4433036  10.6959173
      [135,]  49.8390589  14.3845958
      [136,]  53.7033786  13.3596828
      [137,]  56.8156107  15.3132698
      [138,]  60.4814117  18.8554542
      [139,]  57.2973528  17.2157295
      [140,]  55.7440798  19.3000049
      [141,]  56.7868152  20.4091698
      [142,]  67.9903681  23.0286579
      [143,]  61.5044706  18.7792790
      [144,]  65.9980982  24.3016117
      [145,]  65.2363406  24.2681585
      [146,]  62.6745583  26.6920089
      [147,]  65.5146921  18.8743035
      [148,]  61.6211095  24.2118846
      [149,]  70.2702368  33.6459492
      [150,]  74.7728084  30.8302168
      [151,]  68.0256655  26.3895927
      [152,]  70.2796076  31.5758661
      [153,]  72.0705164  29.1268936
      [154,]  77.8224403  29.2402044
      [155,]  72.9300653  33.2005578
      [156,]  74.0355143  40.8311061
      [157,]  82.1174197  33.5283622
      [158,]  74.4465253  39.8823293
      [159,]  80.1959801  33.2497001
      [160,]  81.0209042  41.4496083
      [161,]  86.3598623  35.8265616
      [162,]  82.6867087  37.6988900
      [163,]  85.6839345  42.7486832
      [164,]  80.5653161  41.5712801
      [165,]  81.5952528  46.5087853
      [166,]  88.1218404  47.7360245
      [167,]  86.8064201  49.4730906
      [168,]  87.4105429  43.5372454
      [169,]  89.7965771  43.1417723
      [170,]  92.4484643  51.3036130
      [171,]  85.6410312  47.6485613
      [172,]  90.2160369  52.8892664
      [173,]  88.7258139  45.9727281
      [174,]  92.8753448  54.3000930
      [175,]  91.0520032  56.3985862
      [176,]  90.3924350  53.5134085
      [177,]  94.8087627  49.9035834
      [178,] 103.1706573  59.0487770
      [179,]  95.6749005  54.0590634
      [180,] 101.6518296  61.6439060
      [181,]  97.2460618  60.2403893
      [182,]  98.5531922  64.1275953
      [183,] 104.1947026  60.8738262
      [184,] 104.0576217  66.3824659
      [185,]  98.9833759  61.2227990
      [186,] 101.4030831  61.8008218
      [187,] 105.2641944  65.7406601
      [188,] 104.3335957  68.4432663
      [189,] 109.8556148  68.2967381
      [190,] 105.4069152  68.6546948
      [191,] 112.2345590  70.5426073
      [192,] 107.3033251  72.9634223
      [193,] 115.4530026  69.4260795
      [194,] 114.6310919  69.0582602
      [195,] 111.3778346  77.3479751
      [196,] 111.6319629  76.2295241
      [197,] 113.6635093  75.3416619
      [198,] 118.4381926  80.1269371
      [199,] 119.8354817  76.8573198
      [200,] 117.1876735  81.5206893
      [201,]   9.1847532  13.2400172
      [202,]  14.0900510  10.9413581
      [203,]   8.4218392  11.9729631
      [204,]  19.3027720  13.5738990
      [205,]  17.0805598  19.7260702
      [206,]  16.4702984  13.0357536
      [207,]  20.4375477  14.3849789
      [208,]  18.8509213  21.7127345
      [209,]  19.7130982  13.2010646
      [210,]  19.5317722  20.1444948
      [211,]  18.3557828  20.6380868
      [212,]  19.5943937  16.2837713
      [213,]  20.0190425  25.2116916
      [214,]  28.0959078  24.5015574
      [215,]  20.0744655  18.7126979
      [216,]  22.9219306  26.6118835
      [217,]  20.9119527  26.3562916
      [218,]  25.8135569  29.7024562
      [219,]  28.1105362  27.4868732
      [220,]  30.1288655  27.5383074
      [221,]  28.9621181  27.8109604
      [222,]  35.3276732  27.0084187
      [223,]  26.0541874  32.9821394
      [224,]  37.3417337  36.3515088
      [225,]  35.8425796  34.8698328
      [226,]  34.3853733  33.2139623
      [227,]  37.2121438  37.0755408
      [228,]  34.4789509  35.4408091
      [229,]  32.2181282  38.3297713
      [230,]  34.9211989  43.8205787
      [231,]  41.7230192  41.1079954
      [232,]  43.8051979  35.7733325
      [233,]  38.9755236  40.3865045
      [234,]  44.5999964  45.6639452
      [235,]  46.1351962  44.5148380
      [236,]  43.8355467  49.3502553
      [237,]  47.6670981  47.7665362
      [238,]  45.9003759  46.4906719
      [239,]  42.8017051  50.0096688
      [240,]  48.1253516  54.5596604
      [241,]  49.8181804  48.1624423
      [242,]  48.7574710  47.3651453
      [243,]  49.3737393  59.5946286
      [244,]  54.6247746  50.8393073
      [245,]  60.0368123  56.2555926
      [246,]  57.5772235  53.5409980
      [247,]  59.7126211  54.1931810
      [248,]  58.7198864  60.1846940
      [249,]  61.3352077  55.2511943
      [250,]  60.2626347  60.1779014
      [251,]  63.8154321  58.2063042
      [252,]  61.8828641  59.6688064
      [253,]  63.9149374  64.6502000
      [254,]  62.6711300  63.4066964
      [255,]  66.0223693  63.1364884
      [256,]  65.8309621  65.4962021
      [257,]  58.7927847  65.4657067
      [258,]  65.6449743  59.7590280
      [259,]  72.3616481  67.3931214
      [260,]  70.9322574  61.3934131
      [261,]  64.7984721  73.5985648
      [262,]  68.5380424  66.2230275
      [263,]  67.9936693  78.3383358
      [264,]  69.9063332  78.8228223
      [265,]  77.2484700  73.0270449
      [266,]  78.1308344  70.8698279
      [267,]  75.9417723  76.8385311
      [268,]  74.7671084  78.1358601
      [269,]  75.6297107  77.5513760
      [270,]  73.7148032  80.9615505
      [271,]  80.9586056  77.3419936
      [272,]  82.3147085  81.6866608
      [273,]  84.8311678  82.4025391
      [274,]  83.7443449  87.5079339
      [275,]  83.0580465  82.9974577
      [276,]  82.3127351  85.9849803
      [277,]  87.9812486  84.8990235
      [278,]  84.0027697  85.0347016
      [279,]  92.4263301  87.6723269
      [280,]  89.3055052  84.7115265
      [281,]  92.3445088  90.0488571
      [282,]  89.4785608  91.6045702
      [283,]  98.7636703  92.3210602
      [284,]  92.1712277  92.9527286
      [285,]  92.6768020  89.6388312
      [286,]  94.0977428  96.0139989
      [287,]  94.7158721  92.4558557
      [288,]  96.6821797  96.8401422
      [289,] 100.5138350  99.6952017
      [290,]  99.2462167  99.3343579
      [291,] 101.2416082 101.4087110
      [292,] 101.3413480  98.9161474
      [293,] 102.1423806 101.2613944
      [294,] 104.4314269 103.8336567
      [295,] 102.3499678 107.6204170
      [296,] 106.9974882 108.8815196
      [297,] 107.0749954 101.9013304
      [298,] 104.4913879 103.5792573
      [299,] 113.5475753 112.4663244
      [300,] 106.5795823 111.3932511

