% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_ard.R
\name{.fill_overall_grp_values}
\alias{.fill_overall_grp_values}
\title{Fill Overall Group Variables}
\usage{
.fill_overall_grp_values(x, vars_protected)
}
\arguments{
\item{x}{(\code{data.frame})\cr
a data frame}
}
\value{
data frame
}
\description{
This function fills the missing values of grouping variables with "Overall
\verb{variable name}" where relevant. Specifically it will modify grouping values
from rows with likely overall calculations present (e.g. non-missing
variable/variable_level, missing group variables, and evidence that the
\code{variable} has been computed by group in other rows). "Overall" values will
be populated only for grouping variables that have been used in other calculations
of the same variable and statistics.
}
\examples{
data <- dplyr::tibble(
  grp = c("AA", "AA", NA, "BB", NA),
  variable = c("A", "B", "A", "C", "C"),
  variable_level = c(1, 2, 1, 3, 3),
  A = rep(NA, 5),
  B = rep(NA, 5),
  ..cards_idx.. = c(1:5)
)

cards:::.fill_overall_grp_values(data, vars_protected = "..cards_idx..")
}
\keyword{internal}
