% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_effectsize_cohens_d.R
\name{.format_cohens_d_results}
\alias{.format_cohens_d_results}
\title{Convert Cohen's D Test to ARD}
\usage{
.format_cohens_d_results(by, variable, lst_tidy, paired, ...)
}
\arguments{
\item{by}{(\code{string})\cr by column name}

\item{variable}{(\code{string})\cr variable column name}

\item{lst_tidy}{(named \code{list})\cr
list of tidied results constructed with \code{\link[cards:eval_capture_conditions]{eval_capture_conditions()}},
e.g. \code{eval_capture_conditions(t.test(mtcars$mpg ~ mtcars$am) |> broom::tidy())}.}

\item{paired}{If \code{TRUE}, the values of \code{x} and \code{y} are considered as paired.
This produces an effect size that is equivalent to the one-sample effect
size on \code{x - y}. See also \code{\link[effectsize:repeated_measures_d]{repeated_measures_d()}} for more options.}

\item{...}{passed to \code{cohens_d(...)}}
}
\value{
ARD data frame
}
\description{
Convert Cohen's D Test to ARD
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("effectsize", "parameters"), reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cardx:::.format_cohens_d_results(
  by = "ARM",
  variable = "AGE",
  paired = FALSE,
  lst_tidy =
    cards::eval_capture_conditions(
      effectsize::hedges_g(data[[variable]] ~ data[[by]], paired = FALSE) |>
        parameters::standardize_names(style = "broom")
    )
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
