% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resamples.R
\name{dotplot.diff.resamples}
\alias{dotplot.diff.resamples}
\alias{levelplot.diff.resamples}
\alias{densityplot.diff.resamples}
\alias{bwplot.diff.resamples}
\title{Lattice Functions for Visualizing Resampling Differences}
\usage{
\method{dotplot}{diff.resamples}(x, data = NULL, metric = x$metric[1],
  ...)
}
\arguments{
\item{x}{an object generated by \code{\link{diff.resamples}}}

\item{data}{Not used}

\item{metric}{a character string for which metrics to plot. Note:
\code{dotplot} and \code{levelplot} require exactly two models whereas the
other methods can plot more than two.}

\item{\dots}{further arguments to pass to either
\code{\link[lattice:histogram]{densityplot}},
\code{\link[lattice:dotplot]{dotplot}} or
\code{\link[lattice:levelplot]{levelplot}}}
}
\value{
a lattice object
}
\description{
Lattice functions for visualizing resampling result differences between
models
}
\details{
\code{densityplot} and \code{bwplot} display univariate visualizations of
the resampling distributions. \code{levelplot} displays the matrix of
pair-wide comparisons. \code{dotplot} shows the differences along with their
associated confidence intervals.
}
\examples{

\dontrun{
#load(url("http://topepo.github.io/caret/exampleModels.RData"))

resamps <- resamples(list(CART = rpartFit,
                          CondInfTree = ctreeFit,
                          MARS = earthFit))
difs <- diff(resamps)

dotplot(difs)

densityplot(difs,
            metric = "RMSE",
            auto.key = TRUE,
            pch = "|")

bwplot(difs,
       metric = "RMSE")

levelplot(difs, what = "differences")

}

}
\seealso{
\code{\link{resamples}}, \code{\link{diff.resamples}},
\code{\link[lattice:bwplot]{bwplot}},
\code{\link[lattice:histogram]{densityplot}},
\code{\link[lattice:xyplot]{xyplot}}, \code{\link[lattice:splom]{splom}}
}
\author{
Max Kuhn
}
\keyword{hplot}
