% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogramR_options.R
\name{cartogramR_options}
\alias{cartogramR_options}
\title{Set the options of \link{cartogramR} in the correct format}
\usage{
cartogramR_options(
  options,
  method = c("gsm", "gn", "dcn", "GastnerSeguyMore", "GastnerNewman",
    "DougenikChrismanNiemeyer")
)
}
\arguments{
\item{options}{a named list with some (or all) the following components:
\itemize{
\item maxit:  (all method) the maximum number of iterations,
default to 50.
\item absrel:  (all method)  boolean, if \code{TRUE} relative convergence
if \code{FALSE} absolute convergence (default to \code{TRUE})
\item abserror: (all method) Areas on cartogram differ at most by an
(absolute value of) error of abserror. That is,
\eqn{max_{polygons} |area_on_cartogram - target_area| <= abserror}
(default to 10000)
\item abstol:  (\code{"dcn"}) the absolute convergence error tolerance:
\eqn{max_\{polygons\} |area(i) - area(i-1)|}
default to 1000
\item relerror: (all method) Areas on cartogram differ at most by an
(absolute value of) relative error of relerror. That is,
\eqn{max_\{polygons\} |area_on_cartogram / target_area - 1| <= relerror}
(default to 0.01)
\item reltol:  (\code{"dcn"}) the absolute convergence tolerance:
\eqn{max_\{polygons\} abs((area(i) - area(i-1))/area(i-1)}
default to 1e-3
\item L: (\verb{"gsm" or "gn"}) integer, gives the value of \code{L} (default
is 512), must be a power of two (for fftw)
\item mp: (all method) if a region contains exactly zero population, it will be
replaced by mp times the smallest (strictly) positive population in any
region (default to 0.2)
\item pf: (\verb{"gsm" or "gn"}) Determines space between map and boundary (default to 1.5)
\item sigma: (\verb{"gsm" or "gn"}) Width of Gaussian blur to smoothen the density (default to 5)
\item center: (\verb{"gsm" or "gn"}) either a character string
(only possible choices are \code{"centroid"}
or \code{"point_on_surface"}) or a function. If the
object is a function, it  will be used to
calculate the "center" of polygons; \code{"point_on_surface"}
will use the function \link[sf:geos_unary]{sf::st_point_on_surface}
while \code{"centroid"} (the default) will use \link[sf:geos_unary]{sf::st_centroid}.
\item verbose: (all method) integer giving the verbosity level
(default to \code{0}, not verbose)
\item grid: (\verb{"gsm" or "gn"}) boolean, if \code{TRUE} export the final
grid from flow algorithm (default to \code{TRUE}). Setting to \code{FALSE}
\item check.ring.dir: (all method) boolean, if \code{TRUE} controls polygons orientation
(default to \code{TRUE})
\item check.only: (all method) boolean, if \code{TRUE} control only polygons orientation
and no replacement is done (default to \code{FALSE})
}}

\item{method}{the method to be used, can be one of the following:
\code{gsm} or \code{GastnerSeguyMore} (default), \code{gn} or
\code{GastnerNewman}, \code{dcn} or \code{DougenikChrismanNiemeyer}.}
}
\value{
a list to be processed by \link{cartogramR}
}
\description{
Set the options of \link{cartogramR} in the correct format
}
\examples{
\donttest{
  data(usa)
  carto1 <- cartogramR(usa, "electors64", options=list(verbose=1, L=256))
  plot(carto1)
}

}
\references{
\itemize{
\item Dougenik, J., Chrisman, R. &  Niemeyer, D. (1985).
An algorithm to construct continuous area cartograms.
Professional Geographer \strong{37}: 75-81.
\item Gastner, M. & Newman, M. E. J. (2004). Diffusion-based
method for producing density equalizing
maps. \emph{Proc. Natl. Acad. Sci. USA}, \strong{101}:7499-7504
\item Gastner, M., Seguy, V. & More, P. (2018). Fast flow-based
algorithm for creating density-equalizing map
projections. \emph{Proceedings of the National Academy of Sciences
USA}, \strong{115}:E2156-E2164
}
}
