% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBorders.R, R/getOuterBorders.R
\name{getBorders}
\alias{getBorders}
\alias{getOuterBorders}
\title{Extract Polygons Borders}
\usage{
getBorders(x, id)

getOuterBorders(x, id, res = NULL, width = NULL)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a SpatialPolygonsDataFrame.}

\item{id}{name of the identifier variable in x, default to the first column. (optional)}

\item{res}{resolution of the grid used to compute outer borders (in x units).
A high resolution will give more detailed borders. (optional)}

\item{width}{maximum distance between used to compute outer borders (in x units).
A higher width will build borders between units that are farther apart. (optional)}
}
\value{
An sf object (MULTILINESTRING) of borders is returned. This object has three 
id variables: id, id1 and id2.
id1 and id2 are ids of units that neighbour a border; id is the concatenation 
of id1 and id2 (with "_" as separator).
}
\description{
Extract borders between polygons.

Outer borders are non-contiguous polygons borders (e.g.
maritime borders).
}
\note{
getBorders and getOuterBorders can be combined with rbind.
}
\examples{
library(sf)
\dontrun{
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# extract
m <- mtq[c(5, 29, 9), ]
# Get borders
m_borders <- getBorders(x = m)
# Plot polygons
plot(st_geometry(m), border = NA, col = "grey60")
# Plot borders
plot(st_geometry(m_borders),
     col = sample(x = rainbow(nrow(m_borders))),
     lwd = 2 * c(4, 3, 2, 1), add = TRUE)
}
library(sf)
\dontrun{
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# extract
m <- mtq[c(29, 9), ]
# Get borders
m_borders <- getOuterBorders(x = m)
# Plot polygons
plot(st_geometry(m))
# Plot borders
plot(st_geometry(m_borders),
     col = sample(x = rainbow(nrow(m_borders))),
     lwd = c(4, 1), add = TRUE)
}
}
\seealso{
\link{discLayer}
}
