% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_E_MEPV.R
\name{create_E_MEPV}
\alias{create_E_MEPV}
\title{MSE of every item for an specified node}
\usage{
create_E_MEPV(bank, dens_vec, nres, prob_array, C)
}
\arguments{
\item{bank}{matrix of the item bank. Rows represent items, and columns
represent parameters. If the model is \code{"GRM"}, the first column
represents the \code{alpha} parameters and the next columns represent the
\code{beta} parameters. If the model is \code{"NRM"}, odd columns represent
the \code{alpha} parameters and even columns represent \code{beta}
parameters}

\item{dens_vec}{vector of the density function values in the specified node
of the evaluated ability levels}

\item{nres}{vector of number of possible responses for every item}

\item{prob_array}{3-D array of probability responses. Dim 1 represent items,
dim 2 represent evaluated ability levels and dim 3 represent possible
responses}

\item{C}{vector of item capacities}
}
\value{
A vector of all item MSE for the specified node
}
\description{
Computes a vector of the mean squared error of every item allocated to the
specified level node in the CAT decision tree. Every MSE is computed using
the ability level density function in the specified node and the ability
level estimations given the item responses
}
\author{
Javier Rodr?guez-Cuadrado
}
