% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iptw_est.R
\name{iptw_est}
\alias{iptw_est}
\title{The inverse probability of treatment weighting (iptw) estimator}
\usage{
iptw_est(Y,
         treat,
         treat_formula,
         numerator_formula,
         data,
         degree,
         treat_mod,
         link_function,
         ...)
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{treat_formula}{an object of class "formula" (or one that can be
coerced to that class) that regresses \code{treat} on a linear combination
of \code{X}: a symbolic description of the model to be fitted.}

\item{numerator_formula}{an object of class "formula" (or one that can be
coerced to that class) that regresses \code{treat} on a linear combination
of \code{X}: a symbolic description of the model to be fitted.  i.e.
\code{treat ~ 1}.}

\item{data}{is a dataframe containing \code{Y}, \code{treat}, and
\code{X}.}

\item{degree}{is 1 for linear and 2 for quadratic outcome model.}

\item{treat_mod}{a description of the error distribution to be used in the
model for treatment. Options include: \code{"Normal"} for normal model,
\code{"LogNormal"} for lognormal model, \code{"Sqrt"} for square-root transformation
to a normal treatment, \code{"Poisson"} for Poisson model,
\code{"NegBinom"} for negative binomial model, \code{"Gamma"} for gamma
model, \code{"Binomial"} for binomial model, \code{"Ordinal"} for ordinal model,
\code{"Multinomial"} for multinomial model.}

\item{link_function}{specifies the link function between the variables in
numerator or denominator and exposure, respectively.
For \code{treat_mod = "Gamma"} (fitted using glm) alternatives are "log" or "inverse".
For \code{treat_mod = "Binomial"} (fitted using glm) alternatives are "logit", "probit", "cauchit", "log" and "cloglog".
For \code{treat_mod = "Multinomial"} this argument is ignored, and
multinomial logistic regression models are always used (fitted using multinom).
For \code{treat_mod = "Ordinal"} (fitted using polr) alternatives are "logit", "probit", "cauchit", and "cloglog".}

\item{...}{additional arguments to be passed to the low level treatment regression fitting functions.}
}
\value{
\code{iptw_est} returns an object of class "causaldrf",
a list that contains the following components:
\item{param}{parameter estimates for a iptw fit.}
\item{t_mod}{the result of the treatment model fit.}
\item{num_mod}{the result of the numerator model fit.}
\item{weights}{the estimated weights.}
\item{weight_data}{the weights.}
\item{out_mod}{the outcome model.}
\item{call}{the matched call.}
}
\description{
The iptw method or importance weighting method estimates the ADRF by
weighting the data with stabilized or non-stabilized weights.
}
\details{
This method uses inverse probability of treatment weighting to adjust
for possible biases.  For more details see Schafer and Galagate (2015) and
Robins, Hernan, and Brumback (2000).
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data

iptw_list <- iptw_est(Y = Y,
              treat = T,
              treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
              numerator_formula = T ~ 1,
              data = example_data,
              degree = 1,
              treat_mod = "Normal")

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
      example_data$Y[sample_index],
      xlab = "T",
      ylab = "Y",
      main = "iptw estimate")

abline(iptw_list$param[1],
        iptw_list$param[2],
        lty=2,
        lwd = 2,
        col = "blue")

legend('bottomright',
        "iptw estimate",
        lty=2,
        lwd = 2,
        col = "blue",
        bty='Y',
        cex=1)

rm(example_data, iptw_list, sample_index)


## Example from van der Wal, Willem M., and Ronald B. Geskus. (2011)
#Simulate data with continuous confounder and outcome, binomial exposure.
#Marginal causal effect of exposure on outcome: 10.
n <- 1000
simdat <- data.frame(l = rnorm(n, 10, 5))
a.lin <- simdat$l - 10
pa <- exp(a.lin)/(1 + exp(a.lin))
simdat$a <- rbinom(n, 1, prob = pa)
simdat$y <- 10*simdat$a + 0.5*simdat$l + rnorm(n, -10, 5)
simdat[1:5,]
temp_iptw <- iptw_est(Y = y,
                      treat = a,
                      treat_formula = a ~ l,
                      numerator_formula = a ~ 1,
                      data = simdat,
                      degree = 1,
                      treat_mod = "Binomial",
                      link_function = "logit")


temp_iptw[[1]]  # estimated coefficients
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.

van der Wal, Willem M., and Ronald B. Geskus.
"IPW: an R package for inverse probability weighting."
\emph{Journal of Statistical Software} \bold{43.13} (2011): 1-23.

Robins, James M and Hernan, Miguel Angel and Brumback, Babette.
Marginal structural models and causal inference in epidemiology.
\emph{Epidemiology} \bold{11.5} (2000): 550--560.

Zhu, Yeying and Coffman, Donna L and Ghosh, Debashis.
A Boosting Algorithm for Estimating Generalized Propensity Scores
with Continuous Treatments.
\emph{Journal of Causal Inference} \bold{3.1} (2015): 25--40.
}
\seealso{
\code{\link{iptw_est}}, \code{\link{ismw_est}},
 \code{\link{reg_est}}, \code{\link{aipwee_est}}, \code{\link{wtrg_est}},
   etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

