% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process-optimizer.R
\name{interpret_bounds}
\alias{interpret_bounds}
\title{Convert bounds string to a function}
\usage{
interpret_bounds(bounds, parameters)
}
\arguments{
\item{bounds}{The bounds element as returned by \link{optimize_effect}}

\item{parameters}{Character vector defining parameters, as returned by \link{analyze_graph}}
}
\value{
A function that takes arguments for the parameters, i.e., the observed probabilities and returns a vector of length 2: the lower bound and the upper bound.
}
\description{
Convert bounds string to a function
}
\examples{
b <- graph_from_literal(X -+ Y, Ur -+ X, Ur -+ Y)
V(b)$leftside <- c(0,0,0)
V(b)$latent <- c(0,0,1)
E(b)$rlconnect <- E(b)$edge.monotone <- c(0, 0, 0)
obj <- analyze_graph(b, constraints = NULL, effectt = "p{Y(X = 1) = 1} - p{Y(X = 0) = 1}")
bounds <- optimize_effect(obj)
bounds_func <- interpret_bounds(bounds$bounds, obj$parameters)
bounds_func(.1, .1, .4, .3)
# vectorized
do.call(bounds_func, lapply(1:4, function(i) runif(5)))
}
