% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{cbc_design}
\alias{cbc_design}
\title{Make a random or Bayesian D-efficient choice-based conjoint survey design}
\usage{
cbc_design(
  profiles,
  n_resp,
  n_alts,
  n_q,
  n_blocks = 1,
  n_draws = 50,
  no_choice = FALSE,
  n_start = 5,
  label = NULL,
  priors = NULL,
  prior_no_choice = NULL,
  probs = FALSE,
  method = "CEA",
  max_iter = 50,
  parallel = TRUE
)
}
\arguments{
\item{profiles}{A data frame in which each row is a possible profile.
This can be generated using the \code{cbc_profiles()} function.}

\item{n_resp}{Number of survey respondents.}

\item{n_alts}{Number of alternatives per choice question.}

\item{n_q}{Number of questions per respondent.}

\item{n_blocks}{Number of blocks used in Bayesian D-efficient design.
Max allowable is one block per respondent, defaults to \code{1}, meaning every
respondent sees the same set of choice questions.}

\item{n_draws}{Number of draws used in simulating the prior distribution
used in Bayesian D-efficient designs. Defaults to \code{50}.}

\item{no_choice}{Include a "no choice" option in the choice sets? Defaults
to \code{FALSE}. If \code{TRUE}, the total number of alternatives per question will be
one more than the provided \code{n_alts} argument.}

\item{n_start}{A numeric value indicating the number of random start designs
to use in obtaining a Bayesian D-efficient design. The default is \code{5}.
Increasing \code{n_start} can result in a more efficient design at the expense
of increased computational time.}

\item{label}{The name of the variable to use in a "labeled" design
(also called an "alternative-specific design") such that each set of
alternatives contains one of each of the levels in the \code{label} attribute.
Currently only compatible with randomized designs. If used, the \code{n_alts}
argument will be ignored as its value is defined by the unique number of
levels in the \code{label} variable. Defaults to \code{NULL}.}

\item{priors}{A list of one or more assumed prior parameters used to
generate a Bayesian D-efficient design. If \code{NULL} (the default), a
randomized design will be generated.}

\item{prior_no_choice}{Prior utility value for the "no choice" alternative.
Only required if \code{no_choice = TRUE}. Defaults to \code{NULL}.}

\item{probs}{If \code{TRUE}, for Bayesian D-efficient designs the resulting
design includes average predicted probabilities for each alternative in each
choice set given the sample from the prior preference distribution.
Defaults to \code{FALSE}.}

\item{method}{Which method to use for obtaining a Bayesian D-efficient
design, \code{"CEA"} or \code{"Modfed"}? Defaults to \code{"CEA"}. See \code{?idefix::CEA}
and \code{?idefix::Modfed} for more details.}

\item{max_iter}{A numeric value indicating the maximum number allowed
iterations when searching for a Bayesian D-efficient design. The default is
50.}

\item{parallel}{Logical value indicating whether computations should be done
over multiple cores. The default is \code{TRUE}.}
}
\value{
A data frame containing a choice-based conjoint survey design where
each row is an alternative.
}
\description{
This function creates a data frame containing a choice-based conjoint survey
design where each row is an alternative. Designs can be either a
randomized or Bayesian D-efficient, in which case an implementation of the
CEA or Modfed Federov algorithm is used via the {idefix} package
}
\examples{
library(cbcTools)

# A simple conjoint experiment about apples

# Generate all possible profiles
profiles <- cbc_profiles(
  price     = c(1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5),
  type      = c("Fuji", "Gala", "Honeycrisp"),
  freshness = c('Poor', 'Average', 'Excellent')
)

# Make a randomized survey design
design_rand <- cbc_design(
  profiles = profiles,
  n_resp   = 300, # Number of respondents
  n_alts   = 3,   # Number of alternatives per question
  n_q      = 6    # Number of questions per respondent
)

# Make a randomized survey design with a "no choice" option
design_rand_nochoice <- cbc_design(
  profiles  = profiles,
  n_resp    = 300, # Number of respondents
  n_alts    = 3,   # Number of alternatives per question
  n_q       = 6,   # Number of questions per respondent
  no_choice = TRUE
)

# Make a randomized labeled survey design with each "type" appearing in
# each choice question
design_rand_labeled <- cbc_design(
  profiles  = profiles,
  n_resp    = 300, # Number of respondents
  n_alts    = 3,   # Number of alternatives per question
  n_q       = 6,   # Number of questions per respondent
  label     = "type"
)

# Make a Bayesian D-efficient design with a prior model specified
# Note that by default parallel = TRUE.
design_deff <- cbc_design(
    profiles  = profiles,
    n_resp    = 300, # Number of respondents
    n_alts    = 3,  # Number of alternatives per question
    n_q       = 6,  # Number of questions per respondent
    n_start   = 1,
    priors = list(
        price     = -0.1,
        type      = c(0.1, 0.2),
        freshness = c(0.1, 0.2)
    ),
    parallel = FALSE
)
}
\keyword{design}
\keyword{logit}
\keyword{logitr}
\keyword{mixed}
\keyword{mnl}
\keyword{mxl}
