% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_studies.R
\name{available_patients}
\alias{available_patients}
\title{Get All Patient IDs in a Study}
\usage{
available_patients(study_id = NULL, base_url = NULL)
}
\arguments{
\item{study_id}{A character string indicating which study ID should be searched.
Only 1 study allowed. If NULL, we will guess a default study ID based on your database URL.}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of patient_ids in a given study
}
\description{
Get All Patient IDs in a Study
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
set_cbioportal_db("public")
available_samples(study_id = "acc_tcga")
}
\dontshow{\}) # examplesIf}
}
