% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_database.R
\name{available_profiles}
\alias{available_profiles}
\title{Get Available Genomic Profiles For a Study or Database}
\usage{
available_profiles(study_id = NULL, base_url = NULL)
}
\arguments{
\item{study_id}{A character vector of length 1 indicating study_id.
See \code{get_studies()} to see all available studies for your URL. If \code{NULL}, it will
return all profiles for your current database url}

\item{base_url}{The database URL to query.
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of available genetic profiles and their profile ids
}
\description{
Get Available Genomic Profiles For a Study or Database
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_cbioportal_db("public")
available_profiles()
available_profiles(study_id = "acc_tcga")
\dontshow{\}) # examplesIf}
}
