% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_samples.R
\name{get_clinical_by_sample}
\alias{get_clinical_by_sample}
\title{Get clinical data by attribute, study ID and sample ID}
\usage{
get_clinical_by_sample(
  study_id = NULL,
  sample_id = NULL,
  sample_study_pairs = NULL,
  clinical_attribute = NULL,
  base_url = NULL
)
}
\arguments{
\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{sample_id}{a vector of sample IDs (character)}

\item{sample_study_pairs}{A dataframe with columns: \code{sample_id}, \code{study_id} and \code{molecular_profile_id} (optional). Variations in capitalization of column names are accepted.
This can be used in place of \code{sample_id}, \code{study_id}, \code{molecular_profile_id} arguments above if you
need to pull samples from several different studies at once. If passed this will take overwrite \code{sample_id}, \code{study_id}, \code{molecular_profile_id} if also passed.}

\item{clinical_attribute}{one or more clinical attributes for your study.
If none provided, will return all attributes available for studies}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
a dataframe of a specific clinical attribute
}
\description{
Get clinical data by attribute, study ID and sample ID
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_clinical_by_sample(study_id = "acc_tcga", sample_id = "TCGA-OR-A5J2-01",
 clinical_attribute = "CANCER_TYPE", base_url = 'www.cbioportal.org/api')

ex <- tibble::tribble(
~sample_id, ~study_id,
"P-0001453-T01-IM3", "blca_nmibc_2017",
"P-0002166-T01-IM3", "blca_nmibc_2017",
"P-0003238-T01-IM5", "blca_nmibc_2017",
"P-0000004-T01-IM3", "msk_impact_2017",
"P-0000023-T01-IM3", "msk_impact_2017")

x <- get_clinical_by_sample(sample_study_pairs = ex,
 clinical_attribute = NULL, base_url = 'www.cbioportal.org/api')
\dontshow{\}) # examplesIf}
}
