% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respiratory-condition.R
\name{resp_condition_fun3}
\alias{resp_condition_fun3}
\title{resp_condition_fun3}
\usage{
resp_condition_fun3(DHHGAGE_cont, CCC_091, CCC_91A, CCC_031)
}
\arguments{
\item{DHHGAGE_cont}{continuous age variable.}

\item{CCC_091}{variable indicating if respondent has either COPD or Emphysema}

\item{CCC_91A}{variable indicating if respondent has chronic bronchitis}

\item{CCC_031}{variable indicating if respondent has asthma}
}
\value{
a categorical variable (resp_condition_der) with 3 levels:

 \enumerate{
 \item respondent is over the age of 35 and has a respiratory condition
 \item respondent is under the age of 35 and has a respiratory condition
 \item respondent does not have a respiratory condition
 }
}
\description{
This is one of 3 functions used to create a derived variable
 (resp_condition_der) that determines if a respondents has a respiratory
 condition. This function for CCHS cycles (2001-2003) that use COPD and
 Emphysema as a combined variable, as well as Bronchitis. Asthma is used
 across CCHS cycles as a separate variable.
}
\examples{
# Using resp_condition_fun3() to create values across CCHS cycles
# (2001-2003) resp_condition_fun3() is specified in
# variable_details.csv along with the CCHS variables and cycles included.

# To transform resp_condition_der, use rec_with_table() for each CCHS cycle
# and specify resp_condition_der, along with the various respiratory
# variables. Then by using bind_rows() you can combine resp_condition_der
# across cycles.

library(cchsflow)

resp2001 <- suppressWarnings(rec_with_table(
  cchs2001_p, c(
    "DHHGAGE_cont", "CCC_091", "CCC_91A", "CCC_031",
    "resp_condition_der"
  )
))

head(resp2001)

resp2003 <- suppressWarnings(rec_with_table(
  cchs2003_p,c(
    "DHHGAGE_cont", "CCC_091", "CCC_91A", "CCC_031",
    "resp_condition_der"
  )
))

tail(resp2003)

combined_resp <- suppressWarnings(bind_rows(resp2001, resp2003))

head(combined_resp)
tail(combined_resp)
}
\seealso{
\code{\link{resp_condition_fun1}}, \code{\link{resp_condition_fun2}}
}
