% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{if_else2}
\alias{if_else2}
\title{if_else2}
\usage{
if_else2(x, a, b)
}
\arguments{
\item{x}{A logical argument}

\item{a}{value if `x` is `TRUE`}

\item{b}{value if `x` is `FALSE`}
}
\value{
a or b based on the evaluation of x
}
\description{
Custom ifelse function that evaluates missing (NA) values. If
 the logical argument (x) compares to a value that is `NA`, it is set to
 `FALSE`
}
\details{
unlike the base ifelse() function, if_else2() is able to evaluate NA
 as either a or b. In base ifelse(), anything compared to NA will produce
 NA, which can break a function. When dealing with large datasets like the
 CCHS, there are many missing (NA) values. That means a special ifelse
 function like if_else2() is needed in order for other functions to not break
}
\examples{
age <- 12
status <- if_else2((age < 18), "child", "invalid age")
print(status)

age <- NA
status <- if_else2((age < 18), "child", "invalid age")
print(status)
}
