% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefOps.R, R/LocalOps.R, R/relops.R
\name{rowrecs_to_blocks}
\alias{rowrecs_to_blocks}
\alias{rowrecs_to_blocks.default}
\alias{rowrecs_to_blocks.relop}
\title{Map a data records from row records to block records.}
\usage{
rowrecs_to_blocks(
  wideTable,
  controlTable,
  ...,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  controlTableKeys = colnames(controlTable)[[1]],
  columnsToCopy = NULL,
  tmp_name_source = wrapr::mk_tmp_name_source("rrtbl"),
  temporary = TRUE,
  allow_rqdatatable = FALSE
)

\method{rowrecs_to_blocks}{default}(
  wideTable,
  controlTable,
  ...,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  controlTableKeys = colnames(controlTable)[[1]],
  columnsToCopy = NULL,
  tmp_name_source = wrapr::mk_tmp_name_source("rrtobd"),
  temporary = TRUE,
  allow_rqdatatable = FALSE
)

\method{rowrecs_to_blocks}{relop}(
  wideTable,
  controlTable,
  ...,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  controlTableKeys = colnames(controlTable)[[1]],
  columnsToCopy = NULL,
  tmp_name_source = wrapr::mk_tmp_name_source("rrtbl"),
  temporary = TRUE,
  allow_rqdatatable = FALSE
)
}
\arguments{
\item{wideTable}{data.frame containing data to be mapped (in-memory data.frame).}

\item{controlTable}{table specifying mapping (local data frame).}

\item{...}{force later arguments to be by name.}

\item{checkNames}{logical, if TRUE check names.}

\item{checkKeys}{logical, if TRUE check columnsToCopy form row keys (not a requirement, unless you want to be able to invert the operation).}

\item{strict}{logical, if TRUE check control table name forms.}

\item{controlTableKeys}{character, which column names of the control table are considered to be keys.}

\item{columnsToCopy}{character array of column names to copy.}

\item{tmp_name_source}{a tempNameGenerator from cdata::mk_tmp_name_source()}

\item{temporary}{logical, if TRUE use temporary tables}

\item{allow_rqdatatable}{logical, if TRUE allow rqdatatable shortcutting on simple conversions.}
}
\value{
long table built by mapping wideTable to one row per group
}
\description{
Map a data records from row records (records that are exactly single rows) to block records
(records that may be more than one row).
}
\details{
The controlTable defines the names of each data element in the two notations:
the notation of the tall table (which is row oriented)
and the notation of the wide table (which is column oriented).
controlTable[ , 1] (the group label) cross colnames(controlTable)
(the column labels) are names of data cells in the long form.
controlTable[ , 2:ncol(controlTable)] (column labels)
are names of data cells in the wide form.
To get behavior similar to tidyr::gather/spread one builds the control table
by running an appropriate query over the data.

Some discussion and examples can be found here:
\url{https://winvector.github.io/FluidData/FluidData.html} and
here \url{https://github.com/WinVector/cdata}.

\code{rowrecs_to_blocks.default} will change some factor columns to character, and there
are issues with time columns with different time zones.
}
\examples{

  # un-pivot example
  d <- data.frame(AUC = 0.6, R2 = 0.2)
  cT <- build_unpivot_control(nameForNewKeyColumn= 'meas',
                              nameForNewValueColumn= 'val',
                              columnsToTakeFrom= c('AUC', 'R2'))
  rowrecs_to_blocks(d, cT)



d <- data.frame(AUC = 0.6, R2 = 0.2)
cT <- build_unpivot_control(
  nameForNewKeyColumn= 'meas',
  nameForNewValueColumn= 'val',
  columnsToTakeFrom= c('AUC', 'R2'))

ops <- rquery::local_td(d) \%.>\%
  rowrecs_to_blocks(., cT)
cat(format(ops))

if(requireNamespace("rqdatatable", quietly = TRUE)) {
  library("rqdatatable")
  d \%.>\%
    ops \%.>\%
    print(.)
}

if(requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbWriteTable(db,
                    'd',
                    d,
                    overwrite = TRUE,
                    temporary = TRUE)
  db \%.>\%
    ops \%.>\%
    print(.)
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{build_unpivot_control}}, \code{\link{blocks_to_rowrecs}}
}
