% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCDL.R
\name{getCDL}
\alias{getCDL}
\title{Get CDL raster data}
\usage{
getCDL(x, year, alternativeUrl, location)
}
\arguments{
\item{x}{Is either a two digit state FIPS code, a two letter abbreviation, or
a state name.}

\item{year}{A numerical vector. A set of years of CDL data to download.}

\item{alternativeUrl}{An optional string containing an alternative url.}

\item{location}{An optional string containing a location to store the file.}
}
\value{
A list of CDL raster objects of interested county for a set of years.
}
\description{
\code{getCDL} retrieves CDL state raster objects for a set of years.
}
\examples{
\dontrun{
getCDL(6,c(2013,2015))
getCDL("California",c(2013,2015))
getCDL("CA",c(2013,2015))
}
}

