% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createComparableCDL.R
\name{createComparableCDL}
\alias{createComparableCDL}
\title{Create comparable raster images}
\usage{
createComparableCDL(rasterList, filenames, baseIndex, progress = "")
}
\arguments{
\item{rasterList}{A list of raster images.}

\item{filenames}{An array of file names of raster images to coerce into a raster list, 
if \code{rasterList} is not provided.}

\item{baseIndex}{The index of the raster list element that all other elements will 
match with respect to resolution, projection and extent.}

\item{progress}{A string for the raster progress bar type, default "" is none, 
"text" provides text output, "window" provides a gui window if available.}
}
\value{
A list of raster images matching in extent, resolution, and projection.
}
\description{
\code{createComparableCDL} uses a base index within a raster list, and sets all other
raster images within the list to the same resolution, projection, and extent.  The 
raster function resample is used to tranform raster images, therefore this 
function may be quite slow without tuning.
}
\examples{
\dontrun{
# download multiple years of Iowa Data
r <- getCDL('iowa',c(2006,2010))
# resample based on the 2006
r2 <- createComparableCDL(r,baseIndex=1)
}
}
\author{
Jonathan Lisic, \email{jlisic@gmail.com}
}
