% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missQ.R
\name{missQ}
\alias{missQ}
\title{Introduce random misspecifications in Q-matrix}
\usage{
missQ(Q, qjk, retainJ = 0, Qid = "none", seed = NULL)
}
\arguments{
\item{Q}{A \emph{J} items x \emph{K} attributes Q-matrix (\code{matrix} or \code{data.frame}).}

\item{qjk}{Number (or proportion, if lower than 1) of q-entries to modify in the Q-matrix.}

\item{retainJ}{Number of items to retain (i.e., not modify) in the Q-matrix. It will retain the first \code{retainJ} items. It is useful for assuring the completeness of the misspecified Q-matrix if the first items conform one or more identity matrices. The default is 0.}

\item{Qid}{Assure that the generated Q-matrix is generically identifiable. It includes \code{"none"} (for no identifiability assurance), \code{"DINA"}, \code{"DINO"}, or \code{"others"} (for other CDMs identifiability). The default is \code{"none"}.}

\item{seed}{A seed for obtaining consistent results. If \code{NULL}, no seed is used. The default is \code{NULL}.}
}
\value{
\code{missQ} returns an object of class \code{missQ}.
\describe{
\item{\code{miss.Q}}{The misspecified Q-matrix (\code{matrix}).}
\item{\code{Q}}{The input (true) Q-matrix (\code{matrix}).}
\item{\code{JK}}{Number of items measuring each attribute (\code{vector}).}
\item{\code{Kcor}}{Tetrachoric correlations among the columns (\code{matrix}).}
\item{\code{is.Qid}}{Q-matrix identifiability information (\code{list}).}
\item{\code{specifications}}{Function call specifications (\code{list}).}
}
}
\description{
Introduces random misspecifications in a Q-matrix.
Only binary Q-matrix are supported so far.
Useful for simulation studies.
}
\examples{
Kj <- c(15, 10, 0, 5) # 15 one-att, 10 2-atts, 0 3-atts, and 5 four-atts items
Q <- genQ(J = 30, K = 4, Kj = Kj, Qid = "others", seed = 123)
miss.Q <- missQ(Q = Q$gen.Q, qjk = .20, retainJ = 4, seed = 123)
}
\references{
Xu, G., & Shang, Z. (2018). Identifying latent structures in restricted latent class models. \emph{Journal of the American Statistical Association}, \emph{113}, 1284-1295. https://doi.org/10.1080/01621459.2017.1340889
}
\author{
{Pablo Nájera, Universidad Pontificia Comillas}
}
