% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censobr_cache.R
\name{censobr_cache}
\alias{censobr_cache}
\title{Manage cached files from the censobr package}
\usage{
censobr_cache(list_files = TRUE, delete_file = NULL)
}
\arguments{
\item{list_files}{Logical. Whether to print a message with the address of all
censobr data sets cached locally. Defaults to \code{TRUE}.}

\item{delete_file}{String. The file name (basename) of a censobr data set
cached locally that should be deleted. Defaults to \code{NULL}, so that no
file is deleted. If \code{delete_file = "all"}, then all cached censobr
files are deleted.}
}
\value{
A message indicating which file exist and/or which ones have been
deleted from local cache directory.
}
\description{
Manage cached files from the censobr package
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# list all files cached
censobr_cache(list_files = TRUE)

# delete particular file
censobr_cache(delete_file = '2010_deaths')
\dontshow{\}) # examplesIf}
}
\concept{Cache data}
