% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{ceramic_cache}
\alias{ceramic_cache}
\title{Ceramic file cache}
\usage{
ceramic_cache(force = FALSE)
}
\arguments{
\item{force}{set to \code{TRUE} to create the location without asking the user}
}
\value{
A character vector, the file path location of the cache.
}
\description{
File system location where ceramic stores its cache.
}
\details{
If allowed, the cache will be created at \code{file.path(rappdirs::user_cache_dir(), ".ceramic")},
which corresponds to '~/.cache/.ceramic' for a given user.

If the file cache location does not exist, the user will be asked in interactive mode
for permission. For non-interactive mode use the \code{force} argument.

It is not currently possible to customize the cache location. To clear the cache (completely)
see \code{clear_ceramic_cache()}.
}
\examples{
if (interactive()) {
 ceramic_cache()
}
}
