% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cernn.r
\name{cernn}
\alias{cernn}
\title{Compute the regularization path for Covariance Estimate Regularized by Nuclear Norms (CERNN)}
\usage{
cernn(X, lambda, alpha)
}
\arguments{
\item{X}{The data matrix whose rows are observations and columns are covariates.}

\item{lambda}{vector of regularization parameters controling amount of shrinkage towards the target.}

\item{alpha}{Parameter that controls mixture between the trace and inverse trace penalties.}
}
\description{
\code{cernn} performs stable covariance estimation over a grid of regularization parameters.
}
\examples{
n <- 10
p <- 5
set.seed(12345)
X <- matrix(rnorm(n*p),n,p)
alpha <- get_alpha(X)
lambda <- 10**(seq(-1,4,length.out=100))
sol_path <- cernn(X,lambda,alpha)
df <- t(sol_path$e)

## Plot regularization paths of eigenvalues
matplot(x=log10(lambda),y=df,type='l',ylab='shrunken eigenvalue')
grand_mean <- (norm(scale(X,center=TRUE,scale=FALSE),'f')**2)/(n*p)
abline(h=grand_mean)
}
\references{
Eric C. Chi and Kenneth Lange, Stable estimation of a covariance matrix guided by nuclear norm penalties,
Computational Statistics and Data Analysis, 80:117-128, 2014.
}
\seealso{
\code{get_alpha}, \code{shrink_eigen}, \code{select_lambda}
}

