% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_profiles.R
\name{calculate_profiles}
\alias{calculate_profiles}
\title{Calculate Ceteris Paribus Profiles}
\usage{
calculate_profiles(
  data,
  variable_splits,
  model,
  predict_function = predict,
  ...
)
}
\arguments{
\item{data}{set of observations. Profile will be calculated for every observation (every row)}

\item{variable_splits}{named list of vectors. Elements of the list are vectors with points in which profiles should be calculated. See an example for more details.}

\item{model}{a model that will be passed to the \code{predict_function}}

\item{predict_function}{function that takes data and model and returns numeric predictions. Note that the ... arguments will be passed to this function.}

\item{...}{other parameters that will be passed to the \code{predict_function}}
}
\value{
a data frame with profiles for selected variables and selected observations
}
\description{
This function calculates ceteris paribus profiles, i.e. series of predictions from a model calculated for observations with altered single coordinate.
}
\details{
Note that \code{calculate_profiles} function is S3 generic.
If you want to work on non standard data sources (like H2O ddf, external databases)
you should overload it.
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
                                      no.rooms + district, data = apartments)
vars <- c("construction.year", "surface", "floor", "no.rooms", "district")
variable_splits <- calculate_variable_splits(apartments, vars)
new_apartment <- apartmentsTest[1:10, ]
profiles <- calculate_profiles(new_apartment, variable_splits,
                               apartments_rf_model)
profiles

# only subset of observations
small_apartments <- select_sample(apartmentsTest, n = 10)
small_apartments
small_profiles <- calculate_profiles(small_apartments, variable_splits,
                               apartments_rf_model)
small_profiles

# neighbors for a selected observation
new_apartment <- apartments[1, 2:6]
small_apartments <- select_neighbours(apartmentsTest, new_apartment, n = 10)
small_apartments
small_profiles <- calculate_profiles(small_apartments, variable_splits,
                               apartments_rf_model)
new_apartment
small_profiles
}
}
