% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_ppa_teams}
\alias{cfbd_metrics_ppa_teams}
\title{\strong{Get team averages for predicted points added (PPA)}}
\usage{
cfbd_metrics_ppa_teams(
  year = NULL,
  team = NULL,
  conference = NULL,
  excl_garbage_time = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference name - select a valid FBS conference
Conference names P5: ACC,  Big 12, Big Ten, SEC, Pac-12
Conference names G5 and FBS Independents: Conference USA, Mid-American, Mountain West, FBS Independents, American Athletic}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE or FALSE)}
}
\value{
\code{\link[=cfbd_metrics_ppa_teams]{cfbd_metrics_ppa_teams()}} - A data frame with 21 variables:
\describe{
\item{\code{season}: integer.}{.}
\item{\code{conference}: character.}{.}
\item{\code{team}: character.}{.}
\item{\code{off_overall}: character.}{Offense overall predicted points added (PPA).}
\item{\code{off_passing}: character.}{Offense passing predicted points added (PPA).}
\item{\code{off_rushing}: character.}{Offense rushing predicted points added (PPA).}
\item{\code{off_first_down}: character.}{Offense 1st down predicted points added (PPA).}
\item{\code{off_second_down}: character.}{Offense 2nd down predicted points added (PPA).}
\item{\code{off_third_down}: character.}{Offense 3rd down predicted points added (PPA).}
\item{\code{off_cumulative_total}: character.}{Offense cumulative total predicted points added (PPA).}
\item{\code{off_cumulative_passing}: character.}{Offense cumulative total passing predicted points added (PPA).}
\item{\code{off_cumulative_rushing}: character.}{Offense cumulative total rushing predicted points added (PPA).}
\item{\code{def_overall}: character.}{Defense overall predicted points added (PPA).}
\item{\code{def_passing}: character.}{Defense passing predicted points added (PPA).}
\item{\code{def_rushing}: character.}{Defense rushing predicted points added (PPA).}
\item{\code{def_first_down}: character.}{Defense 1st down predicted points added (PPA).}
\item{\code{def_second_down}: character.}{Defense 2nd down predicted points added (PPA).}
\item{\code{def_third_down}: character.}{Defense 3rd down predicted points added (PPA).}
\item{\code{def_cumulative_total}: character.}{Defense cumulative total predicted points added (PPA).}
\item{\code{def_cumulative_passing}: character.}{Defense cumulative total passing predicted points added (PPA).}
\item{\code{def_cumulative_rushing}: character.}{Defense cumulative total rushing predicted points added (PPA).}
}
}
\description{
\strong{Get team averages for predicted points added (PPA)}
}
\examples{
\donttest{
  try(cfbd_metrics_ppa_teams(year = 2019, team = "TCU"))
}
}
\keyword{Points}
\keyword{Predicted}
\keyword{Teams}
