% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edges.R
\name{exteriorEdges}
\alias{exteriorEdges}
\title{Exterior edges of a mesh}
\usage{
exteriorEdges(edgesDF, angleThreshold = 1)
}
\arguments{
\item{edgesDF}{the dataframe returned by the \code{edges} method of 
\code{\link{cgalMesh}}}

\item{angleThreshold}{maximum deviation in degrees from the flat angle; for 
example if \code{angleThreshold=1}, then an edge is considered as exterior 
if its corresponding dihedral angle is lower than 179 or higher than 181}
}
\value{
An integer matrix giving the vertex indices of the exterior edges.
}
\description{
Returns the edges of a mesh whose corresponding dihedral angles 
  are not too flat.
}
\note{
Once you get the exterior edges, say in \code{extEdges}, then you can 
  get the indices of the exterior vertices with 
  \code{which(table(extEdges) != 2)}.
}
\examples{
library(cgalMeshes)
library(rgl)
mesh <- cgalMesh$new(dodecahedron3d())
extEdges <- exteriorEdges(mesh$getEdges())
vertices <- mesh$getVertices()
open3d(windowRect = 50 + c(0, 0, 512, 512), zoom = 0.9)
shade3d(dodecahedron3d(), color = "tomato")
plotEdges(vertices, extEdges)
}
