% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatLLM.R
\name{call_llm}
\alias{call_llm}
\title{Call a Large Language Model with optional retries & extra parameters}
\usage{
call_llm(
  prompt = NULL,
  messages = NULL,
  provider = c("openai", "groq", "anthropic"),
  model = NULL,
  temperature = 0.7,
  max_tokens = 1000,
  api_key = NULL,
  n_tries = 3,
  backoff = 2,
  endpoint_url = NULL,
  ...,
  .post_func = httr::POST
)
}
\arguments{
\item{prompt}{(character) A single user prompt. If `messages` provided, prompt
is appended as a user message (optional).}

\item{messages}{(list) A list of message objects, each a list(role, content).}

\item{provider}{(character) One of "openai", "groq", or "anthropic".}

\item{model}{(character) The model name. Defaults to a known model per provider.}

\item{temperature}{(numeric) Sampling temperature (0 to ~2).}

\item{max_tokens}{(integer) Maximum number of tokens to generate.}

\item{api_key}{(character) An API key. If NULL, uses the environment variable.}

\item{n_tries}{(integer) Number of attempts for retry on failure.}

\item{backoff}{(numeric) Seconds to wait between retries.}

\item{endpoint_url}{(character) Base URL for the provider. If NULL,
uses a default for the given provider.}

\item{...}{Additional parameters appended to the request body.}

\item{.post_func}{(function) (Internal) Function to perform POST requests.
Defaults to \code{httr::POST}.}
}
\value{
(character) The text completion from the chosen model.
}
\description{
Call a Large Language Model with optional retries & extra parameters
}
\examples{
\dontrun{
response <- call_llm(
  prompt = "Hello, how are you?",
  provider = "openai",
  max_tokens = 50,
  n_tries = 3,
  backoff = 2
)
cat(response)

conv <- list(
  list(role = "system", content = "You are a helpful assistant."),
  list(role = "user",   content = "Explain recursion in R.")
)
response <- call_llm(
  messages = conv,
  provider = "openai",
  max_tokens = 200,
  presence_penalty = 0.2,
  frequency_penalty = 0.1,
  top_p = 0.95,
  stop = c("###")
)
cat(response)
}
}
