% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkSubset}
\alias{assertSubset}
\alias{checkSubset}
\alias{testSubset}
\title{Check if object is a subset of a given set}
\usage{
checkSubset(x, choices, empty.ok = TRUE)

assertSubset(x, choices, empty.ok = TRUE, .var.name)

testSubset(x, choices, empty.ok = TRUE)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{choices}{[\code{atomic}]\cr
Set of possible values.}

\item{empty.ok}{[\code{logical(1)}]\cr
Treat zero-length \code{x} as subset of any set \code{choices}?
Default is \code{TRUE}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertSubset} throws an error message,
 \code{testSubset} returns \code{FALSE} and \code{checkSubset} returns
 a string with the error message.
}
\description{
Check if object is a subset of a given set
}
\examples{
testSubset(c("a", "z"), letters)
 testSubset("ab", letters)
}
\seealso{
Other set: \code{\link{assertChoice}},
  \code{\link{checkChoice}}, \code{\link{testChoice}};
  \code{\link{assertSetEqual}},
  \code{\link{checkSetEqual}}, \code{\link{testSetEqual}}
}

