% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeAssertion.r
\name{makeAssertion}
\alias{makeAssertion}
\alias{makeAssertionFunction}
\title{Turn a Check into an Assertion}
\usage{
makeAssertion(x, res, var.name, collection)

makeAssertionFunction(check.fun, env = parent.frame())
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{res}{[\code{TRUE} | \code{character(1)}]\cr
The result of a check function: \code{TRUE} for successful checks,
and an error message as string otherwise.}

\item{var.name}{[\code{character(1)}]\cr
The custom name for \code{x} as passed to any \code{assert*} function.}

\item{collection}{[\code{\link{AssertCollection}}]\cr
If an \code{\link{AssertCollection}} is provided, the error message is stored
in it. If \code{NULL} (default), an exception is raised if \code{res} is not
\code{TRUE}.}

\item{check.fun}{[\code{function}]\cr
Function which checks the input. Must return \code{TRUE} on success and a string with the error message otherwise.}

\item{env}{[\code{environment}]\cr
The environment of the created function. Default is the \code{\link[base]{parent.frame}}.}
}
\value{
\code{makeAssertion} invisibly returns the checked object if the check was successful,
 and an exception is raised (or its message stored in the collection) otherwise.
 \code{makeAssertionFunction} returns a \code{function}.
}
\description{
\code{makeAssertion} is the internal function used to evaluate the result of a
check and throw an exception if necessary.
\code{makeAssertionFunction} can be used to automatically create an assertion
function based on a check function (see example).
}
\examples{
# Simple custom check function
checkFalse = function(x) if (!identical(x, FALSE)) "Must be FALSE" else TRUE

# Create the respective assert function
assertFalse = function(x, add = NULL, .var.name) {
  res = checkFalse(x)
  makeAssertion(x, res, .var.name, add)
}

# Alternative: Automatically create such a function
assertFalse = makeAssertionFunction(checkFalse)
print(assertFalse)
}

