% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInteger.R
\name{checkInteger}
\alias{checkInteger}
\alias{check_integer}
\alias{assertInteger}
\alias{assert_integer}
\alias{testInteger}
\alias{test_integer}
\alias{expect_integer}
\title{Check if an argument is vector of type integer}
\usage{
checkInteger(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, sorted = FALSE, names = NULL, null.ok = FALSE)

check_integer(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, sorted = FALSE, names = NULL, null.ok = FALSE)

assertInteger(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, sorted = FALSE, names = NULL, null.ok = FALSE,
  .var.name = vname(x), add = NULL)

assert_integer(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, sorted = FALSE, names = NULL, null.ok = FALSE,
  .var.name = vname(x), add = NULL)

testInteger(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, sorted = FALSE, names = NULL, null.ok = FALSE)

test_integer(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, sorted = FALSE, names = NULL, null.ok = FALSE)

expect_integer(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, sorted = FALSE, names = NULL, null.ok = FALSE,
  info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{sorted}{[\code{logical(1)}]\cr
Elements must be sorted in ascending order. Missing values are ignored.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertInteger}/\code{assert_integer} return 
 \code{x} invisibly, whereas
 \code{checkInteger}/\code{check_integer} and 
 \code{testInteger}/\code{test_integer} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertInteger}/\code{assert_integer}
 throws an error message, 
 \code{testInteger}/\code{test_integer}
 returns \code{FALSE},
 and \code{checkInteger} returns a string with the error message.
 The function \code{expect_integer} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is vector of type integer
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testInteger(1L)
testInteger(1.)
testInteger(1:2, lower = 1, upper = 2, any.missing = FALSE)
}
\seealso{
\code{\link{asInteger}}

Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDate}}, \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNull}}, \code{\link{checkNumeric}},
  \code{\link{checkVector}}
}
