% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-type.R
\name{chk_type}
\alias{chk_type}
\alias{chk_s3_class}
\alias{vld_s3_class}
\alias{chk_s4_class}
\alias{vld_s4_class}
\alias{chk_whole_numeric}
\alias{vld_whole_numeric}
\alias{chk_list}
\alias{vld_list}
\alias{chk_function}
\alias{vld_function}
\alias{chk_vector}
\alias{vld_vector}
\alias{chk_scalar}
\alias{vld_scalar}
\title{Check Type}
\usage{
chk_s3_class(x, class, x_name = NULL)

vld_s3_class(x, class)

chk_s4_class(x, class, x_name = NULL)

vld_s4_class(x, class)

chk_whole_numeric(x, x_name = NULL)

vld_whole_numeric(x)

chk_list(x, x_name = NULL)

vld_list(x)

chk_function(x, formals = NULL, x_name = NULL)

vld_function(x, formals = NULL)

chk_vector(x, x_name = NULL)

vld_vector(x)

chk_scalar(x, x_name = NULL)

vld_scalar(x)
}
\arguments{
\item{x}{The object to check.}

\item{class}{A string specifying the class.}

\item{x_name}{A string of the name of object x or NULL.}

\item{formals}{A count of the number of formal arguments.}
}
\value{
The \code{chk_} functions throw an informative error if the test fails.
The \code{vld_} functions return a flag indicating whether the test was met.
}
\description{
Checks if is a particular type of object.
}
\section{Functions}{
\itemize{
\item \code{chk_s3_class}: Check Inherits from S3 Class

Checks inherits from S3 class using \code{vld_s3_class()}.

Class should be a string.

\item \code{vld_s3_class}: Validate Inherits from S3 Class

Validates inherits from S3 class using

\code{!isS4(x) && inherits(x, class)}

Class should be a string.

\item \code{chk_s4_class}: Check Inherits from S4 Class

Checks inherits from S4 class using \code{vld_s4_class()}.

Class should be a string.

\item \code{vld_s4_class}: Validate Inherits from S4 Class

Validates inherits from S4 class using

\code{isS4(x) && methods::is(x, class)}

Class should be a string.

\item \code{chk_whole_numeric}: Check Whole Numeric

Checks if integer vector or double equivalent using \code{vld_whole_numeric()}.

The \code{\link[=chk_whole_number]{chk_whole_number()}} function checks if
non-missing integer scalar or double equivalent.

\item \code{vld_whole_numeric}: Validate Whole Numeric

Validates integer vector or double equivalent using

\code{is.integer(x) || (is.double(x) && vld_true(all.equal(x, as.integer(x))))}

\item \code{chk_list}: Check List

Checks if is a list using
\code{vld_list()}.

\item \code{vld_list}: Validate List

Validates is a list using

\code{is.list(x)}

\item \code{chk_function}: Check Function

Checks if is a function using \code{vld_function()}.

\item \code{vld_function}: Validate Function

Validates is a function using:

\code{is.function(x) && (is.null(formals) || length(formals(x)) == formals)}

\item \code{chk_vector}: Check Vector

Checks if is a vector using \code{is.vector()}.

\item \code{vld_vector}: Validate Vector

Validates is a vector using:

\code{is.vector(x)}

\item \code{chk_scalar}: Check Scalar

Checks if is a vector using \code{length(x) == 1L}.

\item \code{vld_scalar}: Validate Scalar

Validates is \code{length(x) == 1L}.
}}

\examples{

# chk_s3_class
chk_s3_class(1, "numeric")
try(chk_s3_class(getClass("MethodDefinition"), "classRepresentation"))

# vld_s3_class
vld_s3_class(numeric(0), "numeric")
vld_s3_class(getClass("MethodDefinition"), "classRepresentation")

# chk_s4_class
try(chk_s4_class(1, "numeric"))
chk_s4_class(getClass("MethodDefinition"), "classRepresentation")

# vld_s4_class
vld_s4_class(numeric(0), "numeric")
vld_s4_class(getClass("MethodDefinition"), "classRepresentation")

# chk_whole_numeric
chk_whole_numeric(1)
try(chk_whole_numeric(1.1))

# vld_whole_numeric
vld_whole_numeric(1)
vld_whole_numeric(NA_real_)
vld_whole_numeric(1:2)
vld_whole_numeric(double(0))
vld_whole_numeric(TRUE)
vld_whole_numeric(1.5)

# chk_list
chk_list(list())
try(chk_list(1))

# vld_list
vld_list(list())
vld_list(list(x = 1))
vld_list(mtcars)
vld_list(1)
vld_list(NULL)

# chk_function
chk_function(mean)
try(chk_function(1))

# vld_function
vld_function(mean)
vld_function(function(x) x)
vld_function(1)
vld_function(list(1))

# chk_vector
chk_vector(1)
chk_vector(list())
try(chk_vector(matrix(1)))

# vld_vector
vld_vector(1)

# chk_scalar
chk_scalar(1)
chk_scalar(list(1))
try(chk_scalar(1:2))

# vld_scalar
vld_scalar(1)
}
\seealso{
\code{\link[=isS4]{isS4()}}

\code{\link[=inherits]{inherits()}}

\code{\link[=isS4]{isS4()}}

\code{\link[=inherits]{inherits()}}

\code{\link[methods:is]{methods::is()}}

\code{\link[=is.list]{is.list()}}

\code{\link[=is.function]{is.function()}}

\code{\link[=formals]{formals()}}

\code{\link[=is.vector]{is.vector()}}
}
