% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-all-equivalent.R
\name{chk_all_equivalent}
\alias{chk_all_equivalent}
\alias{vld_all_equivalent}
\title{Check All Equivalent}
\usage{
chk_all_equivalent(x, tolerance = sqrt(.Machine$double.eps), x_name = NULL)

vld_all_equivalent(x, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{The object to check.}

\item{tolerance}{A non-negative numeric scalar.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks all elements in x equivalent using

\code{length(x) < 2L || all(vapply(x, vld_equivalent, TRUE, y = x[[1]], tolerance = tolerance))}
}
\section{Functions}{
\itemize{
\item \code{vld_all_equivalent}: Validate All Equivalent
}}

\examples{

# chk_all_equivalent
chk_all_equivalent(c(1, 1.00000001))
try(chk_all_equivalent(c(1, 1.0000001)))
chk_all_equivalent(list(c(x = 1), c(x = 1)))
chk_all_equivalent(list(c(x = 1), c(y = 1)))

# vld_all_equivalent
vld_all_equivalent(c(x = 1, y = 1))
}
\seealso{
Other chk_alls: 
\code{\link{chk_all_equal}()},
\code{\link{chk_all_identical}()},
\code{\link{chk_all}()}
}
\concept{chk_alls}
