% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-gt.R
\name{chk_gt}
\alias{chk_gt}
\alias{vld_gt}
\title{Check Greater Than}
\usage{
chk_gt(x, value = 0, x_name = NULL)

vld_gt(x, value = 0)
}
\arguments{
\item{x}{The object to check.}

\item{value}{A non-missing scalar of a value.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all non-missing values are greater than value using

\code{all(x[!is.na(x)] > value)}
}
\section{Functions}{
\itemize{
\item \code{vld_gt}: Validate Greater Than
}}

\examples{

# chk_gt
chk_gt(0.1)
try(chk_gt(c(0.1, -0.2)))

# vld_gt
vld_gt(numeric(0))
vld_gt(0)
vld_gt(0.1)
vld_gt(c(0.1, 0.2, NA))
vld_gt(c(0.1, -0.2))
vld_gt(c(-0.1, 0.2), value = -1)
vld_gt("b", value = "a")
}
\seealso{
Other chk_ranges: 
\code{\link{chk_gte}()},
\code{\link{chk_lte}()},
\code{\link{chk_lt}()},
\code{\link{chk_range}()}
}
\concept{chk_ranges}
