% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-double.R
\name{chk_double}
\alias{chk_double}
\alias{vld_double}
\title{Check Double}
\usage{
chk_double(x, x_name = NULL)

vld_double(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if double using

\code{is.double(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_double}: Validate Double
}}

\examples{
# chk_double
chk_double(1)
try(chk_double(1L))
# vld_double
vld_double(1)
vld_double(matrix(c(1, 2, 3, 4), nrow = 2L))
vld_double(double(0))
vld_double(numeric(0))
vld_double(NA_real_)
vld_double(1L)
vld_double(TRUE)
}
\seealso{
Other chk_typeof: 
\code{\link{chk_character_or_factor}()},
\code{\link{chk_character}()},
\code{\link{chk_count}()},
\code{\link{chk_environment}()},
\code{\link{chk_factor}()},
\code{\link{chk_integer}()},
\code{\link{chk_list}()},
\code{\link{chk_logical}()}
}
\concept{chk_typeof}
