% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err.R
\name{err}
\alias{err}
\alias{wrn}
\alias{msg}
\title{Stop, Warning and Message Messages}
\usage{
err(..., n = NULL, tidy = TRUE, .subclass = NULL, call = rlang::caller_call(3))

wrn(..., n = NULL, tidy = TRUE, .subclass = NULL)

msg(..., n = NULL, tidy = TRUE, .subclass = NULL)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or a single
    condition object.}

\item{n}{The value of n for converting \code{sprintf}-like types.}

\item{tidy}{A flag specifying whether capitalize the first character and add a missing period.}

\item{.subclass}{A string of the class of the error message.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\description{
The functions call \code{\link[=message_chk]{message_chk()}} to process
the message and then
\code{\link[rlang:abort]{rlang::abort()}}, \code{\link[rlang:abort]{rlang::warn()}} and
\code{\link[rlang:abort]{rlang::inform()}}, respectively.
}
\details{
The user can set the subclass.
}
\section{Functions}{
\itemize{
\item \code{err()}: Error

\item \code{wrn()}: Warning

\item \code{msg()}: Message

}}
\examples{

# err
try(err("there \%r \%n problem value\%s", n = 2))

# wrn
wrn("there \%r \%n problem value\%s", n = 2)

# msg
msg("there \%r \%n problem value\%s", n = 2)
}
