% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addVoronoi.R
\name{addVoronoi}
\alias{addVoronoi}
\title{Add Voronoi cells.}
\usage{
addVoronoi(pump.select = NULL, vestry = FALSE, case.location = "nominal",
  color = "black", line.type = "solid", line.width = 1,
  latlong = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Default is NULL; all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}. Exclusion (negative selection) is possible (e.g., -6).}

\item{vestry}{Logical. \code{FALSE} for original 13 pumps. TRUE for 14 pumps in Vestry Report.}

\item{case.location}{Character. For \code{observed = FALSE}: "address" or "nominal". "nominal" is the x-y coordinates of \code{regular.cases}.}

\item{color}{Character. Color of cell edges.}

\item{line.type}{Character. Type of line for cell edges: lty.}

\item{line.width}{Numeric. Width of cell edges: lwd.}

\item{latlong}{Logical. Use estimated longitude and latitude.}
}
\description{
Add Voronoi cells.
}
\note{
This function uses \code{deldir::deldir()}.
}
\examples{
snowMap()
# addVoronoi()
}
