% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_chroms.R
\name{load_chroms}
\alias{load_chroms}
\title{Import chromatograms.}
\usage{
load_chroms(
  paths,
  find_files = TRUE,
  format.in = c("csv", "chemstation", "masshunter"),
  sep = ",",
  dat = NULL,
  ...
)
}
\arguments{
\item{paths}{Path(s) to chromatograms or the folders containing the files}

\item{find_files}{Logical. Set to \code{TRUE} (default) if you are providing
the function with a folder or vector of folders containing the files.
Otherwise, set to\code{FALSE}.}

\item{format.in}{Format of files.}

\item{sep}{Argument provided to \code{read.csv}. Defaults to ",".}

\item{dat}{Optional list of chromatograms. If provided, newly imported
chromatograms will be appended to the existing list.}

\item{...}{Additional arguments to \code{\link{read.csv}}.}
}
\value{
A list of chromatograms in matrix format.
}
\description{
Convenience function to import chromatograms from a list of folders or paths.
}
\details{
Chromatograms may be CSVs, ChemStation \code{.uv} files, or MassHunter \code{
.sp} files. Parsers from the \href{https://github.com/bovee/Aston}{Aston}
package for python are used to load binary files.
}
\note{
Relies on the file parsers from the
\href{https://github.com/bovee/aston}{Aston} package to import ChemStation
\code{.uv} and MassHunter \code{.sp} files.
}
\examples{
\dontrun{
###  import from single folder
dat <- load_chromes(paths = path)
### import from multiple folders
path = 'foo'
folders <- list.files(path = path, pattern = "EXPORT3D")
dat <- load_chroms(folders)
}
}
\author{
Ethan Bass
}
