% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{SpatialStack-class}
\alias{SpatialStack-class}
\alias{SpatialStack}
\title{Stack of Spatial Objects}
\arguments{
\item{Spatials}{A \code{list} of Spatial objects or a \code{character} vector of file names identifying items for readOGR, in case the rgdal package is installed..}

\item{proj4string}{A \code{\link[sp]{CRS}}-class object.}

\item{verbose}{A \code{logical} value. Same as for \code{array}, creates \code{proxy} procedurally.}
}
\value{
A \code{SpatialStack} class object.
}
\description{
Vector data in the same CRS organized into a vector.
}
\details{
The class implements a stack of vector data that mimic \code{\link[raster:Raster-classes]{RasterStack}}-class objects, only with vector data. 
Classes, such as \code{link[sp]{SpatialPoints}}, \code{link[sp]{SpatialPointsDataFrame}}, \code{link[sp]{SpatialLines}}, \code{link[sp]{SpatialLinesDataFrame}},
\code{link[sp]{SpatialPolygons}} and \code{link[sp]{SpatialPolygonsDataFrame}} can be concatenated to a vector/list, where elements can be accessed
using list-type subsetting. The only restriction is that the items must share the same \code{\link[sp]{CRS}}. 

The class has two slots:
Spatials: List of Spatial items.
CRS: The coordinate reference system (\code{\link[sp]{CRS}}). 
bbox: The bounding box of all items.
}
