% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{HPEA}
\alias{HPEA}
\title{HPEA}
\usage{
HPEA(genes, geneset, background.genes.size)
}
\arguments{
\item{genes}{DA gene names to be checked if they are over-represented or not.}

\item{geneset}{Pathways to be used in enrichment analyses. If not set vp2008 (Chaussabel, 2008)
immune modules will be used. This can be set to any geneset using `read.gmt` function from `qusage`
package. Different modules are available: https://www.gsea-msigdb.org/gsea/downloads.jsp.}

\item{background.genes.size}{number of background genes for hyper-geometric p-value
calculations. Default is 20,000.}
}
\value{
data.frame, list of pathways and their enrichment (adjusted) p-values.
}
\description{
Hyper-geometric p-value enrichment analyses, looking for over-representation of a set of genes on given pathways.
}
\examples{
\donttest{
library(cinaR)

data("VP2008")
genes.to.test <- vp2008[[1]][1:10]
HPEA(genes.to.test,vp2008, background.genes.size = 20e3)
}

}
