% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pava.r
\name{oldPAVA}
\alias{oldPAVA}
\title{Returns standard isotonic-regression estimate, with flexible dose-response input}
\usage{
oldPAVA(
  y,
  x = NULL,
  wt = rep(1, length(x)),
  outx = NULL,
  full = FALSE,
  dec = FALSE,
  adaptiveShrink = FALSE,
  ...
)
}
\arguments{
\item{y}{can be either of the following: y values (response rates), a 2-column matrix with positive/negative response counts by dose, a \code{\link{DRtrace}} object or a \code{\link{doseResponse}} object.}

\item{x}{dose levels (if not included in y). Note that the PAV algorithm doesn't really use them.}

\item{wt}{weights (if not included in y).}

\item{outx}{vector of x values for which predictions will be made. If \code{NULL} (default), this will be set to the set of unique values in the x argument (or equivalently in y$x). Non-NULL inputs are relevant only if \code{full=TRUE}.}

\item{full}{logical, is a more complete output desired? if \code{FALSE} (default), only a vector of point estimates for y at the provided dose levels is returned}

\item{dec}{logical, is the true function is assumed to be monotone decreasing? Default \code{FALSE}.}

\item{adaptiveShrink}{logical, should the y-values be pre-shrunk towards an experimental target? May be relevant if data were obtain via an adaptive dose-finding design. See \code{\link{DRshrink}}.}

\item{...}{Other arguments passed on to the constructor functions that pre-process the input.}
}
\value{
under default, returns a vector of y estimates at unique x values. With \code{full=TRUE}, returns a list of 3 \code{\link{doseResponse}} objects named \code{output,input,shrinkage} for the output data at dose levels, the input data, and the function as fit at algorithm-generated points, respectively. For this function, the first and third objects are identical.
}
\description{
Nonparametric forward point estimation of a monotone response (y), using the standard isotonic-regression pool-adjacent-violators algorithm (PAVA). Core code from Raubertas (1994) with many modifications.
}
\details{
Compute the isotonic regression of a numeric vector 'y', with
 weights 'wt', with respect to simple order. The core algorithm is still the one
coded by R.F. Raubertas, dated 02 Sep 1994. However, the input and output modules have been
modified to allow more flexible formats in either direction.
note that unlike centered-isotonic-regression (CIR, see \code{\link{cirPAVA}}), this algorithm does not use the dose (x) values at all. For a discussion why CIR is preferred over "plain-vanilla" PAVA, see Oron and Flournoy (2017).
}
\references{
Oron, A.P. and Flournoy, N., 2017. Centered Isotonic Regression: Point and Interval Estimation for Dose-Response Studies. Statistics in Biopharmaceutical Research, In Press (author's public version available on arxiv.org).
}
\seealso{
\code{\link{cirPAVA}}
}
\author{
C.R. Raubertas, Assaf P. Oron \code{<aoron.at.idmod.org>}
}
