% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{templates_list_reports}
\alias{templates_list_reports}
\title{List Report Templates}
\usage{
templates_list_reports(hidden = NULL, category = NULL, limit = NULL,
  page_num = NULL, order = NULL, order_dir = NULL)
}
\arguments{
\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{category}{string optional. A category to filter results by, one of: dataset-viz}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to name. Must be one of: name, updated_at, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, }
\item{name}{string, The name of the template.}
\item{category}{string, The category of this report template.  Can be left blank.  Acceptable values are: dataset-viz}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{useCount}{integer, The number of uses of this template.}
\item{archived}{boolean, Whether the template has been archived.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{techReviewed}{boolean, Whether this template has been audited by Civis for security vulnerability and correctness.}
}
\description{
List Report Templates
}
