% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{templates_post_scripts}
\alias{templates_post_scripts}
\title{Create a Script Template}
\usage{
templates_post_scripts(script_id, name, note = NULL, ui_report_id = NULL,
  archived = NULL, hidden = NULL)
}
\arguments{
\item{script_id}{integer required. The id of the script that this template uses.}

\item{name}{string required. The name of the template.}

\item{note}{string optional. A note describing what this template is used for; custom scripts created off this template will display this description.}

\item{ui_report_id}{integer optional. The id of the report that this template uses.}

\item{archived}{boolean optional. Whether the template has been archived.}

\item{hidden}{boolean optional. The hidden status of the item.}
}
\value{
A list containing the following elements:
\item{id}{integer, }
\item{scriptId}{integer, The id of the script that this template uses.}
\item{userContext}{string, The user context of the script that this template uses.}
\item{name}{string, The name of the template.}
\item{category}{string, The category of this template.}
\item{note}{string, A note describing what this template is used for; custom scripts created off this template will display this description.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{useCount}{integer, The number of uses of this template.}
\item{uiReportId}{integer, The id of the report that this template uses.}
\item{techReviewed}{boolean, Whether this template has been audited by Civis for security vulnerability and correctness.}
\item{archived}{boolean, Whether the template has been archived.}
\item{hidden}{boolean, The hidden status of the item.}
}
\description{
Create a Script Template
}
