% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_list_workers_queued_jobs}
\alias{clusters_list_workers_queued_jobs}
\title{List Queued Jobs for a Worker Cluster}
\usage{
clusters_list_workers_queued_jobs(id)
}
\arguments{
\item{id}{integer required. The ID of this cluster.}
}
\value{
A list containing the following elements:
\item{id}{integer, }
\item{name}{string, }
\item{type}{string, }
\item{fromTemplateId}{integer, }
\item{state}{string, Whether the job is idle, queued, running, cancelled, or failed.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{runs}{array, An array containing the following fields: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{hidden}{boolean, The hidden status of the item.}
\item{requiredCpu}{integer, The CPU shares required by the script.}
\item{requiredDiskSpace}{integer, The disk space in GB required by the script.}
\item{requiredMemory}{integer, The memory in MB required by the script.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
}
\description{
List Queued Jobs for a Worker Cluster
}
