% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{reports_list_snapshots}
\alias{reports_list_snapshots}
\title{Get details about the report's snapshot automation settings}
\usage{
reports_list_snapshots(id)
}
\arguments{
\item{id}{integer required. The ID of this report.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this report.}
\item{state}{string, The status of the job's last run.}
\item{finishedAt}{string, The time that the job's last run finished.}
\item{sendEmailOnCompletion}{boolean, Whether the job will send emails on completion.}
\item{emailTemplate}{string, Custom email template.}
\item{recipientEmailAddresses}{string, Email addresses to send report to, comma separated.}
\item{emailSubject}{string, Subject for Email.}
\item{height}{integer, The height of the cropped snapshot image in screen pixels. The default value is 900 pixels. Minimum value is 600 pixels.}
\item{width}{integer, The width of the cropped snapshot image in screen pixels. The default value is 1440 pixels. Minimum value is 600 pixels.}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{parentId}{integer, The ID of the parent job that will trigger this snapshot.}
}
\description{
Get details about the report's snapshot automation settings
}
