% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_list_me}
\alias{users_list_me}
\title{Show info about the logged-in user}
\usage{
users_list_me()
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this user.}
\item{name}{string, This user's name.}
\item{email}{string, This user's email address.}
\item{username}{string, This user's username.}
\item{initials}{string, This user's initials.}
\item{lastCheckedAnnouncements}{string, The date and time at which the user last checked their announcements.}
\item{featureFlags}{list, The feature flag settings for this user.}
\item{roles}{array, The roles this user has, listed by slug.}
\item{preferences}{list, This user's preferences.}
\item{customBranding}{string, The branding of Platform for this user.}
\item{primaryGroupId}{integer, The ID of the primary group of this user.}
\item{groups}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this group.
\item name string, The name of this group.
\item slug string, The slug of this group.
\item organizationId integer, The ID of the organization associated with this group.
\item organizationName string, The name of the organization associated with this group.
}}
\item{organizationName}{string, The name of the organization the user belongs to.}
\item{organizationSlug}{string, The slug of the organization the user belongs to.}
\item{organizationDefaultThemeId}{integer, The ID of the organizations's default theme.}
\item{createdAt}{string, The date and time when the user was created.}
\item{signInCount}{integer, The number of times the user has signed in.}
\item{assumingRole}{boolean, Whether the user is assuming a role or not.}
\item{assumingAdmin}{boolean, Whether the user is assuming admin.}
\item{assumingAdminExpiration}{string, When the user's admin role is set to expire.}
\item{superadminModeExpiration}{string, The user is in superadmin mode when set to a DateTime. The user is not in superadmin mode when set to null.}
\item{disableNonCompliantFedrampFeatures}{boolean, Whether to disable non-compliant fedramp features.}
\item{createdById}{integer, The ID of the user who created this user.}
\item{lastUpdatedById}{integer, The ID of the user who last updated this user.}
}
\description{
Show info about the logged-in user
}
