% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2o_init_multinode.R
\name{h2o_init_multinode}
\alias{h2o_init_multinode}
\title{Starts an h2o cluster on multiple nodes}
\usage{
h2o_init_multinode(
  h2o_jar,
  node_list = Sys.getenv("SLURM_NODELIST"),
  memory_per_node = "8g",
  cluster_name = "h2o_r",
  verbose = T,
  ...
)
}
\arguments{
\item{h2o_jar}{Path to h2o.jar, e.g. "~/software/h2o-latest/h2o.jar"}

\item{node_list}{Comma-separated list of nodes to use, defaults to
the value of SLURM_NODELIST. Assumed to be hostnames, not IPs.}

\item{memory_per_node}{Memory per node. Default 8g.}

\item{cluster_name}{Name of the h2o cluster. Default "h2o_r".}

\item{verbose}{If T display extra information during execution.}

\item{...}{Remaining arguments passed to h2o.init()}
}
\description{
Can be used on a SLURM system or any cluster where h2o can take advantage
of multiple computers.
}
\examples{
\dontrun{
cl = h2o_init_multinode("~/software/h2o-latest/h2o.jar")

h2o.shutdown()
}

}
