% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/related_show.R
\name{related_show}
\alias{related_show}
\title{Show a related item}
\usage{
related_show(
  id,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{id}{(character) Related item identifier.}

\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Show a related item
}
\details{
By default the help and success slots are dropped, and only the
result slot is returned. You can request raw json with \code{as = 'json'}
then parse yourself to get the help slot.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package and a related item
res <- package_create("hello-pluto2") \%>\%
   related_create(title = "my resource",
                  type = "visualization")

# show the related item
related_show(res)
related_show(res$id)

# get data back in different formats
related_show(res, as = 'json')
related_show(res, as = 'table')
}
}
