% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postanalysis.R
\name{deptime.depth}
\alias{deptime.depth}
\title{Calculates *for each iteration* the slope of a straight curve between depths
 just above and below the desired point.}
\usage{
deptime.depth(depth, yrcm = TRUE, prob = 0.95)
}
\arguments{
\item{depth}{The depth for which accumulation rate estimates should be calculated.}

\item{yrcm}{Calculate in years per cm, or alternatively in cm per yr.}

\item{prob}{Probability level at which to calculate the ranges.}
}
\value{
The slope of a straight curve between depths above and below the desired point.
}
\description{
Calculates *for each iteration* the slope of a straight curve between depths
 above and below the desired point. Requires sufficiently dense density of depths, e.g. \code{yrsteps=1}.
}
\details{
To calculate sedimentation times at a depth. Before running this, run your core in clam and store the data, 
so, make sure to set \code{storedat=TRUE}. 
Renamed from previous accrate.depth function to avoid confusion with accrate.depth function of rbacon.
}
\examples{
  clam(coredir=tempdir(), storedat=TRUE) 
  deptime.depth(20)
  deptime.depth(20, FALSE) # to calculate accumulation rates in cm/yr

}
\author{
Maarten Blaauw
}
